/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui;

import org.apache.uima.resource.metadata.AllowedValue;
import org.apache.uima.resource.metadata.FeatureDescription;
import org.apache.uima.resource.metadata.TypeDescription;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.taeconfigurator.editors.MultiPageEditor;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.Utility;
import org.apache.uima.taeconfigurator.model.BuiltInTypes;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeItem;

public abstract class AbstractImportablePartSection
extends AbstractSection {
    public AbstractImportablePartSection(MultiPageEditor aEditor, Composite parent, String headerText, String description) {
        super(aEditor, parent, headerText, description);
    }

    protected boolean isLocalItem(TreeItem item) {
        return !item.getForeground().equals((Object)this.editor.getFadeColor());
    }

    public FeatureDescription getFeatureFromTypeDescription(String name, TypeDescription td) {
        FeatureDescription[] fds = td.getFeatures();
        if (fds == null) {
            return null;
        }
        for (int i = 0; i < fds.length; ++i) {
            if (!name.equals(fds[i].getName())) continue;
            return fds[i];
        }
        return null;
    }

    public AllowedValue getAllowedValue(String value, TypeDescription td) {
        AllowedValue[] avs = td.getAllowedValues();
        if (null == avs) {
            return null;
        }
        for (int i = 0; i < avs.length; ++i) {
            if (!value.equals(avs[i].getString())) continue;
            return avs[i];
        }
        return null;
    }

    protected TypeDescription getLocalTypeDefinition(TypeDescription td) {
        TypeSystemDescription tsdLocal = this.getTypeSystemDescription();
        if (null == tsdLocal) {
            return null;
        }
        return tsdLocal.getType(td.getName());
    }

    protected FeatureDescription getLocalFeatureDefinition(TypeDescription td, FeatureDescription fd) {
        return this.getLocalFeatureDefinition(td, fd.getName());
    }

    protected FeatureDescription getLocalFeatureDefinition(TypeDescription td, String featureName) {
        TypeDescription localTd = this.getLocalTypeDefinition(td);
        if (null == localTd) {
            return null;
        }
        return this.getFeatureFromTypeDescription(featureName, localTd);
    }

    protected AllowedValue getLocalAllowedValue(TypeDescription td, AllowedValue unchangedAv) {
        TypeDescription localTd = this.getLocalTypeDefinition(td);
        if (null == localTd) {
            return null;
        }
        return this.getAllowedValue(unchangedAv.getString(), localTd);
    }

    public TypeDescription getBuiltInTypeDescription(TypeDescription td) {
        return (TypeDescription)BuiltInTypes.typeDescriptions.get(td.getName());
    }

    protected boolean isLocalType(TypeDescription td) {
        return null != this.getLocalTypeDefinition(td);
    }

    protected boolean isLocalType(String typeName) {
        return null != this.editor.getTypeSystemDescription().getType(typeName);
    }

    protected boolean isLocalFeature(String featureName, TypeDescription td) {
        return null != this.getLocalFeatureDefinition(td, featureName);
    }

    protected boolean isLocalAllowedValue(String avString, TypeDescription td) {
        TypeDescription localTd = this.getLocalTypeDefinition(td);
        if (null == localTd) {
            return false;
        }
        return Utility.arrayContains(localTd.getAllowedValues(), avString);
    }

    public boolean isImportedType(String typeName) {
        return null != this.editor.getImportedTypeSystemDesription().getType(typeName);
    }

    protected boolean isImportedType(TypeDescription td) {
        return null != this.editor.getImportedTypeSystemDesription().getType(td.getName());
    }

    protected boolean isImportedFeature(String name, TypeDescription td) {
        TypeDescription importedTd = this.editor.getImportedTypeSystemDesription().getType(td.getName());
        if (null == importedTd) {
            return false;
        }
        return null != this.getFeatureFromTypeDescription(name, importedTd);
    }

    protected boolean isImportedAllowedValue(TypeDescription td, AllowedValue av) {
        TypeDescription importedTd = this.editor.getImportedTypeSystemDesription().getType(td.getName());
        if (null == importedTd) {
            return false;
        }
        return null != this.getAllowedValue(av.getString(), importedTd);
    }

    protected boolean isBuiltInType(TypeDescription td) {
        return null != this.getBuiltInTypeDescription(td);
    }

    protected boolean isBuiltInType(String typeName) {
        return null != BuiltInTypes.typeDescriptions.get(typeName);
    }

    protected boolean isBuiltInFeature(String name, TypeDescription td) {
        TypeDescription builtInTd = (TypeDescription)BuiltInTypes.typeDescriptions.get(td.getName());
        if (null == builtInTd) {
            return false;
        }
        return null != this.getFeatureFromTypeDescription(name, builtInTd);
    }
}

