/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.testing.assertj;

import java.util.stream.Collectors;
import org.apache.uima.cas.CAS;
import org.apache.uima.fit.validation.ValidationException;
import org.apache.uima.fit.validation.ValidationResult;
import org.apache.uima.fit.validation.ValidationSummary;
import org.apache.uima.fit.validation.Validator;
import org.apache.uima.jcas.JCas;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Fail;

public class CasAssert_ImplBase<SELF extends CasAssert_ImplBase<SELF, ACTUAL>, ACTUAL>
extends AbstractAssert<SELF, ACTUAL> {
    public CasAssert_ImplBase(ACTUAL aActual, Class<?> aSelfType) {
        super(aActual, aSelfType);
    }

    protected ValidationSummary validate(Validator aValidator) throws ValidationException {
        if (this.actual instanceof CAS) {
            return aValidator.check((CAS)this.actual);
        }
        if (this.actual instanceof JCas) {
            return aValidator.check((JCas)this.actual);
        }
        throw new IllegalArgumentException("Unsupported CAS implementation [" + this.actual.getClass().getName() + "]");
    }

    public SELF isValid() {
        return this.isValidUsing(new Validator.Builder().build());
    }

    public SELF isValidUsing(Validator aValidator) {
        this.isNotNull();
        try {
            ValidationSummary summary = this.validate(aValidator);
            String messageBuffer = summary.getResults().stream().filter(r -> r.getSeverity().isEquallyOrMoreSevereThan(ValidationResult.Severity.ERROR)).map(r -> String.format("[%s] %s", r.getSource(), r.getMessage())).collect(Collectors.joining("\n"));
            if (messageBuffer.length() > 0) {
                Fail.fail((String)messageBuffer);
            }
        }
        catch (ValidationException e) {
            Fail.fail((String)"Unable to validate CAS", (Throwable)e);
        }
        return (SELF)((Object)((CasAssert_ImplBase)this.myself));
    }
}

