/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.legacy;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.util.HashMap;
import java.util.Map;
import org.apache.uima.fit.internal.LegacySupportPlugin;
import org.apache.uima.fit.internal.MetaDataType;
import org.apache.uima.fit.legacy.AnnotationConverter;
import org.apache.uima.fit.legacy.converter.ConfigurationParameterConverter;
import org.apache.uima.fit.legacy.converter.ExternalResourceConverter;
import org.apache.uima.fit.legacy.converter.FsIndexCollectionConverter;
import org.apache.uima.fit.legacy.converter.FsIndexConverter;
import org.apache.uima.fit.legacy.converter.FsIndexKeyConverter;
import org.apache.uima.fit.legacy.converter.NoConversionConverter;
import org.apache.uima.fit.legacy.converter.OperationalPropertiesConverter;
import org.apache.uima.fit.legacy.converter.SofaCapabilityConverter;
import org.apache.uima.fit.legacy.converter.TypeCapabilityConverter;
import org.apache.uima.resource.ResourceInitializationException;
import org.uimafit.factory.FsIndexFactory;
import org.uimafit.factory.TypeSystemDescriptionFactory;

public class LegacySupportPluginImpl
implements LegacySupportPlugin {
    private Map<Class<? extends Annotation>, AnnotationConverter<?, ?>> converterRegistry;

    public LegacySupportPluginImpl() {
        this.register(new ConfigurationParameterConverter());
        this.register(new ExternalResourceConverter());
        this.register(new FsIndexConverter());
        this.register(new FsIndexCollectionConverter());
        this.register(new FsIndexKeyConverter());
        this.register(new OperationalPropertiesConverter());
        this.register(new SofaCapabilityConverter());
        this.register(new TypeCapabilityConverter());
    }

    public boolean isAnnotationPresent(AccessibleObject aObject, Class<? extends Annotation> aAnnotationClass) {
        Class legacyType = this.getLegacyType(aAnnotationClass);
        if (legacyType != null) {
            return aObject.getAnnotation(legacyType) != null;
        }
        return false;
    }

    public boolean isAnnotationPresent(Class<?> aObject, Class<? extends Annotation> aAnnotationClass) {
        Class legacyType = this.getLegacyType(aAnnotationClass);
        if (legacyType != null) {
            return aObject.getAnnotation(legacyType) != null;
        }
        return false;
    }

    public <L extends Annotation, M extends Annotation> M getAnnotation(AccessibleObject aObject, Class<M> aAnnotationClass) {
        AnnotationConverter<L, M> converter = this.getConverter(aAnnotationClass);
        L legacyAnnotation = aObject.getAnnotation(converter.getLegacyType());
        if (legacyAnnotation != null) {
            return converter.convert(aObject, legacyAnnotation);
        }
        return null;
    }

    public <L extends Annotation, M extends Annotation> M getAnnotation(Class<?> aObject, Class<M> aAnnotationClass) {
        AnnotationConverter<L, M> converter = this.getConverter(aAnnotationClass);
        L legacyAnnotation = aObject.getAnnotation(converter.getLegacyType());
        if (legacyAnnotation != null) {
            return converter.convert(aObject, legacyAnnotation);
        }
        return null;
    }

    private <L extends Annotation, M extends Annotation> AnnotationConverter<L, M> getConverter(Class<M> aModernType) {
        NoConversionConverter conv = this.converterRegistry.get(aModernType);
        if (conv == null) {
            conv = NoConversionConverter.getInstance();
        }
        return conv;
    }

    private <L extends Annotation, M extends Annotation> Class<L> getLegacyType(Class<M> aModernType) {
        AnnotationConverter<L, M> converter = this.getConverter(aModernType);
        if (converter != null) {
            return converter.getLegacyType();
        }
        return null;
    }

    private void register(AnnotationConverter<?, ?> aConverter) {
        if (this.converterRegistry == null) {
            this.converterRegistry = new HashMap();
        }
        this.converterRegistry.put(aConverter.getModernType(), aConverter);
    }

    public String[] scanTypeDescriptors(MetaDataType aType) throws ResourceInitializationException {
        switch (aType) {
            case FS_INDEX: {
                return FsIndexFactory.scanIndexDescriptors();
            }
            case TYPE_SYSTEM: {
                return TypeSystemDescriptionFactory.scanTypeDescriptors();
            }
        }
        return new String[0];
    }
}

