/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ps.service.protocol.builtin;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.uima.UIMAFramework;
import org.apache.uima.ducc.ps.net.iface.IMetaTask;
import org.apache.uima.ducc.ps.net.iface.IMetaTaskTransaction;
import org.apache.uima.ducc.ps.net.impl.MetaTaskTransaction;
import org.apache.uima.ducc.ps.net.impl.TransactionId;
import org.apache.uima.ducc.ps.service.IService;
import org.apache.uima.ducc.ps.service.errors.IServiceErrorHandler;
import org.apache.uima.ducc.ps.service.errors.ServiceException;
import org.apache.uima.ducc.ps.service.errors.ServiceInitializationException;
import org.apache.uima.ducc.ps.service.processor.IProcessResult;
import org.apache.uima.ducc.ps.service.processor.IServiceProcessor;
import org.apache.uima.ducc.ps.service.protocol.INoTaskAvailableStrategy;
import org.apache.uima.ducc.ps.service.protocol.IServiceProtocolHandler;
import org.apache.uima.ducc.ps.service.transport.IServiceTransport;
import org.apache.uima.ducc.ps.service.transport.TransportException;
import org.apache.uima.ducc.ps.service.transport.XStreamUtils;
import org.apache.uima.ducc.ps.service.utils.Utils;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public class DefaultServiceProtocolHandler
implements IServiceProtocolHandler {
    Logger logger = UIMAFramework.getLogger(DefaultServiceProtocolHandler.class);
    private volatile boolean initError = false;
    private volatile boolean running = false;
    private volatile boolean quiescing = false;
    private IServiceTransport transport;
    private IServiceProcessor processor;
    private INoTaskAvailableStrategy noTaskStrategy;
    private CountDownLatch initLatch;
    private CountDownLatch stopLatch;
    private CountDownLatch startLatch;
    private IService service;
    private static ReentrantLock initLock = new ReentrantLock();
    private static AtomicInteger idGenerator = new AtomicInteger();
    private Thread retryThread = null;

    private DefaultServiceProtocolHandler(Builder builder) {
        this.initLatch = builder.initLatch;
        this.stopLatch = builder.stopLatch;
        this.service = builder.service;
        this.transport = builder.transport;
        this.processor = builder.processor;
        this.noTaskStrategy = builder.strategy;
    }

    private void waitForAllThreadsToInitialize() {
        try {
            this.initLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void initialize() throws ServiceInitializationException {
        this.startLatch = new CountDownLatch(1);
        try {
            initLock.lock();
            if (this.initError) {
                return;
            }
            this.processor.initialize();
        }
        catch (Throwable e) {
            this.initError = true;
            this.running = false;
            e.printStackTrace();
            this.logger.log(Level.WARNING, "ProtocolHandler initialize() failed -", e);
            throw new ServiceInitializationException("Thread:" + Thread.currentThread().getName() + " Failed initialization - " + e);
        }
        finally {
            this.initLatch.countDown();
            initLock.unlock();
            if (!this.initError) {
                this.waitForAllThreadsToInitialize();
            }
        }
    }

    @Override
    public boolean initialized() {
        return !this.initError;
    }

    private IMetaTaskTransaction sendAndReceive(IMetaTaskTransaction transaction) throws Exception {
        if (IMetaTaskTransaction.Type.Get.equals((Object)transaction.getType())) {
            int major = idGenerator.addAndGet(1);
            int minor = 0;
            TransactionId tid = new TransactionId(major, minor);
        } else {
            TransactionId tid = transaction.getTransactionId();
            tid.next();
        }
        transaction.setRequesterProcessName(this.service.getType());
        this.transport.addRequestorInfo(transaction);
        IMetaTaskTransaction reply = null;
        try {
            String body = XStreamUtils.marshall(transaction);
            reply = this.transport.dispatch(body);
            if (Objects.isNull(reply)) {
                throw new TransportException("Received invalid content (null) in response from client - rejecting request");
            }
        }
        catch (Exception e) {
            if (!this.running) {
                throw new TransportException("Service stopping - rejecting request");
            }
            throw e;
        }
        return reply;
    }

    private IMetaTaskTransaction callEnd(IMetaTaskTransaction transaction) throws Exception {
        transaction.setType(IMetaTaskTransaction.Type.End);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "ProtocolHandler calling END");
        }
        return this.sendAndReceive(transaction);
    }

    private IMetaTaskTransaction callAck(IMetaTaskTransaction transaction) throws Exception {
        transaction.setType(IMetaTaskTransaction.Type.Ack);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "ProtocolHandler calling ACK");
        }
        return this.sendAndReceive(transaction);
    }

    private synchronized IMetaTaskTransaction callGet(IMetaTaskTransaction transaction) throws Exception {
        transaction.setType(IMetaTaskTransaction.Type.Get);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "ProtocolHandler calling GET");
        }
        IMetaTaskTransaction metaTransaction = null;
        boolean logOutOfTasks = true;
        while (this.running && ((metaTransaction = this.sendAndReceive(transaction)).getMetaTask() == null || metaTransaction.getMetaTask().getUserSpaceTask() == null)) {
            if (logOutOfTasks) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "Process Thread:" + Thread.currentThread().getId() + " - Driver is out of tasks - waiting for awhile (" + this.noTaskStrategy.getWaitTimeInMillis() + " ms) and will try again ");
                }
                logOutOfTasks = false;
            }
            this.noTaskStrategy.handleNoTaskSupplied();
        }
        return metaTransaction;
    }

    private void awaitStart() throws ServiceInitializationException {
        try {
            this.startLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ServiceInitializationException("Thread interrupted while awaiting start()");
        }
    }

    @Override
    public String call() throws ServiceInitializationException, ServiceException {
        this.initialize();
        this.awaitStart();
        IMetaTaskTransaction transaction = null;
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, ".............. Thread " + Thread.currentThread().getId() + " ready to process");
        }
        while (this.running) {
            try {
                transaction = this.callGet(new MetaTaskTransaction());
                if (!this.running && !this.quiescing || Objects.isNull(transaction) || !this.running && !this.quiescing) break;
                this.logger.log(Level.FINE, ".............. Thread " + Thread.currentThread().getId() + " processing new task");
                if (Objects.isNull(transaction.getMetaTask())) {
                    if (!this.running) continue;
                    this.logger.log(Level.INFO, ".............. Thread " + Thread.currentThread().getId() + " GET returned null MetaTask while service is in a running state - this is unexpected");
                    continue;
                }
                Object task = transaction.getMetaTask().getUserSpaceTask();
                transaction = this.callAck(transaction);
                if (!this.running && !this.quiescing) break;
                IProcessResult processResult = this.processor.process((String)task);
                IServiceErrorHandler.Action action = IServiceErrorHandler.Action.CONTINUE;
                String errorAsString = processResult.getError();
                if (processResult.terminateProcess()) {
                    action = IServiceErrorHandler.Action.TERMINATE;
                } else if (Objects.isNull(errorAsString)) {
                    transaction.getMetaTask().setPerformanceMetrics(processResult.getResult());
                }
                if (Objects.nonNull(errorAsString)) {
                    IMetaTask mc = transaction.getMetaTask();
                    if (Objects.isNull(System.getProperty("ducc.deploy.JpType"))) {
                        mc.setUserSpaceException(errorAsString);
                    } else {
                        this.logger.log(Level.INFO, "Sending Exception to JD:\n" + processResult.getExceptionObject());
                        mc.setUserSpaceException(this.serializeError(processResult.getExceptionObject()));
                    }
                }
                this.callEnd(transaction);
                if (!this.running || !IServiceErrorHandler.Action.TERMINATE.equals((Object)action)) continue;
                this.logger.log(Level.WARNING, "Processor Failure - Action=Terminate");
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        DefaultServiceProtocolHandler.this.delegateStop();
                    }
                }).start();
                this.running = false;
            }
            catch (IllegalStateException e) {
                break;
            }
            catch (TransportException e) {
                break;
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "", (Throwable)e);
            }
        }
        this.stopLatch.countDown();
        System.out.println(Utils.getTimestamp() + ">>>>>>> " + Utils.getShortClassname(this.getClass()) + ".call() >>>>>>>>>> Thread [" + Thread.currentThread().getId() + "]  ProtocolHandler stopped requesting new tasks - Stopping processor");
        this.logger.log(Level.INFO, "ProtocolHandler stopped requesting new tasks - Stopping processor");
        if (this.processor != null) {
            this.processor.stop();
        }
        return String.valueOf(Thread.currentThread().getId());
    }

    private byte[] serializeError(Throwable t) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(t);
        }
        return baos.toByteArray();
    }

    private void delegateStop() {
        this.service.quiesceAndStop();
    }

    @Override
    public void stop() {
        this.quiescing = false;
        this.running = false;
        try {
            if (this.retryThread != null) {
                this.retryThread.interrupt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, this.getClass().getName() + " stop() called");
        }
    }

    @Override
    public void quiesceAndStop() {
        System.out.println(Utils.getTimestamp() + ">>>>>>> " + Utils.getShortClassname(this.getClass()) + ".queisceAndStop()");
        this.logger.log(Level.INFO, this.getClass().getName() + " quiesceAndStop() called");
        this.transport.stop(true);
        this.quiescing = true;
        this.running = false;
        try {
            if (this.retryThread != null) {
                this.retryThread.interrupt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.stopLatch.await();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println(Utils.getTimestamp() + ">>>>>>> " + Utils.getShortClassname(this.getClass()) + ".queisceAndStop() All process threads completed quiesce");
        this.logger.log(Level.INFO, this.getClass().getName() + " All process threads completed quiesce");
    }

    @Override
    public void start() {
        this.running = true;
        this.startLatch.countDown();
    }

    @Override
    public void setServiceProcessor(IServiceProcessor processor) {
        this.processor = processor;
    }

    @Override
    public void setTransport(IServiceTransport transport) {
        this.transport = transport;
    }

    public static class Builder {
        private IServiceTransport transport;
        private IServiceProcessor processor;
        private INoTaskAvailableStrategy strategy;
        private CountDownLatch initLatch;
        private CountDownLatch stopLatch;
        private IService service;

        public Builder withTransport(IServiceTransport transport) {
            this.transport = transport;
            return this;
        }

        public Builder withProcessor(IServiceProcessor processor) {
            this.processor = processor;
            return this;
        }

        public Builder withInitCompleteLatch(CountDownLatch initLatch) {
            this.initLatch = initLatch;
            return this;
        }

        public Builder withDoneLatch(CountDownLatch stopLatch) {
            this.stopLatch = stopLatch;
            return this;
        }

        public Builder withNoTaskStrategy(INoTaskAvailableStrategy strategy) {
            this.strategy = strategy;
            return this;
        }

        public Builder withService(IService service) {
            this.service = service;
            return this;
        }

        public DefaultServiceProtocolHandler build() {
            return new DefaultServiceProtocolHandler(this);
        }
    }
}

