/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ps.service.processor.uima.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineManagement;
import org.apache.uima.ducc.ps.service.processor.uima.utils.PerformanceMetrics;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public class UimaMetricsGenerator {
    private UimaMetricsGenerator() {
    }

    public static void getLeafManagementObjects(AnalysisEngineManagement aem, List<PerformanceMetrics> result) {
        UimaMetricsGenerator.getLeafManagementObjects(aem, result, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PerformanceMetrics> get(AnalysisEngine ae) throws Exception {
        ArrayList<PerformanceMetrics> analysisManagementObjects = new ArrayList<PerformanceMetrics>();
        Class<UimaMetricsGenerator> clazz = UimaMetricsGenerator.class;
        synchronized (UimaMetricsGenerator.class) {
            AnalysisEngineManagement aem = ae.getManagementInterface();
            if (aem.getComponents().size() > 0) {
                UimaMetricsGenerator.getLeafManagementObjects(aem, analysisManagementObjects);
            } else {
                String path = UimaMetricsGenerator.produceUniqueName(aem);
                analysisManagementObjects.add(UimaMetricsGenerator.deepCopyMetrics(aem, path));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return analysisManagementObjects;
        }
    }

    private static void getLeafManagementObjects(AnalysisEngineManagement aem, List<PerformanceMetrics> result, String uimaFullyQualifiedAEContext) {
        if (aem.getComponents().isEmpty()) {
            if (!aem.getName().equals("Fixed Flow Controller")) {
                if (aem.getUniqueMBeanName().indexOf("p0=") > -1) {
                    int p1indx = aem.getUniqueMBeanName().indexOf("p1=");
                    if (p1indx > -1) {
                        String[] parts;
                        String tmp = aem.getUniqueMBeanName().substring(p1indx);
                        for (String part : parts = tmp.split(",")) {
                            if (!part.startsWith("name=")) continue;
                            uimaFullyQualifiedAEContext = uimaFullyQualifiedAEContext + "/" + part.substring(5);
                            break;
                        }
                    } else {
                        uimaFullyQualifiedAEContext = "";
                    }
                }
                result.add(UimaMetricsGenerator.deepCopyMetrics(aem, uimaFullyQualifiedAEContext));
            }
        } else {
            for (AnalysisEngineManagement child : aem.getComponents().values()) {
                UimaMetricsGenerator.getLeafManagementObjects(child, result, UimaMetricsGenerator.produceUniqueName(aem));
            }
        }
    }

    private static String produceUniqueName(AnalysisEngineManagement aem) {
        String[] parts = aem.getUniqueMBeanName().split(",");
        StringBuffer sb = new StringBuffer();
        for (String part : parts) {
            int pos = part.indexOf("=");
            if (pos > -1 && part.startsWith("p")) {
                String indx;
                String n = part.substring(pos + 1, part.indexOf(" Components"));
                if (part.startsWith("p0=") && n.indexOf(" ") > -1 && (indx = n.substring(n.lastIndexOf(" "))) != null) {
                    int instanceNumber = -1;
                    try {
                        instanceNumber = Integer.parseInt(indx.trim());
                        sb.append(instanceNumber).append(" Components ");
                        n = n.substring(0, n.lastIndexOf(" "));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                sb.append("/").append(n.trim());
                continue;
            }
            if (!part.trim().startsWith("name=") && !part.trim().startsWith("org.apache.uima:name=")) continue;
            sb.append("/").append(part.substring(part.trim().indexOf("=") + 1));
        }
        return sb.toString();
    }

    private static PerformanceMetrics deepCopyMetrics(AnalysisEngineManagement aem, String uimaFullyQualifiedAEContext) {
        String index = "";
        int pos = aem.getUniqueMBeanName().lastIndexOf("name=");
        if (pos > -1) {
            String tmp = aem.getUniqueMBeanName().substring(pos + 5);
            int last = tmp.lastIndexOf(" ");
            index = last == -1 ? "1" : tmp.substring(last).trim();
            if (uimaFullyQualifiedAEContext.trim().length() > 0 && last > -1) {
                try {
                    Integer.parseInt(index);
                    uimaFullyQualifiedAEContext = uimaFullyQualifiedAEContext.substring(0, last + 1);
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (Exception exception) {}
            } else if (!uimaFullyQualifiedAEContext.endsWith(tmp)) {
                uimaFullyQualifiedAEContext = uimaFullyQualifiedAEContext + "/" + tmp;
            }
        }
        return new PerformanceMetrics(aem.getName(), uimaFullyQualifiedAEContext, aem.getAnalysisTime(), aem.getNumberOfCASesProcessed());
    }

    public static List<PerformanceMetrics> getDelta(List<PerformanceMetrics> afterAnalysisManagementObjects, List<PerformanceMetrics> beforeAnalysisManagementObjects) throws Exception {
        ArrayList<PerformanceMetrics> performanceList = new ArrayList<PerformanceMetrics>();
        block0: for (PerformanceMetrics after : afterAnalysisManagementObjects) {
            for (PerformanceMetrics before : beforeAnalysisManagementObjects) {
                String uniqueName = after.getUniqueName();
                if (!before.getUniqueName().equals(after.getUniqueName())) continue;
                if (after.getAnalysisTime() - before.getAnalysisTime() < 0L) {
                    Logger logger = UIMAFramework.getLogger();
                    logger.log(Level.WARNING, "Thread:" + Thread.currentThread() + " UimaProcessContainer.getAEMetricsForCAS() - Unexpected negative result for analysis time:" + (after.getAnalysisTime() - before.getAnalysisTime()) + " Component:" + uniqueName + " before=" + before.getAnalysisTime() + " after=" + after.getAnalysisTime());
                }
                PerformanceMetrics metrics = new PerformanceMetrics(after.getName(), uniqueName, after.getAnalysisTime() - before.getAnalysisTime(), after.getNumberOfTasksProcessed() - before.getNumberOfTasksProcessed());
                performanceList.add(metrics);
                continue block0;
            }
        }
        return performanceList;
    }
}

