/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ps.service.processor.uima;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Objects;
import org.apache.uima.ducc.ps.service.errors.IServiceErrorHandler;
import org.apache.uima.ducc.ps.service.processor.IProcessResult;

public class UimaProcessResult
implements IProcessResult {
    private String metrics;
    private Exception exception;
    private IServiceErrorHandler.Action action;

    UimaProcessResult(String pm) {
        this.metrics = pm;
    }

    UimaProcessResult(Exception exception, IServiceErrorHandler.Action action) {
        this.exception = exception;
        this.action = action;
    }

    @Override
    public boolean terminateProcess() {
        return IServiceErrorHandler.Action.TERMINATE.equals((Object)this.action);
    }

    @Override
    public String getResult() {
        return this.metrics;
    }

    @Override
    public String getError() {
        if (Objects.isNull(this.exception)) {
            return null;
        }
        StringWriter sw = new StringWriter();
        this.exception.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    @Override
    public Exception getExceptionObject() {
        return this.exception;
    }
}

