/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resourceSpecifier.factory.impl;

import org.apache.uima.resourceSpecifier.AsyncAggregateErrorConfigurationType;
import org.apache.uima.resourceSpecifier.CasMultiplierType;
import org.apache.uima.resourceSpecifier.CollectionProcessCompleteErrorsType;
import org.apache.uima.resourceSpecifier.GetMetadataErrorsType;
import org.apache.uima.resourceSpecifier.ProcessCasErrorsType;
import org.apache.uima.resourceSpecifier.RemoteAnalysisEngineType;
import org.apache.uima.resourceSpecifier.SerializerType;
import org.apache.uima.resourceSpecifier.factory.Action;
import org.apache.uima.resourceSpecifier.factory.CasMultiplier;
import org.apache.uima.resourceSpecifier.factory.CollectionProcessCompleteErrorHandlingSettings;
import org.apache.uima.resourceSpecifier.factory.DelegateConfiguration;
import org.apache.uima.resourceSpecifier.factory.GetMetaErrorHandlingSettings;
import org.apache.uima.resourceSpecifier.factory.InputQueue;
import org.apache.uima.resourceSpecifier.factory.ProcessErrorHandlingSettings;
import org.apache.uima.resourceSpecifier.factory.RemoteDelegateConfiguration;
import org.apache.uima.resourceSpecifier.factory.RemoteDelegateEngine;
import org.apache.uima.resourceSpecifier.factory.RemoteDelegateErrorConfiguration;
import org.apache.uima.resourceSpecifier.factory.SerializationStrategy;
import org.apache.uima.resourceSpecifier.factory.ServiceContext;
import org.apache.uima.resourceSpecifier.factory.impl.CasMultiplierImpl;
import org.apache.uima.resourceSpecifier.factory.impl.InputQueueImpl;

public class RemoteDelegateEngineImpl
implements RemoteDelegateEngine {
    private RemoteAnalysisEngineType draet;
    private CasMultiplier cm = null;
    private ProcessCasErrorsType pcet;
    private GetMetadataErrorsType gmet;
    private CollectionProcessCompleteErrorsType cpcet;
    private InputQueue inputQueue;
    private SerializerType st;
    private DelegateConfiguration configuration;

    public RemoteDelegateEngineImpl(RemoteAnalysisEngineType draet, RemoteDelegateConfiguration rdc, ServiceContext context) {
        this.draet = draet;
        AsyncAggregateErrorConfigurationType aarct = draet.addNewAsyncAggregateErrorConfiguration();
        this.pcet = aarct.addNewProcessCasErrors();
        this.gmet = aarct.addNewGetMetadataErrors();
        this.cpcet = aarct.addNewCollectionProcessCompleteErrors();
        this.setKey(rdc.getKey());
        this.setReplyQueueScaleup(rdc.getRemoteReplyQueueScaleout());
        this.inputQueue = new InputQueueImpl(draet.addNewInputQueue(), rdc.getEndpoint(), rdc.getBroker(), 1);
        this.st = draet.addNewSerializer();
        this.setSerializationStrategy(rdc.getSerialization());
        if (rdc.isCasMultiplier()) {
            this.addCasMultiplier(draet.addNewCasMultiplier(), rdc, context);
        }
        this.addGetMetaErrorHandlingSettings(draet.getAsyncAggregateErrorConfiguration(), rdc.getGetMetaErrorHandlingSettings());
        this.addProcessErrorHandlingSettings(draet.getAsyncAggregateErrorConfiguration(), rdc.getProcessErrorHandlingSettings());
        this.addCPCErrorHandlingSettings(draet.getAsyncAggregateErrorConfiguration(), rdc.getCollectionProcessCompleteErrorHandlingSettings());
        this.configuration = rdc;
    }

    @Override
    public DelegateConfiguration getConfiguration() {
        return this.configuration;
    }

    private void addCasMultiplier(CasMultiplierType cmt, DelegateConfiguration cdc, ServiceContext context) {
        this.cm = new CasMultiplierImpl(cmt, cdc.getCasPoolSize(), cdc.getInitialHeapSize(), cdc.processParentLast());
    }

    private void addGetMetaErrorHandlingSettings(AsyncAggregateErrorConfigurationType aarct, GetMetaErrorHandlingSettings rdc) {
        if (rdc == null) {
            this.gmet.setMaxRetries(0);
            this.gmet.setErrorAction(Action.Terminate.toString());
            this.gmet.setTimeout(0);
        } else {
            this.gmet.setMaxRetries(rdc.getMaxRetries());
            this.gmet.setErrorAction(rdc.getAction().toString().toLowerCase());
            this.gmet.setTimeout(rdc.getTimeout());
        }
    }

    private void addCPCErrorHandlingSettings(AsyncAggregateErrorConfigurationType aarct, CollectionProcessCompleteErrorHandlingSettings rdc) {
        if (rdc == null) {
            this.cpcet.setTimeout(0);
            this.cpcet.setAdditionalErrorAction(Action.Terminate.toString());
        } else {
            this.cpcet.setAdditionalErrorAction(rdc.getAction().toString());
            this.cpcet.setTimeout(rdc.getTimeout());
        }
    }

    private void addProcessErrorHandlingSettings(AsyncAggregateErrorConfigurationType aarct, ProcessErrorHandlingSettings rdc) {
        if (rdc == null) {
            this.pcet.setMaxRetries(0);
            this.pcet.setThresholdAction(Action.Terminate.toString().toLowerCase());
            this.pcet.setTimeout(0);
            this.pcet.setThresholdCount(0);
            this.pcet.setThresholdWindow(0);
            this.pcet.setContinueOnRetryFailure("false");
        } else {
            this.pcet.setMaxRetries(rdc.getMaxRetries());
            this.pcet.setThresholdAction(rdc.getAction().toString().toLowerCase());
            this.pcet.setTimeout(rdc.getTimeout());
            this.pcet.setThresholdCount(rdc.getThresholdCount());
            this.pcet.setThresholdWindow(rdc.getThresholdWindow());
            this.pcet.setContinueOnRetryFailure(Boolean.toString(rdc.continueOnRetryFailure()));
        }
    }

    @Override
    public String getKey() {
        return this.draet.getKey();
    }

    @Override
    public void setKey(String key) {
        this.draet.setKey(key);
    }

    @Override
    public int getReplyQueueScaleup() {
        return this.draet.getRemoteReplyQueueScaleout();
    }

    @Override
    public void setReplyQueueScaleup(int remoteReplyQueueScaleout) {
        this.draet.setRemoteReplyQueueScaleout(remoteReplyQueueScaleout);
    }

    @Override
    public CasMultiplier getCasMultiplier() {
        return this.cm;
    }

    @Override
    public void setCasMultiplier(CasMultiplier cm) {
    }

    @Override
    public InputQueue getInputQueue() {
        return this.inputQueue;
    }

    @Override
    public void setInputQueue(InputQueue iq) {
    }

    @Override
    public SerializationStrategy getSerializationStrategy() {
        return SerializationStrategy.valueOf(this.st.getMethod().toString());
    }

    @Override
    public void setSerializationStrategy(SerializationStrategy ss) {
        SerializerType.Method.Enum method = ss == SerializationStrategy.binary ? SerializerType.Method.BINARY : SerializerType.Method.XMI;
        this.st.setMethod(method);
    }

    @Override
    public RemoteDelegateErrorConfiguration getErrorConfiguration() {
        return null;
    }

    @Override
    public void setRemoteDelegateErrorConfiguration(RemoteDelegateErrorConfiguration er) {
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    @Override
    public boolean isAggregate() {
        return false;
    }
}

