/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.adapter.jms.service;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.uima.UIMAFramework;
import org.apache.uima.adapter.jms.service.Dd2springException;
import org.apache.uima.internal.util.XMLUtils;
import org.apache.uima.util.Level;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class Dd2spring {
    private static final Class<Dd2spring> THIS_CLASS = Dd2spring.class;
    private ClassLoader saxonClassLoader;

    public static void main(String[] args) {
        try {
            new Dd2spring().convertDd2Spring(args[0], args[1], args[2], args[3]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public File convertDd2Spring(String ddFilePath, String dd2SpringXsltFilePath, String saxonClasspath, String uimaAsDebug) throws Exception {
        File tempFile;
        URL urlForSaxonClassPath;
        try {
            urlForSaxonClassPath = new URL(saxonClasspath);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            UIMAFramework.getLogger(THIS_CLASS).logrb(Level.CONFIG, THIS_CLASS.getName(), "convertDD2Spring", "jms_adapter_messages", "UIMA_dd2spring_Cannot_convert_saxon_classpath_to_a_URL_SEVERE", new Object[]{saxonClasspath});
            return null;
        }
        try {
            tempFile = File.createTempFile("UIMAdd2springOutput", ".xml");
        }
        catch (IOException e) {
            e.printStackTrace();
            UIMAFramework.getLogger(THIS_CLASS).logrb(Level.CONFIG, THIS_CLASS.getName(), "convertDD2Spring", "jms_adapter_messages", "UIMA_dd2spring_cant_create_temp_output_file_SEVERE");
            return null;
        }
        this.convertDd2Spring(tempFile, ddFilePath, dd2SpringXsltFilePath, urlForSaxonClassPath);
        if (null == uimaAsDebug || uimaAsDebug.equals("")) {
            tempFile.deleteOnExit();
        }
        return tempFile;
    }

    private void testForSaxon9InClasspath() throws Exception {
        try {
            Class<?> saxonVersionClass = Class.forName("net.sf.saxon.Version");
            Method versionMethod = saxonVersionClass.getMethod("getProductVersion", new Class[0]);
            String version = (String)versionMethod.invoke(null, new Object[0]);
            if (version.startsWith("9")) {
                UIMAFramework.getLogger(THIS_CLASS).logrb(Level.SEVERE, THIS_CLASS.getName(), "convertDD2Spring", "uimaee_messages", "UIMAEE_exception__SEVERE", new Object[]{"saxon9 must not be in classpath"});
                throw new Dd2springException("saxon9 found in classpath - dd2spring transformation and UIMA-AS do not support saxon9");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void convertDd2Spring(File tempFile, String ddFilePath, String dd2SpringXsltFilePath, URL saxonClasspathURL) throws Exception {
        this.testForSaxon9InClasspath();
        ShutdownHook shutdownHook = new ShutdownHook();
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        ClassLoader currentClassloader = Thread.currentThread().getContextClassLoader();
        if (null == this.saxonClassLoader) {
            URL[] classLoaderUrls = new URL[]{saxonClasspathURL};
            this.saxonClassLoader = new URLClassLoader(classLoaderUrls, currentClassloader);
        }
        SaxonInputs saxonConfig = new SaxonInputs(ddFilePath, tempFile, dd2SpringXsltFilePath, this.saxonClassLoader, currentClassloader);
        SaxonInterface saxon = SaxonInterfaceFactory.newSaxonInterface(saxonConfig);
        try {
            saxon.convertDD2Spring();
        }
        catch (ClassNotFoundException e) {
            System.err.println("Error - can't load Saxon jar from " + saxonClasspathURL + " for dd2spring transformation.");
            e.printStackTrace();
            UIMAFramework.getLogger(THIS_CLASS).logrb(Level.SEVERE, THIS_CLASS.getName(), "convertDD2Spring", "jms_adapter_messages", "UIMA_dd2spring_saxon_missing_SEVERE");
            throw e;
        }
        catch (Exception e) {
            System.err.println("Error - dd2spring transformation failed:");
            e.printStackTrace();
            UIMAFramework.getLogger(THIS_CLASS).logrb(Level.SEVERE, THIS_CLASS.getName(), "convertDD2Spring", "jms_adapter_messages", "UIMA_dd2spring_internal_error_calling_saxon");
            throw e;
        }
        finally {
            Runtime.getRuntime().removeShutdownHook(shutdownHook);
        }
    }

    private static class SaxonJavaInterface
    implements SaxonInterface {
        private SaxonInputs saxonConfig;

        SaxonJavaInterface(SaxonInputs saxonConfig) {
            this.saxonConfig = saxonConfig;
        }

        private void setFeature(Method setFeatureMethod, Object xmlReaderObject, String feature, boolean flag) {
            try {
                setFeatureMethod.invoke(xmlReaderObject, feature, flag);
            }
            catch (Exception e) {
                UIMAFramework.getLogger((Class)THIS_CLASS).log(Level.WARNING, "XMLReader didn't recognize feature " + feature);
            }
        }

        private void configure(Object xmlReaderObject) throws Exception {
            Class<?> xmlReaderClass = Class.forName("org.xml.sax.XMLReader", true, this.saxonConfig.getSaxonClassLoader());
            Method setFeatureMethod = xmlReaderClass.getMethod("setFeature", String.class, Boolean.TYPE);
            this.setFeature(setFeatureMethod, xmlReaderObject, "http://xml.org/sax/features/external-general-entities", false);
            this.setFeature(setFeatureMethod, xmlReaderObject, "http://xml.org/sax/features/external-parameter-entities", false);
            this.setFeature(setFeatureMethod, xmlReaderObject, "http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            this.setFeature(setFeatureMethod, xmlReaderObject, "http://apache.org/xml/features/disallow-doctype-decl", true);
        }

        private void beforeProcess() {
            System.setProperty("javax.xml.transform.TransformerFactory", "net.sf.saxon.TransformerFactoryImpl");
        }

        private void afterProcess() {
            System.clearProperty("javax.xml.parsers.SAXParserFactory");
            System.clearProperty("javax.xml.transform.TransformerFactory");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void convertDD2Spring() throws Exception {
            this.beforeProcess();
            BufferedWriter writer = null;
            try {
                Thread.currentThread().setContextClassLoader(this.saxonConfig.getSaxonClassLoader());
                Class<?> configClass = Class.forName("net.sf.saxon.Configuration", true, this.saxonConfig.getSaxonClassLoader());
                Object oc = configClass.newInstance();
                Method getXMLReaderMethod = configClass.getMethod("getStyleParser", new Class[0]);
                Object xmlReaderObject = getXMLReaderMethod.invoke(oc, new Object[0]);
                this.configure(xmlReaderObject);
                StringWriter out = new StringWriter();
                SAXTransformerFactory tFactory = XMLUtils.createSaxTransformerFactory();
                StreamSource xslSource = new StreamSource(new File(this.saxonConfig.getXSLTPath()));
                StreamResult xmlResult = new StreamResult(out);
                Transformer transformer = tFactory.newTransformer(xslSource);
                File ddAbsFilePath = new File(this.saxonConfig.getDDFilePath());
                SAXSource source = new SAXSource(new InputSource(ddAbsFilePath.toURI().toString()));
                source.setXMLReader((XMLReader)xmlReaderObject);
                transformer.transform(source, xmlResult);
                writer = new BufferedWriter(new FileWriter(this.saxonConfig.getSpringFilePath()));
                writer.write(out.toString());
                if (UIMAFramework.getLogger((Class)THIS_CLASS).isLoggable(Level.FINEST)) {
                    System.out.println("Finished Writing to temp file:" + this.saxonConfig.getSpringFilePath().getAbsolutePath());
                    String result = out.toString();
                    System.out.println(result);
                }
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Exception exception) {}
                }
                this.afterProcess();
                Thread.currentThread().setContextClassLoader(this.saxonConfig.getCurrentClassLoader());
            }
        }
    }

    private static class SaxonCommandLineInterface
    implements SaxonInterface {
        private List<String> argsForSaxon = new ArrayList<String>();
        private SaxonInputs saxonConfig;

        SaxonCommandLineInterface(SaxonInputs saxonConfig) {
            this.saxonConfig = saxonConfig;
            this.argsForSaxon.add("-l");
            this.argsForSaxon.add("-s");
            this.argsForSaxon.add(saxonConfig.getDDFilePath());
            this.argsForSaxon.add("-o");
            this.argsForSaxon.add(saxonConfig.getSpringFilePath().getAbsolutePath());
            this.argsForSaxon.add(saxonConfig.getXSLTPath());
            String uimaFrameworkClass = System.getProperty("uima.framework_impl");
            if (uimaFrameworkClass != null) {
                String saxonParserClass = uimaFrameworkClass + "_SAXParser";
                try {
                    saxonConfig.getSaxonClassLoader().loadClass(saxonParserClass);
                    this.argsForSaxon.add("-x");
                    this.argsForSaxon.add(saxonParserClass);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            UIMAFramework.getLogger((Class)THIS_CLASS).log(Level.INFO, "Saxon args: " + this.argsForSaxon);
        }

        @Override
        public void convertDD2Spring() throws Exception {
            try {
                Thread.currentThread().setContextClassLoader(this.saxonConfig.getSaxonClassLoader());
                Class<?> mainStartClass = null;
                mainStartClass = Class.forName("net.sf.saxon.Transform", true, this.saxonConfig.getSaxonClassLoader());
                Method mainMethod = mainStartClass.getMethod("main", String[].class);
                mainMethod.invoke(null, new Object[]{this.argsForSaxon.toArray(new String[this.argsForSaxon.size()])});
            }
            finally {
                Thread.currentThread().setContextClassLoader(this.saxonConfig.getCurrentClassLoader());
            }
        }
    }

    private static interface SaxonInterface {
        public void convertDD2Spring() throws Exception;
    }

    private static class SaxonInterfaceFactory {
        private SaxonInterfaceFactory() {
        }

        public static SaxonInterface newSaxonInterface(SaxonInputs saxonConfig) {
            SaxonInterface saxon;
            if (System.getProperty("uima.framework_impl") != null) {
                UIMAFramework.getLogger((Class)THIS_CLASS).log(Level.INFO, "Using Saxon command line interface - Java Vendor:" + System.getProperty("java.vendor"));
                saxon = new SaxonCommandLineInterface(saxonConfig);
            } else {
                UIMAFramework.getLogger((Class)THIS_CLASS).log(Level.INFO, "Using Saxon Java API - Java Vendor:" + System.getProperty("java.vendor"));
                saxon = new SaxonJavaInterface(saxonConfig);
            }
            return saxon;
        }
    }

    private class SaxonInputs {
        String ddFilePath;
        File springFilePath;
        String xsltPath;
        ClassLoader currentClassLoader;
        ClassLoader saxonClassLoader;

        public SaxonInputs(String ddFilePath, File springFilePath, String xsltPath, ClassLoader saxonClassloader, ClassLoader currentClassloader) {
            this.ddFilePath = ddFilePath;
            this.springFilePath = springFilePath;
            this.xsltPath = xsltPath;
            this.currentClassLoader = currentClassloader;
            this.saxonClassLoader = saxonClassloader;
        }

        public ClassLoader getCurrentClassLoader() {
            return this.currentClassLoader;
        }

        public ClassLoader getSaxonClassLoader() {
            return this.saxonClassLoader;
        }

        public String getDDFilePath() {
            return this.ddFilePath;
        }

        public File getSpringFilePath() {
            return this.springFilePath;
        }

        public String getXSLTPath() {
            return this.xsltPath;
        }
    }

    private class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        @Override
        public void run() {
            System.err.println("ERROR in dd2spring Saxon transformation ... System.exit called");
            System.err.flush();
        }
    }
}

