/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.jd.timeout;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.uima.ducc.container.common.MessageBuffer;
import org.apache.uima.ducc.container.common.Standardize;
import org.apache.uima.ducc.container.common.fsm.iface.IEvent;
import org.apache.uima.ducc.container.common.fsm.iface.IFsm;
import org.apache.uima.ducc.container.common.logger.IComponent;
import org.apache.uima.ducc.container.common.logger.ILogger;
import org.apache.uima.ducc.container.common.logger.Logger;
import org.apache.uima.ducc.container.jd.JobDriver;
import org.apache.uima.ducc.container.jd.fsm.wi.IActionData;
import org.apache.uima.ducc.container.jd.fsm.wi.WiFsm;
import org.apache.uima.ducc.container.jd.log.LoggerHelper;
import org.apache.uima.ducc.container.jd.timeout.ITimeoutManager;
import org.apache.uima.ducc.container.jd.timeout.ITimeoutTask;
import org.apache.uima.ducc.container.jd.timeout.TimeoutTask;
import org.apache.uima.ducc.container.jd.wi.IWorkItem;

public class TimeoutManager
implements ITimeoutManager {
    private static Logger logger = Logger.getLogger(TimeoutManager.class, IComponent.Id.JD.name());
    private static TimeoutManager instance = new TimeoutManager();
    private ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(5);
    private long ackTimeout = 60000L;
    private ConcurrentHashMap<IWorkItem, ITimeoutTask> mapTask = new ConcurrentHashMap();
    private ConcurrentHashMap<IWorkItem, ScheduledFuture<?>> mapFuture = new ConcurrentHashMap();

    public static TimeoutManager getInstance() {
        return instance;
    }

    private TimeoutManager() {
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = (ScheduledThreadPoolExecutor)this.scheduledExecutorService;
        scheduledThreadPoolExecutor.setRemoveOnCancelPolicy(true);
    }

    @Override
    public void pendingAck(IActionData actionData) {
        String location = "pendingAck";
        try {
            IWorkItem wi = actionData.getWorkItem();
            IFsm fsm = wi.getFsm();
            IEvent event = WiFsm.Ack_Timer_Pop;
            long deadline = System.currentTimeMillis() + this.ackTimeout;
            TimeoutTask timeoutTask = new TimeoutTask(fsm, event, actionData, deadline);
            this.register(wi, timeoutTask);
            MessageBuffer mb = LoggerHelper.getMessageBuffer(actionData);
            mb.append((Object)((Object)Standardize.Label.deadline) + "+" + this.ackTimeout / 1000L);
            logger.debug(location, ILogger.null_id, mb.toString());
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
        }
    }

    @Override
    public void receivedAck(IActionData actionData) {
        String location = "receivedAck";
        try {
            MessageBuffer mb = LoggerHelper.getMessageBuffer(actionData);
            logger.debug(location, ILogger.null_id, mb.toString());
            IWorkItem wi = actionData.getWorkItem();
            this.unregister(wi);
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
        }
    }

    @Override
    public void pendingEnd(IActionData actionData) {
        String location = "pendingEnd";
        try {
            IWorkItem wi = actionData.getWorkItem();
            IFsm fsm = wi.getFsm();
            IEvent event = WiFsm.End_Timer_Pop;
            JobDriver jd = JobDriver.getInstance();
            long endTimeout = jd.getWorkItemTimeoutMillis();
            long deadline = System.currentTimeMillis() + endTimeout;
            TimeoutTask timeoutTask = new TimeoutTask(fsm, event, actionData, deadline);
            this.register(wi, timeoutTask);
            MessageBuffer mb = LoggerHelper.getMessageBuffer(actionData);
            mb.append((Object)((Object)Standardize.Label.deadline) + "+" + endTimeout / 1000L);
            logger.debug(location, ILogger.null_id, mb.toString());
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
        }
    }

    @Override
    public void receivedEnd(IActionData actionData) {
        String location = "receivedEnd";
        try {
            MessageBuffer mb = LoggerHelper.getMessageBuffer(actionData);
            logger.debug(location, ILogger.null_id, mb.toString());
            IWorkItem wi = actionData.getWorkItem();
            this.unregister(wi);
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
        }
    }

    @Override
    public void cancelTimer(IActionData actionData) {
        String location = "cancelTimer";
        try {
            MessageBuffer mb = LoggerHelper.getMessageBuffer(actionData);
            logger.debug(location, ILogger.null_id, mb.toString());
            IWorkItem wi = actionData.getWorkItem();
            this.unregister(wi);
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
        }
    }

    private void register(IWorkItem wi, ITimeoutTask timeoutTask) {
        String location = "register";
        try {
            this.mapTask.put(wi, timeoutTask);
            ITimeoutTask callable = timeoutTask;
            long delay = timeoutTask.getDeadline() - System.currentTimeMillis();
            TimeUnit timeUnit = TimeUnit.MILLISECONDS;
            ScheduledFuture<Object> scheduledFuture = this.scheduledExecutorService.schedule(callable, delay, timeUnit);
            this.mapFuture.put(wi, scheduledFuture);
            IActionData actionData = timeoutTask.getActionData();
            MessageBuffer mb = LoggerHelper.getMessageBuffer(actionData);
            mb.append(Standardize.Label.futures.get() + this.mapFuture.size());
            mb.append(Standardize.Label.tasks.get() + this.mapTask.size());
            logger.debug(location, ILogger.null_id, mb.toString());
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
        }
    }

    private void unregister(IWorkItem wi) {
        String location = "unregister";
        try {
            ITimeoutTask timeoutTask;
            ScheduledFuture<?> scheduledFuture = this.mapFuture.remove(wi);
            if (scheduledFuture != null) {
                scheduledFuture.cancel(false);
            }
            if ((timeoutTask = this.mapTask.remove(wi)) != null) {
                IActionData actionData = timeoutTask.getActionData();
                MessageBuffer mb = LoggerHelper.getMessageBuffer(actionData);
                mb.append(Standardize.Label.futures.get() + this.mapFuture.size());
                mb.append(Standardize.Label.tasks.get() + this.mapTask.size());
                logger.debug(location, ILogger.null_id, mb.toString());
            } else {
                MessageBuffer mb = new MessageBuffer();
                mb.append(Standardize.Label.futures.get() + this.mapFuture.size());
                mb.append(Standardize.Label.tasks.get() + this.mapTask.size());
                logger.trace(location, ILogger.null_id, mb.toString());
            }
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
        }
    }

    @Override
    public void timeout(IActionData actionData) {
        String location = "timeout";
        try {
            MessageBuffer mb = LoggerHelper.getMessageBuffer(actionData);
            logger.debug(location, ILogger.null_id, mb.toString());
            IWorkItem wi = actionData.getWorkItem();
            this.unregister(wi);
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
        }
    }
}

