/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.jd.fsm.wi;

import java.util.List;
import org.apache.uima.ducc.common.jd.files.workitem.IWorkItemStateKeeper;
import org.apache.uima.ducc.container.common.MessageBuffer;
import org.apache.uima.ducc.container.common.MetaCasHelper;
import org.apache.uima.ducc.container.common.Standardize;
import org.apache.uima.ducc.container.common.fsm.iface.IAction;
import org.apache.uima.ducc.container.common.logger.IComponent;
import org.apache.uima.ducc.container.common.logger.ILogger;
import org.apache.uima.ducc.container.common.logger.Logger;
import org.apache.uima.ducc.container.jd.JobDriver;
import org.apache.uima.ducc.container.jd.JobDriverHelper;
import org.apache.uima.ducc.container.jd.cas.CasManager;
import org.apache.uima.ducc.container.jd.fsm.wi.ActionEndAbstract;
import org.apache.uima.ducc.container.jd.fsm.wi.ActionHelper;
import org.apache.uima.ducc.container.jd.fsm.wi.IActionData;
import org.apache.uima.ducc.container.jd.log.LoggerHelper;
import org.apache.uima.ducc.container.jd.mh.RemoteWorkerProcess;
import org.apache.uima.ducc.container.jd.timeout.TimeoutManager;
import org.apache.uima.ducc.container.jd.user.error.classload.ProxyUserErrorException;
import org.apache.uima.ducc.container.jd.user.error.classload.ProxyUserErrorStringify;
import org.apache.uima.ducc.container.jd.wi.IProcessStatistics;
import org.apache.uima.ducc.container.jd.wi.IWorkItem;
import org.apache.uima.ducc.container.jd.wi.IWorkItemStatistics;
import org.apache.uima.ducc.container.jd.wi.WiTracker;
import org.apache.uima.ducc.container.jd.wi.perf.IWorkItemPerformanceSummaryKeeper;
import org.apache.uima.ducc.container.jd.wi.perf.WorkItemPerformanceIndividualKeeper;
import org.apache.uima.ducc.ps.net.iface.IMetaTask;
import org.apache.uima.ducc.ps.net.iface.IMetaTaskRequester;
import org.apache.uima.ducc.ps.net.iface.IMetaTaskTransaction;
import org.apache.uima.ducc.ps.service.processor.uima.utils.PerformanceMetrics;
import org.apache.uima.ducc.ps.service.processor.uima.utils.UimaResultDefaultSerializer;

public class ActionEnd
extends ActionEndAbstract
implements IAction {
    private static Logger logger = Logger.getLogger(ActionEnd.class, IComponent.Id.JD.name());
    private ProxyUserErrorStringify proxy = null;
    private String keyName = "name";
    private String keyUniqueName = "uniqueName";
    private String keyAnalysisTime = "analysisTime";
    private String keyAnalysisTasks = "analysisTasks";
    private boolean oldFormat = false;

    public ActionEnd() {
        super(logger);
        this.initialize();
    }

    private void initialize() {
        String location = "initialize";
        try {
            this.proxy = new ProxyUserErrorStringify();
        }
        catch (ProxyUserErrorException e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
        }
    }

    @Override
    public String getName() {
        return ActionEnd.class.getName();
    }

    private void successWorkItem(IActionData actionData, CasManager cm, IWorkItem wi) {
        String location = "successWorkItem";
        cm.getCasManagerStats().incEndSuccess();
        wi.setTodEnd();
        this.updateStatistics(actionData, wi);
        this.updatePerformanceMetrics(actionData, wi);
        MessageBuffer mb = LoggerHelper.getMessageBuffer(actionData);
        logger.debug(location, ILogger.null_id, mb.toString());
        ActionHelper.checkEnded(logger, actionData, cm);
    }

    private void updateStatistics(IActionData actionData, IWorkItem wi) {
        String location = "updateStatistics";
        IWorkItemStatistics wis = JobDriver.getInstance().getWorkItemStatistics();
        wis.ended(wi);
        MessageBuffer mb = LoggerHelper.getMessageBuffer(actionData);
        mb.append(Standardize.Label.avg.get() + wis.getMillisAvg());
        mb.append(Standardize.Label.max.get() + wis.getMillisMax());
        mb.append(Standardize.Label.min.get() + wis.getMillisMin());
        mb.append(Standardize.Label.stddev.get() + wis.getMillisStdDev());
        logger.debug(location, ILogger.null_id, mb.toString());
    }

    private String normalizeUniqueName(String uniqueName) {
        String retVal = uniqueName;
        if (this.oldFormat) {
            try {
                retVal = uniqueName.trim().split("\\s++", 3)[2];
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retVal;
    }

    private void updatePerformanceMetrics(IActionData actionData, IWorkItem wi) {
        IMetaTask metaCas;
        String location = "updatePerformanceMetrics";
        if (wi != null && (metaCas = wi.getMetaCas()) != null) {
            UimaResultDefaultSerializer deserializer = new UimaResultDefaultSerializer();
            List performanceMetrics = null;
            String serializedPerformance = metaCas.getPerformanceMetrics();
            try {
                performanceMetrics = deserializer.deserialize(serializedPerformance);
                if (performanceMetrics == null) {
                    logger.debug(location, ILogger.null_id, "seqNo=", wi.getSeqNo(), "performanceMetrics=", performanceMetrics);
                } else if (performanceMetrics.isEmpty()) {
                    logger.debug(location, ILogger.null_id, "seqNo=", wi.getSeqNo(), "performanceMetrics=", performanceMetrics);
                }
            }
            catch (Exception e) {
                logger.error(location, ILogger.null_id, e, new Object[0]);
            }
            if (performanceMetrics != null && !performanceMetrics.isEmpty()) {
                int size = 0;
                size = performanceMetrics.size();
                logger.debug(location, ILogger.null_id, "seqNo=", wi.getSeqNo(), "performanceMetrics.size=", size);
                JobDriver jd = JobDriver.getInstance();
                String logdir = jd.getLogDir();
                String seqNo = "" + wi.getSeqNo();
                WorkItemPerformanceIndividualKeeper wipik = new WorkItemPerformanceIndividualKeeper(logdir, seqNo);
                IWorkItemPerformanceSummaryKeeper wipsk = jd.getWorkItemPerformanceSummaryKeeper();
                wipsk.count();
                long total_time = 0L;
                long total_tasks = 0L;
                for (PerformanceMetrics pm : performanceMetrics) {
                    String name = pm.getName();
                    String uniqueName = this.normalizeUniqueName(pm.getUniqueName());
                    long time = pm.getAnalysisTime();
                    long tasks = pm.getNumberOfTasksProcessed();
                    logger.debug(location, ILogger.null_id, "seqNo=", seqNo, "name=", name, "uniqueName=", uniqueName, "time=", time, "tasks=", tasks);
                    if (time < 0L) {
                        String text = "seqNo=" + seqNo + " time=" + time + " analysisTime=" + time + " uniqueName=" + uniqueName;
                        logger.warn(location, ILogger.null_id, text);
                    }
                    wipik.dataAdd(name, uniqueName, time, tasks);
                    wipsk.dataAdd(name, uniqueName, time, tasks);
                    MessageBuffer mb = LoggerHelper.getMessageBuffer(actionData);
                    mb.append(Standardize.Label.key.get() + this.keyName);
                    mb.append(Standardize.Label.value.get() + name);
                    mb.append(Standardize.Label.key.get() + this.keyUniqueName);
                    mb.append(Standardize.Label.value.get() + uniqueName);
                    mb.append(Standardize.Label.key.get() + this.keyAnalysisTime);
                    mb.append(Standardize.Label.value.get() + time);
                    mb.append(Standardize.Label.key.get() + this.keyAnalysisTasks);
                    mb.append(Standardize.Label.value.get() + tasks);
                    logger.debug(location, ILogger.null_id, mb.toString());
                    total_time += time;
                    total_tasks += tasks;
                }
                wipik.publish();
                wipsk.dataAdd("TOTALS", "", total_time, total_tasks);
                MessageBuffer mb = LoggerHelper.getMessageBuffer(actionData);
                mb.append(Standardize.Label.size.get() + size);
                logger.debug(location, ILogger.null_id, mb.toString());
            }
        }
    }

    @Override
    public void engage(Object objectData) {
        block8: {
            String location = "engage";
            logger.trace(location, ILogger.null_id, "");
            IActionData actionData = (IActionData)objectData;
            try {
                if (actionData != null) {
                    IWorkItem wi = actionData.getWorkItem();
                    IMetaTaskTransaction trans = actionData.getMetaCasTransaction();
                    RemoteWorkerProcess rwp = new RemoteWorkerProcess((IMetaTaskRequester)trans);
                    IMetaTask metaCas = wi.getMetaCas();
                    JobDriver jd = JobDriver.getInstance();
                    JobDriverHelper jdh = JobDriverHelper.getInstance();
                    CasManager cm = jd.getCasManager();
                    IWorkItemStateKeeper wisk = jd.getWorkItemStateKeeper();
                    MetaCasHelper metaCasHelper = new MetaCasHelper(metaCas);
                    IProcessStatistics pStats = jdh.getProcessStatistics(rwp);
                    if (metaCas != null) {
                        WiTracker.getInstance().unassign(wi);
                        TimeoutManager toMgr = TimeoutManager.getInstance();
                        toMgr.receivedAck(actionData);
                        toMgr.receivedEnd(actionData);
                        int seqNo = metaCasHelper.getSystemKey();
                        Object exception = metaCas.getUserSpaceException();
                        if (exception != null) {
                            MessageBuffer mb = LoggerHelper.getMessageBuffer(actionData);
                            mb.append("exception");
                            logger.info(location, ILogger.null_id, mb.toString());
                            Object userException = metaCas.getUserSpaceException();
                            String printableException = null;
                            try {
                                printableException = this.proxy.convert(userException);
                            }
                            catch (Exception e) {
                                MessageBuffer eb = LoggerHelper.getMessageBuffer(actionData);
                                eb.append("unable to convert user job process exception into printable form");
                                logger.error(location, ILogger.null_id, eb.toString());
                            }
                            this.handleException(actionData, ActionEndAbstract.ExceptionType.User, userException, printableException);
                            this.displayProcessStatistics(logger, actionData, wi, pStats);
                        } else {
                            MessageBuffer mb = LoggerHelper.getMessageBuffer(actionData);
                            mb.append("ended");
                            logger.info(location, ILogger.null_id, mb.toString());
                            wisk.ended(seqNo);
                            this.successWorkItem(actionData, cm, wi);
                            pStats.done(wi);
                            this.displayProcessStatistics(logger, actionData, wi, pStats);
                        }
                        wi.reset();
                        break block8;
                    }
                    MessageBuffer mb = LoggerHelper.getMessageBuffer(actionData);
                    mb.append("No CAS found for processing");
                    logger.info(location, ILogger.null_id, mb.toString());
                    break block8;
                }
                MessageBuffer mb = LoggerHelper.getMessageBuffer(actionData);
                mb.append("No action data found for processing");
                logger.warn(location, ILogger.null_id, mb.toString());
            }
            catch (Exception e) {
                logger.error(location, ILogger.null_id, e, new Object[0]);
            }
        }
    }
}

