/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.event.common.history;

import org.apache.uima.ducc.common.main.DuccService;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.transport.event.common.history.IHistoryPersistenceManager;
import org.apache.uima.ducc.transport.event.common.history.NullHistoryManager;

public class HistoryFactory {
    private static IHistoryPersistenceManager instance = null;

    public static IHistoryPersistenceManager getInstance(String callerClass) {
        if (instance != null) {
            return instance;
        }
        String methodName = "getInstance";
        int ndx = callerClass.lastIndexOf(".");
        String stem = callerClass.substring(0, ndx);
        String clname = System.getProperty("ducc.job.history.impl");
        if (clname == null) {
            DuccLogger logger = DuccService.getDuccLogger();
            logger.error(methodName, null, new Object[]{"Job history class is not configured."});
            instance = new NullHistoryManager();
            return instance;
        }
        ndx = clname.lastIndexOf(".");
        String clfile = clname.substring(ndx + 1);
        DuccLogger logger = DuccLogger.getLogger((String)(stem + "." + clfile), (String)"DB");
        try {
            Class<?> iss = Class.forName(clname);
            instance = (IHistoryPersistenceManager)iss.newInstance();
            instance.init(logger);
        }
        catch (Throwable t) {
            logger.error(methodName, null, new Object[]{"Cannot instantiate service persistence class", clname, ":", t});
            instance = new NullHistoryManager();
        }
        return instance;
    }
}

