/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.event.common;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.uima.ducc.container.jd.mh.iface.IProcessInfo;
import org.apache.uima.ducc.transport.event.common.IDuccProcessWorkItemsV1;

public class DuccProcessWorkItemsV1
implements IDuccProcessWorkItemsV1 {
    private static final long serialVersionUID = 1L;
    private long unassigned = 0L;
    private AtomicLong dispatch = new AtomicLong(0L);
    private AtomicLong done = new AtomicLong(0L);
    private AtomicLong error = new AtomicLong(0L);
    private AtomicLong retry = new AtomicLong(0L);
    private AtomicLong lost = new AtomicLong(0L);
    private AtomicLong preempt = new AtomicLong(0L);
    private AtomicLong completedMillisTotal = new AtomicLong(0L);
    private AtomicLong completedMillisAvg = new AtomicLong(0L);
    private AtomicLong completedMillisMax = new AtomicLong(0L);
    private AtomicLong completedMillisMin = new AtomicLong(0L);

    public DuccProcessWorkItemsV1() {
    }

    public DuccProcessWorkItemsV1(IProcessInfo pi) {
        this.dispatch.set(pi.getDispatch());
        this.done.set(pi.getDone());
        this.error.set(pi.getError());
        this.retry.set(pi.getRetry());
        this.lost.set(0L);
        this.preempt.set(pi.getPreempt());
        this.completedMillisAvg.set(pi.getAvg());
        this.completedMillisMax.set(pi.getMax());
        this.completedMillisMin.set(pi.getMin());
    }

    @Override
    public boolean isAssignedWork() {
        boolean retVal = true;
        if (this.getCountDispatch() == 0L && this.getCountDone() == 0L && this.getCountError() == 0L && this.getCountPreempt() == 0L && this.getCountRetry() == 0L && this.getCountLost() == 0L) {
            retVal = false;
        }
        return retVal;
    }

    @Override
    public long getCountUnassigned() {
        return this.unassigned;
    }

    @Override
    public void setCountUnassigned(long count) {
        this.unassigned = count;
    }

    private void setMin(long update) {
        long min;
        this.completedMillisMin.compareAndSet(0L, update);
        while (update < (min = this.completedMillisMin.get())) {
            this.completedMillisMin.compareAndSet(min, update);
        }
    }

    private void setMax(long update) {
        long max;
        this.completedMillisMax.compareAndSet(0L, update);
        while (update > (max = this.completedMillisMax.get())) {
            this.completedMillisMax.compareAndSet(max, update);
        }
    }

    @Override
    public void done(long delta) {
        this.done.incrementAndGet();
        this.completedMillisTotal.addAndGet(delta);
        this.setMin(delta);
        this.setMax(delta);
        this.undispatch();
    }

    @Override
    public void error() {
        this.error.incrementAndGet();
        this.undispatch();
    }

    @Override
    public void retry() {
        this.retry.incrementAndGet();
        this.undispatch();
    }

    @Override
    public void lost() {
        this.lost.incrementAndGet();
    }

    @Override
    public void preempt() {
        this.preempt.incrementAndGet();
        this.undispatch();
    }

    @Override
    public void dispatch() {
        this.dispatch.incrementAndGet();
    }

    private void undispatch() {
        this.dispatch.decrementAndGet();
    }

    @Override
    public long getCountDispatch() {
        long retVal = 0L;
        try {
            retVal = this.dispatch.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retVal;
    }

    @Override
    public long getCountDone() {
        long retVal = 0L;
        try {
            retVal = this.done.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retVal;
    }

    @Override
    public long getCountError() {
        long retVal = 0L;
        try {
            retVal = this.error.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retVal;
    }

    @Override
    public long getCountRetry() {
        long retVal = 0L;
        try {
            retVal = this.retry.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retVal;
    }

    @Override
    public long getCountLost() {
        long retVal = 0L;
        try {
            retVal = this.lost.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retVal;
    }

    @Override
    public long getCountPreempt() {
        long retVal = 0L;
        try {
            retVal = this.preempt.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retVal;
    }

    public long getSecsAvgV1() {
        long retVal = 0L;
        try {
            long count = this.done.get();
            if (count > 0L) {
                double msecs = (double)this.completedMillisTotal.get() / (double)count;
                retVal = (long)(msecs / 1000.0);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retVal;
    }

    @Override
    public long getSecsAvg() {
        long retVal = 0L;
        try {
            double msecs = this.completedMillisAvg.get();
            retVal = (long)(msecs / 1000.0);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (retVal == 0L) {
            retVal = this.getSecsAvgV1();
        }
        return retVal;
    }

    @Override
    public long getSecsMax() {
        long retVal = 0L;
        try {
            double msecs = this.completedMillisMax.get();
            retVal = (long)(msecs / 1000.0);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retVal;
    }

    @Override
    public long getSecsMin() {
        long retVal = 0L;
        try {
            double msecs = this.completedMillisMin.get();
            retVal = (long)(msecs / 1000.0);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retVal;
    }

    @Override
    public void setCountDispatch(long value) {
    }

    @Override
    public void setCountDone(long value) {
    }

    @Override
    public void setCountError(long value) {
    }

    @Override
    public void setCountRetry(long value) {
    }

    @Override
    public void setCountPreempt(long value) {
    }

    @Override
    public void setMillisAvg(long value) {
    }

    @Override
    public void setMillisMax(long value) {
    }

    @Override
    public void setMillisMin(long value) {
    }

    @Override
    public long getMillisAvg() {
        return 0L;
    }

    @Override
    public long getMillisMax() {
        return 0L;
    }

    @Override
    public long getMillisMin() {
        return 0L;
    }

    @Override
    public boolean isActiveWork() {
        boolean retVal = true;
        if (this.getCountDispatch() == 0L) {
            retVal = false;
        }
        return retVal;
    }
}

