/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.configuration.jp;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.net.SocketTimeoutException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.client.methods.HttpPost;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.ps.net.iface.IMetaTaskTransaction;
import org.apache.uima.ducc.ps.net.impl.MetaTaskTransaction;
import org.apache.uima.ducc.ps.net.impl.TransactionId;
import org.apache.uima.ducc.transport.configuration.jp.DuccHttpClient;
import org.apache.uima.ducc.transport.configuration.jp.JobProcessComponent;

public class HttpWorkerThread
implements Runnable {
    DuccLogger logger = new DuccLogger(HttpWorkerThread.class);
    private DuccHttpClient httpClient = null;
    private JobProcessComponent duccComponent;
    private Object monitor = new Object();
    private CountDownLatch workerThreadCount = null;
    private CountDownLatch threadReadyCount = null;
    private Object processorInstance = null;
    private static AtomicInteger IdGenerator = new AtomicInteger();
    private Map<String, IMetaTaskTransaction> transactionMap = new ConcurrentHashMap<String, IMetaTaskTransaction>();
    static AtomicInteger maxFrameworkFailures;
    private int maxFrameworkErrors = 2;
    private final boolean exitOnProcessFailure;

    public HttpWorkerThread(JobProcessComponent component, DuccHttpClient httpClient, Object processorInstance, CountDownLatch workerThreadCount, CountDownLatch threadReadyCount, Map<String, IMetaTaskTransaction> transactionMap, AtomicInteger maxFrameworkFailures) {
        this.duccComponent = component;
        this.httpClient = httpClient;
        this.processorInstance = processorInstance;
        this.workerThreadCount = workerThreadCount;
        this.threadReadyCount = threadReadyCount;
        this.transactionMap = transactionMap;
        HttpWorkerThread.maxFrameworkFailures = maxFrameworkFailures;
        this.maxFrameworkErrors = maxFrameworkFailures.get();
        String exitProperty = System.getProperty("ExitOnProcessFailure");
        if (exitProperty == null || exitProperty.trim().equalsIgnoreCase("true")) {
            this.exitOnProcessFailure = true;
        } else if (exitProperty.trim().equalsIgnoreCase("false")) {
            this.exitOnProcessFailure = false;
        } else {
            throw new IllegalArgumentException("Invalid value for property ExitOnProcessFailure. Should be [true/false] but is " + exitProperty);
        }
    }

    public IMetaTaskTransaction getWork(HttpPost postMethod, int major, int minor) throws Exception {
        String command = "";
        MetaTaskTransaction transaction = new MetaTaskTransaction();
        try {
            TransactionId tid = new TransactionId(major, minor);
            transaction.setTransactionId(tid);
            transaction.setType(IMetaTaskTransaction.Type.Get);
            command = IMetaTaskTransaction.Type.Get.name();
            this.logger.debug("HttpWorkerThread.run()", null, new Object[]{"Thread Id:" + Thread.currentThread().getId() + " Requesting next WI from JD"});
            transaction = this.httpClient.execute((IMetaTaskTransaction)transaction, postMethod);
            if (transaction != null && transaction.getMetaTask() != null) {
                this.logger.info("run", null, new Object[]{"Thread:" + Thread.currentThread().getId() + " Recv'd WI:" + transaction.getMetaTask().getSystemKey()});
                transaction.setType(IMetaTaskTransaction.Type.Ack);
                command = IMetaTaskTransaction.Type.Ack.name();
                tid = new TransactionId(major, minor++);
                transaction.setTransactionId(tid);
                this.logger.debug("run", null, new Object[]{"Thread:" + Thread.currentThread().getId() + " Sending ACK request - WI:" + transaction.getMetaTask().getSystemKey()});
                transaction = this.httpClient.execute((IMetaTaskTransaction)transaction, postMethod);
                if (transaction.getMetaTask() == null) {
                    this.logger.info("run", null, new Object[]{"Thread:" + Thread.currentThread().getId() + " ACK reply recv'd, however there is no MetaCas. The JD Cancelled the transaction"});
                } else {
                    this.logger.debug("run", null, new Object[]{"Thread:" + Thread.currentThread().getId() + " ACK reply recv'd"});
                }
            }
        }
        catch (SocketTimeoutException e) {
            this.logger.warn("run", null, new Object[]{"Timed Out While Awaiting Response from JD for " + command + " Request - Retrying ..."});
        }
        return transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitAwhile(long sleepTime) throws InterruptedException {
        Object object = this.monitor;
        synchronized (object) {
            this.monitor.wait(sleepTime);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [79[SIMPLE_IF_TAKEN]], but top level block is 33[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] serializeException(Throwable t) {
        byte[] serializedException;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(baos);
            oos.writeObject(t);
            serializedException = baos.toByteArray();
        }
        catch (Exception ee) {
            RuntimeException e2 = new RuntimeException("Ducc Service Failed to Serialize the Cause of Process Failure. Check Service Log for Details");
            try {
                oos.writeObject(e2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            serializedException = baos.toByteArray();
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (Exception exception) {}
            }
        }
        return serializedException;
    }
}

