/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.configuration.jp;

import java.util.List;
import org.apache.uima.ducc.common.IDuccUser;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.Utils;
import org.apache.uima.ducc.container.jp.iface.IJobProcessManagerCallbackListener;
import org.apache.uima.ducc.transport.agent.IUimaPipelineAEComponent;
import org.apache.uima.ducc.transport.agent.ProcessStateUpdate;
import org.apache.uima.ducc.transport.configuration.jp.iface.IAgentSession;
import org.apache.uima.ducc.transport.dispatcher.DuccEventDispatcher;
import org.apache.uima.ducc.transport.event.DuccEvent;
import org.apache.uima.ducc.transport.event.ProcessStateUpdateDuccEvent;
import org.apache.uima.ducc.transport.event.common.IProcessState;

public class AgentSession
implements IAgentSession,
IJobProcessManagerCallbackListener {
    DuccLogger logger = DuccLogger.getLogger(this.getClass(), (String)"Job Process");
    private DuccEventDispatcher dispatcher;
    private String pid = null;
    private String duccProcessId;
    private IProcessState.ProcessState state;
    private String endpoint;
    private Object stateLock = new Object();
    private volatile boolean stopped = false;
    private volatile boolean log = true;
    private volatile boolean disabled = false;

    public AgentSession(DuccEventDispatcher dispatcher, String duccProcessId, String endpoint) {
        this.dispatcher = dispatcher;
        this.duccProcessId = duccProcessId;
        this.endpoint = endpoint;
    }

    public void disable(boolean trueOrFalse) {
        this.disabled = trueOrFalse;
    }

    @Override
    public void notify(IProcessState.ProcessState state) {
        this.notify(state, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(IProcessState.ProcessState state, String message) {
        if (this.disabled) {
            return;
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.state = state;
            if (this.pid == null) {
                this.pid = Utils.getPID();
            }
            ProcessStateUpdate processUpdate = null;
            processUpdate = message == null ? new ProcessStateUpdate(state, this.pid, this.duccProcessId, null) : new ProcessStateUpdate(state, this.pid, this.duccProcessId, message, null);
            if (this.endpoint != null) {
                processUpdate.setSocketEndpoint(this.endpoint);
            }
            this.notify(processUpdate);
        }
    }

    public void notify(ProcessStateUpdate state) {
        if (this.disabled) {
            return;
        }
        if (this.stopped || state.getState().equals((Object)IProcessState.ProcessState.Stopping) && state.getMessage() == null) {
            return;
        }
        try {
            String jmx;
            ProcessStateUpdateDuccEvent duccEvent = new ProcessStateUpdateDuccEvent(state);
            if (this.endpoint != null) {
                state.setSocketEndpoint(this.endpoint);
            }
            this.dispatcher.dispatch((DuccEvent)duccEvent, System.getenv(IDuccUser.EnvironmentVariable.DUCC_IP.value()));
            String string = jmx = state.getProcessJmxUrl() == null ? "N/A" : state.getProcessJmxUrl();
            if (state.getState().equals((Object)IProcessState.ProcessState.Running) && this.log) {
                this.log = false;
                this.logger.info("notifyAgentWithStatus", null, new Object[]{"... Job Process State Changed - PID:" + this.pid + ". Process State: " + state.getState().toString() + ". JMX Url:" + jmx + " Dispatched State Update Event to Agent with IP:" + System.getenv(IDuccUser.EnvironmentVariable.DUCC_IP.value())});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(boolean forceUpdate, List<IUimaPipelineAEComponent> pipeline) {
        if (this.disabled) {
            return;
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (forceUpdate || this.state.equals((Object)IProcessState.ProcessState.Initializing)) {
                try {
                    ProcessStateUpdate processUpdate = new ProcessStateUpdate(this.state, this.pid, this.duccProcessId, null, pipeline);
                    this.notify(processUpdate);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void stop() throws Exception {
        this.stopped = true;
        this.dispatcher.stop();
    }
}

