/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.spring;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.impl.DefaultDebugger;
import org.apache.camel.impl.InterceptSendToMockEndpointStrategy;
import org.apache.camel.spi.Breakpoint;
import org.apache.camel.spi.Debugger;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.test.ExcludingPackageScanClassResolver;
import org.apache.camel.test.spring.CamelSpringTestHelper;
import org.apache.camel.test.spring.DisableJmx;
import org.apache.camel.test.spring.ExcludeRoutes;
import org.apache.camel.test.spring.MockEndpoints;
import org.apache.camel.test.spring.MockEndpointsAndSkip;
import org.apache.camel.test.spring.ProvidesBreakpoint;
import org.apache.camel.test.spring.ShutdownTimeout;
import org.apache.camel.test.spring.UseAdviceWith;
import org.apache.camel.test.spring.UseOverridePropertiesWithPropertiesComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.support.AbstractContextLoader;
import org.springframework.util.StringUtils;

public class CamelSpringTestContextLoader
extends AbstractContextLoader {
    private static final Logger LOG = LoggerFactory.getLogger(CamelSpringTestContextLoader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationContext loadContext(MergedContextConfiguration mergedConfig) throws Exception {
        Class<?> testClass = this.getTestClass();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading ApplicationContext for merged context configuration [{}].", (Object)mergedConfig);
        }
        try {
            GenericApplicationContext context = this.createContext(testClass, mergedConfig);
            context.getEnvironment().setActiveProfiles(mergedConfig.getActiveProfiles());
            this.loadBeanDefinitions(context, mergedConfig);
            ApplicationContext applicationContext = this.loadContext(context, testClass);
            return applicationContext;
        }
        finally {
            this.cleanup(testClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationContext loadContext(String ... locations) throws Exception {
        Class<?> testClass = this.getTestClass();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading ApplicationContext for locations [" + StringUtils.arrayToCommaDelimitedString((Object[])locations) + "].");
        }
        try {
            GenericApplicationContext context = this.createContext(testClass, null);
            this.loadBeanDefinitions(context, locations);
            ApplicationContext applicationContext = this.loadContext(context, testClass);
            return applicationContext;
        }
        finally {
            this.cleanup(testClass);
        }
    }

    public String getResourceSuffix() {
        return "-context.xml";
    }

    protected ApplicationContext loadContext(GenericApplicationContext context, Class<?> testClass) throws Exception {
        AnnotationConfigUtils.registerAnnotationConfigProcessors((BeanDefinitionRegistry)context);
        this.handleDisableJmx(context, testClass);
        SpringCamelContext.setNoStart((boolean)true);
        context.refresh();
        context.registerShutdownHook();
        SpringCamelContext.setNoStart((boolean)false);
        this.handleProvidesBreakpoint(context, testClass);
        this.handleShutdownTimeout(context, testClass);
        this.handleMockEndpoints(context, testClass);
        this.handleMockEndpointsAndSkip(context, testClass);
        this.handleUseOverridePropertiesWithPropertiesComponent((ConfigurableApplicationContext)context, testClass);
        this.handleCamelContextStartup(context, testClass);
        return context;
    }

    protected void cleanup(Class<?> testClass) {
        SpringCamelContext.setNoStart((boolean)false);
        if (testClass.isAnnotationPresent(DisableJmx.class)) {
            if (CamelSpringTestHelper.getOriginalJmxDisabled() == null) {
                System.clearProperty("org.apache.camel.jmx.disabled");
            } else {
                System.setProperty("org.apache.camel.jmx.disabled", CamelSpringTestHelper.getOriginalJmxDisabled());
            }
        }
    }

    protected void loadBeanDefinitions(GenericApplicationContext context, MergedContextConfiguration mergedConfig) {
        new XmlBeanDefinitionReader((BeanDefinitionRegistry)context).loadBeanDefinitions(mergedConfig.getLocations());
    }

    protected void loadBeanDefinitions(GenericApplicationContext context, String ... locations) {
        new XmlBeanDefinitionReader((BeanDefinitionRegistry)context).loadBeanDefinitions(locations);
    }

    protected GenericApplicationContext createContext(Class<?> testClass, MergedContextConfiguration mergedConfig) {
        ApplicationContext parentContext = null;
        GenericApplicationContext routeExcludingContext = null;
        if (mergedConfig != null) {
            parentContext = mergedConfig.getParentApplicationContext();
        }
        if (testClass.isAnnotationPresent(ExcludeRoutes.class)) {
            Object[] excludedClasses = testClass.getAnnotation(ExcludeRoutes.class).value();
            if (excludedClasses.length > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Setting up package scanning excluded classes as ExcludeRoutes annotation was found. Excluding [" + StringUtils.arrayToCommaDelimitedString((Object[])excludedClasses) + "].");
                }
                routeExcludingContext = parentContext == null ? new GenericApplicationContext() : new GenericApplicationContext(parentContext);
                routeExcludingContext.registerBeanDefinition("excludingResolver", (BeanDefinition)new RootBeanDefinition(ExcludingPackageScanClassResolver.class));
                routeExcludingContext.refresh();
                ExcludingPackageScanClassResolver excludingResolver = (ExcludingPackageScanClassResolver)routeExcludingContext.getBean("excludingResolver", ExcludingPackageScanClassResolver.class);
                List<Object> excluded = Arrays.asList(excludedClasses);
                excludingResolver.setExcludedClasses(new HashSet<Object>(excluded));
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Not enabling package scanning excluded classes as ExcludeRoutes annotation was found but no classes were excluded.");
            }
        }
        GenericApplicationContext context = routeExcludingContext != null ? new GenericApplicationContext(routeExcludingContext) : (parentContext != null ? new GenericApplicationContext(parentContext) : new GenericApplicationContext());
        return context;
    }

    protected void handleDisableJmx(GenericApplicationContext context, Class<?> testClass) {
        CamelSpringTestHelper.setOriginalJmxDisabledValue(System.getProperty("org.apache.camel.jmx.disabled"));
        if (testClass.isAnnotationPresent(DisableJmx.class)) {
            if (testClass.getAnnotation(DisableJmx.class).value()) {
                LOG.info("Disabling Camel JMX globally as DisableJmx annotation was found and disableJmx is set to true.");
                System.setProperty("org.apache.camel.jmx.disabled", "true");
            } else {
                LOG.info("Enabling Camel JMX as DisableJmx annotation was found and disableJmx is set to false.");
                System.clearProperty("org.apache.camel.jmx.disabled");
            }
        } else {
            LOG.info("Disabling Camel JMX globally for tests by default.  Use the DisableJMX annotation to override the default setting.");
            System.setProperty("org.apache.camel.jmx.disabled", "true");
        }
    }

    protected void handleProvidesBreakpoint(GenericApplicationContext context, Class<?> testClass) throws Exception {
        Collection<Method> methods = CamelSpringTestHelper.getAllMethods(testClass);
        final LinkedList<Breakpoint> breakpoints = new LinkedList<Breakpoint>();
        for (Method method : methods) {
            if (AnnotationUtils.findAnnotation((Method)method, ProvidesBreakpoint.class) == null) continue;
            Class<?>[] argTypes = method.getParameterTypes();
            if (argTypes.length != 0) {
                throw new IllegalArgumentException("Method [" + method.getName() + "] is annotated with ProvidesBreakpoint but is not a no-argument method.");
            }
            if (!Breakpoint.class.isAssignableFrom(method.getReturnType())) {
                throw new IllegalArgumentException("Method [" + method.getName() + "] is annotated with ProvidesBreakpoint but does not return a Breakpoint.");
            }
            if (!Modifier.isStatic(method.getModifiers())) {
                throw new IllegalArgumentException("Method [" + method.getName() + "] is annotated with ProvidesBreakpoint but is not static.");
            }
            if (!Modifier.isPublic(method.getModifiers())) {
                throw new IllegalArgumentException("Method [" + method.getName() + "] is annotated with ProvidesBreakpoint but is not public.");
            }
            try {
                breakpoints.add((Breakpoint)method.invoke(null, new Object[0]));
            }
            catch (Exception e) {
                throw new RuntimeException("Method [" + method.getName() + "] threw exception during evaluation.", e);
            }
        }
        if (breakpoints.size() != 0) {
            CamelSpringTestHelper.doToSpringCamelContexts((ApplicationContext)context, new CamelSpringTestHelper.DoToSpringCamelContextsStrategy(){

                @Override
                public void execute(String contextName, SpringCamelContext camelContext) throws Exception {
                    Debugger debugger = camelContext.getDebugger();
                    if (debugger == null) {
                        debugger = new DefaultDebugger();
                        camelContext.setDebugger(debugger);
                    }
                    for (Breakpoint breakpoint : breakpoints) {
                        LOG.info("Adding Breakpoint [{}] to CamelContext with name [{}].", (Object)breakpoint, (Object)contextName);
                        debugger.addBreakpoint(breakpoint);
                    }
                }
            });
        }
    }

    protected void handleShutdownTimeout(GenericApplicationContext context, Class<?> testClass) throws Exception {
        TimeUnit shutdownTimeUnit;
        int shutdownTimeout;
        if (testClass.isAnnotationPresent(ShutdownTimeout.class)) {
            shutdownTimeout = testClass.getAnnotation(ShutdownTimeout.class).value();
            shutdownTimeUnit = testClass.getAnnotation(ShutdownTimeout.class).timeUnit();
        } else {
            shutdownTimeout = 10;
            shutdownTimeUnit = TimeUnit.SECONDS;
        }
        CamelSpringTestHelper.doToSpringCamelContexts((ApplicationContext)context, new CamelSpringTestHelper.DoToSpringCamelContextsStrategy(){

            @Override
            public void execute(String contextName, SpringCamelContext camelContext) throws Exception {
                LOG.info("Setting shutdown timeout to [{} {}] on CamelContext with name [{}].", new Object[]{shutdownTimeout, shutdownTimeUnit, contextName});
                camelContext.getShutdownStrategy().setTimeout((long)shutdownTimeout);
                camelContext.getShutdownStrategy().setTimeUnit(shutdownTimeUnit);
            }
        });
    }

    protected void handleMockEndpoints(GenericApplicationContext context, Class<?> testClass) throws Exception {
        if (testClass.isAnnotationPresent(MockEndpoints.class)) {
            final String mockEndpoints = testClass.getAnnotation(MockEndpoints.class).value();
            CamelSpringTestHelper.doToSpringCamelContexts((ApplicationContext)context, new CamelSpringTestHelper.DoToSpringCamelContextsStrategy(){

                @Override
                public void execute(String contextName, SpringCamelContext camelContext) throws Exception {
                    LOG.info("Enabling auto mocking of endpoints matching pattern [{}] on CamelContext with name [{}].", (Object)mockEndpoints, (Object)contextName);
                    camelContext.addRegisterEndpointCallback((EndpointStrategy)new InterceptSendToMockEndpointStrategy(mockEndpoints));
                }
            });
        }
    }

    protected void handleMockEndpointsAndSkip(GenericApplicationContext context, Class<?> testClass) throws Exception {
        if (testClass.isAnnotationPresent(MockEndpointsAndSkip.class)) {
            final String mockEndpoints = testClass.getAnnotation(MockEndpointsAndSkip.class).value();
            CamelSpringTestHelper.doToSpringCamelContexts((ApplicationContext)context, new CamelSpringTestHelper.DoToSpringCamelContextsStrategy(){

                @Override
                public void execute(String contextName, SpringCamelContext camelContext) throws Exception {
                    String mockEndpointsValue = camelContext.resolvePropertyPlaceholders(mockEndpoints);
                    LOG.info("Enabling auto mocking and skipping of endpoints matching pattern [{}] on CamelContext with name [{}].", (Object)mockEndpointsValue, (Object)contextName);
                    camelContext.addRegisterEndpointCallback((EndpointStrategy)new InterceptSendToMockEndpointStrategy(mockEndpointsValue, true));
                }
            });
        }
    }

    protected void handleUseOverridePropertiesWithPropertiesComponent(ConfigurableApplicationContext context, Class<?> testClass) throws Exception {
        Collection<Method> methods = CamelSpringTestHelper.getAllMethods(testClass);
        final LinkedList<Properties> properties = new LinkedList<Properties>();
        for (Method method : methods) {
            if (AnnotationUtils.findAnnotation((Method)method, UseOverridePropertiesWithPropertiesComponent.class) == null) continue;
            Class<?>[] argTypes = method.getParameterTypes();
            if (argTypes.length > 0) {
                throw new IllegalArgumentException("Method [" + method.getName() + "] is annotated with UseOverridePropertiesWithPropertiesComponent but is not a no-argument method.");
            }
            if (!Properties.class.isAssignableFrom(method.getReturnType())) {
                throw new IllegalArgumentException("Method [" + method.getName() + "] is annotated with UseOverridePropertiesWithPropertiesComponent but does not return a java.util.Properties.");
            }
            if (!Modifier.isStatic(method.getModifiers())) {
                throw new IllegalArgumentException("Method [" + method.getName() + "] is annotated with UseOverridePropertiesWithPropertiesComponent but is not static.");
            }
            if (!Modifier.isPublic(method.getModifiers())) {
                throw new IllegalArgumentException("Method [" + method.getName() + "] is annotated with UseOverridePropertiesWithPropertiesComponent but is not public.");
            }
            try {
                properties.add((Properties)method.invoke(null, new Object[0]));
            }
            catch (Exception e) {
                throw new RuntimeException("Method [" + method.getName() + "] threw exception during evaluation.", e);
            }
        }
        if (properties.size() != 0) {
            CamelSpringTestHelper.doToSpringCamelContexts((ApplicationContext)context, new CamelSpringTestHelper.DoToSpringCamelContextsStrategy(){

                @Override
                public void execute(String contextName, SpringCamelContext camelContext) throws Exception {
                    PropertiesComponent pc = (PropertiesComponent)camelContext.getComponent("properties", PropertiesComponent.class);
                    Properties extra = new Properties();
                    for (Properties prop : properties) {
                        extra.putAll((Map<?, ?>)prop);
                    }
                    if (!extra.isEmpty()) {
                        LOG.info("Using {} properties to override any existing properties on the PropertiesComponent on CamelContext with name [{}].", (Object)extra.size(), (Object)contextName);
                        pc.setOverrideProperties(extra);
                    }
                }
            });
        }
    }

    protected void handleCamelContextStartup(GenericApplicationContext context, Class<?> testClass) throws Exception {
        boolean skip = "true".equalsIgnoreCase(System.getProperty("skipStartingCamelContext"));
        if (skip) {
            LOG.info("Skipping starting CamelContext(s) as system property skipStartingCamelContext is set to be true.");
        } else if (testClass.isAnnotationPresent(UseAdviceWith.class)) {
            if (testClass.getAnnotation(UseAdviceWith.class).value()) {
                LOG.info("Skipping starting CamelContext(s) as UseAdviceWith annotation was found and isUseAdviceWith is set to true.");
                skip = true;
            } else {
                LOG.info("Starting CamelContext(s) as UseAdviceWith annotation was found, but isUseAdviceWith is set to false.");
                skip = false;
            }
        }
        if (!skip) {
            CamelSpringTestHelper.doToSpringCamelContexts((ApplicationContext)context, new CamelSpringTestHelper.DoToSpringCamelContextsStrategy(){

                @Override
                public void execute(String contextName, SpringCamelContext camelContext) throws Exception {
                    LOG.info("Starting CamelContext with name [{}].", (Object)contextName);
                    camelContext.start();
                }
            });
        }
    }

    protected Class<?> getTestClass() {
        return CamelSpringTestHelper.getTestClass();
    }
}

