/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.agent.deploy;

import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.dispatcher.DuccEventHttpDispatcher;
import org.apache.uima.ducc.transport.dispatcher.IDuccEventDispatcher;
import org.apache.uima.ducc.transport.event.DuccEvent;
import org.apache.uima.ducc.transport.event.DuccWorkReplyEvent;
import org.apache.uima.ducc.transport.event.DuccWorkRequestEvent;
import org.apache.uima.ducc.transport.event.common.IDuccWork;

public class DuccWorkHelper {
    public static DuccLogger logger = DuccLogger.getLogger(DuccWorkHelper.class, (String)"Agent");
    private IDuccEventDispatcher dispatcher = null;
    private DuccId jobid = null;
    private String orchestrator = "orchestrator";

    public DuccWorkHelper() {
        this.init();
    }

    private void init() {
        String location = "init";
        try {
            String targetUrl = this.getTargetUrl();
            this.dispatcher = new DuccEventHttpDispatcher(targetUrl);
        }
        catch (Exception e) {
            logger.error(location, this.jobid, (Throwable)e, new Object[0]);
        }
    }

    private String getServer() {
        return this.orchestrator;
    }

    private String getTargetUrl() {
        String location = "getTargetUrl";
        String targetUrl = null;
        String server = this.getServer();
        String host = DuccPropertiesResolver.get((String)"ducc.head");
        String port = DuccPropertiesResolver.get((String)("ducc." + server + ".http.port"));
        if (host == null || port == null) {
            String message = "ducc." + server + ".http.node and/or .port not set in ducc.properties";
            throw new IllegalStateException(message);
        }
        targetUrl = "http://" + host + ":" + port + "/" + server.substring(0, 2);
        logger.info(location, this.jobid, new Object[]{targetUrl});
        return targetUrl;
    }

    public IDuccWork fetch(DuccId duccId) {
        IDuccWork dw;
        block7: {
            String location = "fetch";
            dw = null;
            if (duccId != null) {
                DuccWorkRequestEvent dwRequestEvent = new DuccWorkRequestEvent(duccId);
                DuccWorkReplyEvent dwReplyEvent = null;
                try {
                    dwReplyEvent = (DuccWorkReplyEvent)this.dispatcher.dispatchAndWaitForDuccReply((DuccEvent)dwRequestEvent);
                    if (dwReplyEvent != null) {
                        dw = dwReplyEvent.getDw();
                        if (dw == null) {
                            logger.debug(location, duccId, new Object[]{"value is null"});
                        } else {
                            logger.debug(location, duccId, new Object[]{"state is " + dw.getStateObject()});
                        }
                        break block7;
                    }
                    logger.debug(location, duccId, new Object[]{"reply is null"});
                }
                catch (Exception e) {
                    logger.error(location, duccId, new Object[]{"Error while communicating with the OR:\n" + e});
                }
            } else {
                logger.debug(location, duccId, new Object[]{"key is null"});
            }
        }
        return dw;
    }
}

