/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.adapter.jms.activemq;

import java.net.ConnectException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQMessageProducer;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.AsyncCallback;
import org.apache.activemq.ConnectionFailedException;
import org.apache.activemq.advisory.ConsumerEvent;
import org.apache.activemq.advisory.ConsumerListener;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.InputChannel;
import org.apache.uima.aae.controller.AggregateAnalysisEngineController;
import org.apache.uima.aae.controller.AnalysisEngineController;
import org.apache.uima.aae.controller.BaseAnalysisEngineController;
import org.apache.uima.aae.controller.Endpoint;
import org.apache.uima.aae.controller.LocalCache;
import org.apache.uima.aae.delegate.Delegate;
import org.apache.uima.aae.error.AsynchAEException;
import org.apache.uima.aae.error.DelegateConnectionLostException;
import org.apache.uima.aae.error.InvalidMessageException;
import org.apache.uima.aae.error.ServiceShutdownException;
import org.apache.uima.adapter.jms.activemq.JmsOutputChannel;
import org.apache.uima.cas.CAS;
import org.apache.uima.util.Level;

public class JmsEndpointConnection_impl
implements ConsumerListener {
    private static final Class CLASS_NAME = JmsEndpointConnection_impl.class;
    protected AtomicLong lastDispatchTimestamp = new AtomicLong(0L);
    protected Destination destination;
    protected Session producerSession;
    private MessageProducer producer;
    private JmsOutputChannel.BrokerConnectionEntry brokerDestinations;
    private String serverUri;
    private String endpoint;
    private String endpointName;
    protected Endpoint delegateEndpoint;
    private volatile boolean retryEnabled;
    protected AnalysisEngineController controller = null;
    private volatile boolean connectionAborted = false;
    protected static long connectionCreationTimestamp = 0L;
    private Object semaphore = new Object();
    protected boolean isReplyEndpoint;
    private volatile boolean failed = false;
    private Object lock = new Object();
    private final String componentName;
    private static Semaphore connectionSemaphore = new Semaphore(1);

    public JmsEndpointConnection_impl(JmsOutputChannel.BrokerConnectionEntry aBrokerDestinationMap, Endpoint anEndpoint, AnalysisEngineController aController) {
        this.brokerDestinations = aBrokerDestinationMap;
        this.serverUri = anEndpoint.isFreeCasEndpoint() && anEndpoint.isCasMultiplier() && anEndpoint.isReplyEndpoint() ? anEndpoint.getServerURI() : (anEndpoint.isReplyEndpoint() ? ((JmsOutputChannel)aController.getOutputChannel()).getServerURI() : anEndpoint.getServerURI());
        this.isReplyEndpoint = anEndpoint.isReplyEndpoint();
        this.controller = aController;
        this.endpoint = (anEndpoint.getCommand() == 2006 || this.isReplyEndpoint) && anEndpoint.getDestination() != null && anEndpoint.getDestination() instanceof ActiveMQDestination ? ((ActiveMQDestination)anEndpoint.getDestination()).getPhysicalName() : anEndpoint.getEndpoint();
        anEndpoint.remove();
        this.componentName = this.controller.getComponentName();
        this.delegateEndpoint = anEndpoint;
    }

    public boolean isRetryEnabled() {
        return this.retryEnabled;
    }

    public void setRetryEnabled(boolean retryEnabled) {
        this.retryEnabled = retryEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        Object object = this.lock;
        synchronized (object) {
            if (this.failed || this.producerSession == null || JmsEndpointConnection_impl.connectionClosedOrFailed(this.brokerDestinations)) {
                return false;
            }
            return ((ActiveMQSession)this.producerSession).isRunning();
        }
    }

    protected static boolean connectionClosedOrFailed(JmsOutputChannel.BrokerConnectionEntry aBrokerDestinationMap) {
        Connection connection = aBrokerDestinationMap.getConnection();
        return connection == null || ((ActiveMQConnection)connection).isClosed() || ((ActiveMQConnection)connection).isClosing() || ((ActiveMQConnection)connection).isTransportFailed();
    }

    private void openChannel() throws AsynchAEException, ServiceShutdownException, ConnectException {
        this.openChannel(this.getServerUri(), this.componentName, this.endpoint, this.controller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openChannel(String brokerUri, String aComponentName, String anEndpointName, AnalysisEngineController aController) throws AsynchAEException, ServiceShutdownException, ConnectException {
        Object object = this.lock;
        synchronized (object) {
            block51: {
                try {
                    Connection conn;
                    if (this.isReplyEndpoint && brokerUri.startsWith("http")) {
                        brokerUri = ((JmsOutputChannel)aController.getOutputChannel()).getServerURI();
                        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "open", "jms_adapter_messages", "UIMAJMS_override_connection_to_endpoint__FINE", new Object[]{aComponentName, this.getEndpoint(), ((JmsOutputChannel)aController.getOutputChannel()).getServerURI()});
                        }
                    } else if (!(brokerUri.startsWith("http") || brokerUri.startsWith("failover") || brokerUri.startsWith("vm://localhost?broker.persistent=false"))) {
                        String prefix = "";
                        prefix = brokerUri.indexOf("?") > -1 ? "&" : "?";
                        String extraParams = "";
                        if (brokerUri.indexOf("wireFormat.maxInactivityDuration") == -1) {
                            extraParams = prefix + "wireFormat.maxInactivityDuration=0";
                        }
                        brokerUri = brokerUri + extraParams;
                    }
                    if (!this.isOpen()) {
                        block50: {
                            conn = null;
                            try {
                                connectionSemaphore.acquire();
                                if (!JmsEndpointConnection_impl.connectionClosedOrFailed(this.brokerDestinations)) break block50;
                                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "openChannel", "jms_adapter_messages", "UIMAJMS_activemq_open__FINE", new Object[]{aController.getComponentName(), anEndpointName, brokerUri});
                                }
                                if (this.brokerDestinations.getConnection() != null) {
                                    try {
                                        this.brokerDestinations.getConnection().close();
                                    }
                                    catch (Exception extraParams) {
                                        // empty catch block
                                    }
                                }
                                boolean logConnectionProblem = true;
                                int retryCount = 4;
                                while (retryCount > 0) {
                                    --retryCount;
                                    if (this.controller.isStopped()) break;
                                    try {
                                        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(brokerUri);
                                        factory.setTrustAllPackages(true);
                                        factory.setConnectionIDPrefix("JmsOutputChannel");
                                        factory.setWatchTopicAdvisories(false);
                                        conn = factory.createConnection();
                                        factory.setDispatchAsync(true);
                                        factory.setUseAsyncSend(true);
                                        factory.setCopyMessageOnSend(false);
                                        conn.start();
                                        this.brokerDestinations.setConnection(conn);
                                        for (Map.Entry<Object, JmsEndpointConnection_impl> entry : this.brokerDestinations.endpointMap.entrySet()) {
                                            if (entry.getValue().producerSession == null) continue;
                                            entry.getValue().producerSession.close();
                                            entry.getValue().producerSession = null;
                                        }
                                        break;
                                    }
                                    catch (JMSException jex) {
                                        if (conn != null) {
                                            try {
                                                conn.close();
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                        }
                                        if (jex.getCause() != null && logConnectionProblem) {
                                            logConnectionProblem = false;
                                            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                                                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "openChannel", "uimaee_messages", "UIMAEE_service_lost_connectivity_WARNING", new Object[]{this.controller.getComponentName(), brokerUri});
                                                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "openChannel", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)jex);
                                                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "openChannel", "uimaee_messages", "UIMAEE_service_lost_connectivity_WARNING", new Object[]{this.controller.getComponentName(), brokerUri});
                                            }
                                        }
                                        this.lock.wait(5000L);
                                    }
                                    catch (Exception ee) {
                                        ee.printStackTrace();
                                        if (conn == null) continue;
                                        try {
                                            conn.close();
                                        }
                                        catch (Exception exception) {}
                                    }
                                }
                                if (retryCount == 0) {
                                    throw new ConnectException("Unable to Create Connection to Broker:" + brokerUri);
                                }
                                if (!logConnectionProblem && UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "openChannel", "uimaee_messages", "UIMAEE_service_regained_connectivity_INFO", new Object[]{this.controller.getComponentName(), brokerUri});
                                }
                            }
                            catch (Exception exc) {
                                if (conn != null) {
                                    try {
                                        conn.close();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                throw exc;
                            }
                            finally {
                                connectionSemaphore.release();
                            }
                        }
                        connectionCreationTimestamp = System.nanoTime();
                        this.failed = false;
                    } else {
                        System.out.println("...... Reusing Existing Broker Connetion");
                    }
                    conn = this.brokerDestinations.getConnection();
                    if (this.failed) {
                        return;
                    }
                    this.producerSession = conn.createSession(false, 3);
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "openChannel", "jms_adapter_messages", "UIMAJMS_session_open__FINE", new Object[]{aComponentName, anEndpointName, brokerUri});
                    }
                    if ((this.delegateEndpoint.getCommand() == 2006 || this.isReplyEndpoint) && this.delegateEndpoint.getDestination() != null) {
                        this.producer = this.producerSession.createProducer(null);
                        if (aController != null && UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "openChannel", "jms_adapter_messages", "UIMAJMS_temp_conn_starting__FINE", new Object[]{aComponentName, anEndpointName, brokerUri});
                        }
                    } else {
                        this.destination = this.producerSession.createQueue(this.getEndpoint());
                        this.producer = this.producerSession.createProducer(this.destination);
                        if (this.controller != null && UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "openChannel", "jms_adapter_messages", "UIMAJMS_conn_starting__FINE", new Object[]{aComponentName, anEndpointName, brokerUri});
                        }
                    }
                    this.producer.setDeliveryMode(1);
                    if (!((ActiveMQConnection)this.brokerDestinations.getConnection()).isStarted()) {
                        this.brokerDestinations.getConnection().start();
                    }
                    if (this.controller != null && UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "openChannel", "jms_adapter_messages", "UIMAJMS_conn_started__FINE", new Object[]{this.endpoint, brokerUri});
                        if (this.controller.getInputChannel() != null) {
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "openChannel", "jms_adapter_messages", "UIMAJMS_connection_open_to_endpoint__FINE", new Object[]{aComponentName, this.getEndpoint(), brokerUri});
                        }
                    }
                    this.failed = false;
                }
                catch (Exception e) {
                    boolean rethrow = true;
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "openChannel", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.controller.getComponentName());
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "openChannel", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
                    }
                    if (e instanceof ConnectException) {
                        throw (ConnectException)e;
                    }
                    if (e instanceof JMSException) {
                        rethrow = this.handleJmsException((JMSException)((Object)e));
                    }
                    if (!rethrow) break block51;
                    throw new AsynchAEException((Throwable)e);
                }
            }
        }
    }

    public synchronized void open() throws AsynchAEException, ServiceShutdownException, ConnectException {
        this.open(this.delegateEndpoint.getEndpoint(), this.serverUri);
    }

    public synchronized void open(String anEndpointName, String brokerUri) throws AsynchAEException, ServiceShutdownException, ConnectException {
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "open", "jms_adapter_messages", "UIMAJMS_open__FINE", new Object[]{anEndpointName, brokerUri});
        }
        if (!this.connectionAborted) {
            this.openChannel();
        }
    }

    public synchronized void abort() {
        this.connectionAborted = true;
        this.brokerDestinations.getConnectionTimer().stopTimer();
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.producer != null) {
                try {
                    this.producer.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.producerSession != null) {
                try {
                    this.producerSession.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.producerSession = null;
            }
            if (this.destination != null) {
                this.destination = null;
            }
        }
    }

    protected String getEndpoint() {
        return this.endpoint;
    }

    protected void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    protected void setDelegateEndpoint(Endpoint delegateEndpoint) {
        this.delegateEndpoint = delegateEndpoint;
    }

    protected synchronized String getServerUri() {
        return this.serverUri;
    }

    protected synchronized void setServerUri(String serverUri) {
        this.serverUri = serverUri;
    }

    public TextMessage produceTextMessage(String aTextMessage) throws AsynchAEException, ConnectException {
        Object object = this.lock;
        synchronized (object) {
            if (this.producerSession == null) {
                throw new AsynchAEException("Controller:" + this.controller.getComponentName() + " Unable to create JMS Message. Producer Session Not Initialized (Null)");
            }
            try {
                if (aTextMessage == null) {
                    return this.producerSession.createTextMessage("");
                }
                return this.producerSession.createTextMessage(aTextMessage);
            }
            catch (IllegalStateException e) {
                try {
                    this.open();
                }
                catch (ServiceShutdownException ex) {
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "produceTextMessage", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.controller.getComponentName());
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "produceTextMessage", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)ex);
                    }
                }
                catch (AsynchAEException ex) {
                    throw ex;
                }
            }
            catch (Exception e) {
                throw new AsynchAEException((Throwable)e);
            }
            throw new AsynchAEException((Throwable)new InvalidMessageException("Unable to produce Message Object"));
        }
    }

    public BytesMessage produceByteMessage(byte[] aSerializedCAS) throws AsynchAEException, ConnectException {
        Object object = this.lock;
        synchronized (object) {
            if (this.producerSession == null) {
                throw new AsynchAEException("Controller:" + this.controller.getComponentName() + " Unable to create JMS Message. Producer Session Not Initialized (Null)");
            }
            int retryCount = 1;
            while (retryCount > 0) {
                try {
                    --retryCount;
                    BytesMessage bm = this.producerSession.createBytesMessage();
                    bm.writeBytes(aSerializedCAS);
                    return bm;
                }
                catch (IllegalStateException e) {
                    try {
                        this.open();
                    }
                    catch (ServiceShutdownException ex) {
                        if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) continue;
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "produceByteMessage", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.controller.getComponentName());
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "produceByteMessage", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)ex);
                    }
                }
                catch (Exception e) {
                    throw new AsynchAEException((Throwable)e);
                }
            }
            throw new AsynchAEException((Throwable)new InvalidMessageException("Unable to produce BytesMessage Object"));
        }
    }

    public ObjectMessage produceObjectMessage() throws AsynchAEException {
        Object object = this.lock;
        synchronized (object) {
            if (this.producerSession == null) {
                throw new AsynchAEException("Controller:" + this.controller.getComponentName() + " Unable to create JMS Message. Producer Session Not Initialized (Null)");
            }
            try {
                if (!((ActiveMQSession)this.producerSession).isRunning()) {
                    this.open();
                }
                return this.producerSession.createObjectMessage();
            }
            catch (Exception e) {
                throw new AsynchAEException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean delayCasDelivery(int msgType, Message aMessage, int command) throws Exception {
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "recoverSession", "jms_adapter_messages", "UIMAJMS_open_connection_to_endpoint__FINE", new Object[]{this.getEndpoint()});
        }
        this.openChannel();
        String endpointName = this.delegateEndpoint.getEndpoint();
        Object object = this.lock;
        synchronized (object) {
            CAS cas;
            String casReferenceId;
            String key;
            if (this.controller instanceof AggregateAnalysisEngineController && (key = ((AggregateAnalysisEngineController)this.controller).lookUpDelegateKey(endpointName)) != null && this.destination != null && !this.isReplyEndpoint && msgType != 3000 && command == 2000 && (casReferenceId = aMessage.getStringProperty("CasReference")) != null && (cas = ((AggregateAnalysisEngineController)this.controller).getInProcessCache().getCasByReference(casReferenceId)) != null && ((AggregateAnalysisEngineController)this.controller).delayCasIfDelegateInTimedOutState(casReferenceId, endpointName, (long)cas.hashCode())) {
                return true;
            }
        }
        return false;
    }

    public boolean send(Message aMessage, long msgSize, boolean startTimer) {
        return this.send(aMessage, msgSize, startTimer, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(Message aMessage, long msgSize, boolean startTimer, boolean failOnJMSException) {
        String destinationName = "";
        String target = "Delegate";
        int msgType = 0;
        int command = 0;
        try {
            Object casReferenceId;
            msgType = aMessage.getIntProperty("MessageType");
            command = aMessage.getIntProperty("Command");
            boolean newCAS = false;
            if (aMessage.propertyExists("CasSequence") && aMessage.getLongProperty("CasSequence") > 0L) {
                newCAS = true;
            }
            if (msgType == 3001 || msgType == 3000 && newCAS) {
                target = "Client";
            }
            Endpoint masterEndpoint = null;
            if (this.delegateEndpoint != null && this.delegateEndpoint.getDelegateKey() != null) {
                masterEndpoint = ((AggregateAnalysisEngineController)this.controller).lookUpEndpoint(this.delegateEndpoint.getDelegateKey(), false);
                if (msgType == 3000 && command == 2000 && masterEndpoint != null && masterEndpoint.getStatus() == 2) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    Delegate delegate = ((AggregateAnalysisEngineController)this.controller).lookupDelegate(this.delegateEndpoint.getDelegateKey());
                    if (delegate != null) {
                        delegate.cancelDelegateTimer();
                    }
                    map.put("Command", 2000);
                    map.put("CasReference", aMessage.getStringProperty("CasReference"));
                    map.put("Endpoint", masterEndpoint);
                    DelegateConnectionLostException e = new DelegateConnectionLostException("Controller:" + this.controller.getComponentName() + " Lost Connection to " + target + ":" + masterEndpoint.getDelegateKey());
                    ((BaseAnalysisEngineController)this.controller).handleError(map, (Throwable)e);
                    return true;
                }
            }
            if (!this.isOpen() && this.delayCasDelivery(msgType, aMessage, command)) {
                return true;
            }
            if ((command == 2006 || command == 2005 || this.isReplyEndpoint) && this.delegateEndpoint.getDestination() != null) {
                destinationName = ((ActiveMQDestination)this.delegateEndpoint.getDestination()).getPhysicalName();
                if (UIMAFramework.getLogger().isLoggable(Level.FINE)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "send", "jms_adapter_messages", "UIMAJMS_sending_msg_to_endpoint__FINE", new Object[]{destinationName});
                }
                this.logMessageSize(aMessage, msgSize, destinationName);
                MessageProducer map = this.producer;
                synchronized (map) {
                    AsyncCallback onComplete = this.createAMQCallbackListener(command, aMessage);
                    ((ActiveMQMessageProducer)this.producer).send((Destination)this.delegateEndpoint.getDestination(), aMessage, onComplete);
                }
            }
            destinationName = ((ActiveMQQueue)this.producer.getDestination()).getPhysicalName();
            if (UIMAFramework.getLogger().isLoggable(Level.FINE)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "send", "jms_adapter_messages", "UIMAJMS_sending_msg_to_endpoint__FINE", new Object[]{destinationName});
            }
            this.logMessageSize(aMessage, msgSize, destinationName);
            if (msgType == 3000 && command == 2000) {
                casReferenceId = aMessage.getStringProperty("CasReference");
                LocalCache.CasStateEntry casStateEntry = this.controller.getLocalCache().lookupEntry((String)casReferenceId);
                if (casStateEntry.getNumberOfParallelDelegates() > 0) {
                    casStateEntry.dispatchedCasToParallelDelegate();
                }
            }
            casReferenceId = this.producer;
            synchronized (casReferenceId) {
                AsyncCallback onComplete = this.createAMQCallbackListener(command, aMessage);
                ((ActiveMQMessageProducer)this.producer).send(aMessage, onComplete);
            }
            if (startTimer) {
                // empty if block
            }
            this.lastDispatchTimestamp.set(System.currentTimeMillis());
            return true;
        }
        catch (Exception e) {
            if (e instanceof InvalidDestinationException && "Client".equals(target)) {
                if (this.delegateEndpoint != null) {
                    this.endpointName = ((ActiveMQDestination)this.delegateEndpoint.getDestination()).getPhysicalName();
                }
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "send", "jms_adapter_messages", "UIMAJMS_invalid_destination__INFO", new Object[]{this.controller.getComponentName(), this.endpointName});
                if (command == 2008) {
                    return false;
                }
                if ((msgType == 3001 || msgType == 3000) && command == 2000) {
                    String casReferenceId = "";
                    try {
                        casReferenceId = aMessage.getStringProperty("CasReference");
                    }
                    catch (Exception exx) {
                        String key = "";
                        String endpointName = "";
                        if (this.delegateEndpoint != null) {
                            key = this.delegateEndpoint.getDelegateKey();
                            endpointName = ((ActiveMQDestination)this.delegateEndpoint.getDestination()).getPhysicalName();
                        }
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "send", "uimaee_messages", "UIMAEE_service_delivery_exception__WARNING", new Object[]{this.controller.getComponentName(), key, endpointName});
                    }
                    LocalCache.CasStateEntry casStateEntry = this.controller.getLocalCache().lookupEntry(casReferenceId);
                    casStateEntry.setDeliveryToClientFailed();
                }
                return true;
            }
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                String key = "";
                String endpointName = "";
                if (this.delegateEndpoint != null) {
                    key = this.delegateEndpoint.getDelegateKey();
                    endpointName = ((ActiveMQDestination)this.delegateEndpoint.getDestination()).getPhysicalName();
                }
                if ("Client".equals(target)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "send", "uimaee_messages", "UIMAEE_service_delivery_to_client_exception__WARNING", new Object[]{this.controller.getComponentName(), endpointName});
                } else {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "send", "uimaee_messages", "UIMAEE_service_delivery_exception__WARNING", new Object[]{this.controller.getComponentName(), key, endpointName});
                }
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "send", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
            }
            if (this.controller.isStopped()) {
                return false;
            }
            if (e instanceof JMSException) {
                this.handleJmsException((JMSException)((Object)e));
                if (failOnJMSException) {
                    return false;
                }
            } else if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "send", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.controller.getComponentName());
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "send", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
            }
            return false;
        }
    }

    public AsyncCallback createAMQCallbackListener(int command, Message aMessage) throws Exception {
        String cid = "";
        LocalCache.CasStateEntry casStateEntry = null;
        UimaAsAsyncCallbackListener onComplete = null;
        if (command == 2000) {
            cid = aMessage.getStringProperty("CasReference");
            casStateEntry = this.controller.getLocalCache().lookupEntry(cid);
            onComplete = new UimaAsAsyncCallbackListener(casStateEntry);
        } else {
            onComplete = new UimaAsAsyncCallbackListener(command);
        }
        return onComplete;
    }

    private void logMessageSize(Message aMessage, long msgSize, String destinationName) {
        if (UIMAFramework.getLogger().isLoggable(Level.FINE)) {
            boolean isReply = false;
            if (this.isReplyEndpoint) {
                isReply = true;
            }
            String type = "Text";
            if (aMessage instanceof BytesMessage) {
                type = "Binary";
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "logMessageSize", "jms_adapter_messages", "UIMAJMS_msg_size__FINE", new Object[]{this.componentName, isReply ? "Reply" : "Request", "Binary", destinationName, msgSize});
            } else if (aMessage instanceof TextMessage) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "logMessageSize", "jms_adapter_messages", "UIMAJMS_msg_size__FINE", new Object[]{this.componentName, isReply ? "Reply" : "Request", "XMI", destinationName, msgSize});
            }
        }
    }

    private void createListener(String delegateKey) throws Exception {
        if (this.controller instanceof AggregateAnalysisEngineController) {
            InputChannel iC = this.controller.getReplyInputChannel(delegateKey);
            iC.createListener(delegateKey, null);
        }
    }

    private synchronized boolean handleJmsException(JMSException ex) {
        block8: {
            if (!this.failed) {
                this.failed = true;
            }
            try {
                if (ex.getMessage() != null && ex.getMessage().startsWith("Cannot publish to a deleted Destination")) {
                    String destName = this.endpointName;
                    int startPos = ex.getMessage().indexOf(58);
                    if (startPos > 0) {
                        destName = ex.getMessage().substring(startPos);
                    }
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "handleJmsException", "jms_adapter_messages", "UIMAJMS_send_failed_deleted_queue_INFO", new Object[]{this.componentName, destName, this.serverUri});
                    }
                    return false;
                }
                if (ex instanceof ConnectionFailedException && this.isReplyEndpoint) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "handleJmsException", "jms_adapter_messages", "UIMAJMS_connection_failure__INFO", new Object[]{this.componentName, this.serverUri, this.delegateEndpoint.getDestination()});
                    return false;
                }
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handleJmsException", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.controller.getComponentName());
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handleJmsException", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)ex);
                }
            }
            catch (Exception e) {
                if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block8;
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handleJmsException", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.controller.getComponentName());
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handleJmsException", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
            }
        }
        return true;
    }

    public void onConsumerEvent(ConsumerEvent arg0) {
        if (this.controller != null) {
            this.controller.handleDelegateLifeCycleEvent(this.getEndpoint(), arg0.getConsumerCount());
        }
    }

    protected synchronized void finalize() throws Throwable {
    }

    private class UimaAsAsyncCallbackListener
    implements AsyncCallback {
        LocalCache.CasStateEntry casState = null;
        int command;

        public UimaAsAsyncCallbackListener(int command) {
            this.command = command;
        }

        public UimaAsAsyncCallbackListener(LocalCache.CasStateEntry casState) {
            this.casState = casState;
        }

        public void onException(JMSException exception) {
            if (this.casState != null) {
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "UimaAsAsyncCallbackListener.onException()", "uimaee_messages", "UIMAEE_unable_to_deliver_msg__INFO", new Object[]{JmsEndpointConnection_impl.this.controller.getComponentName(), this.casState.getCasReferenceId(), exception.getMessage()});
                }
                this.casState.setDeliveryToClientFailed();
                if (this.casState.isSubordinate()) {
                    try {
                        String inputCasId = this.casState.getInputCasReferenceId();
                        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "UimaAsAsyncCallbackListener.onException()", "uimaee_messages", "UIMAEE_force_cas_abort__INFO", new Object[]{JmsEndpointConnection_impl.this.controller.getComponentName(), "parent", inputCasId});
                        }
                        LocalCache.CasStateEntry parentCasStateEntry = JmsEndpointConnection_impl.this.controller.getLocalCache().lookupEntry(inputCasId);
                        parentCasStateEntry.setFailed();
                        JmsEndpointConnection_impl.this.controller.addAbortedCasReferenceId(inputCasId);
                        if (JmsEndpointConnection_impl.this.controller instanceof AggregateAnalysisEngineController) {
                            List controllers = ((AggregateAnalysisEngineController)JmsEndpointConnection_impl.this.controller).getChildControllerList();
                            for (AnalysisEngineController ctrl : controllers) {
                                ctrl.addAbortedCasReferenceId(inputCasId);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    JmsEndpointConnection_impl.this.controller.releaseNextCas(this.casState.getCasReferenceId());
                }
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "UimaAsAsyncCallbackListener.onException()", "uimaee_messages", "UIMAEE_release_cas_req__FINE", new Object[]{JmsEndpointConnection_impl.this.controller.getComponentName(), this.casState.getCasReferenceId()});
                }
            } else {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "UimaAsAsyncCallbackListener.onException()", "uimaee_messages", "UIMAEE_service_delivery_exception_WARNING", new Object[]{JmsEndpointConnection_impl.this.controller.getComponentName(), exception});
            }
        }

        public void onSuccess() {
        }
    }
}

