/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.utils;

public class JdkEvaluator {
    public static final int JAVA7 = 7;
    public static final int JAVA8 = 8;
    public static final int JAVA9 = 9;
    public static final int FIXPACK40 = 40;
    public static final int FIXPACK101 = 101;
    public static final int FIXPACK91 = 91;
    public static final int SR3 = 3;
    public static final int SR9 = 9;

    public static void main(String[] args) {
        JDKVendor jdkVendor = Vendors.getVendor();
        System.out.println(jdkVendor.getVendor().name() + " JDK " + jdkVendor.getRuntimeVersion());
        if (JdkEvaluator.secureJdk(jdkVendor)) {
            System.out.println(".......... Secure JDK");
        } else {
            System.out.println(".......... Non Secure JDK");
        }
    }

    private JdkEvaluator() {
    }

    public static boolean secureJdk(JDKVendor vendor) {
        String javaVersion = System.getProperty("java.version");
        return vendor.containsSecurityFix(javaVersion);
    }

    public static class Vendors {
        private Vendors() {
        }

        public static JDKVendor getVendor() {
            AbstractJDKVendor jdkVendor = null;
            String vendor = System.getProperty("java.vendor");
            jdkVendor = vendor.startsWith("IBM") ? new IBM() : (vendor.startsWith("Sun") || vendor.startsWith("Oracle") ? new Oracle() : (vendor.startsWith("OpenJDK") ? new OpenJDK() : new Unsupported()));
            return jdkVendor;
        }

        public static enum Vendor {
            IBM,
            ORACLE,
            OPENJDK,
            UNSUPPORTED;

        }
    }

    public static abstract class AbstractJDKVendor
    implements JDKVendor {
        @Override
        public String getRuntimeVersion() {
            return System.getProperty("java.runtime.version");
        }

        public static class JdkVersion {
            public static int getMajor(String javaVersion) {
                String[] vs = javaVersion.split("\\.");
                int pos = 0;
                int major = 1;
                pos = vs[0].indexOf(45);
                major = pos > 0 ? Integer.parseInt(vs[0].substring(0, pos)) : Integer.parseInt(vs[0]);
                if (major < 9) {
                    major = Integer.parseInt(vs[1]);
                }
                return major;
            }

            public static int getMinor(String javaVersion) {
                String[] vs = javaVersion.split("\\.");
                int major = JdkVersion.getMajor(javaVersion);
                if (major >= 9) {
                    if (vs.length == 1) {
                        return 0;
                    }
                    return Integer.parseInt(vs[1]);
                }
                return Integer.parseInt(vs[2]);
            }
        }
    }

    public static class Unsupported
    extends AbstractJDKVendor {
        private Vendors.Vendor vendor = Vendors.Vendor.UNSUPPORTED;

        @Override
        public Vendors.Vendor getVendor() {
            return this.vendor;
        }

        @Override
        public boolean containsSecurityFix(String javaVersion) {
            return false;
        }
    }

    private static class OpenJDK
    extends Oracle {
        private Vendors.Vendor vendor = Vendors.Vendor.OPENJDK;

        private OpenJDK() {
        }

        @Override
        public Vendors.Vendor getVendor() {
            return this.vendor;
        }
    }

    private static class Oracle
    extends AbstractJDKVendor {
        private Vendors.Vendor vendor = Vendors.Vendor.ORACLE;

        private Oracle() {
        }

        @Override
        public Vendors.Vendor getVendor() {
            return this.vendor;
        }

        @Override
        public String getRuntimeVersion() {
            return System.getProperty("java.runtime.version");
        }

        @Override
        public boolean containsSecurityFix(String javaVersion) {
            boolean containsFix = false;
            String[] vs = javaVersion.split("\\.");
            int pos = 0;
            int major = AbstractJDKVendor.JdkVersion.getMajor(javaVersion);
            if (major >= 9) {
                containsFix = true;
            } else if (Integer.parseInt(vs[1]) == 8) {
                String fixPack = "";
                int minor = 0;
                pos = 0;
                pos = vs[2].indexOf(95);
                if (pos > 0) {
                    minor = Integer.parseInt(vs[2].substring(0, pos));
                    if (minor > 0) {
                        containsFix = true;
                    } else {
                        fixPack = vs[2].indexOf(45) > -1 ? vs[2].substring(vs[2].indexOf(95) + 1, vs[2].indexOf(45)) : vs[2].substring(pos + 1);
                    }
                }
                if (!containsFix) {
                    containsFix = this.isJava8Fixed(fixPack);
                }
            } else if (Integer.parseInt(vs[1]) == 7) {
                String fixPack = "";
                int minor = 0;
                if (vs[2].indexOf(95) > -1) {
                    minor = Integer.parseInt(vs[2].substring(vs[2].indexOf(95)));
                    if (vs[2].indexOf(45) > -1) {
                        fixPack = vs[2].substring(vs[2].indexOf(95) + 1, vs[2].indexOf(45));
                    }
                } else {
                    minor = Integer.parseInt(vs[2].trim());
                }
                containsFix = this.isJava7Fixed(minor, fixPack);
            }
            return containsFix;
        }

        private boolean isJava7Fixed(int minor, String fp) {
            int fpNumber;
            boolean containsFix = false;
            if (minor > 1) {
                containsFix = true;
            } else if (minor == 0 && (fpNumber = Integer.parseInt(fp)) >= 101) {
                containsFix = true;
            }
            return containsFix;
        }

        private boolean isJava8Fixed(String fp) {
            boolean containsFix = false;
            int fpNumber = Integer.parseInt(fp);
            if (fpNumber >= 91) {
                containsFix = true;
            }
            return containsFix;
        }
    }

    private static class IBM
    extends AbstractJDKVendor {
        private Vendors.Vendor vendor = Vendors.Vendor.IBM;

        private IBM() {
        }

        @Override
        public Vendors.Vendor getVendor() {
            return this.vendor;
        }

        @Override
        public boolean containsSecurityFix(String javaVersion) {
            boolean containsFix = false;
            String runtimeVersion = this.getRuntimeVersion();
            int major = IbmJdkVersion.getMajor(javaVersion);
            if (major >= 9) {
                containsFix = true;
            } else if (major == 8) {
                containsFix = this.isJava8Fixed(runtimeVersion);
            } else if (major == 7) {
                containsFix = this.isJava7Fixed(runtimeVersion, IbmJdkVersion.getMinor(javaVersion));
            }
            return containsFix;
        }

        private boolean isJava7Fixed(String runtimeVersion, int minor) {
            boolean containsFix = false;
            if (minor > 1) {
                return true;
            }
            int serviceReleaseVersion = this.getSecurityReleaseVersion(runtimeVersion);
            int fixPackVersion = this.getFixPackVersion(runtimeVersion);
            if (minor == 1) {
                if (serviceReleaseVersion >= 3 && fixPackVersion >= 40) {
                    containsFix = true;
                }
            } else if (minor == 0 && serviceReleaseVersion >= 9 && fixPackVersion >= 40) {
                containsFix = true;
            }
            return containsFix;
        }

        private boolean isJava8Fixed(String runtimeVersion) {
            int fixPackVersion;
            boolean containsFix = false;
            int serviceReleaseVersion = this.getSecurityReleaseVersion(runtimeVersion);
            if (serviceReleaseVersion >= 3 && (fixPackVersion = this.getFixPackVersion(runtimeVersion)) >= 0) {
                containsFix = true;
            }
            return containsFix;
        }

        private int getSecurityReleaseVersion(String runtimeVersion) {
            int start = runtimeVersion.indexOf("(SR");
            if (start > 0) {
                String upgradeStringVersion = runtimeVersion.substring(start + 1, runtimeVersion.indexOf(41, start));
                String srAsString = "";
                srAsString = upgradeStringVersion.indexOf(32) > -1 ? upgradeStringVersion.substring(2, upgradeStringVersion.indexOf(32)) : upgradeStringVersion.substring(2);
                return Integer.parseInt(srAsString);
            }
            return -1;
        }

        private int getFixPackVersion(String runtimeVersion) {
            int fixPackVersion = -1;
            int start = runtimeVersion.indexOf("(SR");
            if (start > 0) {
                int p1 = runtimeVersion.indexOf(32, start);
                int p2 = runtimeVersion.indexOf(41, start);
                String fixPackAsString = runtimeVersion.substring(p1 + 3, p2);
                fixPackVersion = Integer.parseInt(fixPackAsString);
            }
            return fixPackVersion;
        }

        private static class IbmJdkVersion {
            private IbmJdkVersion() {
            }

            public static int getMajor(String javaVersion) {
                String[] vs = javaVersion.split("\\.");
                int pos = 0;
                int major = 1;
                pos = vs[0].indexOf(45);
                major = pos > 0 ? Integer.parseInt(vs[0].substring(0, pos)) : Integer.parseInt(vs[0]);
                if (major < 9) {
                    major = Integer.parseInt(vs[1]);
                }
                return major;
            }

            public static int getMinor(String javaVersion) {
                String[] vs = javaVersion.split("\\.");
                int major = IbmJdkVersion.getMajor(javaVersion);
                if (major >= 9) {
                    if (vs.length == 1) {
                        return 0;
                    }
                    return Integer.parseInt(vs[1]);
                }
                return Integer.parseInt(vs[2]);
            }
        }
    }

    public static interface JDKVendor {
        public boolean containsSecurityFix(String var1);

        public Vendors.Vendor getVendor();

        public String getRuntimeVersion();
    }
}

