/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.uima.ducc.common.IDuccEnv;
import org.apache.uima.ducc.common.utils.DuccProperties;

public class DuccPropertiesResolver {
    private AtomicBoolean loadedPrivate = new AtomicBoolean(false);
    private AtomicBoolean e1 = new AtomicBoolean(false);
    private AtomicBoolean e2 = new AtomicBoolean(false);
    private AtomicBoolean e3 = new AtomicBoolean(false);
    private AtomicBoolean e4 = new AtomicBoolean(false);
    private AtomicBoolean e5 = new AtomicBoolean(false);
    private static DuccPropertiesResolver duccPropertiesResolver = new DuccPropertiesResolver();
    private Properties initialProperties = new DuccProperties();
    private Properties defaultProperties = new DuccProperties();
    public static final String ducc_head = "ducc.head";
    public static final String ducc_security_home = "ducc.security.home";
    public static final String ducc_private_resources = "ducc.private.resources";
    public static final String ducc_threads_limit = "ducc.threads.limit";
    public static final String ducc_job_max_pipelines_count = "ducc.job.max.pipelines.count";
    public static final String ducc_driver_jvm_args = "ducc.driver.jvm.args";
    public static final String ducc_process_jvm_args = "ducc.process.jvm.args";
    public static final String ducc_environment_propagated = "ducc.environment.propagated";
    public static final String ducc_runmode = "ducc.runmode";
    public static final String ducc_signature_required = "ducc.signature.required";
    public static final String ducc_broker_url = "ducc.broker.url";
    public static final String ducc_broker_protocol = "ducc.broker.protocol";
    public static final String ducc_broker_port = "ducc.broker.port";
    public static final String ducc_broker_url_decoration = "ducc.broker.url.decoration";
    public static final String ducc_broker_name = "ducc.broker.name";
    public static final String ducc_broker_jmx_port = "ducc.broker.jmx.port";
    public static final String ducc_jms_provider = "ducc.jms.provider";
    public static final String ducc_database_automanage = "ducc.database.automanage";
    public static final String ducc_database_host_list = "ducc.database.host.list";
    public static final String ducc_database_disabled = "--disabled--";
    public static final String ducc_database_jmx_host = "ducc.database.jmx.host";
    public static final String ducc_database_jmx_port = "ducc.database.jmx.port";
    public static final String ducc_orchestrator_state_publish_rate = "ducc.orchestrator.state.publish.rate";
    public static final String ducc_orchestrator_state_update_endpoint_type = "ducc.orchestrator.state.update.endpoint.type";
    public static final String ducc_orchestrator_state_update_endpoint = "ducc.orchestrator.state.update.endpoint";
    public static final String ducc_orchestrator_http_port = "ducc.orchestrator.http.port";
    public static final String ducc_orchestrator_http_node = "ducc.orchestrator.http.node";
    public static final String ducc_orchestrator_maintenance_rate = "ducc.orchestrator.maintenance.rate";
    public static final String ducc_orchestrator_job_factory_classpath_order = "ducc.orchestrator.job.factory.classpath.order";
    public static final String ducc_orchestrator_unmanaged_reservations_accepted = "ducc.orchestrator.unmanaged.reservations.accepted";
    public static final String ducc_orchestrator_use_lock_file = "ducc.orchestrator.use.lock.file";
    public static final String ducc_orchestrator_start_type = "ducc.orchestrator.start.type";
    public static final String ducc_orchestrator_checkpoint = "ducc.orchestrator.checkpoint";
    public static final String ducc_default_process_per_item_time_max = "ducc.default.process.per.item.time.max";
    public static final String ducc_default_process_init_time_max = "ducc.default.process.init.time.max";
    public static final String ducc_jd_queue_prefix = "ducc.jd.queue.prefix";
    public static final String ducc_jd_host_class = "ducc.jd.host.class";
    public static final String ducc_jd_host_description = "ducc.jd.host.description";
    public static final String ducc_jd_host_memory_size = "ducc.jd.host.memory.size";
    public static final String ducc_jd_host_number_of_machines = "ducc.jd.host.number.of.machines";
    public static final String ducc_jd_host_user = "ducc.jd.host.user";
    public static final String ducc_jd_state_publish_rate = "ducc.orchestrator.state.publish.rate";
    public static final String ducc_jd_configuration_class = "ducc.jd.configuration.class";
    public static final String ducc_jd_startup_initialization_error_limit = "ducc.jd.startup.initialization.error.limit";
    public static final String ducc_jd_workitem_name_maximum_length = "ducc.jd.workitem.name.maximum.length";
    public static final String ducc_jd_error_handler_class = "ducc.jd.error.handler.class";
    public static final String ducc_jd_error_handler_args = "ducc.jd.error.handler.args";
    public static final String ducc_rm_class_definitions = "ducc.rm.class.definitions";
    public static final String ducc_rm_user_registry = "ducc.rm.user.registry";
    public static final String ducc_rm_share_quantum = "ducc.rm.share.quantum";
    public static final String ducc_jd_share_quantum = "ducc.jd.share.quantum";
    public static final String ducc_jd_share_quantum_reserve_count = "ducc.jd.share.quantum.reserve.count";
    public static final String ducc_authentication_implementer = "ducc.authentication.implementer";
    public static final String ducc_authentication_users_include = "ducc.authentication.users.include";
    public static final String ducc_authentication_users_exclude = "ducc.authentication.users.exclude";
    public static final String ducc_authentication_groups_include = "ducc.authentication.groups.include";
    public static final String ducc_authentication_groups_exclude = "ducc.authentication.groups.exclude";
    public static final String ducc_ws_host = "ducc.ws.node";
    public static final String ducc_ws_port = "ducc.ws.port";
    public static final String ducc_ws_max_history_entries = "ducc.ws.max.history.entries";
    public static final String ducc_ws_login_enabled = "ducc.ws.login.enabled";
    public static final String ducc_ws_bytes_per_page = "ducc.ws.bytes.per.page";
    public static final String ducc_ws_banner_message = "ducc.ws.banner.message";
    public static final String ducc_ws_user_data_access = "ducc.ws.user.data.access";
    public static final String ducc_rm_node_stability = "ducc.rm.node.stability";
    public static final String ducc_agent_node_metrics_publish_rate = "ducc.agent.node.metrics.publish.rate";
    public static final String ducc_agent_node_inventory_publish_rate = "ducc.agent.node.inventory.publish.rate";
    public static final String ducc_agent_node_inventory_publish_rate_skip = "ducc.agent.node.inventory.publish.rate.skip";
    public static final String ducc_transport_trace = "ducc.transport.trace";
    public static final String ducc_ws_port_ssl = "ducc.ws.port.ssl";
    public static final String ducc_ws_welcome_page = "ducc.ws.welcome.page";
    public static final String ducc_ws_idle_timeout = "ducc.ws.idle.timeout";
    public static final String ducc_ws_max_threads = "ducc.ws.max.threads";
    public static final String ducc_ws_monitored_daemon_down_millis_expiry = "ducc.ws.monitored.daemon.down.millis.expiry";

    public static DuccPropertiesResolver getInstance() {
        return duccPropertiesResolver;
    }

    public static String get(String key) {
        return duccPropertiesResolver.getProperty(key);
    }

    public static String get(String key, String dflt) {
        String value = duccPropertiesResolver.getProperty(key);
        return value != null ? value : dflt;
    }

    public static int get(String key, int dflt) {
        int retVal = dflt;
        String value = duccPropertiesResolver.getProperty(key);
        try {
            retVal = Integer.parseInt(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    public DuccPropertiesResolver() {
        try {
            this.init(this.initialProperties);
            this.initDefaultProperties();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void initDefaultProperties() {
        this.defaultProperties.put(ducc_runmode, "Production");
        this.defaultProperties.put(ducc_broker_url, "tcp://localhost:61616");
        this.defaultProperties.put(ducc_jms_provider, "activemq");
        this.defaultProperties.put(ducc_orchestrator_state_update_endpoint, "ducc.orchestrator.state");
        this.defaultProperties.put(ducc_orchestrator_state_update_endpoint_type, "topic");
        this.defaultProperties.put(ducc_default_process_init_time_max, "1440");
        this.defaultProperties.put(ducc_default_process_per_item_time_max, "1");
        this.defaultProperties.put(ducc_rm_share_quantum, "10");
        this.defaultProperties.put(ducc_jd_share_quantum, "300");
        this.defaultProperties.put(ducc_jd_share_quantum_reserve_count, "2");
        this.defaultProperties.put(ducc_orchestrator_unmanaged_reservations_accepted, "true");
        this.defaultProperties.put(ducc_orchestrator_use_lock_file, "false");
        this.defaultProperties.put(ducc_ws_login_enabled, "true");
        this.defaultProperties.put(ducc_authentication_implementer, "org.apache.uima.ducc.ws.authentication.LinuxAuthenticationManager");
        this.defaultProperties.put("ducc.orchestrator.state.publish.rate", "15000");
        this.defaultProperties.put(ducc_jd_host_class, "JobDriver");
        this.defaultProperties.put(ducc_jd_host_description, "Job Driver");
        this.defaultProperties.put(ducc_jd_host_memory_size, "2GB");
        this.defaultProperties.put(ducc_jd_host_number_of_machines, "1");
        this.defaultProperties.put(ducc_jd_host_user, "System");
    }

    private void init(Properties properties) {
        block5: {
            String fileName = null;
            try {
                String componentProperties = "ducc.deploy.configuration";
                fileName = System.getProperty(componentProperties);
                if (fileName == null) {
                    fileName = IDuccEnv.DUCC_PROPERTIES_FILE;
                }
                File file = new File(fileName);
                FileInputStream fis = new FileInputStream(file);
                properties.load(fis);
                fis.close();
            }
            catch (FileNotFoundException e) {
                if (!this.e1.get()) {
                    this.e1.set(true);
                }
            }
            catch (IOException e) {
                if (this.e2.get()) break block5;
                this.e2.set(true);
            }
        }
        this.enrich(properties);
    }

    private void enrich(Properties properties) {
        Properties privateProperties = this.getPrivateProperties();
        for (Map.Entry<Object, Object> entry : privateProperties.entrySet()) {
            properties.put(entry.getKey(), entry.getValue());
        }
    }

    private Properties getPrivateProperties() {
        Properties privateProperties;
        block8: {
            privateProperties = new Properties();
            String key = ducc_private_resources;
            String directory = this.getProperty(key);
            if (directory != null) {
                String fileName = directory + File.separator + "ducc.private.properties";
                try {
                    File file = new File(fileName);
                    FileInputStream fis = new FileInputStream(file);
                    privateProperties.load(fis);
                    fis.close();
                    if (this.loadedPrivate.get()) {
                        // empty if block
                    }
                    this.loadedPrivate.set(true);
                }
                catch (FileNotFoundException e) {
                    if (!this.e3.get()) {
                        this.e3.set(true);
                    }
                    break block8;
                }
                catch (IOException e) {
                    if (!this.e4.get()) {
                        this.e4.set(true);
                    }
                    break block8;
                }
            }
            if (!this.e5.get()) {
                this.e5.set(true);
            }
        }
        return privateProperties;
    }

    public String getProperty(String key) {
        return this.getCachedProperty(key);
    }

    public String getCachedProperty(String key) {
        String value = this.initialProperties.getProperty(key);
        if (value == null) {
            value = this.defaultProperties.getProperty(key);
        }
        return value == null ? null : value.trim();
    }

    public String getFileProperty(String key) {
        DuccProperties currentProperties = new DuccProperties();
        this.init(currentProperties);
        String value = ((Properties)currentProperties).getProperty(key);
        if (value == null) {
            value = this.defaultProperties.getProperty(key);
        }
        return value == null ? null : value.trim();
    }
}

