/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.jd.files.workitem;

import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.zip.GZIPInputStream;
import org.apache.uima.ducc.common.jd.files.IWorkItemState;
import org.apache.uima.ducc.common.jd.files.WorkItemState;
import org.apache.uima.ducc.common.jd.files.workitem.IWorkItemStateReader;
import org.apache.uima.ducc.common.jd.files.workitem.WorkItemStateAbstract;
import org.apache.uima.ducc.common.jd.files.workitem.WorkItemStateKeeper;
import org.apache.uima.ducc.common.jd.files.workitem.legacy.WorkItemStateManager;
import org.apache.uima.ducc.common.utils.DuccLogger;

public class WorkItemStateReader
extends WorkItemStateAbstract
implements IWorkItemStateReader {
    protected DuccLogger logger = DuccLogger.getLogger(WorkItemStateReader.class, null);
    private long MaxRecords = 4096L;
    private WorkItemStateManager wism = null;
    private String component = null;
    private String directory = null;
    private String user = null;
    private long wiVersion = 0L;

    public WorkItemStateReader(String component, String directory, String user, long wiVersion) {
        this.logger = DuccLogger.getLogger(WorkItemStateKeeper.class, component);
        this.setComponent(component);
        this.setDirectory(directory);
        this.setUser(user);
        this.setWiVersion(wiVersion);
        this.initialize();
    }

    private void setComponent(String value) {
        this.component = value;
    }

    private void setDirectory(String value) {
        this.directory = value;
    }

    private void setUser(String value) {
        this.user = value;
    }

    private void setWiVersion(long value) {
        this.wiVersion = value;
    }

    private void initialize() {
        if (this.wiVersion == 0L) {
            this.wism = new WorkItemStateManager(this.component, this.directory, this.user);
        } else {
            super.initialize(this.directory);
        }
    }

    @Override
    public ConcurrentSkipListMap<Long, IWorkItemState> getMap() {
        long lastRecordNo = 0L;
        long maxRecords = this.MaxRecords;
        return this.getMap(lastRecordNo, maxRecords);
    }

    private ConcurrentSkipListMap<Long, IWorkItemState> getMap(long lastRecordNo, long maxRecords) {
        ConcurrentSkipListMap<Long, IWorkItemState> map;
        block8: {
            String location = "getMap";
            map = new ConcurrentSkipListMap();
            if (this.wiVersion == 0L) {
                map = this.wism.getMap();
            } else {
                map = new ConcurrentSkipListMap();
                try {
                    this.fetchZipped(map, lastRecordNo, maxRecords);
                    if (!map.isEmpty()) break block8;
                    try {
                        this.fetchActive(map);
                    }
                    catch (Exception e) {
                        this.logger.debug(location, jobid, e, new Object[0]);
                    }
                    try {
                        this.fetchCompleted(map, lastRecordNo, maxRecords);
                    }
                    catch (Exception e) {
                        this.logger.debug(location, jobid, e, new Object[0]);
                    }
                }
                catch (Exception e) {
                    this.logger.debug(location, jobid, e, new Object[0]);
                }
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchActive(ConcurrentSkipListMap<Long, IWorkItemState> map) throws IOException {
        String location = "fetchActive";
        FileInputStream fis = null;
        InputStreamReader isr = null;
        String line = null;
        try (BufferedReader br = null;){
            String targetFile = this.fnActiveJson;
            fis = new FileInputStream(targetFile);
            isr = new InputStreamReader(fis);
            br = new BufferedReader(isr);
            Type type = new TypeToken<WorkItemState>(){}.getType();
            line = br.readLine();
            while (line != null) {
                this.logger.trace(location, jobid, line);
                StringReader sr = new StringReader(line.trim());
                WorkItemState wis = (WorkItemState)gson.fromJson((Reader)sr, type);
                Long key = Long.parseLong(wis.getSeqNo());
                WorkItemState value = wis;
                map.put(key, value);
                line = br.readLine();
            }
        }
    }

    private void trim(IWorkItemState wis, ConcurrentSkipListMap<Long, IWorkItemState> map, long lastRecordNo, long maxRecords) throws IOException {
        String location = "trim";
        if (maxRecords > 0L && (long)map.size() > maxRecords) {
            block3: for (Map.Entry<Long, IWorkItemState> entry : map.entrySet()) {
                Long key = entry.getKey();
                switch (entry.getValue().getState()) {
                    case ended: 
                    case error: {
                        map.remove(key);
                        this.logger.debug(location, jobid, "seqNo:" + key);
                        break block3;
                    }
                    default: {
                        continue block3;
                    }
                }
            }
        }
    }

    private void tryToAdd(IWorkItemState wis, ConcurrentSkipListMap<Long, IWorkItemState> map, long lastRecordNo, long maxRecords) throws IOException {
        String location = "tryToAdd";
        Long key = Long.parseLong(wis.getSeqNo());
        IWorkItemState value = wis;
        if (lastRecordNo > 0L) {
            if (key <= lastRecordNo) {
                map.put(key, value);
                this.logger.debug(location, jobid, "seqNo:" + key);
            }
        } else {
            map.put(key, value);
        }
        this.trim(wis, map, lastRecordNo, maxRecords);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchCompleted(ConcurrentSkipListMap<Long, IWorkItemState> map, long lastRecordNo, long maxRecords) throws IOException {
        String location = "fetchCompleted";
        FileInputStream fis = null;
        InputStreamReader isr = null;
        String line = null;
        try (BufferedReader br = null;){
            String targetFile = this.fnJson;
            fis = new FileInputStream(targetFile);
            isr = new InputStreamReader(fis);
            br = new BufferedReader(isr);
            Type type = new TypeToken<WorkItemState>(){}.getType();
            line = br.readLine();
            while (line != null) {
                this.logger.trace(location, jobid, line);
                StringReader sr = new StringReader(line.trim());
                WorkItemState wis = (WorkItemState)gson.fromJson((Reader)sr, type);
                this.tryToAdd(wis, map, lastRecordNo, maxRecords);
                if (lastRecordNo == 0L && maxRecords != 0L && (long)map.size() >= maxRecords) {
                    break;
                }
                line = br.readLine();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchZipped(ConcurrentSkipListMap<Long, IWorkItemState> map, long lastRecordNo, long maxRecords) throws IOException {
        String location = "fetchZipped";
        File file = null;
        FileInputStream fis = null;
        GZIPInputStream gis = null;
        InputStreamReader isr = null;
        try (JsonReader jr = null;){
            String targetFile = this.fnJsonGz;
            file = new File(targetFile);
            fis = new FileInputStream(file);
            gis = new GZIPInputStream(fis);
            isr = new InputStreamReader((InputStream)gis, "UTF-8");
            jr = new JsonReader((Reader)isr);
            jr.beginArray();
            while (jr.hasNext()) {
                IWorkItemState wis = (IWorkItemState)gson.fromJson(jr, WorkItemState.class);
                this.tryToAdd(wis, map, lastRecordNo, maxRecords);
                if (lastRecordNo != 0L || maxRecords == 0L || (long)map.size() < maxRecords) continue;
                break;
            }
            jr.endArray();
        }
    }

    public double getMin() {
        double retVal = 0.0;
        if (this.wiVersion == 0L) {
            retVal = this.wism.getMin();
        }
        return retVal;
    }

    public double getMax() {
        double retVal = 0.0;
        if (this.wiVersion == 0L) {
            retVal = this.wism.getMax();
        }
        return retVal;
    }

    public double getAvg() {
        double retVal = 0.0;
        if (this.wiVersion == 0L) {
            retVal = this.wism.getAvg();
        }
        return retVal;
    }
}

