/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import net.sf.saxon.Configuration;
import net.sf.saxon.Err;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.sort.ComparisonKey;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.ValidationErrorValue;
import net.sf.saxon.value.Whitespace;

public final class TimeValue
extends CalendarValue {
    private byte hour;
    private byte minute;
    private byte second;
    private int microsecond;

    public TimeValue(byte by, byte by2, byte by3, int n, int n2) {
        this.hour = by;
        this.minute = by2;
        this.second = by3;
        this.microsecond = n;
        this.setTimezoneInMinutes(n2);
        this.typeLabel = BuiltInAtomicType.TIME;
    }

    public TimeValue(GregorianCalendar gregorianCalendar, int n) {
        this.hour = (byte)gregorianCalendar.get(11);
        this.minute = (byte)gregorianCalendar.get(12);
        this.second = (byte)gregorianCalendar.get(13);
        this.microsecond = gregorianCalendar.get(14) * 1000;
        this.setTimezoneInMinutes(n);
        this.typeLabel = BuiltInAtomicType.TIME;
    }

    public TimeValue(CharSequence charSequence) throws XPathException {
        StringTokenizer stringTokenizer = new StringTokenizer(((Object)Whitespace.trimWhitespace(charSequence)).toString(), "-:.+Z", true);
        try {
            String string;
            if (!stringTokenizer.hasMoreElements()) {
                this.badTime("too short", charSequence);
            }
            if ((string = (String)stringTokenizer.nextElement()).length() != 2) {
                this.badTime("hour must be two digits", charSequence);
            }
            this.hour = (byte)Integer.parseInt(string);
            if (this.hour > 24) {
                this.badTime("hour is out of range", charSequence);
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badTime("too short", charSequence);
            }
            if (!":".equals(stringTokenizer.nextElement())) {
                this.badTime("wrong delimiter after hour", charSequence);
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badTime("too short", charSequence);
            }
            if ((string = (String)stringTokenizer.nextElement()).length() != 2) {
                this.badTime("minute must be two digits", charSequence);
            }
            this.minute = (byte)Integer.parseInt(string);
            if (this.minute > 59) {
                this.badTime("minute is out of range", charSequence);
            }
            if (this.hour == 24 && this.minute != 0) {
                this.badTime("If hour is 24, minute must be 00", charSequence);
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badTime("too short", charSequence);
            }
            if (!":".equals(stringTokenizer.nextElement())) {
                this.badTime("wrong delimiter after minute", charSequence);
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badTime("too short", charSequence);
            }
            if ((string = (String)stringTokenizer.nextElement()).length() != 2) {
                this.badTime("second must be two digits", charSequence);
            }
            this.second = (byte)Integer.parseInt(string);
            if (this.second > 59) {
                this.badTime("second is out of range", charSequence);
            }
            if (this.hour == 24 && this.second != 0) {
                this.badTime("If hour is 24, second must be 00", charSequence);
            }
            int n = 0;
            int n2 = 0;
            while (stringTokenizer.hasMoreElements()) {
                String string2;
                if (n2 == 9) {
                    this.badTime("characters after the end", charSequence);
                }
                if (".".equals(string2 = (String)stringTokenizer.nextElement())) {
                    if (n2 != 0) {
                        this.badTime("decimal separator occurs twice", charSequence);
                    }
                    if (!stringTokenizer.hasMoreElements()) {
                        this.badTime("decimal point must be followed by digits", charSequence);
                    }
                    string = (String)stringTokenizer.nextElement();
                    double d = Double.parseDouble('.' + string);
                    this.microsecond = (int)Math.round(d * 1000000.0);
                    if (this.hour == 24 && this.microsecond != 0) {
                        this.badTime("If hour is 24, fractional seconds must be 0", charSequence);
                    }
                    n2 = 1;
                    continue;
                }
                if ("Z".equals(string2)) {
                    if (n2 > 1) {
                        this.badTime("Z cannot occur here", charSequence);
                    }
                    n = 0;
                    n2 = 9;
                    this.setTimezoneInMinutes(0);
                    continue;
                }
                if ("+".equals(string2) || "-".equals(string2)) {
                    if (n2 > 1) {
                        this.badTime(string2 + " cannot occur here", charSequence);
                    }
                    n2 = 2;
                    if (!stringTokenizer.hasMoreElements()) {
                        this.badTime("missing timezone", charSequence);
                    }
                    if ((string = (String)stringTokenizer.nextElement()).length() != 2) {
                        this.badTime("timezone hour must be two digits", charSequence);
                    }
                    if ((n = Integer.parseInt(string) * 60) > 840) {
                        this.badTime("timezone hour is out of range", charSequence);
                    }
                    if (!"-".equals(string2)) continue;
                    n = -n;
                    continue;
                }
                if (":".equals(string2)) {
                    if (n2 != 2) {
                        this.badTime("colon cannot occur here", charSequence);
                    }
                    n2 = 9;
                    string = (String)stringTokenizer.nextElement();
                    int n3 = Integer.parseInt(string);
                    if (string.length() != 2) {
                        this.badTime("timezone minute must be two digits", charSequence);
                    }
                    if (n3 > 59) {
                        this.badTime("timezone minute is out of range", charSequence);
                    }
                    if (n < 0) {
                        n3 = -n3;
                    }
                    this.setTimezoneInMinutes(n += n3);
                    continue;
                }
                this.badTime("timezone format is incorrect", charSequence);
            }
            if (n2 == 2 || n2 == 3) {
                this.badTime("timezone incomplete", charSequence);
            }
            if (this.hour == 24) {
                this.hour = 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.badTime("non-numeric component", charSequence);
        }
        this.typeLabel = BuiltInAtomicType.TIME;
    }

    private void badTime(String string, CharSequence charSequence) throws XPathException {
        ValidationException validationException = new ValidationException("Invalid time " + Err.wrap(charSequence, 4) + " (" + string + ")");
        validationException.setErrorCode("FORG0001");
        throw validationException;
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.TIME;
    }

    public byte getHour() {
        return this.hour;
    }

    public byte getMinute() {
        return this.minute;
    }

    public byte getSecond() {
        return this.second;
    }

    public int getMicrosecond() {
        return this.microsecond;
    }

    public AtomicValue convertPrimitive(BuiltInAtomicType builtInAtomicType, boolean bl, XPathContext xPathContext) {
        switch (builtInAtomicType.getPrimitiveType()) {
            case 88: 
            case 520: 
            case 632: {
                return this;
            }
            case 513: {
                return new StringValue(this.getStringValueCS());
            }
            case 631: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
        }
        ValidationException validationException = new ValidationException("Cannot convert time to " + builtInAtomicType.getDisplayName());
        validationException.setErrorCode("XPTY0004");
        validationException.setIsTypeError(true);
        return new ValidationErrorValue(validationException);
    }

    public CharSequence getStringValueCS() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(16);
        TimeValue.appendTwoDigits(fastStringBuffer, this.hour);
        fastStringBuffer.append(':');
        TimeValue.appendTwoDigits(fastStringBuffer, this.minute);
        fastStringBuffer.append(':');
        TimeValue.appendTwoDigits(fastStringBuffer, this.second);
        if (this.microsecond != 0) {
            fastStringBuffer.append('.');
            int n = this.microsecond;
            int n2 = 100000;
            while (n > 0) {
                int n3 = n / n2;
                fastStringBuffer.append((char)(n3 + 48));
                n %= n2;
                n2 /= 10;
            }
        }
        if (this.hasTimezone()) {
            this.appendTimezone(fastStringBuffer);
        }
        return fastStringBuffer;
    }

    public DateTimeValue toDateTime() {
        return new DateTimeValue(1972, 12, 31, this.hour, this.minute, this.second, this.microsecond, this.getTimezoneInMinutes());
    }

    public GregorianCalendar getCalendar() {
        int n = this.hasTimezone() ? this.getTimezoneInMinutes() : 0;
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(n * 60000, "LLL");
        GregorianCalendar gregorianCalendar = new GregorianCalendar(simpleTimeZone);
        gregorianCalendar.setLenient(false);
        int n2 = 1972;
        int n3 = 11;
        int n4 = 31;
        gregorianCalendar.set(n2, n3, n4, this.hour, this.minute, this.second);
        gregorianCalendar.set(14, this.microsecond / 1000);
        gregorianCalendar.set(15, n * 60000);
        gregorianCalendar.set(16, 0);
        gregorianCalendar.getTime();
        return gregorianCalendar;
    }

    public AtomicValue copy(AtomicType atomicType) {
        TimeValue timeValue = new TimeValue(this.hour, this.minute, this.second, this.microsecond, this.getTimezoneInMinutes());
        timeValue.typeLabel = atomicType;
        return timeValue;
    }

    public CalendarValue adjustTimezone(int n) {
        DateTimeValue dateTimeValue = (DateTimeValue)this.toDateTime().adjustTimezone(n);
        return new TimeValue(dateTimeValue.getHour(), dateTimeValue.getMinute(), dateTimeValue.getSecond(), dateTimeValue.getMicrosecond(), dateTimeValue.getTimezoneInMinutes());
    }

    public Object convertToJava(Class clazz, XPathContext xPathContext) throws XPathException {
        if (clazz.isAssignableFrom(TimeValue.class)) {
            return this;
        }
        if (clazz == String.class) {
            return this.getStringValue();
        }
        if (clazz == Object.class) {
            return this.getStringValue();
        }
        Object object = super.convertToJava(clazz, xPathContext);
        if (object == null) {
            throw new DynamicError("Conversion of time to " + clazz.getName() + " is not supported");
        }
        return object;
    }

    public AtomicValue getComponent(int n) throws XPathException {
        switch (n) {
            case 4: {
                return Int64Value.makeIntegerValue(this.hour);
            }
            case 5: {
                return Int64Value.makeIntegerValue(this.minute);
            }
            case 6: {
                BigDecimal bigDecimal = BigDecimal.valueOf(this.microsecond);
                bigDecimal = bigDecimal.divide(DecimalValue.BIG_DECIMAL_ONE_MILLION, 6, 4);
                bigDecimal = bigDecimal.add(BigDecimal.valueOf(this.second));
                return new DecimalValue(bigDecimal);
            }
            case 11: {
                return new Int64Value(this.microsecond);
            }
            case 7: {
                if (this.hasTimezone()) {
                    return DayTimeDurationValue.fromMilliseconds(this.getTimezoneInMinutes() * 60000);
                }
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown component for time: " + n);
    }

    public Comparable getXPathComparable() {
        return this;
    }

    public int compareTo(Object object) {
        if (!(object instanceof TimeValue)) {
            throw new ClassCastException("Time values are not comparable to " + object.getClass());
        }
        TimeValue timeValue = (TimeValue)object;
        if (this.getTimezoneInMinutes() == timeValue.getTimezoneInMinutes()) {
            if (this.hour != timeValue.hour) {
                return this.hour - timeValue.hour;
            }
            if (this.minute != timeValue.minute) {
                return this.minute - timeValue.minute;
            }
            if (this.second != timeValue.second) {
                return this.second - timeValue.second;
            }
            if (this.microsecond != timeValue.microsecond) {
                return this.microsecond - timeValue.microsecond;
            }
            return 0;
        }
        return this.toDateTime().compareTo(timeValue.toDateTime());
    }

    public int compareTo(CalendarValue calendarValue, Configuration configuration) {
        if (!(calendarValue instanceof TimeValue)) {
            throw new ClassCastException("Time values are not comparable to " + calendarValue.getClass());
        }
        TimeValue timeValue = (TimeValue)calendarValue;
        if (this.getTimezoneInMinutes() == timeValue.getTimezoneInMinutes()) {
            return this.compareTo(calendarValue);
        }
        return this.toDateTime().compareTo(timeValue.toDateTime(), configuration);
    }

    public ComparisonKey getComparisonKey(Configuration configuration) {
        return new ComparisonKey(520, this.toDateTime().normalize(configuration));
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int hashCode() {
        return this.toDateTime().hashCode();
    }

    public CalendarValue add(DurationValue durationValue) throws XPathException {
        if (durationValue instanceof DayTimeDurationValue) {
            DateTimeValue dateTimeValue = (DateTimeValue)this.toDateTime().add(durationValue);
            return new TimeValue(dateTimeValue.getHour(), dateTimeValue.getMinute(), dateTimeValue.getSecond(), dateTimeValue.getMicrosecond(), this.getTimezoneInMinutes());
        }
        DynamicError dynamicError = new DynamicError("Time+Duration arithmetic is supported only for xs:dayTimeDuration");
        dynamicError.setErrorCode("XPTY0004");
        dynamicError.setIsTypeError(true);
        throw dynamicError;
    }

    public DayTimeDurationValue subtract(CalendarValue calendarValue, XPathContext xPathContext) throws XPathException {
        if (!(calendarValue instanceof TimeValue)) {
            DynamicError dynamicError = new DynamicError("First operand of '-' is a time, but the second is not");
            dynamicError.setIsTypeError(true);
            throw dynamicError;
        }
        return super.subtract(calendarValue, xPathContext);
    }
}

