/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.io.PrintStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import net.sf.saxon.Configuration;
import net.sf.saxon.Platform;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SequenceIterable;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.UnionEnumeration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.Tokenize;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.ListIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingleNodeIterator;
import net.sf.saxon.pattern.IdrefTest;
import net.sf.saxon.pattern.PatternFinder;
import net.sf.saxon.sort.IntHashMap;
import net.sf.saxon.sort.IntIterator;
import net.sf.saxon.sort.LocalOrderComparer;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.KeyDefinition;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.UntypedAtomicValue;

public class KeyManager
implements Serializable {
    private IntHashMap keyList = new IntHashMap(10);
    private transient WeakHashMap docIndexes = new WeakHashMap(10);

    public KeyManager(Configuration configuration) {
        this.registerIdrefKey(configuration);
    }

    private void registerIdrefKey(Configuration configuration) {
        IdrefTest idrefTest = IdrefTest.getInstance();
        Atomizer atomizer = new Atomizer(new ContextItemExpression(), configuration);
        Tokenize tokenize = (Tokenize)SystemFunction.makeSystemFunction("tokenize", 2, configuration.getNamePool());
        StringLiteral stringLiteral = new StringLiteral("\\s");
        Expression[] expressionArray = new Expression[]{atomizer, stringLiteral};
        tokenize.setArguments(expressionArray);
        KeyDefinition keyDefinition = new KeyDefinition(idrefTest, tokenize, null, null);
        keyDefinition.setIndexedItemType(BuiltInAtomicType.STRING);
        try {
            this.addKeyDefinition(562, keyDefinition, configuration);
        }
        catch (StaticError staticError) {
            throw new AssertionError((Object)staticError);
        }
    }

    public void addKeyDefinition(int n, KeyDefinition keyDefinition, Configuration configuration) throws StaticError {
        int n2;
        ArrayList<KeyDefinition> arrayList = (ArrayList<KeyDefinition>)this.keyList.get(n);
        if (arrayList == null) {
            arrayList = new ArrayList<KeyDefinition>(3);
            this.keyList.put(n, arrayList);
        } else {
            String string = keyDefinition.getCollationName();
            if (string == null) {
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    if (((KeyDefinition)arrayList.get(n2)).getCollationName() == null) continue;
                    StaticError staticError = new StaticError("All keys with the same name must use the same collation");
                    staticError.setErrorCode("XTSE1220");
                    throw staticError;
                }
            } else {
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    if (string.equals(((KeyDefinition)arrayList.get(n2)).getCollationName())) continue;
                    StaticError staticError = new StaticError("All keys with the same name must use the same collation");
                    staticError.setErrorCode("XTSE1220");
                    throw staticError;
                }
            }
        }
        arrayList.add(keyDefinition);
        boolean bl = false;
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            if (!((KeyDefinition)arrayList.get(n2)).isBackwardsCompatible()) continue;
            bl = true;
            break;
        }
        if (bl) {
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                KeyDefinition keyDefinition2 = (KeyDefinition)arrayList.get(n2);
                keyDefinition2.setBackwardsCompatible(true);
                if (keyDefinition2.getBody().getItemType(configuration.getTypeHierarchy()).equals(BuiltInAtomicType.STRING)) continue;
                AtomicSequenceConverter atomicSequenceConverter = new AtomicSequenceConverter(keyDefinition2.getBody(), BuiltInAtomicType.STRING);
                keyDefinition2.setBody(atomicSequenceConverter);
            }
        }
    }

    public List getKeyDefinitions(int n) {
        return (List)this.keyList.get(n);
    }

    private synchronized HashMap buildIndex(int n, BuiltInAtomicType builtInAtomicType, Set set, DocumentInfo documentInfo, XPathContext xPathContext) throws XPathException {
        List list = this.getKeyDefinitions(n);
        if (list == null) {
            DynamicError dynamicError = new DynamicError("Key " + xPathContext.getNamePool().getDisplayName(n) + " has not been defined");
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setErrorCode("XTDE1260");
            throw dynamicError;
        }
        HashMap hashMap = new HashMap(100);
        for (int i = 0; i < list.size(); ++i) {
            this.constructIndex(documentInfo, hashMap, (KeyDefinition)list.get(i), builtInAtomicType, set, xPathContext, i == 0);
        }
        return hashMap;
    }

    private void constructIndex(DocumentInfo documentInfo, HashMap hashMap, KeyDefinition keyDefinition, BuiltInAtomicType builtInAtomicType, Set set, XPathContext xPathContext, boolean bl) throws XPathException {
        Item item;
        PatternFinder patternFinder = keyDefinition.getMatch();
        XPathContextMajor xPathContextMajor = xPathContext.newContext();
        xPathContextMajor.setOrigin(keyDefinition);
        SlotManager slotManager = keyDefinition.getStackFrameMap();
        if (slotManager != null) {
            xPathContextMajor.openStackFrame(slotManager);
        }
        SequenceIterator sequenceIterator = patternFinder.selectNodes(documentInfo, xPathContextMajor);
        while ((item = sequenceIterator.next()) != null) {
            this.processKeyNode((NodeInfo)item, builtInAtomicType, set, keyDefinition, hashMap, xPathContextMajor, bl);
        }
    }

    private void processKeyNode(NodeInfo nodeInfo, BuiltInAtomicType builtInAtomicType, Set set, KeyDefinition keyDefinition, HashMap hashMap, XPathContext xPathContext, boolean bl) throws XPathException {
        AtomicValue atomicValue;
        AxisIterator axisIterator = SingleNodeIterator.makeIterator(nodeInfo);
        axisIterator.next();
        xPathContext.setCurrentIterator(axisIterator);
        Platform platform = null;
        StringCollator stringCollator = keyDefinition.getCollation();
        if (stringCollator != null) {
            platform = Configuration.getPlatform();
        }
        SequenceIterable sequenceIterable = keyDefinition.getUse();
        SequenceIterator sequenceIterator = sequenceIterable.iterate(xPathContext);
        while ((atomicValue = (AtomicValue)sequenceIterator.next()) != null) {
            Object object;
            BuiltInAtomicType builtInAtomicType2 = atomicValue.getPrimitiveType();
            if (set != null) {
                set.add(builtInAtomicType2);
            }
            if (!Type.isComparable(builtInAtomicType2, builtInAtomicType, false)) {
                if (keyDefinition.isStrictComparison()) {
                    object = new DynamicError("Cannot compare " + builtInAtomicType + " to " + builtInAtomicType2 + " using 'eq'");
                    ((XPathException)object).setErrorCode("XPTY0004");
                    throw object;
                }
                if (keyDefinition.isConvertUntypedToOther() && builtInAtomicType2.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                    atomicValue = atomicValue.convert(builtInAtomicType, xPathContext);
                } else if (!keyDefinition.isConvertUntypedToOther() || !builtInAtomicType.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) continue;
            }
            if (builtInAtomicType.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                object = stringCollator == null ? atomicValue.getStringValue() : stringCollator.getCollationKey(atomicValue.getStringValue(), platform);
            } else if (builtInAtomicType.equals(BuiltInAtomicType.STRING)) {
                object = stringCollator == null ? atomicValue.getStringValue() : stringCollator.getCollationKey(atomicValue.getStringValue(), platform);
            } else {
                if (atomicValue instanceof NumericValue && ((NumericValue)atomicValue).isNaN()) break;
                try {
                    object = atomicValue.convert(builtInAtomicType, xPathContext);
                }
                catch (XPathException xPathException) {
                    break;
                }
            }
            ArrayList<NodeInfo> arrayList = (ArrayList<NodeInfo>)hashMap.get(object);
            if (arrayList == null) {
                arrayList = new ArrayList<NodeInfo>(4);
                hashMap.put(object, arrayList);
                arrayList.add(nodeInfo);
                continue;
            }
            if (bl) {
                if (arrayList.get(arrayList.size() - 1) == nodeInfo) continue;
                arrayList.add(nodeInfo);
                continue;
            }
            LocalOrderComparer localOrderComparer = LocalOrderComparer.getInstance();
            for (int i = 0; i < arrayList.size(); ++i) {
                int n = localOrderComparer.compare(nodeInfo, (NodeInfo)arrayList.get(i));
                if (n > 0) continue;
                if (n != 0) {
                    arrayList.add(i, nodeInfo);
                }
                return;
            }
            arrayList.add(nodeInfo);
        }
    }

    public SequenceIterator selectByKey(int n, DocumentInfo documentInfo, AtomicValue atomicValue, XPathContext xPathContext) throws XPathException {
        HashMap hashMap;
        Object object;
        Object object2;
        Object object3;
        BuiltInAtomicType builtInAtomicType;
        Serializable serializable;
        boolean bl;
        if (atomicValue == null) {
            return EmptyIterator.getInstance();
        }
        List list = this.getKeyDefinitions(n);
        if (list == null) {
            throw new DynamicError("Key " + xPathContext.getNamePool().getDisplayName(n) + " has not been defined", "XTDE1260", xPathContext);
        }
        KeyDefinition keyDefinition = (KeyDefinition)list.get(0);
        StringCollator stringCollator = keyDefinition.getCollation();
        Platform platform = null;
        if (stringCollator != null) {
            platform = Configuration.getPlatform();
        }
        if (bl = keyDefinition.isBackwardsCompatible()) {
            atomicValue = atomicValue.convert(BuiltInAtomicType.STRING, xPathContext);
        } else {
            serializable = atomicValue.getPrimitiveType();
            if (((BuiltInAtomicType)serializable).equals(BuiltInAtomicType.INTEGER) || ((BuiltInAtomicType)serializable).equals(BuiltInAtomicType.DECIMAL) || ((BuiltInAtomicType)serializable).equals(BuiltInAtomicType.FLOAT)) {
                atomicValue = new DoubleValue(((NumericValue)atomicValue).getDoubleValue());
            }
        }
        serializable = null;
        AtomicValue atomicValue2 = atomicValue;
        if (atomicValue instanceof UntypedAtomicValue && keyDefinition.isConvertUntypedToOther()) {
            builtInAtomicType = keyDefinition.getIndexedItemType();
            if (builtInAtomicType.equals(BuiltInAtomicType.ANY_ATOMIC)) {
                serializable = new HashSet(10);
                builtInAtomicType = BuiltInAtomicType.STRING;
            }
            atomicValue2 = atomicValue.convert(builtInAtomicType, xPathContext);
        }
        if ((object3 = this.getIndex(documentInfo, n, builtInAtomicType = atomicValue2.getPrimitiveType())) instanceof String) {
            DynamicError dynamicError = new DynamicError("Key definition is circular");
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setErrorCode("XTDE0640");
            throw dynamicError;
        }
        HashMap hashMap2 = (HashMap)object3;
        if (hashMap2 == null) {
            this.putIndex(documentInfo, n, builtInAtomicType, "Under Construction", xPathContext);
            hashMap2 = this.buildIndex(n, builtInAtomicType, (Set)((Object)serializable), documentInfo, xPathContext);
            this.putIndex(documentInfo, n, builtInAtomicType, hashMap2, xPathContext);
            if (serializable != null) {
                object2 = ((HashSet)serializable).iterator();
                while (object2.hasNext()) {
                    object = (BuiltInAtomicType)object2.next();
                    if (((BuiltInAtomicType)object).equals(BuiltInAtomicType.STRING)) continue;
                    this.putIndex(documentInfo, n, (AtomicType)object, "Under Construction", xPathContext);
                    hashMap2 = this.buildIndex(n, (BuiltInAtomicType)object, null, documentInfo, xPathContext);
                    this.putIndex(documentInfo, n, (AtomicType)object, hashMap2, xPathContext);
                }
            }
        }
        if (serializable == null) {
            object2 = (ArrayList)hashMap2.get(KeyManager.getCollationKey(atomicValue2, builtInAtomicType, stringCollator, platform));
            if (object2 == null) {
                return EmptyIterator.getInstance();
            }
            return new ListIterator((List)object2);
        }
        object2 = null;
        object = (WeakReference)this.docIndexes.get(documentInfo);
        if (object != null && (hashMap = (HashMap)((Reference)object).get()) != null) {
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                ArrayList arrayList;
                Serializable serializable2;
                long l = (Long)iterator.next();
                if ((l >> 32 & 0xFFFFFFFFFFFFFFFFL) != (long)n) continue;
                int n2 = (int)(l & 0xFFFFFFFFFFFFFFFFL);
                BuiltInAtomicType builtInAtomicType2 = (BuiltInAtomicType)BuiltInType.getSchemaType(n2);
                Object object4 = this.getIndex(documentInfo, n, builtInAtomicType2);
                if (object4 instanceof String) {
                    serializable2 = new DynamicError("Key definition is circular");
                    ((DynamicError)serializable2).setXPathContext(xPathContext);
                    ((XPathException)serializable2).setErrorCode("XTDE0640");
                    throw serializable2;
                }
                serializable2 = (HashMap)object4;
                if (((HashMap)serializable2).size() <= 0 || (arrayList = (ArrayList)((HashMap)serializable2).get(KeyManager.getCollationKey(atomicValue2 = atomicValue.convert(builtInAtomicType2, xPathContext), builtInAtomicType2, stringCollator, platform))) == null) continue;
                if (object2 == null) {
                    object2 = new ListIterator(arrayList);
                    continue;
                }
                object2 = new UnionEnumeration((SequenceIterator)object2, new ListIterator(arrayList), LocalOrderComparer.getInstance());
            }
        }
        if (object2 == null) {
            return EmptyIterator.getInstance();
        }
        return object2;
    }

    private static Object getCollationKey(AtomicValue atomicValue, BuiltInAtomicType builtInAtomicType, StringCollator stringCollator, Platform platform) {
        Object object = builtInAtomicType.equals(BuiltInAtomicType.STRING) || builtInAtomicType.equals(BuiltInAtomicType.UNTYPED_ATOMIC) ? (stringCollator == null ? atomicValue.getStringValue() : stringCollator.getCollationKey(atomicValue.getStringValue(), platform)) : atomicValue;
        return object;
    }

    private synchronized void putIndex(DocumentInfo documentInfo, int n, AtomicType atomicType, Object object, XPathContext xPathContext) {
        HashMap hashMap;
        WeakReference weakReference;
        if (this.docIndexes == null) {
            this.docIndexes = new WeakHashMap(10);
        }
        if ((weakReference = (WeakReference)this.docIndexes.get(documentInfo)) == null || weakReference.get() == null) {
            hashMap = new HashMap(10);
            xPathContext.getController().setUserData(documentInfo, "key-index-list", hashMap);
            this.docIndexes.put(documentInfo, new WeakReference<HashMap>(hashMap));
        } else {
            hashMap = (HashMap)weakReference.get();
        }
        hashMap.put(new Long((long)n << 32 | (long)atomicType.getFingerprint()), object);
    }

    private synchronized Object getIndex(DocumentInfo documentInfo, int n, AtomicType atomicType) {
        WeakReference weakReference;
        if (this.docIndexes == null) {
            this.docIndexes = new WeakHashMap(10);
        }
        if ((weakReference = (WeakReference)this.docIndexes.get(documentInfo)) == null) {
            return null;
        }
        HashMap hashMap = (HashMap)weakReference.get();
        if (hashMap == null) {
            return null;
        }
        return hashMap.get(new Long((long)n << 32 | (long)atomicType.getFingerprint()));
    }

    public void explainKeys(Configuration configuration, PrintStream printStream) {
        if (this.keyList.size() < 2) {
            return;
        }
        printStream.println("============ Indexes ======================");
        IntIterator intIterator = this.keyList.keyIterator();
        while (intIterator.hasNext()) {
            int n = intIterator.next();
            List list = (List)this.keyList.get(n);
            for (int i = 0; i < list.size(); ++i) {
                KeyDefinition keyDefinition = (KeyDefinition)list.get(i);
                printStream.println(" Index " + configuration.getNamePool().getDisplayName(n));
                printStream.println("   match = ");
                printStream.println(keyDefinition.getMatch().toString());
                if (!(keyDefinition.getUse() instanceof Expression)) continue;
                printStream.println("   use = ");
                ((Expression)keyDefinition.getUse()).display(10, printStream, configuration);
            }
        }
        printStream.println("===========================================");
    }
}

