/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.java;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.java.JDK14RegexTranslator;
import net.sf.saxon.java.JDK15RegexTranslator;
import net.sf.saxon.java.JRegexIterator;
import net.sf.saxon.java.JTokenIterator;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.regex.RegexIterator;
import net.sf.saxon.regex.RegexSyntaxException;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;

public class JRegularExpression
implements RegularExpression {
    Pattern pattern;
    String javaRegex;
    int flagBits;

    public JRegularExpression(String string, int n) {
        this.flagBits = n;
        this.javaRegex = string;
        String string2 = System.getProperty("java.version");
        this.pattern = string2.startsWith("1.4") ? Pattern.compile(string, n & 0xFFFFFFFB) : Pattern.compile(string, n & 0xFFFFFFF9);
    }

    public JRegularExpression(CharSequence charSequence, boolean bl, int n) throws XPathException {
        this.flagBits = n;
        try {
            String string = System.getProperty("java.version");
            if (string.startsWith("1.4")) {
                JDK14RegexTranslator jDK14RegexTranslator = new JDK14RegexTranslator();
                jDK14RegexTranslator.setIgnoreWhitespace((n & 4) != 0);
                this.javaRegex = jDK14RegexTranslator.translate(charSequence, bl);
                this.pattern = Pattern.compile(this.javaRegex, n & 0xFFFFFFFB);
            } else {
                boolean bl2 = (n & 4) != 0;
                boolean bl3 = (n & 2) != 0;
                this.javaRegex = JDK15RegexTranslator.translate(charSequence, bl, bl2, bl3);
                this.pattern = Pattern.compile(this.javaRegex, n & 0xFFFFFFF9);
            }
        }
        catch (RegexSyntaxException regexSyntaxException) {
            throw new DynamicError(regexSyntaxException.getMessage());
        }
    }

    public String getJavaRegularExpression() {
        return this.javaRegex;
    }

    public int getFlagBits() {
        return this.flagBits;
    }

    public RegexIterator analyze(CharSequence charSequence) {
        return new JRegexIterator(((Object)charSequence).toString(), this.pattern);
    }

    public boolean containsMatch(CharSequence charSequence) {
        return this.pattern.matcher(charSequence).find();
    }

    public boolean matches(CharSequence charSequence) {
        return this.pattern.matcher(charSequence).matches();
    }

    public CharSequence replace(CharSequence charSequence, CharSequence charSequence2) throws XPathException {
        Matcher matcher = this.pattern.matcher(charSequence);
        try {
            String string = matcher.replaceAll(((Object)charSequence2).toString());
            return string;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            int n = matcher.groupCount();
            if (n >= 9) {
                throw indexOutOfBoundsException;
            }
            String string = ((Object)charSequence2).toString();
            String string2 = "\\$[" + (n + 1) + "-9]";
            String string3 = Pattern.compile(string2).matcher(string).replaceAll("");
            String string4 = matcher.replaceAll(string3);
            return string4;
        }
    }

    public SequenceIterator tokenize(CharSequence charSequence) {
        if (charSequence.length() == 0) {
            return EmptyIterator.getInstance();
        }
        return new JTokenIterator(charSequence, this.pattern);
    }

    public static int setFlags(CharSequence charSequence) throws DynamicError {
        int n = 1;
        block6: for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            switch (c) {
                case 'm': {
                    n |= 8;
                    continue block6;
                }
                case 'i': {
                    n |= 2;
                    n |= 0x40;
                    continue block6;
                }
                case 's': {
                    n |= 0x20;
                    continue block6;
                }
                case 'x': {
                    n |= 4;
                    continue block6;
                }
                default: {
                    DynamicError dynamicError = new DynamicError("Invalid character '" + c + "' in regular expression flags");
                    dynamicError.setErrorCode("FORX0001");
                    throw dynamicError;
                }
            }
        }
        return n;
    }
}

