/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Error;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.TailCallReturner;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;

public class IfExpression
extends Expression
implements TailCallReturner {
    private Expression condition;
    private Expression thenExp;
    private Expression elseExp;

    public IfExpression(Expression expression, Expression expression2, Expression expression3) {
        this.condition = expression;
        this.thenExp = expression2;
        this.elseExp = expression3;
        this.adoptChildExpression(expression);
        this.adoptChildExpression(expression2);
        this.adoptChildExpression(expression3);
    }

    public Expression getCondition() {
        return this.condition;
    }

    public Expression getThenExpression() {
        return this.thenExp;
    }

    public Expression getElseExpression() {
        return this.elseExp;
    }

    public void setCondition(Expression expression) {
        this.condition = expression;
        this.adoptChildExpression(expression);
    }

    public void setThenExpression(Expression expression) {
        this.thenExp = expression;
        this.adoptChildExpression(expression);
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.condition = this.condition.simplify(staticContext);
        if (this.condition instanceof Literal) {
            boolean bl;
            try {
                bl = ((Literal)this.condition).getValue().effectiveBooleanValue();
            }
            catch (XPathException xPathException) {
                xPathException.setLocator(this);
                throw xPathException;
            }
            return bl ? this.thenExp.simplify(staticContext) : this.elseExp.simplify(staticContext);
        }
        this.thenExp = this.thenExp.simplify(staticContext);
        this.elseExp = this.elseExp.simplify(staticContext);
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.condition = this.condition.typeCheck(staticContext, itemType);
        TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
        if (typeHierarchy.isSubType(this.condition.getItemType(typeHierarchy), AnyNodeTest.getInstance()) && !Cardinality.allowsZero(this.condition.getCardinality())) {
            this.condition = Literal.makeLiteral(BooleanValue.TRUE);
        }
        if (this.condition instanceof Literal) {
            if (ExpressionTool.effectiveBooleanValue(this.condition.iterate(null))) {
                Expression.setParentExpression(this.thenExp, this.getParentExpression());
                return this.thenExp.typeCheck(staticContext, itemType);
            }
            Expression.setParentExpression(this.elseExp, this.getParentExpression());
            return this.elseExp.typeCheck(staticContext, itemType);
        }
        XPathException xPathException = TypeChecker.ebvError(this.condition, staticContext.getConfiguration().getTypeHierarchy());
        if (xPathException != null) {
            xPathException.setLocator(this);
            throw xPathException;
        }
        this.thenExp = this.thenExp.typeCheck(staticContext, itemType);
        this.elseExp = this.elseExp.typeCheck(staticContext, itemType);
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        this.condition = this.condition.optimize(optimizer, staticContext, itemType);
        this.thenExp = this.thenExp.optimize(optimizer, staticContext, itemType);
        this.elseExp = this.elseExp.optimize(optimizer, staticContext, itemType);
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        this.condition = this.doPromotion(this.condition, promotionOffer);
        if (promotionOffer.action == 13 || promotionOffer.action == 12 || promotionOffer.action == 14) {
            this.thenExp = this.doPromotion(this.thenExp, promotionOffer);
            this.elseExp = this.doPromotion(this.elseExp, promotionOffer);
        }
        return this;
    }

    public Iterator iterateSubExpressions() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>(3);
        arrayList.add(this.condition);
        arrayList.add(this.thenExp);
        arrayList.add(this.elseExp);
        return arrayList.iterator();
    }

    public boolean replaceSubExpression(Expression expression, Expression expression2) {
        boolean bl = false;
        if (this.condition == expression) {
            this.condition = expression2;
            bl = true;
        }
        if (this.thenExp == expression) {
            this.thenExp = expression2;
            bl = true;
        }
        if (this.elseExp == expression) {
            this.elseExp = expression2;
            bl = true;
        }
        return bl;
    }

    public void suppressValidation(int n) {
        this.thenExp.suppressValidation(n);
        this.elseExp.suppressValidation(n);
    }

    public int markTailFunctionCalls(int n, int n2) {
        int n3 = ExpressionTool.markTailFunctionCalls(this.thenExp, n, n2);
        int n4 = ExpressionTool.markTailFunctionCalls(this.elseExp, n, n2);
        return Math.max(n3, n4);
    }

    public void checkPermittedContents(SchemaType schemaType, StaticContext staticContext, boolean bl) throws XPathException {
        this.thenExp.checkPermittedContents(schemaType, staticContext, bl);
        this.elseExp.checkPermittedContents(schemaType, staticContext, bl);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        if (this.condition.effectiveBooleanValue(xPathContext)) {
            return this.thenExp.evaluateItem(xPathContext);
        }
        return this.elseExp.evaluateItem(xPathContext);
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        if (this.condition.effectiveBooleanValue(xPathContext)) {
            return this.thenExp.iterate(xPathContext);
        }
        return this.elseExp.iterate(xPathContext);
    }

    public void process(XPathContext xPathContext) throws XPathException {
        if (this.condition.effectiveBooleanValue(xPathContext)) {
            this.thenExp.process(xPathContext);
        } else {
            this.elseExp.process(xPathContext);
        }
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        if (this.condition.effectiveBooleanValue(xPathContext)) {
            if (this.thenExp instanceof TailCallReturner) {
                return ((TailCallReturner)((Object)this.thenExp)).processLeavingTail(xPathContext);
            }
            this.thenExp.process(xPathContext);
            return null;
        }
        if (this.elseExp instanceof TailCallReturner) {
            return ((TailCallReturner)((Object)this.elseExp)).processLeavingTail(xPathContext);
        }
        this.elseExp.process(xPathContext);
        return null;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        if (this.thenExp instanceof Error) {
            return this.elseExp.getItemType(typeHierarchy);
        }
        if (this.elseExp instanceof Error) {
            return this.thenExp.getItemType(typeHierarchy);
        }
        return Type.getCommonSuperType(this.thenExp.getItemType(typeHierarchy), this.elseExp.getItemType(typeHierarchy), typeHierarchy);
    }

    public int computeCardinality() {
        return Cardinality.union(this.thenExp.getCardinality(), this.elseExp.getCardinality());
    }

    public int computeSpecialProperties() {
        if (Literal.isEmptySequence(this.thenExp)) {
            return this.elseExp.getSpecialProperties();
        }
        if (Literal.isEmptySequence(this.elseExp)) {
            return this.thenExp.getSpecialProperties();
        }
        return this.thenExp.getSpecialProperties() & this.elseExp.getSpecialProperties();
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n) + "if (");
        this.condition.display(n + 1, printStream, configuration);
        printStream.println(ExpressionTool.indent(n) + "then");
        this.thenExp.display(n + 1, printStream, configuration);
        printStream.println(ExpressionTool.indent(n) + "else");
        this.elseExp.display(n + 1, printStream, configuration);
    }
}

