/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Cardinality;

public final class CardinalityCheckingIterator
implements SequenceIterator {
    private SequenceIterator base;
    private int requiredCardinality;
    private RoleLocator role;
    private Item first = null;
    private Item second = null;
    private Item current = null;
    private int position = 0;

    public CardinalityCheckingIterator(SequenceIterator sequenceIterator, int n, RoleLocator roleLocator) throws XPathException {
        this.base = sequenceIterator;
        this.requiredCardinality = n;
        this.role = roleLocator;
        this.first = sequenceIterator.next();
        if (this.first == null) {
            if (!Cardinality.allowsZero(n)) {
                this.typeError("An empty sequence is not allowed as the " + roleLocator.getMessage(), roleLocator.getErrorCode());
            }
        } else {
            if (n == 8192) {
                this.typeError("The only value allowed for the " + roleLocator.getMessage() + " is an empty sequence", roleLocator.getErrorCode());
            }
            this.second = sequenceIterator.next();
            if (this.second != null && !Cardinality.allowsMany(n)) {
                this.typeError("A sequence of more than one item is not allowed as the " + roleLocator.getMessage() + CardinalityChecker.depictSequenceStart(sequenceIterator.getAnother(), 2), roleLocator.getErrorCode());
            }
        }
    }

    public Item next() throws XPathException {
        if (this.position < 2) {
            if (this.position == 0) {
                this.current = this.first;
                this.position = 1;
                return this.current;
            }
            if (this.position == 1) {
                this.current = this.second;
                this.position = 2;
                return this.current;
            }
        }
        this.current = this.base.next();
        this.position = this.current == null ? -1 : ++this.position;
        return this.current;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        return this.position;
    }

    public SequenceIterator getAnother() throws XPathException {
        return new CardinalityCheckingIterator(this.base.getAnother(), this.requiredCardinality, this.role);
    }

    public int getProperties() {
        return 0;
    }

    private void typeError(String string, String string2) throws DynamicError {
        DynamicError dynamicError = new DynamicError(string, this.role.getSourceLocator());
        dynamicError.setIsTypeError(true);
        dynamicError.setErrorCode(string2);
        throw dynamicError;
    }
}

