/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.orchestrator.jd.scheduler;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.SizeBytes;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.orchestrator.jd.scheduler.IJdReservation;
import org.apache.uima.ducc.orchestrator.jd.scheduler.JdHelper;
import org.apache.uima.ducc.transport.event.common.IDuccState;
import org.apache.uima.ducc.transport.event.common.IDuccWorkReservation;
import org.apache.uima.ducc.transport.event.common.JdReservationBean;

public class JdReservation
extends JdReservationBean
implements IJdReservation {
    private static final long serialVersionUID = 1L;
    private static DuccLogger logger = new DuccLogger(JdReservation.class);
    private static DuccId jobid = null;

    public JdReservation(IDuccWorkReservation dwr, SizeBytes sizeOfReservation, SizeBytes sizeOfSlice) {
        this.initialize(dwr, sizeOfReservation, sizeOfSlice);
    }

    private void initialize(IDuccWorkReservation dwr, SizeBytes sizeOfReservation, SizeBytes sizeOfSlice) {
        if (dwr != null) {
            DuccId jdReservationId = dwr.getDuccId();
            this.setJdReservationId(jdReservationId);
            this.setNodeIdentity(JdHelper.getNodeIdentity(dwr));
            this.setReservationState(dwr.getReservationState());
            if (sizeOfReservation != null) {
                this.setSizeOfReservation(sizeOfReservation);
            }
            if (sizeOfSlice != null) {
                this.setSizeOfSlice(sizeOfSlice);
            }
        }
    }

    public String getHost() {
        String retVal = null;
        NodeIdentity nodeIdentity = this.getNodeIdentity();
        if (nodeIdentity != null) {
            retVal = nodeIdentity.getCanonicalName();
        }
        return retVal;
    }

    public boolean isUp() {
        boolean retVal = false;
        IDuccState.ReservationState reservationState = this.getReservationState();
        if (reservationState != null) {
            switch (reservationState) {
                case Assigned: {
                    retVal = true;
                    break;
                }
            }
        }
        return retVal;
    }

    @Override
    public Long getSlicesTotal() {
        String location = "getSlicesTotal";
        SizeBytes sizeOfReservation = this.getSizeOfReservation();
        SizeBytes sizeOfSlice = this.getSizeOfSlice();
        Long retVal = (long)((double)sizeOfReservation.getBytes() / (1.0 * (double)sizeOfSlice.getBytes()));
        logger.trace(location, jobid, new Object[]{retVal});
        return retVal;
    }

    @Override
    public Long getSlicesInuse() {
        String location = "getSlicesInuse";
        ConcurrentHashMap map = this.getMap();
        long retVal = new Long(map.size());
        logger.trace(location, jobid, new Object[]{retVal});
        return retVal;
    }

    public Long getSlicesAvailable() {
        String location = "getSlicesAvailable";
        Long retVal = this.getSlicesTotal() - this.getSlicesInuse();
        logger.trace(location, jobid, new Object[]{retVal});
        return retVal;
    }

    public boolean isFull() {
        boolean retVal = this.getSlicesTotal() <= this.getSlicesInuse();
        return retVal;
    }

    public boolean isEmpty() {
        boolean retVal = this.getSlicesInuse() == 0L;
        return retVal;
    }

    protected NodeIdentity allocate(DuccId jobIdentity, DuccId driverIdentity) {
        NodeIdentity retVal = this.allocate(jobIdentity, driverIdentity, this.getSizeOfSlice());
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NodeIdentity allocate(DuccId jobIdentity, DuccId driverIdentity, SizeBytes size) {
        String location = "allocate";
        NodeIdentity retVal = null;
        ConcurrentHashMap map = this.getMap();
        if (jobIdentity != null) {
            JdReservation jdReservation = this;
            synchronized (jdReservation) {
                SizeBytes previous;
                if (!map.containsKey(jobIdentity) && !this.isFull() && (previous = map.putIfAbsent(jobIdentity, size)) == null) {
                    retVal = this.getNodeIdentity();
                }
            }
            if (retVal != null) {
                logger.info(location, jobIdentity, new Object[]{"driverId:" + driverIdentity + " host: " + retVal.getCanonicalName() + " size: " + map.size()});
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NodeIdentity deallocate(DuccId jobIdentity, DuccId driverIdentity) {
        String location = "deallocate";
        NodeIdentity retVal = null;
        ConcurrentHashMap map = this.getMap();
        if (jobIdentity != null) {
            JdReservation jdReservation = this;
            synchronized (jdReservation) {
                if (map.containsKey(jobIdentity)) {
                    map.remove(jobIdentity);
                    retVal = this.getNodeIdentity();
                }
            }
            if (retVal != null) {
                logger.info(location, jobIdentity, new Object[]{"driverId:" + driverIdentity + " host: " + retVal.getCanonicalName() + " size: " + map.size()});
            }
        }
        return retVal;
    }
}

