/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.orchestrator.jd.scheduler;

import java.util.Iterator;
import java.util.Map;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.SizeBytes;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.orchestrator.jd.scheduler.JdHostProperties;
import org.apache.uima.ducc.transport.event.common.IDuccReservation;
import org.apache.uima.ducc.transport.event.common.IDuccReservationMap;
import org.apache.uima.ducc.transport.event.common.IDuccWorkReservation;

public class JdHelper {
    private static DuccLogger logger = new DuccLogger(JdHelper.class);
    private static DuccId jobid = null;
    public static long SlicesReserveDefault = 2L;

    public static NodeIdentity getNodeIdentity(IDuccWorkReservation dwr) {
        NodeIdentity retVal;
        block0: {
            Iterator iterator;
            IDuccReservationMap rm;
            retVal = null;
            if (dwr == null || (rm = dwr.getReservationMap()) == null || !(iterator = rm.entrySet().iterator()).hasNext()) break block0;
            Map.Entry entry = (Map.Entry)iterator.next();
            retVal = ((IDuccReservation)entry.getValue()).getNodeIdentity();
        }
        return retVal;
    }

    private static long parseCount(String value) {
        long count = -1L;
        try {
            String tValue = value.trim();
            count = new Long(tValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return count;
    }

    public static SizeBytes getReservationSize(IDuccWorkReservation dwr) {
        String location = "getReservationSize";
        SizeBytes retVal = null;
        try {
            long sizeBytes = dwr.getSchedulingInfo().getMemorySizeAllocatedInBytes();
            retVal = new SizeBytes(SizeBytes.Type.Bytes, sizeBytes);
            logger.trace(location, dwr.getDuccId(), new Object[]{retVal.getGBytes() + " GB"});
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    public static SizeBytes getSliceSize(JdHostProperties jdHostProperties) {
        String location = "getSliceSize";
        SizeBytes retVal = null;
        if (jdHostProperties != null) {
            String value = jdHostProperties.getJdShareQuantum();
            retVal = new SizeBytes(SizeBytes.Type.MBytes, Long.parseLong(value));
            logger.trace(location, jobid, new Object[]{retVal.getMBytes() + " MB"});
        }
        return retVal;
    }

    public static long getSlicesReserve(JdHostProperties jdHostProperties) {
        String location = "getSlicesReserve";
        long retVal = 0L;
        if (jdHostProperties != null) {
            String value = jdHostProperties.getSlicesReserve();
            retVal = JdHelper.parseCount(value);
            logger.trace(location, jobid, new Object[]{retVal + " specified"});
        }
        if (retVal < 0L) {
            retVal = SlicesReserveDefault;
            logger.trace(location, jobid, new Object[]{retVal + " default"});
        }
        return retVal;
    }
}

