/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.orchestrator;

import java.util.ArrayList;
import java.util.Properties;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.orchestrator.authentication.DuccWebAdministrators;
import org.apache.uima.ducc.orchestrator.utilities.CliVersion;
import org.apache.uima.ducc.orchestrator.utilities.MemorySpecification;
import org.apache.uima.ducc.transport.event.AbstractDuccOrchestratorEvent;
import org.apache.uima.ducc.transport.event.CancelJobDuccEvent;
import org.apache.uima.ducc.transport.event.CancelReservationDuccEvent;
import org.apache.uima.ducc.transport.event.CancelServiceDuccEvent;
import org.apache.uima.ducc.transport.event.SubmitJobDuccEvent;
import org.apache.uima.ducc.transport.event.SubmitReservationDuccEvent;
import org.apache.uima.ducc.transport.event.SubmitServiceDuccEvent;
import org.apache.uima.ducc.transport.event.cli.JobRequestProperties;
import org.apache.uima.ducc.transport.event.cli.JobSpecificationProperties;
import org.apache.uima.ducc.transport.event.cli.ReservationRequestProperties;
import org.apache.uima.ducc.transport.event.cli.ServiceRequestProperties;
import org.apache.uima.ducc.transport.event.common.DuccWorkReservation;

public class Validate {
    private static final DuccLogger logger = DuccLogger.getLogger(Validate.class);
    private static DuccWebAdministrators duccWebAdministrators = new DuccWebAdministrators();

    private static void addError(Properties properties, String reason) {
        String methodName = "addError";
        String key = JobSpecificationProperties.key_submit_errors;
        ArrayList<String> value = (ArrayList<String>)properties.get(key);
        if (value == null) {
            value = new ArrayList<String>();
            properties.put(key, value);
        }
        value.add(reason);
        logger.info(methodName, null, new Object[]{reason});
    }

    private static void addWarning(Properties properties, String reason) {
        String methodName = "addWarning";
        String key = JobSpecificationProperties.key_submit_warnings;
        ArrayList<String> value = (ArrayList<String>)properties.get(key);
        if (value == null) {
            value = new ArrayList<String>();
            properties.put(key, value);
        }
        value.add(reason);
        logger.info(methodName, null, new Object[]{reason});
    }

    private static String createReason(String type, String key, String value) {
        String retVal = type + ": " + key + "=" + value;
        return retVal;
    }

    public static boolean integer(boolean retVal, Properties properties, String key, String defaultValue, String minValue) {
        String value = (String)properties.get(key);
        if (value == null) {
            String reason = Validate.createReason("default", key, defaultValue);
            Validate.addWarning(properties, reason);
        } else {
            try {
                int specified_value = Integer.parseInt(value);
                int min_value = Integer.parseInt(minValue);
                if (specified_value < min_value) {
                    String reason = Validate.createReason("invalid, under " + minValue, key, value);
                    Validate.addError(properties, reason);
                    retVal = false;
                }
            }
            catch (Exception e) {
                String reason = Validate.createReason("invalid, non-integer", key, value);
                Validate.addError(properties, reason);
                retVal = false;
            }
        }
        return retVal;
    }

    public static boolean request(SubmitJobDuccEvent duccEvent) {
        boolean retVal = true;
        if (!Validate.validate_cli_version((AbstractDuccOrchestratorEvent)duccEvent)) {
            return false;
        }
        JobRequestProperties properties = (JobRequestProperties)duccEvent.getProperties();
        retVal = Validate.integer(retVal, (Properties)properties, JobSpecificationProperties.key_process_pipeline_count, "1", "1");
        String key = JobRequestProperties.key_scheduling_class;
        String value = (String)properties.get((Object)key);
        if (value == null) {
            String reason = Validate.createReason("invalid", key, value);
            Validate.addError((Properties)properties, reason);
            retVal = false;
        }
        return retVal;
    }

    public static boolean request(CancelJobDuccEvent duccEvent) {
        if (!Validate.validate_cli_version((AbstractDuccOrchestratorEvent)duccEvent)) {
            return false;
        }
        boolean retVal = true;
        return retVal;
    }

    public static boolean accept(SubmitReservationDuccEvent duccEvent) {
        String value = DuccPropertiesResolver.getInstance().getProperty("ducc.orchestrator.unmanaged.reservations.accepted");
        Boolean result = new Boolean(value);
        return result;
    }

    public static boolean request(SubmitReservationDuccEvent duccEvent) {
        String reason;
        String key;
        boolean retVal = true;
        if (!Validate.validate_cli_version((AbstractDuccOrchestratorEvent)duccEvent)) {
            return false;
        }
        ReservationRequestProperties properties = (ReservationRequestProperties)duccEvent.getProperties();
        String memorySize = (String)properties.get((Object)(key = ReservationRequestProperties.key_memory_size));
        MemorySpecification memorySpecification = new MemorySpecification(memorySize);
        String value = memorySpecification.getSize();
        if (value == null) {
            reason = Validate.createReason("invalid", key, value);
            Validate.addError((Properties)properties, reason);
            retVal = false;
        }
        if ((value = (String)properties.get((Object)(key = ReservationRequestProperties.key_scheduling_class))) == null) {
            reason = Validate.createReason("invalid", key, value);
            Validate.addError((Properties)properties, reason);
            retVal = false;
        }
        return retVal;
    }

    public static boolean request(CancelReservationDuccEvent duccEvent, DuccWorkReservation duccWorkReservation) {
        String location = "request";
        boolean retVal = false;
        if (!Validate.validate_cli_version((AbstractDuccOrchestratorEvent)duccEvent)) {
            return false;
        }
        Properties properties = duccEvent.getProperties();
        String userid = properties.getProperty(JobSpecificationProperties.key_user);
        String ownerid = duccWorkReservation.getStandardInfo().getUser();
        if (userid != null && userid.equals(ownerid)) {
            retVal = true;
        } else if (duccWebAdministrators.isAdministrator(userid)) {
            retVal = true;
        } else {
            String reason = userid == null ? Validate.createReason("reservation cancel invalid", JobSpecificationProperties.key_user, "unspecified") : Validate.createReason("reservation cancel unauthorized", JobSpecificationProperties.key_user, userid);
            Validate.addWarning(properties, reason);
            logger.warn(location, duccWorkReservation.getDuccId(), new Object[]{reason});
        }
        return retVal;
    }

    public static boolean request(SubmitServiceDuccEvent duccEvent) {
        boolean retVal = true;
        if (!Validate.validate_cli_version((AbstractDuccOrchestratorEvent)duccEvent)) {
            return false;
        }
        JobRequestProperties properties = (JobRequestProperties)duccEvent.getProperties();
        retVal = Validate.integer(retVal, (Properties)properties, JobSpecificationProperties.key_process_pipeline_count, "1", "1");
        String key = ServiceRequestProperties.key_scheduling_class;
        String value = (String)properties.get((Object)key);
        if (value == null) {
            String reason = Validate.createReason("invalid", key, value);
            Validate.addError((Properties)properties, reason);
            retVal = false;
        }
        return retVal;
    }

    public static boolean request(CancelServiceDuccEvent duccEvent) {
        boolean retVal = true;
        if (!Validate.validate_cli_version((AbstractDuccOrchestratorEvent)duccEvent)) {
            return false;
        }
        return retVal;
    }

    private static boolean validate_cli_version(AbstractDuccOrchestratorEvent ev) {
        if (ev.getCliVersion() == CliVersion.getVersion()) {
            return true;
        }
        String reason = ev.getEventType() + " rejected. Incompatible CLI request using version " + ev.getCliVersion() + " while DUCC expects version " + CliVersion.getVersion();
        Validate.addError(ev.getProperties(), reason);
        logger.warn("validate_cli_request", null, new Object[]{reason});
        return false;
    }
}

