/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.orchestrator;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;

public class ProcessToJobMap {
    private static final DuccLogger logger = DuccLogger.getLogger(ProcessToJobMap.class);
    private static final DuccId jobid = null;
    private static ProcessToJobMap instance = new ProcessToJobMap();
    private ConcurrentHashMap<DuccId, DuccId> processToJobMap = new ConcurrentHashMap();

    public static ProcessToJobMap getInstance() {
        return instance;
    }

    public ConcurrentHashMap<DuccId, DuccId> getMap() {
        ConcurrentHashMap<DuccId, DuccId> retVal = new ConcurrentHashMap<DuccId, DuccId>();
        retVal.putAll(this.processToJobMap);
        return retVal;
    }

    public void putMap(ConcurrentHashMap<DuccId, DuccId> map) {
        String location = "putMap";
        if (map != null) {
            logger.debug(location, jobid, new Object[]{map.size()});
            for (Map.Entry<DuccId, DuccId> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public boolean containsKey(DuccId key) {
        return this.processToJobMap.containsKey(key);
    }

    public DuccId put(DuccId processId, DuccId jobId) {
        String location = "put";
        DuccId retVal = this.processToJobMap.put(processId, jobId);
        logger.debug(location, jobId, processId, new Object[]{"size=" + this.processToJobMap.size()});
        return retVal;
    }

    public DuccId remove(DuccId processId) {
        String location = "remove";
        DuccId jobId = this.processToJobMap.get(processId);
        DuccId retVal = this.processToJobMap.remove(processId);
        logger.debug(location, jobId, processId, new Object[]{"size=" + this.processToJobMap.size()});
        return retVal;
    }

    public DuccId get(DuccId key) {
        String location = "get";
        DuccId retVal = this.processToJobMap.get(key);
        logger.debug(location, retVal, key, new Object[]{"size=" + this.processToJobMap.size()});
        return retVal;
    }

    public int size() {
        return this.processToJobMap.size();
    }
}

