/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.SortKeyDefinition;
import net.sf.saxon.sort.SortKeyEvaluator;
import net.sf.saxon.sort.SortedIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;

public class SortExpression
extends Expression
implements SortKeyEvaluator {
    private Expression select = null;
    private SortKeyDefinition[] sortKeyDefinitions = null;
    private transient AtomicComparer[] comparators = null;

    public SortExpression(Expression expression, SortKeyDefinition[] sortKeyDefinitionArray) {
        this.select = expression;
        this.sortKeyDefinitions = sortKeyDefinitionArray;
        Iterator iterator = this.iterateSubExpressions();
        while (iterator.hasNext()) {
            Expression expression2 = (Expression)iterator.next();
            this.adoptChildExpression(expression2);
        }
    }

    public Expression getBaseExpression() {
        return this.select;
    }

    public Iterator iterateSubExpressions() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>(8);
        arrayList.add(this.select);
        for (int i = 0; i < this.sortKeyDefinitions.length; ++i) {
            arrayList.add(this.sortKeyDefinitions[i].getSortKey());
            Expression expression = this.sortKeyDefinitions[i].order;
            if (expression != null) {
                arrayList.add(expression);
            }
            if ((expression = this.sortKeyDefinitions[i].caseOrder) != null) {
                arrayList.add(expression);
            }
            if ((expression = this.sortKeyDefinitions[i].dataTypeExpression) != null) {
                arrayList.add(expression);
            }
            if ((expression = this.sortKeyDefinitions[i].language) != null) {
                arrayList.add(expression);
            }
            if ((expression = this.sortKeyDefinitions[i].collationName) != null) {
                arrayList.add(expression);
            }
            if ((expression = this.sortKeyDefinitions[i].stable) == null) continue;
            arrayList.add(expression);
        }
        return arrayList.iterator();
    }

    public boolean replaceSubExpression(Expression expression, Expression expression2) {
        boolean bl = false;
        if (this.select == expression) {
            this.select = expression2;
            bl = true;
        }
        for (int i = 0; i < this.sortKeyDefinitions.length; ++i) {
            if (this.sortKeyDefinitions[i].getSortKey() == expression) {
                this.sortKeyDefinitions[i].setSortKey(expression2);
                bl = true;
            }
            if (this.sortKeyDefinitions[i].getOrder() == expression) {
                this.sortKeyDefinitions[i].setOrder(expression2);
                bl = true;
            }
            if (this.sortKeyDefinitions[i].getCaseOrder() == expression) {
                this.sortKeyDefinitions[i].setCaseOrder(expression2);
                bl = true;
            }
            if (this.sortKeyDefinitions[i].getDataTypeExpression() == expression) {
                this.sortKeyDefinitions[i].setDataTypeExpression(expression2);
                bl = true;
            }
            if (this.sortKeyDefinitions[i].getLanguage() != expression) continue;
            this.sortKeyDefinitions[i].setLanguage(expression2);
            bl = true;
        }
        return bl;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.select = this.select.simplify(staticContext);
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        int n;
        Expression expression = this.select.typeCheck(staticContext, itemType);
        if (expression != this.select) {
            this.adoptChildExpression(expression);
            this.select = expression;
        }
        ItemType itemType2 = this.select.getItemType(staticContext.getConfiguration().getTypeHierarchy());
        boolean bl = true;
        for (n = 0; n < this.sortKeyDefinitions.length; ++n) {
            this.sortKeyDefinitions[n].setParentExpression(this);
            if (this.sortKeyDefinitions[n].isFixed()) continue;
            bl = false;
        }
        if (bl) {
            this.comparators = new AtomicComparer[this.sortKeyDefinitions.length];
        }
        for (n = 0; n < this.sortKeyDefinitions.length; ++n) {
            Serializable serializable;
            Expression expression2 = this.sortKeyDefinitions[n].getSortKey();
            expression2 = expression2.typeCheck(staticContext, itemType2);
            if (staticContext.isInBackwardsCompatibleMode()) {
                expression2 = new FirstItemExpression(expression2);
            } else {
                serializable = new RoleLocator(4, "xsl:sort/select", 0, null);
                serializable.setErrorCode("XTTE1020");
                expression2 = CardinalityChecker.makeCardinalityChecker(expression2, 24576, serializable);
            }
            this.sortKeyDefinitions[n].setSortKey(expression2);
            if (!this.sortKeyDefinitions[n].isFixed()) continue;
            serializable = this.sortKeyDefinitions[n].makeComparator(staticContext.makeEarlyEvaluationContext());
            this.sortKeyDefinitions[n].setFinalComparator((AtomicComparer)serializable);
            if (!bl) continue;
            this.comparators[n] = serializable;
        }
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        Expression expression = this.select.optimize(optimizer, staticContext, itemType);
        if (expression != this.select) {
            this.adoptChildExpression(expression);
            this.select = expression;
        }
        if (Cardinality.allowsMany(this.select.getCardinality())) {
            return this;
        }
        Expression.setParentExpression(this.select, this.getParentExpression());
        return this.select;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        this.select = this.doPromotion(this.select, promotionOffer);
        for (int i = 0; i < this.sortKeyDefinitions.length; ++i) {
            Expression expression2 = this.sortKeyDefinitions[i].getSortKey().promote(promotionOffer);
            this.sortKeyDefinitions[i].setSortKey(expression2);
            if (this.sortKeyDefinitions[i].caseOrder != null) {
                this.sortKeyDefinitions[i].caseOrder = this.sortKeyDefinitions[i].caseOrder.promote(promotionOffer);
            }
            if (this.sortKeyDefinitions[i].dataTypeExpression != null) {
                this.sortKeyDefinitions[i].dataTypeExpression = this.sortKeyDefinitions[i].dataTypeExpression.promote(promotionOffer);
            }
            if (this.sortKeyDefinitions[i].language != null) {
                this.sortKeyDefinitions[i].language = this.sortKeyDefinitions[i].language.promote(promotionOffer);
            }
            if (this.sortKeyDefinitions[i].collationName == null) continue;
            this.sortKeyDefinitions[i].collationName = this.sortKeyDefinitions[i].collationName.promote(promotionOffer);
        }
        return this;
    }

    public boolean isSortKey(Expression expression) {
        for (int i = 0; i < this.sortKeyDefinitions.length; ++i) {
            Expression expression2 = this.sortKeyDefinitions[i].getSortKey();
            if (expression2 != expression) continue;
            return true;
        }
        return false;
    }

    public int computeCardinality() {
        return this.select.getCardinality();
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return this.select.getItemType(typeHierarchy);
    }

    public int computeSpecialProperties() {
        int n = 0;
        if ((this.select.getSpecialProperties() & 0x10000) != 0) {
            n |= 0x10000;
        }
        if ((this.select.getSpecialProperties() & 0x800000) != 0) {
            n |= 0x800000;
        }
        if ((this.select.getSpecialProperties() & 0x400000) != 0) {
            n |= 0x400000;
        }
        return n;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.select.iterate(xPathContext);
        if (sequenceIterator instanceof EmptyIterator) {
            return sequenceIterator;
        }
        XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
        xPathContextMinor.setOrigin(this);
        AtomicComparer[] atomicComparerArray = this.comparators;
        if (this.comparators == null) {
            atomicComparerArray = new AtomicComparer[this.sortKeyDefinitions.length];
            for (int i = 0; i < this.sortKeyDefinitions.length; ++i) {
                AtomicComparer atomicComparer = this.sortKeyDefinitions[i].getFinalComparator();
                if (atomicComparer == null) {
                    atomicComparer = this.sortKeyDefinitions[i].makeComparator(xPathContextMinor);
                }
                atomicComparerArray[i] = atomicComparer;
            }
        }
        sequenceIterator = new SortedIterator(xPathContextMinor, sequenceIterator, this, atomicComparerArray);
        ((SortedIterator)sequenceIterator).setHostLanguage(this.getHostLanguage());
        return sequenceIterator;
    }

    public Item evaluateSortKey(int n, XPathContext xPathContext) throws XPathException {
        return this.sortKeyDefinitions[n].getSortKey().evaluateItem(xPathContext);
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n) + "sort");
        this.select.display(n + 1, printStream, configuration);
    }
}

