/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.jcas.cas;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.uima.cas.LongArrayFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JCasRegistry;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.cas.TOP_Type;

public final class LongArray
extends TOP
implements LongArrayFS,
Iterable<Long> {
    public static final int typeIndexID;
    public static final int type;

    @Override
    public int getTypeIndexID() {
        return typeIndexID;
    }

    private LongArray() {
    }

    public LongArray(int addr, TOP_Type type) {
        super(addr, type);
    }

    public LongArray(JCas jcas, int length) {
        this(jcas.getLowLevelCas().ll_createLongArray(length), jcas.getType(typeIndexID));
    }

    @Override
    public long get(int i) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, i);
        return this.jcasType.ll_cas.ll_getLongArrayValue(this.addr, i);
    }

    @Override
    public void set(int i, long v) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, i);
        this.jcasType.ll_cas.ll_setLongArrayValue(this.addr, i, v);
    }

    @Override
    public void copyFromArray(long[] src, int srcOffset, int destOffset, int length) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, destOffset, length);
        for (int i = 0; i < length; ++i) {
            this.jcasType.ll_cas.ll_setLongArrayValue(this.addr, i + destOffset, src[i + srcOffset]);
        }
    }

    @Override
    public void copyToArray(int srcOffset, long[] dest, int destOffset, int length) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, srcOffset, length);
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = this.jcasType.ll_cas.ll_getLongArrayValue(this.addr, i + srcOffset);
        }
    }

    @Override
    public long[] toArray() {
        int size = this.size();
        long[] outArray = new long[size];
        this.copyToArray(0, outArray, 0, size);
        return outArray;
    }

    @Override
    public int size() {
        return this.jcasType.casImpl.ll_getArraySize(this.addr);
    }

    @Override
    public void copyToArray(int srcOffset, String[] dest, int destOffset, int length) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, srcOffset, length);
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = Long.toString(this.jcasType.ll_cas.ll_getLongArrayValue(this.addr, i + srcOffset));
        }
    }

    @Override
    public void copyFromArray(String[] src, int srcOffset, int destOffset, int length) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, destOffset, length);
        for (int i = 0; i < length; ++i) {
            this.jcasType.ll_cas.ll_setLongArrayValue(this.addr, i + destOffset, Long.parseLong(src[i + srcOffset]));
        }
    }

    @Override
    public String[] toStringArray() {
        int size = this.size();
        String[] strArray = new String[size];
        this.copyToArray(0, strArray, 0, size);
        return strArray;
    }

    @Override
    public Iterator<Long> iterator() {
        return new Iterator<Long>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < LongArray.this.size();
            }

            @Override
            public Long next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return LongArray.this.get(this.i++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static {
        type = typeIndexID = JCasRegistry.register(LongArray.class);
    }
}

