/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae.spi.transport.vm;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.UIDGenerator;
import org.apache.uima.aae.UimaAsContext;
import org.apache.uima.aae.UimaAsThreadFactory;
import org.apache.uima.aae.controller.AggregateAnalysisEngineController;
import org.apache.uima.aae.controller.AnalysisEngineController;
import org.apache.uima.aae.controller.PrimitiveAnalysisEngineController;
import org.apache.uima.aae.error.UimaSpiException;
import org.apache.uima.aae.spi.transport.SpiListener;
import org.apache.uima.aae.spi.transport.UimaMessageDispatcher;
import org.apache.uima.aae.spi.transport.UimaMessageListener;
import org.apache.uima.aae.spi.transport.UimaTransport;
import org.apache.uima.aae.spi.transport.vm.UimaVmMessage;
import org.apache.uima.aae.spi.transport.vm.UimaVmMessageDispatcher;
import org.apache.uima.aae.spi.transport.vm.UimaVmMessageListener;
import org.apache.uima.aae.spi.transport.vm.UimaVmQueue;
import org.apache.uima.util.Level;

public class VmTransport
implements UimaTransport {
    private static final Class CLASS_NAME = VmTransport.class;
    private List<SpiListener> spiListeners = new ArrayList<SpiListener>();
    private ConcurrentHashMap<String, UimaVmMessageDispatcher> dispatchers = new ConcurrentHashMap();
    private ThreadPoolExecutor executor = null;
    private ThreadGroup threadGroup = null;
    private BlockingQueue<Runnable> workQueue = null;
    private UimaVmMessageDispatcher dispatcher;
    private UimaVmMessageListener listener;
    private AnalysisEngineController controller;
    private UimaAsContext context;
    private AtomicBoolean stopping = new AtomicBoolean(false);

    public VmTransport(UimaAsContext aContext, AnalysisEngineController aController) {
        this.context = aContext;
        UIDGenerator idGenerator = new UIDGenerator();
        this.controller = aController;
        this.threadGroup = new ThreadGroup("VmThreadGroup" + idGenerator.nextId() + "_" + this.controller.getComponentName());
    }

    @Override
    public void addSpiListener(SpiListener listener) {
        this.spiListeners.add(listener);
    }

    @Override
    public UimaVmMessage produceMessage() {
        return new UimaVmMessage();
    }

    @Override
    public UimaVmMessage produceMessage(int aCommand, int aMessageType, String aMessageFrom) {
        UimaVmMessage message = this.produceMessage();
        message.addIntProperty("Command", aCommand);
        message.addIntProperty("MessageType", aMessageType);
        switch (aCommand) {
            case 2001: {
                message.addIntProperty("Payload", 1002);
                break;
            }
            case 2002: {
                message.addIntProperty("Payload", 1005);
                break;
            }
            case 2000: {
                message.addIntProperty("Payload", 1001);
            }
        }
        message.addStringProperty("MessageFrom", aMessageFrom);
        message.addStringProperty("ServerURI", "vm://localhost");
        return message;
    }

    @Override
    public void startIt() throws UimaSpiException {
        this.dispatcher = new UimaVmMessageDispatcher(this.executor, null, (String)this.context.get("EndpointName"));
    }

    @Override
    public synchronized void stopIt() throws UimaSpiException {
        if (this.stopping.get()) {
            return;
        }
        this.stopping.set(true);
        this.executor.purge();
        this.executor.shutdownNow();
        this.workQueue.clear();
        Set<Map.Entry<String, UimaVmMessageDispatcher>> set = this.dispatchers.entrySet();
        for (Map.Entry<String, UimaVmMessageDispatcher> entry : set) {
            UimaVmMessageDispatcher dispatcher = entry.getValue();
            dispatcher.stop();
        }
    }

    public void destroy() {
        try {
            this.stopIt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected ThreadPoolExecutor getExecutorInstance() {
        if (this.executor == null) {
            int concurrentConsumerCount = this.context.getConcurrentConsumerCount();
            this.workQueue = new UimaVmQueue();
            this.executor = new ThreadPoolExecutor(concurrentConsumerCount, concurrentConsumerCount, Long.MAX_VALUE, TimeUnit.NANOSECONDS, this.workQueue);
            UimaAsThreadFactory tf = null;
            tf = this.controller instanceof PrimitiveAnalysisEngineController ? new UimaAsThreadFactory(this.threadGroup, (PrimitiveAnalysisEngineController)this.controller) : new UimaAsThreadFactory(this.threadGroup, null);
            tf.setDaemon(true);
            this.executor.setThreadFactory(tf);
            this.executor.prestartAllCoreThreads();
        }
        return this.executor;
    }

    @Override
    public void registerWithJMX(AnalysisEngineController aController, String queueKind) {
        block3: {
            try {
                ((UimaVmQueue)this.workQueue).setConsumerCount(this.context.getConcurrentConsumerCount());
                aController.registerVmQueueWithJMX(this.workQueue, queueKind);
            }
            catch (Exception e) {
                if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block3;
                if (this.controller != null) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "registerWithJMX", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.controller.getComponentName());
                }
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "registerWithJMX", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
            }
        }
    }

    public UimaMessageDispatcher getMessageDispatcher() throws UimaSpiException {
        return this.dispatcher;
    }

    @Override
    public UimaMessageListener getUimaMessageListener() {
        return this.listener;
    }

    @Override
    public UimaMessageListener produceUimaMessageListener() throws UimaSpiException {
        this.listener = new UimaVmMessageListener(this.controller);
        return this.listener;
    }

    @Override
    public UimaMessageDispatcher getUimaMessageDispatcher() throws UimaSpiException {
        return this.getUimaMessageDispatcher(this.controller.getName());
    }

    @Override
    public UimaMessageDispatcher getUimaMessageDispatcher(String aKey) throws UimaSpiException {
        return this.dispatchers.get(aKey);
    }

    @Override
    public UimaVmMessageDispatcher produceUimaMessageDispatcher(UimaTransport aTransport) throws UimaSpiException {
        UimaVmMessageDispatcher dispatcher = null;
        String endpointName = (String)this.context.get("EndpointName");
        if (!this.controller.isTopLevelComponent()) {
            endpointName = this.controller.getParentController().getName();
        }
        dispatcher = new UimaVmMessageDispatcher(((VmTransport)aTransport).getExecutorInstance(), ((VmTransport)aTransport).getUimaMessageListener(), endpointName);
        if (this.controller instanceof AggregateAnalysisEngineController || ((VmTransport)aTransport).controller instanceof AggregateAnalysisEngineController) {
            this.dispatchers.put(((VmTransport)aTransport).controller.getName(), dispatcher);
        } else {
            this.dispatchers.put(this.controller.getName(), dispatcher);
        }
        return dispatcher;
    }
}

