/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.visitor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaElement;
import org.apache.uima.ruta.RutaModule;
import org.apache.uima.ruta.RutaStatement;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.ScriptApply;
import org.apache.uima.ruta.block.BlockApply;
import org.apache.uima.ruta.block.RutaBlock;
import org.apache.uima.ruta.rule.AbstractRule;
import org.apache.uima.ruta.rule.AbstractRuleMatch;
import org.apache.uima.ruta.rule.RuleApply;
import org.apache.uima.ruta.rule.RutaRule;
import org.apache.uima.ruta.type.DebugScriptApply;
import org.apache.uima.ruta.verbalize.RutaVerbalizer;
import org.apache.uima.ruta.visitor.DebugInfoFactory;
import org.apache.uima.ruta.visitor.RutaInferenceVisitor;
import org.apache.uima.ruta.visitor.TimeProfilerVisitor;

public class DebugInfoCollectorVisitor
implements RutaInferenceVisitor {
    private boolean createDebugInfo;
    private List<String> ids;
    private DebugInfoFactory debugFactory;
    private boolean withMatches;
    private boolean addToIndexes;
    private ScriptApply rootApply;
    private Map<RutaStatement, Stack<ScriptApply>> applies;
    private Stack<RutaElement> callStack;

    public DebugInfoCollectorVisitor(boolean createDebugInfo, boolean withMatches, boolean addToIndexes, List<String> ids, RutaVerbalizer verbalizer) {
        this.createDebugInfo = createDebugInfo;
        this.withMatches = withMatches;
        this.addToIndexes = addToIndexes;
        this.ids = ids;
        this.debugFactory = new DebugInfoFactory(verbalizer);
        this.applies = new HashMap<RutaStatement, Stack<ScriptApply>>();
        this.callStack = new Stack();
    }

    public DebugInfoCollectorVisitor(boolean createDebugInfo, boolean withMatches, List<String> ids, RutaVerbalizer verbalizer) {
        this(createDebugInfo, withMatches, false, ids, verbalizer);
    }

    public boolean isCreateDebugInfo() {
        return this.createDebugInfo;
    }

    public boolean createDebugInfo(RutaRule rule) {
        return this.createDebugInfo || this.ids.contains(String.valueOf(rule.getId()));
    }

    @Override
    public void beginVisit(RutaElement element, ScriptApply result) {
        if (element instanceof RutaStatement) {
            this.callStack.push(element);
            RutaStatement stmt = (RutaStatement)element;
            Stack<ScriptApply> stack = this.applies.get(stmt);
            if (stack == null) {
                stack = new Stack();
                this.applies.put(stmt, stack);
            }
            stack.push(result);
            this.applies.put(stmt, stack);
            if (result instanceof RuleApply) {
                RuleApply ra;
                ra.setAcceptMatches((ra = (RuleApply)result).isAcceptMatches() || this.withMatches);
            }
        }
    }

    @Override
    public void endVisit(RutaElement element, ScriptApply result) {
        if (element instanceof RutaStatement) {
            ScriptApply parentApply;
            Stack<ScriptApply> parentStack;
            RutaStatement stmt = (RutaStatement)element;
            RutaBlock parent = stmt.getParent();
            Stack<ScriptApply> stack = this.applies.get(stmt);
            if (stack == null) {
                stack = new Stack();
                this.applies.put(stmt, stack);
            }
            if (!stack.isEmpty()) {
                stack.pop();
            }
            stack.push(result);
            this.applies.put(stmt, stack);
            if (parent != null && (parentStack = this.applies.get(parent)) != null && !parentStack.isEmpty() && (parentApply = parentStack.peek()) instanceof BlockApply) {
                BlockApply blockApply = (BlockApply)parentApply;
                if (element instanceof RutaRule && parent.getRule().equals(element) && result instanceof RuleApply) {
                    blockApply.setRuleApply((RuleApply)result);
                } else if (stack.size() == 1) {
                    if (this.callStack.size() > 1) {
                        RutaElement tme = (RutaElement)this.callStack.get(this.callStack.size() - 2);
                        if (tme.equals(parent)) {
                            blockApply.add(result);
                        }
                    } else {
                        blockApply.add(result);
                    }
                } else {
                    RutaElement tme = (RutaElement)this.callStack.get(this.callStack.size() - 2);
                    if (tme.equals(parent)) {
                        blockApply.add(result);
                    }
                }
            }
            stack.pop();
            this.callStack.pop();
        }
        if (element instanceof RutaModule) {
            this.rootApply = result;
        }
    }

    @Override
    public void finished(RutaStream stream, List<RutaInferenceVisitor> visitors) {
        if (this.createDebugInfo) {
            Map<RutaElement, Long> timeInfo = this.getTimeInfo(visitors);
            DebugScriptApply debugScriptApply = this.debugFactory.createDebugScriptApply(this.rootApply, stream, this.addToIndexes, this.withMatches, timeInfo);
            debugScriptApply.setTimestamp(System.currentTimeMillis());
            debugScriptApply.addToIndexes();
        }
    }

    private Map<RutaElement, Long> getTimeInfo(List<RutaInferenceVisitor> visitors) {
        for (RutaInferenceVisitor each : visitors) {
            if (!(each instanceof TimeProfilerVisitor)) continue;
            return ((TimeProfilerVisitor)each).getTimeInfo();
        }
        return null;
    }

    @Override
    public void annotationAdded(AnnotationFS annotation, AbstractRuleMatch<? extends AbstractRule> creator) {
    }
}

