/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.engine;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UimaContext;
import org.apache.uima.UimaContextAdmin;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.internal.ResourceManagerFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.ruta.FilterManager;
import org.apache.uima.ruta.ReindexUpdateMode;
import org.apache.uima.ruta.RutaBasicUtils;
import org.apache.uima.ruta.RutaEnvironment;
import org.apache.uima.ruta.RutaIndexingConfiguration;
import org.apache.uima.ruta.RutaModule;
import org.apache.uima.ruta.RutaScriptFactory;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.TypeUsageInformation;
import org.apache.uima.ruta.action.ActionFactory;
import org.apache.uima.ruta.block.RutaBlock;
import org.apache.uima.ruta.condition.ConditionFactory;
import org.apache.uima.ruta.engine.Ruta;
import org.apache.uima.ruta.expression.ExpressionFactory;
import org.apache.uima.ruta.extensions.IRutaExtension;
import org.apache.uima.ruta.extensions.RutaExternalFactory;
import org.apache.uima.ruta.parser.RutaLexer;
import org.apache.uima.ruta.parser.RutaParser;
import org.apache.uima.ruta.resource.RutaResourceLoader;
import org.apache.uima.ruta.seed.RutaAnnotationSeeder;
import org.apache.uima.ruta.type.RutaBasic;
import org.apache.uima.ruta.type.TokenSeed;
import org.apache.uima.ruta.verbalize.RutaVerbalizer;
import org.apache.uima.ruta.visitor.CreatedByVisitor;
import org.apache.uima.ruta.visitor.DebugInfoCollectorVisitor;
import org.apache.uima.ruta.visitor.InferenceCrowd;
import org.apache.uima.ruta.visitor.RutaInferenceVisitor;
import org.apache.uima.ruta.visitor.StatisticsVisitor;
import org.apache.uima.ruta.visitor.TimeProfilerVisitor;
import org.apache.uima.util.Level;
import org.springframework.core.io.Resource;

public class RutaEngine
extends JCasAnnotator_ImplBase {
    public static final String SCRIPT_FILE_EXTENSION = ".ruta";
    public static final String SEPARATOR_VAR_VALUES = ",";
    public static final String SOURCE_DOCUMENT_INFORMATION = "org.apache.uima.examples.SourceDocumentInformation";
    public static final String BASIC_TYPE = "org.apache.uima.ruta.type.RutaBasic";
    public static final String OPTIONAL_TYPE = "org.apache.uima.ruta.type.RutaOptional";
    public static final String FRAME_TYPE = "org.apache.uima.ruta.type.RutaFrame";
    public static final String PARAM_RULES = "rules";
    @ConfigurationParameter(name="rules", mandatory=false)
    private String rules;
    public static final String PARAM_RULES_SCRIPT_NAME = "rulesScriptName";
    @ConfigurationParameter(name="rulesScriptName", mandatory=true, defaultValue={"Anonymous"})
    private String rulesScriptName;
    public static final String PARAM_MAIN_SCRIPT = "mainScript";
    @ConfigurationParameter(name="mainScript", mandatory=false)
    private String mainScript;
    public static final String PARAM_SCRIPT_ENCODING = "scriptEncoding";
    @ConfigurationParameter(name="scriptEncoding", mandatory=false, defaultValue={"UTF-8"})
    private String scriptEncoding;
    public static final String PARAM_SCRIPT_PATHS = "scriptPaths";
    @ConfigurationParameter(name="scriptPaths", mandatory=false)
    private String[] scriptPaths;
    public static final String PARAM_DESCRIPTOR_PATHS = "descriptorPaths";
    @ConfigurationParameter(name="descriptorPaths", mandatory=false, defaultValue={})
    private String[] descriptorPaths;
    public static final String PARAM_RESOURCE_PATHS = "resourcePaths";
    @ConfigurationParameter(name="resourcePaths", mandatory=false, defaultValue={})
    private String[] resourcePaths;
    public static final String PARAM_ADDITIONAL_SCRIPTS = "additionalScripts";
    @ConfigurationParameter(name="additionalScripts", mandatory=false, defaultValue={})
    private String[] additionalScripts;
    public static final String PARAM_ADDITIONAL_ENGINES = "additionalEngines";
    @ConfigurationParameter(name="additionalEngines", mandatory=false, defaultValue={})
    private String[] additionalEngines;
    public static final String PARAM_ADDITIONAL_UIMAFIT_ENGINES = "additionalUimafitEngines";
    @ConfigurationParameter(name="additionalUimafitEngines", mandatory=false, defaultValue={})
    private String[] additionalUimafitEngines;
    public static final String PARAM_ADDITIONAL_EXTENSIONS = "additionalExtensions";
    @ConfigurationParameter(name="additionalExtensions", mandatory=false, defaultValue={})
    private String[] additionalExtensions;
    public static final String PARAM_RELOAD_SCRIPT = "reloadScript";
    @ConfigurationParameter(name="reloadScript", mandatory=false, defaultValue={"false"})
    private Boolean reloadScript;
    public static final String PARAM_SEEDERS = "seeders";
    @ConfigurationParameter(name="seeders", mandatory=false, defaultValue={"org.apache.uima.ruta.seed.TextSeeder"})
    private String[] seeders;
    public static final String PARAM_DEFAULT_FILTERED_TYPES = "defaultFilteredTypes";
    @ConfigurationParameter(name="defaultFilteredTypes", mandatory=false, defaultValue={"org.apache.uima.ruta.type.SPACE", "org.apache.uima.ruta.type.BREAK", "org.apache.uima.ruta.type.MARKUP"})
    private String[] defaultFilteredTypes;
    public static final String PARAM_REMOVE_BASICS = "removeBasics";
    @ConfigurationParameter(name="removeBasics", mandatory=false, defaultValue={"false"})
    private Boolean removeBasics;
    public static final String PARAM_DYNAMIC_ANCHORING = "dynamicAnchoring";
    @ConfigurationParameter(name="dynamicAnchoring", mandatory=false, defaultValue={"false"})
    private Boolean dynamicAnchoring;
    public static final String PARAM_LOW_MEMORY_PROFILE = "lowMemoryProfile";
    @ConfigurationParameter(name="lowMemoryProfile", mandatory=false, defaultValue={"false"})
    private Boolean lowMemoryProfile;
    public static final String PARAM_SIMPLE_GREEDY_FOR_COMPOSED = "simpleGreedyForComposed";
    @ConfigurationParameter(name="simpleGreedyForComposed", mandatory=false, defaultValue={"false"})
    private Boolean simpleGreedyForComposed;
    public static final String PARAM_GREEDY_RULE_ELEMENT = "greedyRuleElement";
    @ConfigurationParameter(name="greedyRuleElement", mandatory=false, defaultValue={"false"})
    private Boolean greedyRuleElement = false;
    public static final String PARAM_GREEDY_RULE = "greedyRule";
    @ConfigurationParameter(name="greedyRule", mandatory=false, defaultValue={"false"})
    private Boolean greedyRule = false;
    public static final String PARAM_DEBUG = "debug";
    @ConfigurationParameter(name="debug", mandatory=false, defaultValue={"false"})
    private Boolean debug;
    public static final String PARAM_DEBUG_WITH_MATCHES = "debugWithMatches";
    @ConfigurationParameter(name="debugWithMatches", mandatory=false, defaultValue={"false"})
    private Boolean debugWithMatches;
    public static final String PARAM_DEBUG_ADD_TO_INDEXES = "debugAddToIndexes";
    @ConfigurationParameter(name="debugAddToIndexes", mandatory=false, defaultValue={"false"})
    private Boolean debugAddToIndexes;
    public static final String PARAM_DEBUG_ONLY_FOR = "debugOnlyFor";
    @ConfigurationParameter(name="debugOnlyFor", mandatory=false, defaultValue={})
    private String[] debugOnlyFor;
    public static final String PARAM_PROFILE = "profile";
    @ConfigurationParameter(name="profile", mandatory=false, defaultValue={"false"})
    private Boolean profile;
    public static final String PARAM_STATISTICS = "statistics";
    @ConfigurationParameter(name="statistics", mandatory=false, defaultValue={"false"})
    private Boolean statistics;
    public static final String PARAM_CREATED_BY = "createdBy";
    @ConfigurationParameter(name="createdBy", mandatory=false, defaultValue={"false"})
    private Boolean createdBy;
    public static final String PARAM_STRICT_IMPORTS = "strictImports";
    @ConfigurationParameter(name="strictImports", mandatory=false, defaultValue={"false"})
    private Boolean strictImports = false;
    public static final String PARAM_TYPE_IGNORE_PATTERN = "typeIgnorePattern";
    @ConfigurationParameter(name="typeIgnorePattern", mandatory=false)
    private Pattern typeIgnorePattern;
    public static final String PARAM_DICT_REMOVE_WS = "dictRemoveWS";
    @ConfigurationParameter(name="dictRemoveWS", mandatory=false, defaultValue={"true"})
    private Boolean dictRemoveWS = true;
    public static final String PARAM_CSV_SEPARATOR = "csvSeparator";
    @ConfigurationParameter(name="csvSeparator", mandatory=false, defaultValue={";"})
    private String csvSeparator = ";";
    public static final String PARAM_VAR_NAMES = "varNames";
    @ConfigurationParameter(name="varNames", mandatory=false, defaultValue={})
    private String[] varNames;
    public static final String PARAM_VAR_VALUES = "varValues";
    @ConfigurationParameter(name="varValues", mandatory=false, defaultValue={})
    private String[] varValues;
    public static final String PARAM_INDEX_ONLY = "indexOnly";
    @ConfigurationParameter(name="indexOnly", mandatory=false, defaultValue={"uima.tcas.Annotation"})
    private String[] indexOnly;
    public static final String PARAM_REINDEX_ONLY = "reindexOnly";
    @ConfigurationParameter(name="reindexOnly", mandatory=false, defaultValue={"uima.tcas.Annotation"})
    private String[] reindexOnly;
    public static final String PARAM_INDEX_ONLY_MENTIONED_TYPES = "indexOnlyMentionedTypes";
    @ConfigurationParameter(name="indexOnlyMentionedTypes", mandatory=true, defaultValue={"false"})
    private boolean indexOnlyMentionedTypes;
    public static final String PARAM_REINDEX_ONLY_MENTIONED_TYPES = "reindexOnlyMentionedTypes";
    @ConfigurationParameter(name="reindexOnlyMentionedTypes", mandatory=true, defaultValue={"false"})
    private boolean reindexOnlyMentionedTypes;
    public static final String PARAM_INDEX_SKIP_TYPES = "indexSkipTypes";
    @ConfigurationParameter(name="indexSkipTypes", mandatory=true, defaultValue={})
    private String[] indexSkipTypes;
    public static final String PARAM_REINDEX_SKIP_TYPES = "reindexSkipTypes";
    @ConfigurationParameter(name="reindexSkipTypes", mandatory=true, defaultValue={})
    private String[] reindexSkipTypes;
    public static final String PARAM_INDEX_ADDITONALLY = "indexAdditionally";
    @ConfigurationParameter(name="indexAdditionally", mandatory=false, defaultValue={})
    private String[] indexAdditionally;
    public static final String PARAM_REINDEX_ADDITONALLY = "reindexAdditionally";
    @ConfigurationParameter(name="reindexAdditionally", mandatory=false, defaultValue={})
    private String[] reindexAdditionally;
    public static final String PARAM_REINDEX_UPDATE_MODE = "reindexUpdateMode";
    @ConfigurationParameter(name="reindexUpdateMode", mandatory=true, defaultValue={"ADDITIVE"})
    private ReindexUpdateMode reindexUpdateMode;
    public static final String PARAM_VALIDATE_INTERNAL_INDEXING = "validateInternalIndexing";
    @ConfigurationParameter(name="validateInternalIndexing", mandatory=true, defaultValue={"false"})
    private boolean validateInternalIndexing;
    public static final String PARAM_EMPTY_IS_INVISIBLE = "emptyIsInvisible";
    @ConfigurationParameter(name="emptyIsInvisible", mandatory=false, defaultValue={"true"})
    private boolean emptyIsInvisible;
    public static final String PARAM_MODIFY_DATAPATH = "modifyDataPath";
    @ConfigurationParameter(name="modifyDataPath", mandatory=false, defaultValue={"false"})
    private boolean modifyDataPath;
    public static final String PARAM_INFERENCE_VISITORS = "inferenceVisitors";
    @ConfigurationParameter(name="inferenceVisitors", mandatory=false, defaultValue={})
    private String[] inferenceVisitors;
    public static final String PARAM_MAX_RULE_MATCHES = "maxRuleMatches";
    @ConfigurationParameter(name="maxRuleMatches", mandatory=false, defaultValue={"2147483647"})
    private int maxRuleMatches;
    public static final String PARAM_MAX_RULE_ELEMENT_MATCHES = "maxRuleElementMatches";
    @ConfigurationParameter(name="maxRuleElementMatches", mandatory=false, defaultValue={"2147483647"})
    private int maxRuleElementMatches;
    private UimaContext context;
    private RutaModule script;
    private RutaExternalFactory externalFactory;
    private RutaVerbalizer verbalizer;
    private boolean initialized = false;
    private boolean analysisEnginesAlreadyInitialized = false;
    private List<Type> seedTypes;
    private TypeUsageInformation typeUsageInformation;
    private TypeSystem lastTypeSystem;
    private ResourceManager resourceManager = null;
    private RutaResourceLoader scriptRutaResourceLoader;
    private RutaResourceLoader descriptorRutaResourceLoader;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        if (aContext == null && this.context != null) {
            aContext = this.context;
        }
        this.context = aContext;
        this.externalFactory = new RutaExternalFactory();
        this.externalFactory.setContext(aContext);
        this.verbalizer = new RutaVerbalizer();
        this.analysisEnginesAlreadyInitialized = false;
        this.initializeResourceManager();
        this.handleDataPath();
        this.scriptRutaResourceLoader = new RutaResourceLoader(this.scriptPaths, this.resourceManager.getExtensionClassLoader());
        this.descriptorRutaResourceLoader = new RutaResourceLoader(this.descriptorPaths, this.resourceManager.getExtensionClassLoader());
        if (!this.externalFactory.isInitialized()) {
            this.initializeExtensionWithClassPath();
        }
        if (!this.reloadScript.booleanValue()) {
            try {
                this.initializeScript("_InitialView");
                this.initialized = false;
            }
            catch (AnalysisEngineProcessException e) {
                throw new ResourceInitializationException((Throwable)e);
            }
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        boolean typeSystemChanged;
        CAS cas = jcas.getCas();
        if (this.reloadScript.booleanValue() || !this.initialized && !cas.getViewName().equals("_InitialView")) {
            this.initializeScript(cas.getViewName());
        } else {
            this.resetEnvironments(cas);
            this.initializeVariableValues();
        }
        boolean bl = typeSystemChanged = this.lastTypeSystem != cas.getTypeSystem();
        if (!this.initialized || this.reloadScript.booleanValue() || typeSystemChanged) {
            this.initializeTypes(this.script, cas, new ArrayList<String>());
            if (this.typeUsageInformation != null) {
                this.typeUsageInformation.resolveTypes(this.script, cas.getTypeSystem());
            }
            this.initialized = true;
            this.lastTypeSystem = cas.getTypeSystem();
        }
        InferenceCrowd crowd = this.initializeCrowd();
        RutaStream stream = this.initializeStream(cas, crowd);
        stream.setDynamicAnchoring(this.dynamicAnchoring);
        stream.setGreedyRuleElement(this.greedyRuleElement);
        stream.setGreedyRule(this.greedyRule);
        stream.setMaxRuleMatches(this.maxRuleMatches);
        stream.setMaxRuleElementMatches(this.maxRuleElementMatches);
        if (this.validateInternalIndexing) {
            ArrayList<String> ignoreTypeNames = new ArrayList<String>();
            ignoreTypeNames.addAll(Arrays.asList(this.indexSkipTypes));
            ignoreTypeNames.addAll(Arrays.asList(this.reindexSkipTypes));
            RutaBasicUtils.validateInternalIndexing(jcas, ignoreTypeNames);
        }
        try {
            this.script.apply(stream, crowd);
        }
        catch (Throwable e) {
            throw new AnalysisEngineProcessException("annotator_exception", new Object[0], e);
        }
        crowd.finished(stream);
        if (this.removeBasics.booleanValue()) {
            jcas.removeAllIncludingSubtypes(RutaBasic.type);
            jcas.removeAllIncludingSubtypes(TokenSeed.type);
            ArrayList<AnnotationFS> toRemove = new ArrayList<AnnotationFS>();
            for (Type seedType : this.seedTypes) {
                AnnotationIndex seedIndex = cas.getAnnotationIndex(seedType);
                for (AnnotationFS fs : seedIndex) {
                    toRemove.add(fs);
                }
            }
            for (AnnotationFS annotationFS : toRemove) {
                cas.removeFsFromIndexes((FeatureStructure)annotationFS);
            }
        }
    }

    private void initializeResourceManager() throws ResourceInitializationException {
        UimaContextAdmin uca;
        ResourceManager rm;
        if (this.context instanceof UimaContextAdmin && (rm = (uca = (UimaContextAdmin)this.context).getResourceManager()) != null) {
            this.resourceManager = rm;
        }
        if (this.resourceManager == null) {
            this.resourceManager = ResourceManagerFactory.newResourceManager();
        }
    }

    private void handleDataPath() throws ResourceInitializationException {
        String dataPath = this.context.getDataPath();
        Object[] singleDataPaths = dataPath.split(File.pathSeparator);
        String[] clonedDescriptorPath = null;
        if (this.descriptorPaths != null) {
            clonedDescriptorPath = (String[])this.descriptorPaths.clone();
        }
        if (!StringUtils.isBlank((CharSequence)dataPath)) {
            this.scriptPaths = (String[])ArrayUtils.addAll((Object[])this.scriptPaths, (Object[])singleDataPaths);
            this.descriptorPaths = (String[])ArrayUtils.addAll((Object[])this.descriptorPaths, (Object[])singleDataPaths);
            this.resourcePaths = (String[])ArrayUtils.addAll((Object[])this.resourcePaths, (Object[])singleDataPaths);
        }
        if (this.modifyDataPath && clonedDescriptorPath != null) {
            if (!dataPath.endsWith(File.pathSeparator)) {
                dataPath = dataPath + File.pathSeparator;
            }
            for (String path : clonedDescriptorPath) {
                dataPath = dataPath + path + File.pathSeparator;
            }
            try {
                this.resourceManager.setDataPath(dataPath);
            }
            catch (MalformedURLException e) {
                throw new ResourceInitializationException((Throwable)e);
            }
        }
    }

    private void resetEnvironments(CAS cas) {
        this.resetEnvironment(this.script, cas, new HashSet<RutaModule>());
    }

    private void resetEnvironment(RutaModule module, CAS cas, Collection<RutaModule> alreadyResetted) {
        if (alreadyResetted.contains(module)) {
            return;
        }
        alreadyResetted.add(module);
        RutaBlock block = module.getBlock(null);
        block.getEnvironment().reset(cas);
        Collection<RutaBlock> blocks = module.getBlocks().values();
        for (RutaBlock each : blocks) {
            each.getEnvironment().reset(cas);
        }
        Collection<RutaModule> scripts = module.getScripts().values();
        for (RutaModule eachModule : scripts) {
            this.resetEnvironment(eachModule, cas, alreadyResetted);
        }
    }

    private void initializeTypes(RutaModule script, CAS cas, List<String> initialized) {
        RutaBlock mainRootBlock = script.getBlock(null);
        mainRootBlock.getEnvironment().setResourceManager(this.resourceManager);
        Set<Map.Entry<String, RutaModule>> values = script.getScripts().entrySet();
        for (Map.Entry entry : values) {
            String name = (String)entry.getKey();
            if (initialized.contains(name)) continue;
            RutaModule eachModule = (RutaModule)entry.getValue();
            this.relinkEnvironments(eachModule, mainRootBlock, new ArrayList<RutaModule>());
            this.initializeTypes(eachModule, cas, initialized);
            initialized.add(name);
        }
        mainRootBlock.getEnvironment().setTypeIgnorePattern(this.typeIgnorePattern);
        mainRootBlock.getEnvironment().initializeTypes(cas, this.strictImports);
    }

    private void relinkEnvironments(RutaModule script, RutaBlock mainRootBlock, Collection<RutaModule> processed) {
        if (!processed.contains(script)) {
            processed.add(script);
            RutaBlock block = script.getBlock(null);
            block.setParent(mainRootBlock);
            Collection<RutaModule> innerScripts = script.getScripts().values();
            for (RutaModule module : innerScripts) {
                this.relinkEnvironments(module, mainRootBlock, processed);
            }
        }
    }

    private void initializeExtensionWithClassPath() {
        if (this.additionalExtensions == null) {
            return;
        }
        for (String each : this.additionalExtensions) {
            try {
                Class forName = this.loadClass(each);
                if (!IRutaExtension.class.isAssignableFrom(forName)) continue;
                IRutaExtension extension = (IRutaExtension)forName.newInstance();
                this.verbalizer.addExternalVerbalizers(extension);
                for (String name : extension.getKnownExtensions()) {
                    this.externalFactory.addExtension(name, extension);
                }
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "Failed to initialize extension " + each);
            }
        }
    }

    private InferenceCrowd initializeCrowd() {
        ArrayList<RutaInferenceVisitor> visitors = new ArrayList<RutaInferenceVisitor>();
        if (this.debug.booleanValue()) {
            visitors.add(new DebugInfoCollectorVisitor(this.debug, this.debugWithMatches, this.debugAddToIndexes, Arrays.asList(this.debugOnlyFor), this.verbalizer));
        }
        if (this.profile.booleanValue()) {
            visitors.add(new TimeProfilerVisitor());
        }
        if (this.statistics.booleanValue()) {
            visitors.add(new StatisticsVisitor(this.verbalizer));
        }
        if (this.createdBy.booleanValue()) {
            visitors.add(new CreatedByVisitor(this.verbalizer));
        }
        if (this.inferenceVisitors != null && this.inferenceVisitors.length != 0) {
            for (String eachClassName : this.inferenceVisitors) {
                try {
                    Class forName = this.loadClass(eachClassName);
                    if (!RutaInferenceVisitor.class.isAssignableFrom(forName)) continue;
                    RutaInferenceVisitor visitor = (RutaInferenceVisitor)forName.newInstance();
                    visitors.add(visitor);
                }
                catch (Exception e) {
                    this.getLogger().log(Level.WARNING, "Failed to initialize inference visitor " + eachClassName);
                }
            }
        }
        return new InferenceCrowd(visitors);
    }

    private RutaStream initializeStream(CAS cas, InferenceCrowd crowd) throws AnalysisEngineProcessException {
        ArrayList<Type> filterTypes = new ArrayList<Type>();
        TypeSystem typeSystem = cas.getTypeSystem();
        for (String each : this.defaultFilteredTypes) {
            Type type = typeSystem.getType(each);
            if (type == null) continue;
            filterTypes.add(type);
        }
        FilterManager filter = new FilterManager(filterTypes, this.typeUsageInformation == null, cas);
        Type basicType = typeSystem.getType(BASIC_TYPE);
        this.seedTypes = this.seedAnnotations(cas);
        RutaStream stream = new RutaStream(cas, basicType, filter, this.lowMemoryProfile, this.simpleGreedyForComposed, this.emptyIsInvisible, this.typeUsageInformation, crowd);
        stream.initalizeBasics(this.createRutaIndexingConfiguration());
        return stream;
    }

    private RutaIndexingConfiguration createRutaIndexingConfiguration() {
        RutaIndexingConfiguration indexingConfig = new RutaIndexingConfiguration();
        indexingConfig.setIndexOnly(this.indexOnly);
        indexingConfig.setIndexSkipTypes(this.indexSkipTypes);
        indexingConfig.setIndexOnlyMentionedTypes(this.indexOnlyMentionedTypes);
        indexingConfig.setIndexAdditionally(this.indexAdditionally);
        indexingConfig.setReindexOnly(this.reindexOnly);
        indexingConfig.setReindexSkipTypes(this.reindexSkipTypes);
        indexingConfig.setReindexOnlyMentionedTypes(this.reindexOnlyMentionedTypes);
        indexingConfig.setReindexAdditionally(this.reindexAdditionally);
        indexingConfig.setReindexUpdateMode(this.reindexUpdateMode);
        return indexingConfig;
    }

    private List<Type> seedAnnotations(CAS cas) throws AnalysisEngineProcessException {
        ArrayList<Type> result = new ArrayList<Type>();
        if (this.seeders != null) {
            for (String seederClass : this.seeders) {
                Class loadClass = null;
                try {
                    loadClass = this.loadClass(seederClass);
                }
                catch (ClassNotFoundException e) {
                    throw new AnalysisEngineProcessException((Throwable)e);
                }
                Object newInstance = null;
                try {
                    newInstance = loadClass.newInstance();
                }
                catch (Exception e) {
                    throw new AnalysisEngineProcessException((Throwable)e);
                }
                try {
                    RutaAnnotationSeeder seeder = newInstance;
                    result.add(seeder.seed(cas.getDocumentText(), cas));
                }
                catch (Exception e) {
                    throw new AnalysisEngineProcessException((Throwable)e);
                }
            }
        }
        return result;
    }

    private void initializeScript(String viewName) throws AnalysisEngineProcessException {
        if (this.rules != null) {
            try {
                this.script = this.loadScriptByString(this.rules);
            }
            catch (RecognitionException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
        }
        if (this.mainScript != null) {
            Resource scriptResource = this.scriptRutaResourceLoader.getResourceWithDotNotation(this.mainScript, SCRIPT_FILE_EXTENSION);
            if (scriptResource == null || !scriptResource.exists()) {
                throw new AnalysisEngineProcessException((Throwable)new FileNotFoundException("Script [" + this.mainScript + "] cannot be found at [" + StringUtils.join((Object[])this.scriptPaths, (char)File.pathSeparatorChar) + "] or classpath with extension " + SCRIPT_FILE_EXTENSION));
            }
            try {
                this.script = this.loadScript(scriptResource, this.getModuleName(this.mainScript));
            }
            catch (IOException | RecognitionException e) {
                throw new AnalysisEngineProcessException(e);
            }
        }
        if (this.script == null) {
            return;
        }
        HashMap<String, RutaModule> additionalScriptMap = new HashMap<String, RutaModule>();
        HashMap<String, AnalysisEngine> additionalUimafitEngineMap = new HashMap<String, AnalysisEngine>();
        HashMap<String, AnalysisEngine> additionalDescriptorEngineMap = new HashMap<String, AnalysisEngine>();
        String[] stringArray = this.additionalUimafitEngines;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String each;
            String classString = each = stringArray[i];
            ArrayList<String> configurationData = new ArrayList();
            String[] split = each.split("[\\[\\]]");
            if (split.length == 2) {
                classString = split[0];
                configurationData = Arrays.asList(StringUtils.split((String)split[1], (String)SEPARATOR_VAR_VALUES));
            }
            this.script.addUimafitEngine(classString, null);
            if (configurationData.isEmpty()) continue;
            this.script.addConfigurationData(classString, configurationData);
        }
        for (String each : this.additionalEngines) {
            this.script.addDescriptorEngine(each, null);
        }
        for (String each : this.additionalScripts) {
            this.script.addScript(each, null);
        }
        this.initializeEngines(this.script, viewName, additionalUimafitEngineMap, additionalDescriptorEngineMap);
        for (String add : this.script.getScripts().keySet()) {
            this.recursiveLoadScript(add, additionalScriptMap, additionalDescriptorEngineMap, additionalUimafitEngineMap, viewName);
        }
        this.analysisEnginesAlreadyInitialized = true;
        for (RutaModule each : additionalScriptMap.values()) {
            each.setScriptDependencies(additionalScriptMap);
        }
        this.script.setScriptDependencies(additionalScriptMap);
        for (RutaModule each : additionalScriptMap.values()) {
            each.setDescriptorEngineDependencies(additionalDescriptorEngineMap);
            each.setUimafitEngineDependencies(additionalUimafitEngineMap);
        }
        this.script.setDescriptorEngineDependencies(additionalDescriptorEngineMap);
        this.script.setUimafitEngineDependencies(additionalUimafitEngineMap);
        this.initializeVariableValues();
    }

    private void recursiveLoadScript(String toLoad, Map<String, RutaModule> additionalScripts, Map<String, AnalysisEngine> additionalDescriptorEngineMap, Map<String, AnalysisEngine> additionalUimafitEngineMap, String viewName) throws AnalysisEngineProcessException {
        Resource scriptResource = this.scriptRutaResourceLoader.getResourceWithDotNotation(toLoad, SCRIPT_FILE_EXTENSION);
        if (scriptResource == null) {
            throw new AnalysisEngineProcessException((Throwable)new FileNotFoundException("Script [" + this.mainScript + "] cannot be found at [" + StringUtils.join((Object[])this.scriptPaths, (char)File.pathSeparatorChar) + "] or classpath with extension " + SCRIPT_FILE_EXTENSION));
        }
        RutaModule eachScript = null;
        try {
            eachScript = this.loadScript(scriptResource, this.getModuleName(toLoad));
        }
        catch (IOException | RecognitionException e) {
            throw new AnalysisEngineProcessException(e);
        }
        additionalScripts.put(toLoad, eachScript);
        for (String add : eachScript.getScripts().keySet()) {
            if (additionalScripts.containsKey(add)) continue;
            this.recursiveLoadScript(add, additionalScripts, additionalDescriptorEngineMap, additionalUimafitEngineMap, viewName);
        }
        this.initializeEngines(eachScript, viewName, additionalUimafitEngineMap, additionalDescriptorEngineMap);
    }

    private void initializeEngines(RutaModule module, String viewName, Map<String, AnalysisEngine> additionalUimafitEngineMap, Map<String, AnalysisEngine> additionalDescriptorEngineMap) throws AnalysisEngineProcessException {
        if (!this.analysisEnginesAlreadyInitialized) {
            for (String eachUimafitEngine : module.getUimafitEngines().keySet()) {
                this.addUimafitAnalysisEngine(module, additionalUimafitEngineMap, eachUimafitEngine);
            }
        }
        if (!this.analysisEnginesAlreadyInitialized) {
            for (String eachEngineLocation : module.getDescriptorEngines().keySet()) {
                Resource descriptorResource = this.descriptorRutaResourceLoader.getResourceWithDotNotation(eachEngineLocation, ".xml");
                if (descriptorResource == null) {
                    throw new AnalysisEngineProcessException((Throwable)new FileNotFoundException("Engine at [" + eachEngineLocation + "] cannot be found in [" + StringUtils.join((Object[])this.descriptorPaths, (char)',') + "] with extension .xml (from mainScript=" + this.mainScript + " in " + StringUtils.join((Object[])this.scriptPaths, (char)',')));
                }
                try {
                    AnalysisEngine eachEngine = Ruta.wrapAnalysisEngine(descriptorResource.getURL(), viewName, this.resourceManager);
                    this.addAnalysisEngineToMap(additionalDescriptorEngineMap, eachEngineLocation, eachEngine);
                }
                catch (Exception e) {
                    throw new AnalysisEngineProcessException((Throwable)e);
                }
            }
        }
    }

    private void addAnalysisEngineToMap(Map<String, AnalysisEngine> additionalEnginesMap, String eachEngineLocation, AnalysisEngine eachEngine) {
        String engineName = this.getModuleName(eachEngineLocation);
        additionalEnginesMap.put(eachEngineLocation, eachEngine);
        additionalEnginesMap.put(engineName, eachEngine);
    }

    private void addUimafitAnalysisEngine(RutaModule script, Map<String, AnalysisEngine> additionalEnginesMap, String eachUimafitEngine) throws AnalysisEngineProcessException {
        AnalysisEngine eachEngine = null;
        try {
            Class uimafitClass = this.loadClass(eachUimafitEngine);
            List<String> configurationData = script.getConfigurationData(eachUimafitEngine);
            AnalysisEngineDescription aed = AnalysisEngineFactory.createEngineDescription(uimafitClass, (Object[])configurationData.toArray());
            eachEngine = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)aed, (ResourceManager)this.resourceManager, null);
        }
        catch (ClassNotFoundException | ResourceInitializationException e) {
            throw new AnalysisEngineProcessException(e);
        }
        this.addAnalysisEngineToMap(additionalEnginesMap, eachUimafitEngine, eachEngine);
    }

    private static <T> Class<T> loadClass(String className, ClassLoader ... classLoaders) throws ClassNotFoundException {
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<ClassLoader> classLoadersTried = new ArrayList<ClassLoader>();
        for (ClassLoader cl : classLoaders) {
            if (cl == null) continue;
            classLoadersTried.add(cl);
            try {
                return cl.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                errors.add(e.getMessage());
            }
        }
        String classLoaderList = Arrays.asList(classLoadersTried).stream().map(Object::toString).collect(Collectors.joining(", "));
        String errorList = errors.stream().collect(Collectors.joining("\n- ", "\n- ", ""));
        throw new ClassNotFoundException(className + " cannot be found by any of the classloaders [" + classLoaderList + "]: " + errorList);
    }

    private <T> Class<T> loadClass(String className) throws ClassNotFoundException {
        ClassLoader extCl = this.resourceManager.getExtensionClassLoader();
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        ClassLoader local = ((Object)((Object)this)).getClass().getClassLoader();
        return RutaEngine.loadClass(className, extCl, tccl, local);
    }

    private String getModuleName(String completeNamespace) {
        int lastIndexOf = completeNamespace.lastIndexOf(46);
        if (lastIndexOf != -1) {
            return completeNamespace.substring(lastIndexOf + 1, completeNamespace.length());
        }
        return completeNamespace;
    }

    private void initializeVariableValues() {
        if (this.varNames == null || this.varValues == null) {
            return;
        }
        if (this.varNames.length != this.varValues.length) {
            throw new IllegalArgumentException("The parameters varNames and varValues must contain the same amount of entries.");
        }
        for (int i = 0; i < this.varNames.length; ++i) {
            RutaEnvironment environment;
            RutaBlock block;
            String longName = this.varNames[i];
            String value = this.varValues[i];
            int lastIndexOf = longName.lastIndexOf(46);
            String shortName = longName;
            String blockName = this.script.getRootBlock().getName();
            if (lastIndexOf != -1) {
                blockName = longName.substring(0, lastIndexOf);
                shortName = longName.substring(lastIndexOf + 1, longName.length());
            }
            if ((block = this.script.getBlock(blockName)) == null || !(environment = block.getEnvironment()).ownsVariable(shortName)) continue;
            List<?> valueObj = null;
            Class<?> variableType = environment.getVariableType(shortName);
            if (variableType == null) {
                throw new IllegalArgumentException("Variable " + shortName + " is not known in block: " + blockName);
            }
            valueObj = List.class.equals(variableType) ? this.getListVariableValueFromString(value, shortName, environment) : this.getVariableValueFromString(value, variableType);
            if (value == null) {
                throw new IllegalArgumentException("Cannot determine value " + value + " of variable " + shortName + "  in block: " + blockName + ". Null values are not allowed");
            }
            environment.setVariableValue(shortName, valueObj);
        }
    }

    private Object getVariableValueFromString(String value, Class<?> variableType) {
        if (Integer.class.equals(variableType)) {
            return Integer.parseInt(value);
        }
        if (Double.class.equals(variableType)) {
            return Double.parseDouble(value);
        }
        if (Float.class.equals(variableType)) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (String.class.equals(variableType)) {
            return value;
        }
        if (Boolean.class.equals(variableType)) {
            return Boolean.parseBoolean(value);
        }
        if (Type.class.equals(variableType)) {
            if (this.typeUsageInformation != null) {
                this.typeUsageInformation.addMentionedType(value);
            }
            return value;
        }
        return null;
    }

    private List<?> getListVariableValueFromString(String value, String shortName, RutaEnvironment environment) {
        String[] split;
        ArrayList<Object> result = new ArrayList<Object>();
        Class<?> genericType = environment.getVariableGenericType(shortName);
        for (String string : split = StringUtils.split((String)value, (String)SEPARATOR_VAR_VALUES)) {
            result.add(this.getVariableValueFromString(string.trim(), genericType));
        }
        return result;
    }

    public static void addSourceDocumentInformation(CAS cas, File each) {
        Type sdiType = cas.getTypeSystem().getType(SOURCE_DOCUMENT_INFORMATION);
        if (sdiType != null && cas.getAnnotationIndex(sdiType).size() == 0) {
            AnnotationFS sdi = cas.createAnnotation(sdiType, cas.getDocumentAnnotation().getBegin(), cas.getDocumentAnnotation().getEnd());
            Feature uriFeature = sdiType.getFeatureByBaseName("uri");
            sdi.setStringValue(uriFeature, each.toURI().getPath());
            cas.addFsToIndexes((FeatureStructure)sdi);
        }
    }

    public static void removeSourceDocumentInformation(CAS cas) {
        Type sdiType = cas.getTypeSystem().getType(SOURCE_DOCUMENT_INFORMATION);
        if (sdiType != null) {
            AnnotationIndex annotationIndex = cas.getAnnotationIndex(sdiType);
            ArrayList<AnnotationFS> toRemove = new ArrayList<AnnotationFS>();
            for (AnnotationFS annotationFS : annotationIndex) {
                toRemove.add(annotationFS);
            }
            for (AnnotationFS annotationFS : toRemove) {
                cas.removeFsFromIndexes((FeatureStructure)annotationFS);
            }
        }
    }

    protected RutaModule loadScriptByString(String rules) throws RecognitionException {
        ANTLRStringStream st = new ANTLRStringStream(rules);
        RutaLexer lexer = new RutaLexer((CharStream)st);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        RutaParser parser = this.createParser(tokens);
        RutaModule script = parser.file_input(this.rulesScriptName);
        return script;
    }

    protected RutaModule loadScript(Resource scriptResource, String name) throws IOException, RecognitionException {
        InputStream scriptInputStream = scriptResource.getInputStream();
        ANTLRInputStream st = new ANTLRInputStream(scriptInputStream, this.scriptEncoding);
        RutaLexer lexer = new RutaLexer((CharStream)st);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        RutaParser parser = this.createParser(tokens);
        RutaModule script = parser.file_input(name);
        return script;
    }

    private RutaParser createParser(CommonTokenStream tokens) {
        RutaParser parser = new RutaParser((TokenStream)tokens);
        this.initializeTypeUsageInformation();
        ActionFactory actionFactory = new ActionFactory(this.typeUsageInformation);
        ConditionFactory conditionFactory = new ConditionFactory(this.typeUsageInformation);
        ExpressionFactory expressionFactory = new ExpressionFactory(this.typeUsageInformation);
        RutaScriptFactory scriptFactory = new RutaScriptFactory(expressionFactory, this.typeUsageInformation);
        scriptFactory.setContext(this.context);
        parser.setScriptFactory(scriptFactory);
        parser.setExpressionFactory(expressionFactory);
        parser.setActionFactory(actionFactory);
        parser.setConditionFactory(conditionFactory);
        parser.setExternalFactory(this.externalFactory);
        parser.setContext(this.context);
        parser.setResourcePaths(this.resourcePaths);
        parser.setResourceManager(this.resourceManager);
        return parser;
    }

    private void initializeTypeUsageInformation() {
        if (this.typeUsageInformation == null && this.indexOnlyMentionedTypes) {
            this.typeUsageInformation = new TypeUsageInformation();
            if (this.defaultFilteredTypes != null) {
                for (String typeName : this.defaultFilteredTypes) {
                    this.typeUsageInformation.addMentionedType(typeName);
                }
            }
            if (this.indexAdditionally != null) {
                for (String typeName : this.indexAdditionally) {
                    this.typeUsageInformation.addMentionedType(typeName);
                }
            }
        }
    }

    protected RutaExternalFactory getFactory() {
        return this.externalFactory;
    }

    protected TypeUsageInformation getTypeUsageInfomation() {
        return this.typeUsageInformation;
    }

    public void batchProcessComplete() throws AnalysisEngineProcessException {
        super.batchProcessComplete();
        if (this.script != null) {
            Collection<AnalysisEngine> values = this.script.getAllEngines().values();
            for (AnalysisEngine each : values) {
                each.batchProcessComplete();
            }
        }
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        super.collectionProcessComplete();
        if (this.script != null) {
            Collection<AnalysisEngine> values = this.script.getAllEngines().values();
            for (AnalysisEngine each : values) {
                each.collectionProcessComplete();
            }
        }
    }

    public void destroy() {
        super.destroy();
        if (this.script != null) {
            Collection<AnalysisEngine> values = this.script.getAllEngines().values();
            for (AnalysisEngine each : values) {
                each.destroy();
            }
        }
    }
}

