/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.condition;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.condition.TypeSentiveCondition;
import org.apache.uima.ruta.expression.bool.IBooleanExpression;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RutaMatcher;
import org.apache.uima.ruta.rule.RutaRuleElement;
import org.apache.uima.ruta.type.RutaBasic;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class PositionCondition
extends TypeSentiveCondition {
    private final INumberExpression position;
    private final IBooleanExpression relative;

    public PositionCondition(ITypeExpression type, INumberExpression position, IBooleanExpression relative) {
        super(type);
        this.position = position;
        this.relative = relative;
    }

    @Override
    public EvaluatedCondition eval(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        AnnotationFS annotation = context.getAnnotation();
        Type t = this.type.getType(context, stream);
        if (annotation == null || t == null) {
            return new EvaluatedCondition(this, false);
        }
        RuleElement element = context.getElement();
        RutaBasic beginAnchor = stream.getBeginAnchor(annotation.getBegin());
        RutaBasic endAnchor = stream.getEndAnchor(annotation.getEnd());
        if (beginAnchor == null || endAnchor == null || !beginAnchor.isPartOf(t) || !endAnchor.isPartOf(t)) {
            return new EvaluatedCondition(this, false);
        }
        boolean relatively = this.relative == null ? true : this.relative.getBooleanValue(context, stream);
        FSIterator iterator = stream.getCas().getAnnotationIndex(t).iterator((FeatureStructure)beginAnchor);
        if (!iterator.isValid()) {
            iterator.moveToNext();
        }
        if (!iterator.isValid()) {
            iterator.moveToLast();
        }
        AnnotationFS window = null;
        while (iterator.isValid()) {
            AnnotationFS annotationFS = (AnnotationFS)iterator.get();
            if (annotationFS.getBegin() <= annotation.getBegin() && annotationFS.getEnd() >= annotation.getEnd()) {
                window = annotationFS;
                break;
            }
            iterator.moveToPrevious();
        }
        ArrayList<Type> targetTypes = new ArrayList<Type>();
        if (element instanceof RutaRuleElement) {
            RutaRuleElement re = (RutaRuleElement)element;
            RutaMatcher matcher = re.getMatcher();
            if (matcher != null) {
                targetTypes.add(matcher.getType(element.getParent(), stream));
            }
        } else {
            targetTypes.add(annotation.getType());
        }
        if (window == null) {
            return new EvaluatedCondition(this, false);
        }
        int integerValue = this.position.getIntegerValue(context, stream);
        if (relatively) {
            int counter = 0;
            List<RutaBasic> inWindow = stream.getBasicsInWindow(window);
            for (RutaBasic each : inWindow) {
                if (!this.beginsWith(each, targetTypes)) continue;
                if (++counter == integerValue) {
                    if (each.getBegin() == beginAnchor.getBegin()) {
                        return new EvaluatedCondition(this, true);
                    }
                    return new EvaluatedCondition(this, false);
                }
                if (counter <= integerValue) continue;
                return new EvaluatedCondition(this, false);
            }
            return new EvaluatedCondition(this, false);
        }
        int counter = 0;
        List<RutaBasic> inWindow = stream.getBasicsInWindow(window);
        for (RutaBasic each : inWindow) {
            boolean beginsWith = this.beginsWith(each, targetTypes);
            if (each.getBegin() == beginAnchor.getBegin() && beginsWith && ++counter == integerValue) {
                return new EvaluatedCondition(this, true);
            }
            if (counter <= integerValue) continue;
            return new EvaluatedCondition(this, false);
        }
        return new EvaluatedCondition(this, false);
    }

    private boolean beginsWith(RutaBasic each, List<Type> targetTypes) {
        for (Type type : targetTypes) {
            if (!each.beginsWith(type)) continue;
            return true;
        }
        return false;
    }

    public INumberExpression getPosition() {
        return this.position;
    }

    public IBooleanExpression getRelative() {
        return this.relative;
    }
}

