/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.rule;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.ScriptApply;
import org.apache.uima.ruta.rule.ComposedRuleElementMatch;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.RuleElement;

public class RuleElementMatch {
    protected final RuleElement ruleElement;
    protected List<AnnotationFS> textsMatched;
    protected boolean conditionsMatched = true;
    protected boolean baseConditionMatched = true;
    private boolean inlinedRulesMatched = true;
    protected List<EvaluatedCondition> conditions;
    protected ComposedRuleElementMatch containerMatch;
    private boolean ruleAnchor = false;
    private List<List<ScriptApply>> inlinedActionRules;
    private List<List<ScriptApply>> inlinedConditionRules;

    public RuleElementMatch(RuleElement ruleElement, ComposedRuleElementMatch containerMatch) {
        this.ruleElement = ruleElement;
        this.containerMatch = containerMatch;
        this.textsMatched = new ArrayList<AnnotationFS>();
    }

    public String getLabel() {
        return this.ruleElement.getLabel();
    }

    public void setMatchInfo(boolean baseCondition, List<AnnotationFS> texts, RutaStream stream) {
        this.baseConditionMatched = baseCondition;
        this.textsMatched = texts;
        this.conditionsMatched = this.baseConditionMatched;
        if (this.containerMatch != null) {
            this.containerMatch.addInnerMatch(this.ruleElement, this, stream);
        }
    }

    public void setConditionInfo(boolean baseCondition, List<EvaluatedCondition> conditionList) {
        this.baseConditionMatched = baseCondition;
        this.conditions = conditionList;
        this.conditionsMatched = this.baseConditionMatched;
        if (this.baseConditionMatched) {
            for (EvaluatedCondition each : this.conditions) {
                this.conditionsMatched = this.conditionsMatched && each.isValue();
            }
        }
    }

    public boolean matched() {
        return this.baseConditionMatched && this.conditionsMatched && this.inlinedRulesMatched;
    }

    public RuleElement getRuleElement() {
        return this.ruleElement;
    }

    public List<AnnotationFS> getTextsMatched() {
        return this.textsMatched;
    }

    public void setTextsMatched(List<AnnotationFS> textsMatched) {
        this.textsMatched = textsMatched;
    }

    public List<EvaluatedCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<EvaluatedCondition> conditions) {
        this.conditions = conditions;
    }

    public void setConditionsMatched(boolean conditionsMatched) {
        this.conditionsMatched = conditionsMatched;
    }

    public void setBaseConditionMatched(boolean baseConditionMatched) {
        this.baseConditionMatched = baseConditionMatched;
    }

    public void setContainerMatch(ComposedRuleElementMatch containerMatch) {
        this.containerMatch = containerMatch;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.matched() + " : ");
        for (AnnotationFS each : this.textsMatched) {
            sb.append(each.getCoveredText());
        }
        String string = sb.toString();
        if (string.length() > 20) {
            string = string.substring(0, 20) + "...";
        }
        return string;
    }

    public boolean isBaseConditionMatched() {
        return this.baseConditionMatched;
    }

    public ComposedRuleElementMatch getContainerMatch() {
        return this.containerMatch;
    }

    public RuleElementMatch copy() {
        RuleElementMatch copy = new RuleElementMatch(this.ruleElement, this.containerMatch);
        copy.setBaseConditionMatched(this.baseConditionMatched);
        copy.setConditions(this.conditions);
        copy.setConditionsMatched(this.conditionsMatched);
        copy.setTextsMatched(this.textsMatched);
        copy.setRuleAnchor(this.ruleAnchor);
        return copy;
    }

    public boolean isRuleAnchor() {
        return this.ruleAnchor;
    }

    public void setRuleAnchor(boolean ruleAnchor) {
        this.ruleAnchor = ruleAnchor;
    }

    public boolean isInlinedRulesMatched() {
        return this.inlinedRulesMatched;
    }

    public void setInlinedRulesMatched(boolean inlinedRulesMatched) {
        this.inlinedRulesMatched = inlinedRulesMatched;
    }

    public void setInlinedActionRules(List<List<ScriptApply>> inlinedBlocksApplies) {
        this.inlinedActionRules = inlinedBlocksApplies;
    }

    public void setInlinedConditionRules(List<List<ScriptApply>> inlinedBlocksApplies) {
        this.inlinedConditionRules = inlinedBlocksApplies;
    }

    public List<List<ScriptApply>> getInlinedActionRules() {
        return this.inlinedActionRules;
    }

    public List<List<ScriptApply>> getInlinedConditionRules() {
        return this.inlinedConditionRules;
    }
}

