/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.ruta.RutaEnvironment;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.block.RutaBlock;
import org.apache.uima.ruta.condition.AbstractRutaCondition;
import org.apache.uima.ruta.rule.AbstractRuleElement;
import org.apache.uima.ruta.rule.ComposedRuleElementMatch;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleApply;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleElementCaretaker;
import org.apache.uima.ruta.rule.RuleElementContainer;
import org.apache.uima.ruta.rule.RuleElementMatch;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.rule.RuleMatchComparator;
import org.apache.uima.ruta.rule.quantifier.RuleElementQuantifier;
import org.apache.uima.ruta.type.RutaFrame;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class ComposedRuleElement
extends AbstractRuleElement
implements RuleElementContainer {
    protected List<RuleElement> elements;
    protected RuleElementContainer caretaker;
    private Boolean conjunct = null;
    private Comparator<RuleMatch> ruleMatchComparator = new RuleMatchComparator();

    public ComposedRuleElement(List<RuleElement> elements, RuleElementQuantifier quantifier, List<AbstractRutaCondition> conditions, List<AbstractRutaAction> actions, RuleElementContainer container, RutaBlock parent) {
        super(quantifier, conditions, actions, container, parent);
        this.elements = elements;
        this.caretaker = new RuleElementCaretaker(this);
    }

    @Override
    public void apply(RuleMatch match, RutaStream symbolStream, InferenceCrowd crowd) {
        this.applyRuleElements(match, symbolStream, crowd);
        super.apply(match, symbolStream, crowd);
    }

    @Override
    public List<RuleMatch> startMatch(RuleMatch ruleMatch, RuleApply ruleApply, ComposedRuleElementMatch containerMatch, RuleElement entryPoint, RutaStream stream, InferenceCrowd crowd) {
        List<RuleMatch> result;
        block8: {
            block9: {
                block7: {
                    result = new ArrayList<RuleMatch>();
                    if (this.conjunct != null) break block7;
                    ComposedRuleElementMatch composedMatch = this.createComposedMatch(ruleMatch, containerMatch, stream);
                    RuleElement anchorElement = this.getAnchoringRuleElement(stream);
                    result = anchorElement.startMatch(ruleMatch, ruleApply, composedMatch, entryPoint, stream, crowd);
                    break block8;
                }
                if (this.conjunct.booleanValue()) break block9;
                LinkedHashMap<RuleMatch, ComposedRuleElementMatch> ruleMatches = new LinkedHashMap<RuleMatch, ComposedRuleElementMatch>();
                for (RuleElement each : this.elements) {
                    ComposedRuleElementMatch extendedContainerMatch = containerMatch.copy();
                    RuleMatch ruleMatch2 = ruleMatch.copy(extendedContainerMatch, true);
                    ComposedRuleElementMatch composedMatch = this.createComposedMatch(ruleMatch2, extendedContainerMatch, stream);
                    List<RuleMatch> startRuleMatches = each.startMatch(ruleMatch2, null, composedMatch, this, stream, crowd);
                    for (RuleMatch startRuleMatch : startRuleMatches) {
                        ComposedRuleElementMatch startElementMatch = (ComposedRuleElementMatch)startRuleMatch.getLastMatch(this, true);
                        ruleMatches.put(startRuleMatch, startElementMatch);
                    }
                }
                Map<RuleMatch, ComposedRuleElementMatch> mergedMatches = this.mergeDisjunctiveRuleMatches(ruleMatches, true, stream);
                Set<Map.Entry<RuleMatch, ComposedRuleElementMatch>> entrySet = mergedMatches.entrySet();
                for (Map.Entry entry : entrySet) {
                    RuleMatch eachRuleMatch = (RuleMatch)entry.getKey();
                    ComposedRuleElementMatch eachComposedMatch = (ComposedRuleElementMatch)entry.getValue();
                    MatchContext context = new MatchContext(null, this, eachRuleMatch, true);
                    AnnotationFS lastAnnotation = eachRuleMatch.getLastMatchedAnnotation(context, stream);
                    boolean failed = !eachComposedMatch.matched();
                    ComposedRuleElement sideStepOrigin = this.hasAncestor(false) ? this : null;
                    List<RuleMatch> fallbackContinue = this.fallbackContinue(true, failed, lastAnnotation, eachRuleMatch, ruleApply, eachComposedMatch, sideStepOrigin, entryPoint, stream, crowd);
                    result.addAll(fallbackContinue);
                }
                break block8;
            }
            if (!this.conjunct.booleanValue()) break block8;
            LinkedHashMap<RuleMatch, ComposedRuleElementMatch> ruleMatches = new LinkedHashMap<RuleMatch, ComposedRuleElementMatch>();
            RuleElement anchoringRuleElement = this.getAnchoringRuleElement(stream);
            ComposedRuleElementMatch composedMatch = this.createComposedMatch(ruleMatch, containerMatch, stream);
            List<RuleMatch> startRuleMatches = anchoringRuleElement.startMatch(ruleMatch, null, composedMatch, this, stream, crowd);
            for (RuleMatch eachStartRuleMatch : startRuleMatches) {
                if (!eachStartRuleMatch.matched()) continue;
                AnnotationFS prefixAnnotation = this.getPrefixAnnotation(eachStartRuleMatch, stream);
                for (RuleElement each : this.elements) {
                    if (each.equals(anchoringRuleElement)) continue;
                    ComposedRuleElementMatch startElementMatch = (ComposedRuleElementMatch)eachStartRuleMatch.getLastMatch(this, true);
                    List<RuleMatch> continueMatch = each.continueMatch(true, prefixAnnotation, eachStartRuleMatch, null, startElementMatch, null, this, stream, crowd);
                    for (RuleMatch startRuleMatch : continueMatch) {
                        ComposedRuleElementMatch elementMatch = (ComposedRuleElementMatch)startRuleMatch.getLastMatch(this, true);
                        ruleMatches.put(startRuleMatch, elementMatch);
                    }
                }
            }
            Map<RuleMatch, ComposedRuleElementMatch> map = this.mergeConjunctiveRuleMatches(ruleMatches, true);
            Set<Map.Entry<RuleMatch, ComposedRuleElementMatch>> entrySet = map.entrySet();
            for (Map.Entry<RuleMatch, ComposedRuleElementMatch> entry : entrySet) {
                RuleMatch eachRuleMatch = entry.getKey();
                ComposedRuleElementMatch eachComposedMatch = entry.getValue();
                MatchContext context = new MatchContext(this, eachRuleMatch);
                AnnotationFS lastAnnotation = eachRuleMatch.getLastMatchedAnnotation(context, stream);
                boolean failed = !eachComposedMatch.matched();
                List<AnnotationFS> textsMatched = eachComposedMatch.getTextsMatched();
                if ((stream.isGreedyAnchoring() || stream.isOnlyOnce()) && this.earlyExit(textsMatched.get(0), ruleApply, stream)) continue;
                ComposedRuleElement sideStepOrigin = this.hasAncestor(false) ? this : null;
                List<RuleMatch> fallbackContinue = this.fallbackContinue(true, failed, lastAnnotation, eachRuleMatch, ruleApply, eachComposedMatch, sideStepOrigin, entryPoint, stream, crowd);
                result.addAll(fallbackContinue);
            }
        }
        return result;
    }

    private AnnotationFS getPrefixAnnotation(RuleMatch ruleMatch, RutaStream stream) {
        MatchContext context = new MatchContext(this, ruleMatch);
        AnnotationFS lastMatchedAnnotation = ruleMatch.getLastMatchedAnnotation(context, stream);
        if (lastMatchedAnnotation.getBegin() == 0) {
            JCas jCas = stream.getJCas();
            RutaFrame dummy = new RutaFrame(jCas, 0, 0);
            return dummy;
        }
        return stream.getEndAnchor(lastMatchedAnnotation.getBegin());
    }

    protected ComposedRuleElementMatch createComposedMatch(RuleMatch ruleMatch, ComposedRuleElementMatch containerMatch, RutaStream stream) {
        ComposedRuleElementMatch composedMatch = new ComposedRuleElementMatch(this, containerMatch);
        this.includeMatch(ruleMatch, containerMatch, composedMatch, stream);
        return composedMatch;
    }

    @Override
    public List<RuleMatch> continueMatch(boolean after, AnnotationFS annotation, RuleMatch ruleMatch, RuleApply ruleApply, ComposedRuleElementMatch containerMatch, RuleElement sideStepOrigin, RuleElement entryPoint, RutaStream stream, InferenceCrowd crowd) {
        List<RuleMatch> result;
        block10: {
            block11: {
                block9: {
                    result = new ArrayList<RuleMatch>();
                    if (this.conjunct != null) break block9;
                    RuleElement nextElement = this.getNextElement(after, this);
                    if (nextElement != null) {
                        ComposedRuleElementMatch composedMatch = this.createComposedMatch(ruleMatch, containerMatch, stream);
                        result = nextElement.continueMatch(after, annotation, ruleMatch, ruleApply, composedMatch, sideStepOrigin, entryPoint, stream, crowd);
                    } else {
                        result = this.fallback(after, false, annotation, ruleMatch, ruleApply, containerMatch, sideStepOrigin, entryPoint, stream, crowd);
                    }
                    break block10;
                }
                if (this.conjunct.booleanValue()) break block11;
                HashMap<RuleMatch, ComposedRuleElementMatch> ruleMatches = new HashMap<RuleMatch, ComposedRuleElementMatch>();
                for (RuleElement each : this.elements) {
                    ComposedRuleElementMatch extendedContainerMatch = containerMatch.copy();
                    RuleMatch ruleMatch2 = ruleMatch.copy(extendedContainerMatch, after);
                    ComposedRuleElementMatch composedMatch = this.createComposedMatch(ruleMatch2, extendedContainerMatch, stream);
                    List<RuleMatch> continueRuleMatches = each.continueMatch(after, annotation, ruleMatch2, null, composedMatch, sideStepOrigin, this, stream, crowd);
                    for (RuleMatch continueRuleMatch : continueRuleMatches) {
                        ComposedRuleElementMatch startElementMatch = (ComposedRuleElementMatch)continueRuleMatch.getLastMatch(this, true);
                        ruleMatches.put(continueRuleMatch, startElementMatch);
                    }
                }
                Map<RuleMatch, ComposedRuleElementMatch> mergedMatches = this.mergeDisjunctiveRuleMatches(ruleMatches, after, stream);
                Set<Map.Entry<RuleMatch, ComposedRuleElementMatch>> entrySet = mergedMatches.entrySet();
                for (Map.Entry entry : entrySet) {
                    RuleMatch eachRuleMatch = (RuleMatch)entry.getKey();
                    ComposedRuleElementMatch eachComposedMatch = (ComposedRuleElementMatch)entry.getValue();
                    MatchContext matchContext = new MatchContext(annotation, this, eachRuleMatch, after);
                    AnnotationFS lastAnnotation = eachRuleMatch.getLastMatchedAnnotation(matchContext, stream);
                    boolean failed = !eachComposedMatch.matched();
                    List<AnnotationFS> textsMatched = eachRuleMatch.getMatchedAnnotationsOfRoot();
                    if ((stream.isGreedyAnchoring() || stream.isOnlyOnce()) && (textsMatched.isEmpty() || this.earlyExit(textsMatched.get(0), ruleApply, stream))) continue;
                    List<RuleMatch> fallbackContinue = this.fallbackContinue(after, failed, lastAnnotation, eachRuleMatch, ruleApply, eachComposedMatch, sideStepOrigin, entryPoint, stream, crowd);
                    result.addAll(fallbackContinue);
                }
                break block10;
            }
            if (!this.conjunct.booleanValue()) break block10;
            HashMap<RuleMatch, ComposedRuleElementMatch> ruleMatches = new HashMap<RuleMatch, ComposedRuleElementMatch>();
            RuleElement anchoringRuleElement = this.getAnchoringRuleElement(stream);
            ComposedRuleElementMatch composedMatch = this.createComposedMatch(ruleMatch, containerMatch, stream);
            List<RuleMatch> startRuleMatches = anchoringRuleElement.continueMatch(after, annotation, ruleMatch, null, composedMatch, sideStepOrigin, this, stream, crowd);
            for (RuleMatch eachStartRuleMatch : startRuleMatches) {
                for (RuleElement ruleElement : this.elements) {
                    if (ruleElement.equals(anchoringRuleElement)) continue;
                    ComposedRuleElementMatch startElementMatch = (ComposedRuleElementMatch)eachStartRuleMatch.getLastMatch(this, after);
                    List<RuleMatch> continueMatch = ruleElement.continueMatch(after, annotation, eachStartRuleMatch, null, startElementMatch, null, this, stream, crowd);
                    for (RuleMatch startRuleMatch : continueMatch) {
                        ComposedRuleElementMatch elementMatch = (ComposedRuleElementMatch)startRuleMatch.getLastMatch(this, after);
                        ruleMatches.put(startRuleMatch, elementMatch);
                    }
                }
            }
            Map<RuleMatch, ComposedRuleElementMatch> map = this.mergeConjunctiveRuleMatches(ruleMatches, after);
            Set<Map.Entry<RuleMatch, ComposedRuleElementMatch>> entrySet = map.entrySet();
            for (Map.Entry entry : entrySet) {
                RuleMatch eachRuleMatch = (RuleMatch)entry.getKey();
                ComposedRuleElementMatch eachComposedMatch = (ComposedRuleElementMatch)entry.getValue();
                MatchContext context = new MatchContext(this, eachRuleMatch);
                AnnotationFS lastAnnotation = eachRuleMatch.getLastMatchedAnnotation(context, stream);
                boolean failed = !eachComposedMatch.matched();
                List<AnnotationFS> textsMatched = eachRuleMatch.getMatchedAnnotationsOfRoot();
                if ((stream.isGreedyAnchoring() || stream.isOnlyOnce()) && (textsMatched.isEmpty() || this.earlyExit(textsMatched.get(0), ruleApply, stream))) continue;
                List<RuleMatch> fallbackContinue = this.fallbackContinue(after, failed, lastAnnotation, eachRuleMatch, ruleApply, eachComposedMatch, sideStepOrigin, entryPoint, stream, crowd);
                result.addAll(fallbackContinue);
            }
        }
        return result;
    }

    private Map<RuleMatch, ComposedRuleElementMatch> mergeConjunctiveRuleMatches(Map<RuleMatch, ComposedRuleElementMatch> ruleMatches, boolean direction) {
        return ruleMatches;
    }

    private Map<RuleMatch, ComposedRuleElementMatch> mergeDisjunctiveRuleMatches(Map<RuleMatch, ComposedRuleElementMatch> ruleMatches, boolean direction, RutaStream stream) {
        Map<RuleMatch, ComposedRuleElementMatch> result = new TreeMap<RuleMatch, ComposedRuleElementMatch>(this.ruleMatchComparator);
        Set<Map.Entry<RuleMatch, ComposedRuleElementMatch>> entrySet = ruleMatches.entrySet();
        Map.Entry<RuleMatch, ComposedRuleElementMatch> largestEntry = null;
        AnnotationFS largestAnnotation = null;
        for (Map.Entry<RuleMatch, ComposedRuleElementMatch> entry : entrySet) {
            RuleMatch ruleMatch = entry.getKey();
            ComposedRuleElementMatch elementMatch = entry.getValue();
            if (elementMatch.matched()) {
                result.putIfAbsent(ruleMatch, elementMatch);
                continue;
            }
            MatchContext context = new MatchContext(this.getFirstElement(), ruleMatch, direction);
            AnnotationFS lastMatchedAnnotation = ruleMatch.getLastMatchedAnnotation(context, stream);
            if (largestEntry == null) {
                largestEntry = entry;
                largestAnnotation = lastMatchedAnnotation;
                continue;
            }
            if (lastMatchedAnnotation == null || largestAnnotation == null || lastMatchedAnnotation.getCoveredText().length() <= largestAnnotation.getCoveredText().length()) continue;
            largestEntry = entry;
            largestAnnotation = lastMatchedAnnotation;
        }
        if (result.isEmpty()) {
            if (largestEntry != null) {
                result.put((RuleMatch)largestEntry.getKey(), (ComposedRuleElementMatch)largestEntry.getValue());
            } else {
                result = ruleMatches;
            }
        }
        return result;
    }

    @Override
    public List<RuleMatch> continueOwnMatch(boolean after, AnnotationFS annotation, RuleMatch ruleMatch, RuleApply ruleApply, ComposedRuleElementMatch containerMatch, RuleElement sideStepOrigin, RuleElement entryPoint, RutaStream stream, InferenceCrowd crowd) {
        List<Object> result = new ArrayList();
        if (!stream.isSimpleGreedyForComposed()) {
            result = this.continueMatch(after, annotation, ruleMatch, ruleApply, containerMatch, sideStepOrigin, entryPoint, stream, crowd);
        } else {
            boolean stopMatching = false;
            boolean failed = false;
            AnnotationFS nextAnnotation = annotation;
            while (!stopMatching) {
                RuleElement nextElement = this.getNextElement(after, this);
                if (nextElement != null) {
                    ComposedRuleElementMatch composedMatch = this.createComposedMatch(ruleMatch, containerMatch, stream);
                    nextElement.continueMatch(after, nextAnnotation, ruleMatch, ruleApply, composedMatch, sideStepOrigin, this, stream, crowd);
                    ComposedRuleElementMatch parentContainerMatch = containerMatch.getContainerMatch();
                    List<RuleElementMatch> match = this.getMatch(ruleMatch, parentContainerMatch);
                    int lenghtBefore = match.size();
                    MatchContext context = new MatchContext(this, ruleMatch, after);
                    List<RuleElementMatch> evaluateMatches = this.quantifier.evaluateMatches(match, context, stream, crowd);
                    ruleMatch.setMatched(ruleMatch.matched() && evaluateMatches != null);
                    if (evaluateMatches != null && evaluateMatches.size() != lenghtBefore) {
                        failed = true;
                        stopMatching = true;
                    }
                    if (!this.quantifier.continueMatch(after, context, nextAnnotation, containerMatch, stream, crowd)) {
                        stopMatching = true;
                    }
                    if (evaluateMatches == null) continue;
                    List<AnnotationFS> textsMatched = evaluateMatches.get(evaluateMatches.size() - 1).getTextsMatched();
                    nextAnnotation = textsMatched.get(textsMatched.size() - 1);
                    continue;
                }
                stopMatching = true;
            }
            result = this.fallback(after, failed, nextAnnotation, ruleMatch, ruleApply, containerMatch, sideStepOrigin, entryPoint, stream, crowd);
        }
        return result;
    }

    public List<RuleMatch> fallbackContinue(boolean after, boolean failed, AnnotationFS annotation, RuleMatch ruleMatch, RuleApply ruleApply, ComposedRuleElementMatch containerMatch, RuleElement sideStepOrigin, RuleElement entryPoint, RutaStream stream, InferenceCrowd crowd) {
        List<RuleMatch> result = new ArrayList<RuleMatch>();
        RuleElementContainer container = this.getContainer();
        this.doMatch(after, annotation, ruleMatch, containerMatch, this.isStartAnchor(), stream, crowd);
        if (this.equals(entryPoint) && ruleApply == null) {
            if (failed) {
                ruleMatch.setMatched(false);
            }
            result.add(ruleMatch);
        } else if (container == null) {
            result = this.fallback(after, failed, annotation, ruleMatch, ruleApply, containerMatch, sideStepOrigin, entryPoint, stream, crowd);
        } else {
            boolean removedFailedMatches;
            ComposedRuleElementMatch parentContainerMatch = containerMatch.getContainerMatch();
            RuleElement nextElement = container.getNextElement(after, this);
            List<RuleElementMatch> match = this.getMatch(ruleMatch, parentContainerMatch);
            int sizeBefore = match.size();
            MatchContext context = new MatchContext(annotation, this, ruleMatch, after);
            boolean continueMatch = this.quantifier.continueMatch(after, context, annotation, parentContainerMatch, stream, crowd);
            List<RuleElementMatch> evaluateMatches = this.quantifier.evaluateMatches(match, context, stream, crowd);
            int sizeAfter = evaluateMatches != null ? evaluateMatches.size() : sizeBefore;
            boolean bl = removedFailedMatches = sizeAfter < sizeBefore;
            if (removedFailedMatches) {
                containerMatch.enforceUpdate();
            }
            ruleMatch.setMatched(!(!ruleMatch.matched() && !removedFailedMatches || evaluateMatches == null && !continueMatch && sideStepOrigin == null));
            if (failed) {
                if (!removedFailedMatches && evaluateMatches != null && continueMatch) {
                    result = this.continueOwnMatch(after, annotation, ruleMatch, ruleApply, parentContainerMatch, sideStepOrigin, entryPoint, stream, crowd);
                } else if (nextElement != null) {
                    AnnotationFS backtrackedAnnotation = this.getBacktrackedAnnotation(after, evaluateMatches, annotation);
                    result = backtrackedAnnotation != null ? nextElement.continueMatch(after, backtrackedAnnotation, ruleMatch, ruleApply, parentContainerMatch, sideStepOrigin, entryPoint, stream, crowd) : this.fallback(after, failed, annotation, ruleMatch, ruleApply, parentContainerMatch, sideStepOrigin, entryPoint, stream, crowd);
                } else if (this.equals(entryPoint)) {
                    result.add(ruleMatch);
                } else {
                    result = this.fallback(after, !removedFailedMatches, annotation, ruleMatch, ruleApply, parentContainerMatch, sideStepOrigin, entryPoint, stream, crowd);
                }
            } else {
                result = continueMatch && !removedFailedMatches ? this.continueOwnMatch(after, annotation, ruleMatch, ruleApply, parentContainerMatch, sideStepOrigin, entryPoint, stream, crowd) : (nextElement != null ? nextElement.continueMatch(after, annotation, ruleMatch, ruleApply, parentContainerMatch, sideStepOrigin, entryPoint, stream, crowd) : this.fallback(after, failed, annotation, ruleMatch, ruleApply, parentContainerMatch, sideStepOrigin, entryPoint, stream, crowd));
            }
        }
        return result;
    }

    private AnnotationFS getBacktrackedAnnotation(boolean after, List<RuleElementMatch> evaluateMatches, AnnotationFS annotation) {
        if (evaluateMatches == null) {
            return null;
        }
        if (evaluateMatches.isEmpty()) {
            return annotation;
        }
        if (after) {
            List<AnnotationFS> textsMatched = evaluateMatches.get(evaluateMatches.size() - 1).getTextsMatched();
            if (textsMatched.isEmpty()) {
                return null;
            }
            AnnotationFS backtrackedAnnotation = textsMatched.get(textsMatched.size() - 1);
            return backtrackedAnnotation;
        }
        List<AnnotationFS> textsMatched = evaluateMatches.get(0).getTextsMatched();
        if (textsMatched.isEmpty()) {
            return null;
        }
        AnnotationFS backtrackedAnnotation = textsMatched.get(0);
        return backtrackedAnnotation;
    }

    private List<RuleMatch> fallback(boolean after, boolean failed, AnnotationFS annotation, RuleMatch ruleMatch, RuleApply ruleApply, ComposedRuleElementMatch containerMatch, RuleElement sideStepOrigin, RuleElement entryPoint, RutaStream stream, InferenceCrowd crowd) {
        RuleElementContainer parentContainer = this.getContainer();
        if (parentContainer instanceof ComposedRuleElement) {
            ComposedRuleElement parentElement = (ComposedRuleElement)parentContainer;
            return parentElement.fallbackContinue(after, failed, annotation, ruleMatch, ruleApply, containerMatch, sideStepOrigin, entryPoint, stream, crowd);
        }
        if (sideStepOrigin != null && !failed && sideStepOrigin.getContainer() != null) {
            return sideStepOrigin.continueSideStep(after, ruleMatch, ruleApply, containerMatch, entryPoint, stream, crowd);
        }
        ruleMatch.setMatched(ruleMatch.matched && !failed);
        this.doneMatching(ruleMatch, ruleApply, stream, crowd);
        return Arrays.asList(ruleMatch);
    }

    private void includeMatch(RuleMatch ruleMatch, ComposedRuleElementMatch containerMatch, ComposedRuleElementMatch composedMatch, RutaStream stream) {
        if (containerMatch == null) {
            ruleMatch.setRootMatch(composedMatch);
        } else {
            containerMatch.addInnerMatch(this, composedMatch, false, stream);
        }
    }

    @Override
    public void doMatch(boolean after, AnnotationFS annotation, RuleMatch ruleMatch, ComposedRuleElementMatch containerMatch, boolean ruleAnchor, RutaStream stream, InferenceCrowd crowd) {
        List<AnnotationFS> textsMatched = containerMatch.getTextsMatched();
        if (textsMatched == null || textsMatched.isEmpty()) {
            this.getParent().getEnvironment().addMatchToVariable(ruleMatch, this, new MatchContext(this.getParent()), stream);
            containerMatch.evaluateInnerMatches(true, stream);
            return;
        }
        int begin = textsMatched.get(0).getBegin();
        int end = textsMatched.get(textsMatched.size() - 1).getEnd();
        AnnotationFS implicitAnnotation = stream.getCas().createAnnotation(stream.getCas().getAnnotationType(), begin, end);
        MatchContext context = new MatchContext(implicitAnnotation, this, ruleMatch, after);
        RutaEnvironment environment = context.getParent().getEnvironment();
        environment.addMatchToVariable(ruleMatch, this, context, stream);
        ArrayList<EvaluatedCondition> evaluatedConditions = new ArrayList<EvaluatedCondition>(this.conditions.size());
        for (AbstractRutaCondition condition : this.conditions) {
            crowd.beginVisit(condition, null);
            EvaluatedCondition eval = condition.eval(context, stream, crowd);
            crowd.endVisit(condition, null);
            evaluatedConditions.add(eval);
            if (eval.isValue()) continue;
            break;
        }
        containerMatch.setConditionInfo(evaluatedConditions);
        containerMatch.evaluateInnerMatches(true, stream);
        if (containerMatch.matched()) {
            boolean inlinedRulesMatched = this.matchInlinedRules(ruleMatch, containerMatch, stream, crowd);
            containerMatch.setInlinedRulesMatched(inlinedRulesMatched);
        } else {
            environment.removeVariableValue(this.getLabel(), context);
        }
    }

    @Override
    public Collection<? extends AnnotationFS> getAnchors(RutaStream stream) {
        RuleElement anchorElement = this.getAnchoringRuleElement(stream);
        Collection<? extends AnnotationFS> anchors = anchorElement.getAnchors(stream);
        return anchors;
    }

    @Override
    public long estimateAnchors(RutaStream stream) {
        long result = 1L;
        for (RuleElement each : this.elements) {
            result += each.estimateAnchors(stream);
        }
        MatchContext context = new MatchContext(null, null);
        if (this.quantifier.isOptional(context, stream)) {
            result *= (long)(3 * (int)stream.getIndexPenalty());
        }
        return result;
    }

    @Override
    public RuleElement getAnchoringRuleElement(RutaStream stream) {
        return this.caretaker.getAnchoringRuleElement(stream);
    }

    @Override
    public List<RuleElement> getRuleElements() {
        return this.elements;
    }

    public void setRuleElements(List<RuleElement> elements) {
        this.elements = elements;
    }

    @Override
    public RuleElement getFirstElement() {
        return this.caretaker.getFirstElement();
    }

    @Override
    public RuleElement getLastElement() {
        return this.caretaker.getLastElement();
    }

    @Override
    public void applyRuleElements(RuleMatch ruleMatch, RutaStream stream, InferenceCrowd crowd) {
        this.caretaker.applyRuleElements(ruleMatch, stream, crowd);
    }

    public String toString() {
        String con = "";
        if (this.conjunct != null) {
            con = this.conjunct != false ? "&" : "|";
        }
        String simpleName = this.getQuantifier().getClass().getSimpleName();
        return "(" + con + (this.elements == null ? "null" : this.elements.toString()) + ")" + (simpleName.equals("NormalQuantifier") ? "" : simpleName);
    }

    @Override
    public RuleElement getNextElement(boolean after, RuleElement ruleElement) {
        if (this.conjunct == null || this.equals(ruleElement)) {
            return this.caretaker.getNextElement(after, ruleElement);
        }
        return null;
    }

    public void setConjunct(Boolean conjunct) {
        this.conjunct = conjunct;
    }

    public Boolean getConjunct() {
        return this.conjunct;
    }
}

