/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.expression.resource;

import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.block.RutaBlock;
import org.apache.uima.ruta.expression.resource.WordListExpression;
import org.apache.uima.ruta.resource.RutaWordList;
import org.apache.uima.ruta.rule.MatchContext;

public class LiteralWordListExpression
extends WordListExpression {
    private final String text;

    public LiteralWordListExpression(String text) {
        if (text.startsWith("'") && text.endsWith("'")) {
            text = text.substring(1, text.length() - 1);
        }
        this.text = LiteralWordListExpression.stripEscapes(text);
    }

    public static String stripEscapes(String str) {
        String result = str.replaceAll("\\\\\\\\", "\\\\");
        return result.replaceAll("\\\\\\\"", "\\\"");
    }

    @Override
    public RutaWordList getList(MatchContext context, RutaStream stream) {
        RutaBlock parent = context.getParent();
        RutaWordList list = parent.getEnvironment().getWordList(this.getText());
        return list;
    }

    public String getText() {
        return this.text;
    }
}

