/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.expression;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.uima.ruta.RutaEnvironment;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.block.RutaBlock;
import org.apache.uima.ruta.expression.IRutaExpression;
import org.apache.uima.ruta.expression.RutaExpression;
import org.apache.uima.ruta.expression.annotation.AnnotationListDelegateVariableExpression;
import org.apache.uima.ruta.expression.annotation.AnnotationListVariableExpression;
import org.apache.uima.ruta.expression.annotation.AnnotationListVariableIndexExpression;
import org.apache.uima.ruta.expression.annotation.AnnotationVariableExpression;
import org.apache.uima.ruta.expression.annotation.IAnnotationExpression;
import org.apache.uima.ruta.expression.annotation.IAnnotationListExpression;
import org.apache.uima.ruta.expression.feature.FeatureExpression;
import org.apache.uima.ruta.expression.feature.FeatureMatchExpression;
import org.apache.uima.ruta.expression.feature.SimpleFeatureExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.expression.type.ITypeListExpression;
import org.apache.uima.ruta.expression.type.SimpleTypeExpression;
import org.apache.uima.ruta.expression.type.TypeListVariableExpression;
import org.apache.uima.ruta.expression.type.TypeVariableExpression;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.utils.IndexedReference;
import org.apache.uima.ruta.utils.ParsingUtils;

public class MatchReference
extends RutaExpression {
    private String reference;
    private String comparator;
    private IRutaExpression argument;
    private ITypeExpression typeExpression;
    private ITypeListExpression typeListExpression;
    private IAnnotationExpression annotationExpression;
    private IAnnotationListExpression annotationListExpression;
    private FeatureExpression featureExpression;
    private List<String> features = Collections.emptyList();
    private boolean initialized = false;

    public MatchReference(String reference) {
        this(reference, null, null);
    }

    public MatchReference(String reference, String comparator, IRutaExpression argument) {
        this.reference = reference;
        this.comparator = comparator;
        this.argument = argument;
    }

    public MatchReference(ITypeExpression expression) {
        this.typeExpression = expression;
        this.initialized = true;
    }

    public MatchReference(ITypeListExpression expression) {
        this.typeListExpression = expression;
        this.initialized = true;
    }

    public MatchReference(IAnnotationExpression expression) {
        this.annotationExpression = expression;
        this.initialized = true;
    }

    public MatchReference(IAnnotationListExpression expression) {
        this.annotationListExpression = expression;
        this.initialized = true;
    }

    private void resolve(MatchContext context, RutaStream stream) {
        if (this.initialized) {
            return;
        }
        RutaBlock parent = context.getParent();
        RutaEnvironment e = parent.getEnvironment();
        boolean success = this.buildTypeOrAnnotationExpression(this.reference, e, context, stream);
        if (!success) {
            String[] elements = this.reference.split("[.]");
            StringBuilder sb = new StringBuilder();
            List<String> tail = null;
            int counter = 0;
            for (String eachPart : elements) {
                if (sb.length() != 0) {
                    sb.append('.');
                }
                sb.append(eachPart);
                String head = sb.toString();
                success = this.buildTypeOrAnnotationExpression(head, e, context, stream);
                if (success) {
                    tail = Arrays.asList(elements).subList(counter + 1, elements.length);
                    break;
                }
                ++counter;
            }
            if (tail != null) {
                this.featureExpression = this.comparator != null && this.argument != null ? new FeatureMatchExpression(this, this.comparator, this.argument) : new SimpleFeatureExpression(this);
                this.features = tail;
            }
        }
        if (this.featureExpression == null && this.comparator != null && this.argument != null) {
            this.featureExpression = new FeatureMatchExpression(this, this.comparator, this.argument);
        }
        this.initialized = true;
        if (this.typeExpression == null && this.typeListExpression == null && this.annotationExpression == null && this.annotationListExpression == null) {
            throw new IllegalArgumentException("Not able to resolve annotation/type expression: " + this.reference + " in script " + context.getParent().getName());
        }
    }

    private boolean buildTypeOrAnnotationExpression(String candidate, RutaEnvironment environment, MatchContext context, RutaStream stream) {
        IndexedReference indexedReference = ParsingUtils.parseIndexedReference(candidate);
        if (indexedReference.index >= 0) {
            if (environment.isVariableOfType(candidate, "ANNOTATIONLIST")) {
                this.annotationExpression = new AnnotationListVariableIndexExpression(indexedReference.reference, indexedReference.index);
                return true;
            }
        } else {
            if (environment.isVariableOfType(candidate, "TYPE")) {
                this.typeExpression = new TypeVariableExpression(candidate);
                return true;
            }
            if (environment.isVariableOfType(candidate, "TYPELIST")) {
                this.typeListExpression = new TypeListVariableExpression(candidate);
                return true;
            }
            if (environment.isVariableOfType(candidate, "ANNOTATION")) {
                this.annotationExpression = new AnnotationVariableExpression(candidate);
                this.annotationListExpression = new AnnotationListDelegateVariableExpression(candidate);
                return true;
            }
            if (environment.isVariableOfType(candidate, "ANNOTATIONLIST")) {
                this.annotationListExpression = new AnnotationListVariableExpression(candidate);
                return true;
            }
            if (environment.getType(candidate) != null) {
                this.typeExpression = new SimpleTypeExpression(candidate);
                return true;
            }
        }
        return false;
    }

    public ITypeExpression getTypeExpression(MatchContext context, RutaStream stream) {
        this.resolve(context, stream);
        return this.typeExpression;
    }

    public ITypeListExpression getTypeListExpression(MatchContext context, RutaStream stream) {
        this.resolve(context, stream);
        return this.typeListExpression;
    }

    public IAnnotationExpression getAnnotationExpression(MatchContext context, RutaStream stream) {
        this.resolve(context, stream);
        return this.annotationExpression;
    }

    public IAnnotationListExpression getAnnotationListExpression(MatchContext context, RutaStream stream) {
        this.resolve(context, stream);
        return this.annotationListExpression;
    }

    public FeatureExpression getFeatureExpression(MatchContext context, RutaStream stream) {
        this.resolve(context, stream);
        return this.featureExpression;
    }

    public String toString() {
        if (this.reference != null) {
            if (this.comparator != null && this.argument != null) {
                return this.reference + this.comparator + this.argument.toString();
            }
            return this.reference;
        }
        if (this.typeExpression != null) {
            return this.typeExpression.toString();
        }
        if (this.typeListExpression != null) {
            return this.typeListExpression.toString();
        }
        if (this.annotationExpression != null) {
            return this.annotationExpression.toString();
        }
        if (this.annotationListExpression != null) {
            return this.annotationListExpression.toString();
        }
        return super.toString();
    }

    public String getMatch() {
        return this.reference;
    }

    public List<String> getFeatureList() {
        return this.features;
    }

    public IRutaExpression getArgument() {
        return this.argument;
    }

    public String getComparator() {
        return this.comparator;
    }
}

