/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.condition;

import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.condition.TypeSentiveCondition;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.expression.number.SimpleNumberExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class CurrentCountCondition
extends TypeSentiveCondition {
    private final INumberExpression min;
    private final INumberExpression max;
    private final String var;

    public CurrentCountCondition(ITypeExpression type, INumberExpression min, INumberExpression max, String var) {
        super(type);
        this.min = min == null ? new SimpleNumberExpression(Integer.MIN_VALUE) : min;
        this.max = max == null ? new SimpleNumberExpression(Integer.MAX_VALUE) : max;
        this.var = var;
    }

    @Override
    public EvaluatedCondition eval(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        AnnotationFS annotation = context.getAnnotation();
        RuleElement element = context.getElement();
        Type t = this.type.getType(context, stream);
        if (t == null) {
            return new EvaluatedCondition(this, false);
        }
        int count = 0;
        if (annotation != null) {
            AnnotationFS next;
            FSIterator it = stream.getCas().getAnnotationIndex(t).iterator();
            while (it.hasNext() && (next = (AnnotationFS)it.next()).getBegin() < annotation.getBegin()) {
                ++count;
            }
        }
        if (this.var != null) {
            element.getParent().getEnvironment().setVariableValue(this.var, count);
        }
        boolean value = count >= this.min.getIntegerValue(context, stream) && count <= this.max.getIntegerValue(context, stream);
        return new EvaluatedCondition(this, value);
    }

    public INumberExpression getMin() {
        return this.min;
    }

    public INumberExpression getMax() {
        return this.max;
    }

    public String getVar() {
        return this.var;
    }
}

