/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.condition;

import java.util.List;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.condition.TerminalRutaCondition;
import org.apache.uima.ruta.expression.resource.WordListExpression;
import org.apache.uima.ruta.expression.string.AbstractStringListExpression;
import org.apache.uima.ruta.expression.string.IStringExpression;
import org.apache.uima.ruta.resource.RutaWordList;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class InListCondition
extends TerminalRutaCondition {
    private WordListExpression listExpr;
    private AbstractStringListExpression stringList;
    private IStringExpression arg;

    public InListCondition(WordListExpression listExpr, IStringExpression arg) {
        this.listExpr = listExpr;
        this.arg = arg;
    }

    public InListCondition(AbstractStringListExpression list, IStringExpression arg) {
        this.stringList = list;
        this.arg = arg;
    }

    @Override
    public EvaluatedCondition eval(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        AnnotationFS annotation = context.getAnnotation();
        if (annotation == null) {
            return new EvaluatedCondition(this, false);
        }
        String text = annotation.getCoveredText();
        if (this.arg != null) {
            text = this.arg.getStringValue(context, stream);
        }
        if (text == null) {
            return new EvaluatedCondition(this, false);
        }
        if (this.stringList == null) {
            RutaWordList wordList = this.listExpr.getList(context, stream);
            boolean contains = false;
            if (wordList != null) {
                contains = wordList.contains(text, false, 0, null, 0, true);
            }
            return new EvaluatedCondition(this, contains);
        }
        List sList = this.stringList.getList(context, stream);
        boolean contains = sList.contains(text);
        return new EvaluatedCondition(this, contains);
    }

    public WordListExpression getListExpression() {
        return this.listExpr;
    }

    public AbstractStringListExpression getStringList() {
        return this.stringList;
    }

    public IStringExpression getArg() {
        return this.arg;
    }
}

