/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractStructureAction;
import org.apache.uima.ruta.expression.IRutaExpression;
import org.apache.uima.ruta.expression.list.ListExpression;
import org.apache.uima.ruta.expression.number.AbstractNumberListExpression;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.expression.string.IStringExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleElementMatch;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.type.RutaFrame;
import org.apache.uima.ruta.utils.UIMAUtils;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class GatherAction
extends AbstractStructureAction {
    private ITypeExpression structureType;
    private Map<IStringExpression, IRutaExpression> features;
    private List<INumberExpression> indexes;

    public GatherAction(ITypeExpression structureType, Map<IStringExpression, IRutaExpression> features, List<INumberExpression> indexes) {
        this.structureType = structureType;
        this.features = features == null ? new HashMap() : features;
        this.indexes = indexes == null || indexes.isEmpty() ? null : indexes;
    }

    @Override
    public void execute(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        RuleMatch match = context.getRuleMatch();
        RuleElement element = context.getElement();
        Type type = this.structureType.getType(context, stream);
        if (type == null) {
            return;
        }
        List<Integer> indexList = this.getIndexList(this.indexes, context, stream);
        List<AnnotationFS> matchedAnnotations = match.getMatchedAnnotations(indexList, element.getContainer());
        for (AnnotationFS matchedAnnotation : matchedAnnotations) {
            if (matchedAnnotation == null) {
                return;
            }
            FeatureStructure newFS = stream.getCas().createFS(type);
            if (newFS instanceof Annotation) {
                Annotation a = (Annotation)newFS;
                a.setBegin(matchedAnnotation.getBegin());
                a.setEnd(matchedAnnotation.getEnd());
                stream.addAnnotation((AnnotationFS)a, match);
                this.addAnnotationToLabel((AnnotationFS)a, context);
            }
            TOP newStructure = null;
            if (!(newFS instanceof TOP)) continue;
            newStructure = (TOP)newFS;
            this.gatherFeatures(newStructure, this.features, matchedAnnotation, context, stream);
            newStructure.addToIndexes();
        }
    }

    private void gatherFeatures(TOP structure, Map<IStringExpression, IRutaExpression> features, AnnotationFS matchedAnnotation, MatchContext context, RutaStream stream) {
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        for (Map.Entry<IStringExpression, IRutaExpression> each : features.entrySet()) {
            IStringExpression ne;
            context.getParent();
            String value = each.getKey().getStringValue(context, stream);
            IRutaExpression expr = each.getValue();
            ArrayList<Integer> ints = new ArrayList<Integer>();
            if (expr instanceof INumberExpression) {
                ne = (INumberExpression)expr;
                ints.add(ne.getIntegerValue(context, stream));
                map.put(value, ints);
                continue;
            }
            if (!(expr instanceof AbstractNumberListExpression)) continue;
            ne = (AbstractNumberListExpression)expr;
            map.put(value, ((ListExpression)ne).getList(context, stream));
        }
        TypeSystem typeSystem = stream.getCas().getTypeSystem();
        JCas jcas = stream.getJCas();
        List featuresList = structure.getType().getFeatures();
        for (int i = 0; i < featuresList.size(); ++i) {
            Feature targetFeature = (Feature)featuresList.get(i);
            String name = targetFeature.getName();
            String shortFName = name.substring(name.indexOf(":") + 1, name.length());
            List reIndexes = (List)map.get(shortFName);
            if (reIndexes == null || reIndexes.isEmpty()) continue;
            Type range = targetFeature.getRange();
            List<RuleElementMatch> tms = this.getMatchInfo(context.getRuleMatch(), context.getElement(), reIndexes);
            if (tms.size() == 0) continue;
            if (tms.size() == 1) {
                Collection endAnchors;
                RuleElementMatch tm = tms.get(0);
                List<AnnotationFS> textsMatched = tm.getTextsMatched();
                if (textsMatched.size() != 1) continue;
                AnnotationFS fs = textsMatched.get(0);
                if (typeSystem.subsumes(jcas.getCasType(FSArray.type), range)) {
                    ArrayList<AnnotationFS> list = new ArrayList<AnnotationFS>();
                    list.add(fs);
                    structure.setFeatureValue(targetFeature, UIMAUtils.toFSArray(jcas, list));
                    continue;
                }
                if (typeSystem.subsumes(range, fs.getType())) {
                    structure.setFeatureValue(targetFeature, (FeatureStructure)fs);
                    continue;
                }
                Collection beginAnchors = stream.getBeginAnchor(fs.getBegin()).getBeginAnchors(range);
                Collection intersection = CollectionUtils.intersection((Iterable)beginAnchors, (Iterable)(endAnchors = stream.getEndAnchor(fs.getEnd()).getEndAnchors(range)));
                if (intersection.size() < 1) continue;
                structure.setFeatureValue(targetFeature, (FeatureStructure)intersection.iterator().next());
                continue;
            }
            List<AnnotationFS> textsMatched = this.getMatchedText(tms);
            if (typeSystem.subsumes(jcas.getCasType(FSArray.type), range)) {
                structure.setFeatureValue(targetFeature, UIMAUtils.toFSArray(jcas, textsMatched));
                continue;
            }
            int begin = textsMatched.get(0).getBegin();
            int end = textsMatched.get(textsMatched.size() - 1).getEnd();
            RutaFrame frame = new RutaFrame(jcas, begin, end);
            FSIterator iterator = jcas.getAnnotationIndex(range).iterator((FeatureStructure)frame);
            AnnotationFS newA = null;
            while (iterator.isValid()) {
                Annotation a = (Annotation)iterator.get();
                if (a.getBegin() == begin && a.getEnd() == end && jcas.getTypeSystem().subsumes(range, a.getType())) {
                    newA = a;
                } else if (a.getBegin() > begin || a.getEnd() < end) break;
                iterator.moveToNext();
            }
            if (newA == null) {
                newA = jcas.getCas().createAnnotation(range, begin, end);
            }
            structure.setFeatureValue(targetFeature, newA);
        }
    }

    private List<AnnotationFS> getMatchedText(List<RuleElementMatch> tms) {
        ArrayList<AnnotationFS> result = new ArrayList<AnnotationFS>();
        for (RuleElementMatch each : tms) {
            result.addAll(each.getTextsMatched());
        }
        return result;
    }

    private List<RuleElementMatch> getMatchInfo(RuleMatch match, RuleElement element, List<Number> reIndexes) {
        ArrayList<RuleElementMatch> result = new ArrayList<RuleElementMatch>();
        List<RuleElement> elements = element.getContainer().getRuleElements();
        for (Number eachNumber : reIndexes) {
            int eachInt = eachNumber.intValue();
            RuleElement ruleElement = elements.get(eachInt - 1);
            List<List<RuleElementMatch>> matchInfo = match.getMatchInfo(ruleElement);
            for (List<RuleElementMatch> list : matchInfo) {
                if (list == null) continue;
                result.addAll(list);
            }
        }
        return result;
    }

    public ITypeExpression getStructureType() {
        return this.structureType;
    }

    public Map<IStringExpression, IRutaExpression> getFeatures() {
        return this.features;
    }

    public List<INumberExpression> getIndexes() {
        return this.indexes;
    }
}

