/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.quartz.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.fulcrum.quartz.QuartzScheduler;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;

public class QuartzSchedulerImpl
extends AbstractLogEnabled
implements QuartzScheduler,
Configurable,
Serviceable,
Disposable,
Initializable,
ThreadSafe,
JobListener,
Startable {
    private static final String CONFIG_CONFIGURATION = "configuration";
    private static final String CONFIG_PROPERTY_FILE = "quartzPropertyFile";
    private static final String CONFIG_PROPERTIES = "properties";
    private ServiceManager serviceManager;
    private Scheduler scheduler;
    private String quartzPropertyFile;
    private Properties quartzProperties;

    public void configure(Configuration conf) throws ConfigurationException {
        Configuration quartzConf = conf.getChild(CONFIG_CONFIGURATION, true);
        if (quartzConf.getChild(CONFIG_PROPERTIES, false) != null) {
            this.quartzProperties = Parameters.toProperties((Parameters)Parameters.fromConfiguration((Configuration)quartzConf.getChild(CONFIG_PROPERTIES)));
        } else if (quartzConf.getChild(CONFIG_PROPERTY_FILE, false) != null) {
            this.quartzPropertyFile = quartzConf.getChild(CONFIG_PROPERTY_FILE).getValue();
        }
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.serviceManager = manager;
    }

    public void initialize() throws Exception {
        StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
        if (this.quartzProperties != null) {
            this.getLogger().info("Pulling quartz configuration from the container XML configuration");
            schedulerFactory.initialize(this.quartzProperties);
        } else if (this.quartzPropertyFile != null) {
            this.getLogger().info("Pulling quartz configuration from the following property file : " + this.quartzPropertyFile);
            schedulerFactory.initialize(this.quartzPropertyFile);
        } else {
            this.getLogger().info("Using Quartz default configuration since no user-supplied configuration was found");
            schedulerFactory.initialize();
        }
        this.scheduler = schedulerFactory.getScheduler();
        this.getScheduler().getListenerManager().addJobListener((JobListener)this, new ArrayList());
    }

    public void start() throws Exception {
        this.getScheduler().start();
        if (this.getLogger().isInfoEnabled()) {
            this.logSchedulerConfiguration();
        }
    }

    public void stop() throws Exception {
        this.getScheduler().standby();
    }

    public void dispose() {
        try {
            this.scheduler.shutdown(true);
        }
        catch (SchedulerException e) {
            this.getLogger().warn("Problem shutting down quartz scheduler ", (Throwable)e);
        }
        this.scheduler = null;
        this.serviceManager = null;
    }

    @Override
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public void jobToBeExecuted(JobExecutionContext context) {
        Job job = context.getJobInstance();
        if (job instanceof LogEnabled) {
            ((LogEnabled)job).enableLogging(this.getLogger());
        }
        if (job instanceof Serviceable) {
            try {
                ((Serviceable)job).service(this.serviceManager);
            }
            catch (ServiceException e) {
                this.getLogger().error("Error servicing Job[" + String.valueOf(job) + "]", (Throwable)e);
            }
        }
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException ex) {
        if (ex != null) {
            String msg = "Executing the job '" + String.valueOf(context.getJobDetail().getKey()) + "' failed";
            this.getLogger().error(msg, ex.getCause());
        } else if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Executing the job '" + String.valueOf(context.getJobDetail().getKey()) + "' took " + context.getJobRunTime() + " ms");
        }
    }

    public void jobExecutionVetoed(JobExecutionContext context) {
    }

    private void logSchedulerConfiguration() throws SchedulerException {
        for (String jobGroup : this.getScheduler().getJobGroupNames()) {
            Set jobsInGroup = this.getScheduler().getJobKeys(GroupMatcher.jobGroupEquals((String)jobGroup));
            this.getLogger().info("Job Group: " + jobGroup + " contains the following number of jobs : " + jobsInGroup.size());
            for (JobKey jobKey : jobsInGroup) {
                StringBuilder buffer = new StringBuilder();
                JobDetail jobDetail = this.getScheduler().getJobDetail(jobKey);
                List jobTriggers = this.getScheduler().getTriggersOfJob(jobKey);
                buffer.append(jobDetail.getKey());
                buffer.append(" => ");
                if (jobTriggers != null && !jobTriggers.isEmpty()) {
                    Trigger jt = (Trigger)jobTriggers.get(0);
                    buffer.append(jt.getKey());
                    buffer.append(" (");
                    buffer.append(jt.getNextFireTime());
                    buffer.append(")");
                } else {
                    buffer.append("no trigger defined");
                }
                this.getLogger().info(buffer.toString());
            }
        }
    }
}

