/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.util;

public class IPAddress {
    public static boolean isValid(String string2) {
        return IPAddress.isValidIPv4(string2) || IPAddress.isValidIPv6(string2);
    }

    public static boolean isValidWithNetMask(String string2) {
        return IPAddress.isValidIPv4WithNetmask(string2) || IPAddress.isValidIPv6WithNetmask(string2);
    }

    public static boolean isValidIPv4(String string2) {
        int n;
        if (string2.length() == 0) {
            return false;
        }
        int n2 = 0;
        String string3 = string2 + ".";
        int n3 = 0;
        while (n3 < string3.length() && (n = string3.indexOf(46, n3)) > n3) {
            int n4;
            if (n2 == 4) {
                return false;
            }
            try {
                n4 = Integer.parseInt(string3.substring(n3, n));
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (n4 < 0 || n4 > 255) {
                return false;
            }
            n3 = n + 1;
            ++n2;
        }
        return n2 == 4;
    }

    public static boolean isValidIPv4WithNetmask(String string2) {
        int n = string2.indexOf("/");
        String string3 = string2.substring(n + 1);
        return n > 0 && IPAddress.isValidIPv4(string2.substring(0, n)) && (IPAddress.isValidIPv4(string3) || IPAddress.isMaskValue(string3, 32));
    }

    public static boolean isValidIPv6WithNetmask(String string2) {
        int n = string2.indexOf("/");
        String string3 = string2.substring(n + 1);
        return n > 0 && IPAddress.isValidIPv6(string2.substring(0, n)) && (IPAddress.isValidIPv6(string3) || IPAddress.isMaskValue(string3, 128));
    }

    private static boolean isMaskValue(String string2, int n) {
        try {
            int n2 = Integer.parseInt(string2);
            return n2 >= 0 && n2 <= n;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isValidIPv6(String string2) {
        int n;
        if (string2.length() == 0) {
            return false;
        }
        int n2 = 0;
        String string3 = string2 + ":";
        boolean bl = false;
        int n3 = 0;
        while (n3 < string3.length() && (n = string3.indexOf(58, n3)) >= n3) {
            if (n2 == 8) {
                return false;
            }
            if (n3 != n) {
                String string4 = string3.substring(n3, n);
                if (n == string3.length() - 1 && string4.indexOf(46) > 0) {
                    if (!IPAddress.isValidIPv4(string4)) {
                        return false;
                    }
                    ++n2;
                } else {
                    int n4;
                    try {
                        n4 = Integer.parseInt(string3.substring(n3, n), 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return false;
                    }
                    if (n4 < 0 || n4 > 65535) {
                        return false;
                    }
                }
            } else {
                if (n != 1 && n != string3.length() - 1 && bl) {
                    return false;
                }
                bl = true;
            }
            n3 = n + 1;
            ++n2;
        }
        return n2 == 8 || bl;
    }
}

