/*
 * Decompiled with CFR 0.152.
 */
package org.jabsorb.serializer;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jabsorb.ExceptionTransformer;
import org.jabsorb.JSONRPCResult;
import org.jabsorb.JSONSerializer;
import org.jabsorb.callback.CallbackController;
import org.jabsorb.localarg.LocalArgController;
import org.jabsorb.reflect.AccessibleObjectKey;
import org.jabsorb.serializer.AccessibleObjectCandidate;
import org.jabsorb.serializer.MarshallException;
import org.jabsorb.serializer.ObjectMatch;
import org.jabsorb.serializer.SerializerState;
import org.jabsorb.serializer.UnmarshallException;
import org.json.JSONArray;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessibleObjectResolver {
    private static final Logger log = LoggerFactory.getLogger(AccessibleObjectResolver.class);
    private static final Map primitiveRankings;

    public static JSONRPCResult invokeAccessibleObject(AccessibleObject accessibleObject, Object[] context, JSONArray arguments, Object javascriptObject, Object requestId, JSONSerializer serializer, CallbackController cbc, ExceptionTransformer exceptionTransformer) {
        JSONRPCResult result;
        try {
            boolean isConstructor = accessibleObject instanceof Constructor;
            if (log.isDebugEnabled()) {
                if (!isConstructor) {
                    log.debug("invoking " + ((Method)accessibleObject).getReturnType().getName() + " " + ((Method)accessibleObject).getName() + "(" + AccessibleObjectResolver.argSignature(accessibleObject) + ")");
                } else {
                    log.debug("invoking " + ((Constructor)accessibleObject).getName() + " (" + AccessibleObjectResolver.argSignature(accessibleObject) + ")");
                }
            }
            Class[] parameterTypes = isConstructor ? ((Constructor)accessibleObject).getParameterTypes() : ((Method)accessibleObject).getParameterTypes();
            Object[] javaArgs = AccessibleObjectResolver.unmarshallArgs(context, parameterTypes, arguments, serializer);
            if (cbc != null) {
                for (int i = 0; i < context.length; ++i) {
                    cbc.preInvokeCallback(context[i], javascriptObject, accessibleObject, javaArgs);
                }
            }
            Object returnObj = isConstructor ? ((Constructor)accessibleObject).newInstance(javaArgs) : ((Method)accessibleObject).invoke(javascriptObject, javaArgs);
            if (cbc != null) {
                for (int i = 0; i < context.length; ++i) {
                    cbc.postInvokeCallback(context[i], javascriptObject, accessibleObject, returnObj);
                }
            }
            SerializerState serializerState = new SerializerState();
            Object json = serializer.marshall(serializerState, null, returnObj, "r");
            result = new JSONRPCResult(0, requestId, json, serializerState.getFixUps());
        }
        catch (UnmarshallException e) {
            if (cbc != null) {
                for (int i = 0; i < context.length; ++i) {
                    cbc.errorCallback(context[i], javascriptObject, accessibleObject, e);
                }
            }
            result = new JSONRPCResult(592, requestId, e.getMessage());
        }
        catch (MarshallException e) {
            if (cbc != null) {
                for (int i = 0; i < context.length; ++i) {
                    cbc.errorCallback(context[i], javascriptObject, accessibleObject, e);
                }
            }
            result = new JSONRPCResult(593, requestId, e.getMessage());
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            if ("org.mortbay.jetty.RetryRequest".equals(e.getClass().getName())) {
                throw (RuntimeException)e;
            }
            if (cbc != null) {
                for (int i = 0; i < context.length; ++i) {
                    cbc.errorCallback(context[i], javascriptObject, accessibleObject, e);
                }
            }
            result = new JSONRPCResult(490, requestId, exceptionTransformer.transform(e));
        }
        return result;
    }

    public static AccessibleObject resolveMethod(Map methodMap, String methodName, JSONArray arguments, JSONSerializer serializer) {
        AccessibleObjectKey mk = new AccessibleObjectKey(methodName, arguments.length());
        List accessibleObjects = (List)methodMap.get(mk);
        if (accessibleObjects == null || accessibleObjects.size() == 0) {
            return null;
        }
        if (accessibleObjects.size() == 1) {
            return (AccessibleObject)accessibleObjects.get(0);
        }
        ArrayList<AccessibleObjectCandidate> candidate = new ArrayList<AccessibleObjectCandidate>();
        if (log.isDebugEnabled()) {
            log.debug("looking for method " + methodName + "(" + AccessibleObjectResolver.argSignature(arguments) + ")");
        }
        for (int i = 0; i < accessibleObjects.size(); ++i) {
            AccessibleObject accessibleObject = (AccessibleObject)accessibleObjects.get(i);
            Class[] parameterTypes = null;
            if (accessibleObject instanceof Method) {
                parameterTypes = ((Method)accessibleObject).getParameterTypes();
            } else if (accessibleObject instanceof Constructor) {
                parameterTypes = ((Constructor)accessibleObject).getParameterTypes();
            }
            try {
                candidate.add(AccessibleObjectResolver.tryUnmarshallArgs(accessibleObject, arguments, parameterTypes, serializer));
                if (!log.isDebugEnabled()) continue;
                log.debug("+++ possible match with method " + methodName + "(" + AccessibleObjectResolver.argSignature(accessibleObject) + ")");
                continue;
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) continue;
                log.debug("xxx " + e.getMessage() + " in " + methodName + "(" + AccessibleObjectResolver.argSignature(accessibleObject) + ")");
            }
        }
        AccessibleObjectCandidate best = null;
        for (int i = 0; i < candidate.size(); ++i) {
            AccessibleObjectCandidate c = (AccessibleObjectCandidate)candidate.get(i);
            if (best == null) {
                best = c;
                continue;
            }
            ObjectMatch bestMatch = best.getMatch();
            ObjectMatch cMatch = c.getMatch();
            if (bestMatch.getMismatch() > cMatch.getMismatch()) {
                best = c;
                continue;
            }
            if (bestMatch.getMismatch() != cMatch.getMismatch()) continue;
            best = AccessibleObjectResolver.betterSignature(best, c);
        }
        if (best != null) {
            AccessibleObject ao = best.getAccessibleObject();
            if (log.isDebugEnabled()) {
                log.debug("found method " + methodName + "(" + AccessibleObjectResolver.argSignature(ao) + ")");
            }
            return ao;
        }
        return null;
    }

    private static String argSignature(AccessibleObject accessibleObject) {
        Class<?>[] param = accessibleObject instanceof Method ? ((Method)accessibleObject).getParameterTypes() : ((Constructor)accessibleObject).getParameterTypes();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < param.length; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(param[i].getName());
        }
        return buf.toString();
    }

    private static String argSignature(JSONArray arguments) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < arguments.length(); ++i) {
            Object jso;
            if (i > 0) {
                buf.append(",");
            }
            try {
                jso = arguments.get(i);
            }
            catch (JSONException e) {
                throw (NoSuchElementException)new NoSuchElementException(e.getMessage()).initCause(e);
            }
            if (jso == null) {
                buf.append("java.lang.Object");
                continue;
            }
            if (jso instanceof String) {
                buf.append("java.lang.String");
                continue;
            }
            if (jso instanceof Number) {
                buf.append("java.lang.Number");
                continue;
            }
            if (jso instanceof JSONArray) {
                buf.append("java.lang.Object[]");
                continue;
            }
            buf.append("java.lang.Object");
        }
        return buf.toString();
    }

    private static AccessibleObjectCandidate betterSignature(AccessibleObjectCandidate methodCandidate, AccessibleObjectCandidate methodCandidate1) {
        Class[] parameters = methodCandidate.getParameterTypes();
        Class[] parameters1 = methodCandidate1.getParameterTypes();
        int c = 0;
        int c1 = 0;
        for (int i = 0; i < parameters.length; ++i) {
            Class parameterClass = parameters[i];
            Class parameterClass1 = parameters1[i];
            if (parameterClass == parameterClass1) continue;
            if (parameterClass.isPrimitive() && parameterClass1.isPrimitive()) {
                if ((Integer)primitiveRankings.get(parameterClass.getName()) < (Integer)primitiveRankings.get(parameterClass1.getName())) {
                    ++c;
                    continue;
                }
                ++c1;
                continue;
            }
            if (parameterClass.isAssignableFrom(parameterClass1)) {
                ++c1;
                continue;
            }
            ++c;
        }
        if (c1 > c) {
            return methodCandidate1;
        }
        return methodCandidate;
    }

    private static AccessibleObjectCandidate tryUnmarshallArgs(AccessibleObject accessibleObject, JSONArray arguments, Class[] parameterTypes, JSONSerializer serializer) throws UnmarshallException {
        int i;
        ObjectMatch[] matches = new ObjectMatch[parameterTypes.length];
        try {
            int nonLocalArgIndex = 0;
            for (i = 0; i < parameterTypes.length; ++i) {
                SerializerState serialiserState = new SerializerState();
                matches[i] = LocalArgController.isLocalArg(parameterTypes[i]) ? ObjectMatch.OKAY : serializer.tryUnmarshall(serialiserState, parameterTypes[i], arguments.get(nonLocalArgIndex++));
            }
        }
        catch (JSONException e) {
            throw (NoSuchElementException)new NoSuchElementException(e.getMessage()).initCause(e);
        }
        catch (UnmarshallException e) {
            throw new UnmarshallException("arg " + (i + 1) + " " + e.getMessage(), e);
        }
        AccessibleObjectCandidate candidate = new AccessibleObjectCandidate(accessibleObject, parameterTypes, matches);
        return candidate;
    }

    private static Object[] unmarshallArgs(Object[] context, Class[] param, JSONArray arguments, JSONSerializer serializer) throws UnmarshallException {
        int i;
        Object[] javaArgs = new Object[param.length];
        int j = 0;
        try {
            for (i = 0; i < param.length; ++i) {
                SerializerState serializerState = new SerializerState();
                javaArgs[i] = LocalArgController.isLocalArg(param[i]) ? LocalArgController.resolveLocalArg(context, param[i]) : serializer.unmarshall(serializerState, param[i], arguments.get(j++));
            }
        }
        catch (JSONException e) {
            throw (NoSuchElementException)new NoSuchElementException(e.getMessage()).initCause(e);
        }
        catch (UnmarshallException e) {
            throw new UnmarshallException("arg " + (i + 1) + " could not unmarshall", e);
        }
        return javaArgs;
    }

    static {
        int counter = 0;
        primitiveRankings = new HashMap();
        primitiveRankings.put("byte", counter++);
        primitiveRankings.put("short", counter++);
        primitiveRankings.put("int", counter++);
        primitiveRankings.put("long", counter++);
        primitiveRankings.put("float", counter++);
        primitiveRankings.put("double", counter++);
        primitiveRankings.put("boolean", counter++);
    }
}

