/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.model;

import jakarta.xml.bind.annotation.XmlEnum;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import org.apache.fulcrum.intake.IntakeException;
import org.apache.fulcrum.intake.model.BigDecimalField;
import org.apache.fulcrum.intake.model.BooleanField;
import org.apache.fulcrum.intake.model.DateStringField;
import org.apache.fulcrum.intake.model.DoubleField;
import org.apache.fulcrum.intake.model.Field;
import org.apache.fulcrum.intake.model.FloatField;
import org.apache.fulcrum.intake.model.Group;
import org.apache.fulcrum.intake.model.IntegerField;
import org.apache.fulcrum.intake.model.LongField;
import org.apache.fulcrum.intake.model.ShortField;
import org.apache.fulcrum.intake.model.StringField;
import org.apache.fulcrum.intake.model.UploadPartField;
import org.apache.fulcrum.intake.model.XmlField;

@XmlEnum(value=String.class)
public enum FieldType implements Serializable
{
    FIELD_BOOLEAN("boolean"){

        @Override
        public Field<?> getInstance(XmlField f, Group g) throws IntakeException {
            return new BooleanField(f, g);
        }
    }
    ,
    FIELD_BIGDECIMAL("BigDecimal"){

        @Override
        public Field<?> getInstance(XmlField f, Group g) throws IntakeException {
            return new BigDecimalField(f, g);
        }
    }
    ,
    FIELD_INT("int"){

        @Override
        public Field<?> getInstance(XmlField f, Group g) throws IntakeException {
            return new IntegerField(f, g);
        }
    }
    ,
    FIELD_FLOAT("float"){

        @Override
        public Field<?> getInstance(XmlField f, Group g) throws IntakeException {
            return new FloatField(f, g);
        }
    }
    ,
    FIELD_FILEITEM("FileItem"){

        @Override
        public Field<?> getInstance(XmlField f, Group g) throws IntakeException {
            return new UploadPartField(f, g);
        }
    }
    ,
    FIELD_UPLOADPART("UploadPart"){

        @Override
        public Field<?> getInstance(XmlField f, Group g) throws IntakeException {
            return new UploadPartField(f, g);
        }
    }
    ,
    FIELD_STRING("String"){

        @Override
        public Field<?> getInstance(XmlField f, Group g) throws IntakeException {
            return new StringField(f, g);
        }
    }
    ,
    FIELD_DATESTRING("DateString"){

        @Override
        public Field<?> getInstance(XmlField f, Group g) throws IntakeException {
            return new DateStringField(f, g);
        }
    }
    ,
    FIELD_COMBOKEY("ComboKey"){

        @Override
        public Field<?> getInstance(XmlField f, Group g) throws IntakeException {
            throw new IntakeException("An unsupported type has been specified for " + f.getName() + " in group " + g.getIntakeGroupName() + " type = " + this.value());
        }
    }
    ,
    FIELD_DOUBLE("double"){

        @Override
        public Field<?> getInstance(XmlField f, Group g) throws IntakeException {
            return new DoubleField(f, g);
        }
    }
    ,
    FIELD_SHORT("short"){

        @Override
        public Field<?> getInstance(XmlField f, Group g) throws IntakeException {
            return new ShortField(f, g);
        }
    }
    ,
    FIELD_LONG("long"){

        @Override
        public Field<?> getInstance(XmlField f, Group g) throws IntakeException {
            return new LongField(f, g);
        }
    }
    ,
    FIELD_CUSTOM("custom"){

        @Override
        public Field<?> getInstance(XmlField f, Group g) throws IntakeException {
            Object fieldClass = f.getFieldClass();
            if (fieldClass != null && ((String)fieldClass).indexOf(46) == -1) {
                fieldClass = "org.apache.fulcrum.intake.model." + (String)fieldClass;
            }
            if (fieldClass != null) {
                try {
                    Class<?> field = Class.forName((String)fieldClass);
                    Constructor<?> constructor = field.getConstructor(XmlField.class, Group.class);
                    return (Field)constructor.newInstance(f, g);
                }
                catch (ClassNotFoundException e) {
                    throw new IntakeException("Could not load Field class(" + (String)fieldClass + ")", e);
                }
                catch (Exception e) {
                    throw new IntakeException("Could not create new instance of Field(" + (String)fieldClass + ")", e);
                }
            }
            throw new IntakeException("Custom field types must define a fieldClass");
        }
    };

    private static final long serialVersionUID = -8563326491799622016L;
    private String stringValue;

    private FieldType(String stringValue) {
        this.stringValue = stringValue;
    }

    public String value() {
        return this.stringValue;
    }

    public abstract Field<?> getInstance(XmlField var1, Group var2) throws IntakeException;
}

