/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.turbine.Turbine;
import org.apache.turbine.annotation.TurbineConfiguration;
import org.apache.turbine.util.RunData;

public class TurbineConfig
implements ServletConfig,
ServletContext,
Initializable,
Disposable {
    @TurbineConfiguration(value="session.timeout")
    protected int timeout = -1;
    public static final String CONFIGURATION_PATH_KEY = "configuration";
    public static final String PROPERTIES_PATH_KEY = "properties";
    public static final String PROPERTIES_PATH_DEFAULT = "/WEB-INF/conf/TurbineResources.properties";
    protected File root;
    protected Map<String, Object> attributes;
    protected Map<String, String> initParams;
    private Turbine turbine;
    private final Logger log = LogManager.getLogger(this.getClass());

    public TurbineConfig(String path, Map<String, Object> attributes, Map<String, String> initParams) {
        this.root = new File(path);
        this.attributes = attributes;
        this.initParams = initParams;
    }

    public TurbineConfig(String path, Map<String, String> initParams) {
        this(path, new HashMap<String, Object>(0), initParams);
    }

    public TurbineConfig(String path, String properties) {
        this(path, new HashMap<String, String>(1));
        this.initParams.put(PROPERTIES_PATH_KEY, properties);
    }

    public void initialize() {
        try {
            this.turbine = new Turbine();
            this.turbine.init(this);
        }
        catch (Exception e) {
            this.log.error("TurbineConfig: Initialization failed", (Throwable)e);
        }
    }

    public void init(RunData data) {
        if (this.turbine != null) {
            this.turbine.init(data);
        }
    }

    public void dispose() {
        if (this.turbine != null) {
            this.turbine.destroy();
        }
    }

    public Turbine getTurbine() {
        return this.turbine;
    }

    public ServletContext getServletContext() {
        return this;
    }

    public String getRealPath(String path) {
        String result = null;
        File f = new File(this.root, path);
        if (this.log.isDebugEnabled()) {
            this.log.debug("TurbineConfig.getRealPath: path '{}' translated to '{}' {}found", (Object)path, (Object)f.getPath(), (Object)(f.exists() ? "" : "not "));
        }
        if (f.exists()) {
            result = f.getPath();
        } else {
            this.log.error("getRealPath(\"{}\") is undefined, returning null", (Object)path);
        }
        return result;
    }

    public String getInitParameter(String name) {
        return this.initParams.get(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return new Vector<String>(this.initParams.keySet()).elements();
    }

    public String getServletName() {
        return "Turbine";
    }

    public String getServletContextName() {
        return "Turbine";
    }

    public String getContextPath() {
        return "/turbine";
    }

    public URL getResource(String s) throws MalformedURLException {
        return new URL("file://" + this.getRealPath(s));
    }

    public InputStream getResourceAsStream(String s) {
        try {
            FileInputStream fis = new FileInputStream(this.getRealPath(s));
            return new BufferedInputStream(fis);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    @Deprecated
    public void log(Exception e, String m) {
        this.log.info(m, (Throwable)e);
    }

    public void log(String m) {
        this.log.info(m);
    }

    public void log(String m, Throwable t) {
        this.log.info(m, t);
    }

    public Object getAttribute(String s) {
        return this.attributes.get(s);
    }

    public Enumeration<String> getAttributeNames() {
        return new Vector<String>(this.attributes.keySet()).elements();
    }

    public ServletContext getContext(String s) {
        throw new UnsupportedOperationException();
    }

    public int getMajorVersion() {
        throw new UnsupportedOperationException();
    }

    public String getMimeType(String s) {
        throw new UnsupportedOperationException();
    }

    public int getMinorVersion() {
        throw new UnsupportedOperationException();
    }

    public RequestDispatcher getNamedDispatcher(String s) {
        throw new UnsupportedOperationException();
    }

    public RequestDispatcher getRequestDispatcher(String s) {
        throw new UnsupportedOperationException();
    }

    public Set<String> getResourcePaths(String s) {
        throw new UnsupportedOperationException();
    }

    public String getServerInfo() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Servlet getServlet(String s) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Enumeration<String> getServletNames() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Enumeration<Servlet> getServlets() {
        throw new UnsupportedOperationException();
    }

    public void removeAttribute(String s) {
        throw new UnsupportedOperationException();
    }

    public void setAttribute(String s, Object o) {
        throw new UnsupportedOperationException();
    }

    public int getEffectiveMajorVersion() {
        throw new UnsupportedOperationException();
    }

    public int getEffectiveMinorVersion() {
        throw new UnsupportedOperationException();
    }

    public boolean setInitParameter(String name, String value) {
        throw new UnsupportedOperationException();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        throw new UnsupportedOperationException();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        throw new UnsupportedOperationException();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        throw new UnsupportedOperationException();
    }

    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public ServletRegistration getServletRegistration(String servletName) {
        throw new UnsupportedOperationException();
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        throw new UnsupportedOperationException();
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        throw new UnsupportedOperationException();
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        throw new UnsupportedOperationException();
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        throw new UnsupportedOperationException();
    }

    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        throw new UnsupportedOperationException();
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        throw new UnsupportedOperationException();
    }

    public SessionCookieConfig getSessionCookieConfig() {
        throw new UnsupportedOperationException();
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        throw new UnsupportedOperationException();
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        throw new UnsupportedOperationException();
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        throw new UnsupportedOperationException();
    }

    public void addListener(String className) {
        throw new UnsupportedOperationException();
    }

    public <T extends EventListener> void addListener(T t) {
        throw new UnsupportedOperationException();
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
        throw new UnsupportedOperationException();
    }

    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        throw new UnsupportedOperationException();
    }

    public ClassLoader getClassLoader() {
        throw new UnsupportedOperationException();
    }

    public void declareRoles(String ... roleNames) {
        throw new UnsupportedOperationException();
    }

    public String getVirtualServerName() {
        throw new UnsupportedOperationException();
    }
}

