/*
 * Decompiled with CFR 0.152.
 */
package org.jabsorb.serializer.impl;

import java.math.BigDecimal;
import org.jabsorb.serializer.AbstractSerializer;
import org.jabsorb.serializer.MarshallException;
import org.jabsorb.serializer.ObjectMatch;
import org.jabsorb.serializer.SerializerState;
import org.jabsorb.serializer.UnmarshallException;

public class NumberSerializer
extends AbstractSerializer {
    private static final long serialVersionUID = 2L;
    private static Class[] _serializableClasses = new Class[]{Integer.class, Byte.class, Short.class, Long.class, Float.class, Double.class, BigDecimal.class};
    private static Class[] _JSONClasses = new Class[]{Integer.class, Byte.class, Short.class, Long.class, Float.class, Double.class, BigDecimal.class, String.class};

    public Class[] getSerializableClasses() {
        return _serializableClasses;
    }

    public Class[] getJSONClasses() {
        return _JSONClasses;
    }

    public Object toNumber(Class clazz, Object jso) throws NumberFormatException {
        if (clazz == Integer.class) {
            if (jso instanceof String) {
                return new Integer((String)jso);
            }
            return new Integer(((Number)jso).intValue());
        }
        if (clazz == Long.class) {
            if (jso instanceof String) {
                return new Long((String)jso);
            }
            return new Long(((Number)jso).longValue());
        }
        if (clazz == Short.class) {
            if (jso instanceof String) {
                return new Short((String)jso);
            }
            return new Short(((Number)jso).shortValue());
        }
        if (clazz == Byte.class) {
            if (jso instanceof String) {
                return new Byte((String)jso);
            }
            return new Byte(((Number)jso).byteValue());
        }
        if (clazz == Float.class) {
            if (jso instanceof String) {
                return new Float((String)jso);
            }
            return new Float(((Number)jso).floatValue());
        }
        if (clazz == Double.class) {
            if (jso instanceof String) {
                return new Double((String)jso);
            }
            return new Double(((Number)jso).doubleValue());
        }
        if (clazz == BigDecimal.class) {
            if (jso instanceof String) {
                return new BigDecimal((String)jso);
            }
            return new BigDecimal(((Number)jso).doubleValue());
        }
        return null;
    }

    public ObjectMatch tryUnmarshall(SerializerState state, Class clazz, Object jso) throws UnmarshallException {
        try {
            this.toNumber(clazz, jso);
        }
        catch (NumberFormatException e) {
            throw new UnmarshallException("not a number", e);
        }
        state.setSerialized(jso, ObjectMatch.OKAY);
        return ObjectMatch.OKAY;
    }

    public Object unmarshall(SerializerState state, Class clazz, Object jso) throws UnmarshallException {
        try {
            if (jso == null || "".equals(jso)) {
                return null;
            }
            Object num = this.toNumber(clazz, jso);
            state.setSerialized(jso, num);
            return num;
        }
        catch (NumberFormatException e) {
            throw new UnmarshallException("cannot convert object " + jso + " to type " + clazz.getName(), e);
        }
    }

    public Object marshall(SerializerState state, Object p, Object o) throws MarshallException {
        return o;
    }
}

