/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.UserAgentAnalyzer;
import nl.basjes.parse.useragent.analyze.Analyzer;
import nl.basjes.parse.useragent.analyze.InvalidParserConfigurationException;
import nl.basjes.parse.useragent.analyze.Matcher;
import nl.basjes.parse.useragent.analyze.MatcherAction;
import nl.basjes.parse.useragent.analyze.UselessMatcherException;
import nl.basjes.parse.useragent.analyze.WordRangeVisitor;
import nl.basjes.parse.useragent.parse.UserAgentTreeFlattener;
import nl.basjes.parse.useragent.utils.Normalize;
import nl.basjes.parse.useragent.utils.VersionSplitter;
import nl.basjes.parse.useragent.utils.YamlUtils;
import nl.basjes.parse.useragent.utils.YauaaVersion;
import nl.basjes.shaded.com.google.common.net.InternetDomainName;
import nl.basjes.shaded.org.antlr.v4.runtime.tree.ParseTree;
import nl.basjes.shaded.org.springframework.core.io.Resource;
import nl.basjes.shaded.org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import nl.basjes.shaded.org.yaml.snakeyaml.Yaml;
import nl.basjes.shaded.org.yaml.snakeyaml.nodes.MappingNode;
import nl.basjes.shaded.org.yaml.snakeyaml.nodes.Node;
import nl.basjes.shaded.org.yaml.snakeyaml.nodes.NodeTuple;
import nl.basjes.shaded.org.yaml.snakeyaml.nodes.SequenceNode;
import nl.basjes.shaded.org.yaml.snakeyaml.reader.UnicodeReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DefaultSerializer(value=KryoSerializer.class)
public class UserAgentAnalyzerDirect
implements Analyzer,
Serializable {
    private static final int INFORM_ACTIONS_HASHMAP_CAPACITY = 1000000;
    private static final Logger LOG = LoggerFactory.getLogger(UserAgentAnalyzerDirect.class);
    private final List<Matcher> allMatchers = new ArrayList<Matcher>(5000);
    private final Map<String, Set<MatcherAction>> informMatcherActions = new HashMap<String, Set<MatcherAction>>(1000000);
    private transient Map<String, List<MappingNode>> matcherConfigs = new HashMap<String, List<MappingNode>>();
    private boolean showMatcherStats = false;
    private boolean doingOnlyASingleTest = false;
    List<String> wantedFieldNames = null;
    private final List<Map<String, Map<String, String>>> testCases = new ArrayList<Map<String, Map<String, String>>>(2048);
    private Map<String, Map<String, String>> lookups = new HashMap<String, Map<String, String>>(128);
    private final Map<String, Set<String>> lookupSets = new HashMap<String, Set<String>>(128);
    protected UserAgentTreeFlattener flattener;
    public static final int DEFAULT_USER_AGENT_MAX_LENGTH = 2048;
    private int userAgentMaxLength = 2048;
    private boolean loadTests = false;
    private static final String DEFAULT_RESOURCES = "classpath*:UserAgents/**/*.yaml";
    private boolean delayInitialization = true;
    private boolean matchersHaveBeenInitialized = false;
    private final Map<String, Set<WordRangeVisitor.Range>> informMatcherActionRanges = new HashMap<String, Set<WordRangeVisitor.Range>>(10000);
    public static final int MAX_PREFIX_HASH_MATCH = 3;
    private final Map<String, Set<Integer>> informMatcherActionPrefixesLengths = new HashMap<String, Set<Integer>>(1000);
    private boolean verbose = false;
    private static final List<String> HARD_CODED_GENERATED_FIELDS = new ArrayList<String>();
    private static final long MAX_PRE_HEAT_ITERATIONS = 1000000L;

    protected List<Matcher> getAllMatchers() {
        return this.allMatchers;
    }

    public List<Map<String, Map<String, String>>> getTestCases() {
        return this.testCases;
    }

    private void initTransientFields() {
        this.matcherConfigs = new HashMap<String, List<MappingNode>>(64);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.initTransientFields();
        stream.defaultReadObject();
        this.showDeserializationStats();
    }

    private void showDeserializationStats() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("This Analyzer instance was deserialized.");
        lines.add("");
        lines.add("Lookups      : " + (this.lookups == null ? 0 : this.lookups.size()));
        lines.add("LookupSets   : " + this.lookupSets.size());
        lines.add("Matchers     : " + this.allMatchers.size());
        lines.add("Hashmap size : " + this.informMatcherActions.size());
        lines.add("Ranges map   : " + this.informMatcherActionRanges.size());
        lines.add("Testcases    : " + this.testCases.size());
        YauaaVersion.logVersion(lines);
    }

    protected UserAgentAnalyzerDirect() {
    }

    public void delayInitialization() {
        this.delayInitialization = true;
    }

    public void immediateInitialization() {
        this.delayInitialization = false;
    }

    public UserAgentAnalyzerDirect setShowMatcherStats(boolean newShowMatcherStats) {
        this.showMatcherStats = newShowMatcherStats;
        return this;
    }

    public UserAgentAnalyzerDirect dropTests() {
        this.loadTests = false;
        this.testCases.clear();
        return this;
    }

    public UserAgentAnalyzerDirect keepTests() {
        this.loadTests = true;
        return this;
    }

    public boolean willKeepTests() {
        return this.loadTests;
    }

    public long getNumberOfTestCases() {
        return this.testCases.size();
    }

    protected void initialize() {
        this.initialize(Collections.singletonList(DEFAULT_RESOURCES));
    }

    protected void initialize(List<String> resources) {
        YauaaVersion.logVersion(new String[0]);
        resources.forEach(this::loadResources);
        this.verifyWeAreNotAskingForImpossibleFields();
        if (!this.delayInitialization) {
            this.initializeMatchers();
        }
    }

    protected void verifyWeAreNotAskingForImpossibleFields() {
        if (this.wantedFieldNames == null) {
            return;
        }
        ArrayList<String> impossibleFields = new ArrayList<String>();
        List<String> allPossibleFields = this.getAllPossibleFieldNamesSorted();
        for (String wantedFieldName : this.wantedFieldNames) {
            if (UserAgent.isSystemField(wantedFieldName) || allPossibleFields.contains(wantedFieldName)) continue;
            impossibleFields.add(wantedFieldName);
        }
        if (impossibleFields.isEmpty()) {
            return;
        }
        throw new InvalidParserConfigurationException("We cannot provide these fields:" + ((Object)impossibleFields).toString());
    }

    public void loadResources(String resourceString) {
        if (this.matchersHaveBeenInitialized) {
            throw new IllegalStateException("Refusing to load additional resources after the datastructures have been initialized.");
        }
        LOG.info("Loading from: \"{}\"", (Object)resourceString);
        long startFiles = System.nanoTime();
        this.flattener = new UserAgentTreeFlattener(this);
        Yaml yaml = new Yaml();
        TreeMap<String, Resource> resources = new TreeMap<String, Resource>();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            Resource[] resourceArray;
            for (Resource resource : resourceArray = resolver.getResources(resourceString)) {
                resources.put(resource.getFilename(), resource);
            }
        }
        catch (IOException e) {
            throw new InvalidParserConfigurationException("Error reading resources: " + e.getMessage(), e);
        }
        this.doingOnlyASingleTest = false;
        int maxFilenameLength = 0;
        if (resources.isEmpty()) {
            throw new InvalidParserConfigurationException("Unable to find ANY config files");
        }
        Set resourceBasenames = resources.keySet().stream().map(k -> k.replaceAll("^.*/", "")).collect(Collectors.toSet());
        Set alreadyLoadedResourceBasenames = this.matcherConfigs.keySet().stream().map(k -> k.replaceAll("^.*/", "")).collect(Collectors.toSet());
        alreadyLoadedResourceBasenames.retainAll(resourceBasenames);
        if (!alreadyLoadedResourceBasenames.isEmpty()) {
            LOG.error("Trying to load these {} resources for the second time: {}", (Object)alreadyLoadedResourceBasenames.size(), alreadyLoadedResourceBasenames);
            throw new InvalidParserConfigurationException("Trying to load " + alreadyLoadedResourceBasenames.size() + " resources for the second time");
        }
        for (Map.Entry resourceEntry : resources.entrySet()) {
            try {
                Resource resource = (Resource)resourceEntry.getValue();
                String filename = resource.getFilename();
                if (filename == null) continue;
                maxFilenameLength = Math.max(maxFilenameLength, filename.length());
                this.loadResource(yaml, resource.getInputStream(), filename);
            }
            catch (IOException e) {
                throw new InvalidParserConfigurationException("Error reading resources: " + e.getMessage(), e);
            }
        }
        long stopFiles = System.nanoTime();
        LOG.info("Loaded {} files in {} msec", (Object)resources.size(), (Object)((stopFiles - startFiles) / 1000000L));
        if (this.lookups != null && !this.lookups.isEmpty()) {
            HashMap<String, Map<String, String>> cleanedLookups = new HashMap<String, Map<String, String>>(this.lookups.size());
            for (Map.Entry entry : this.lookups.entrySet()) {
                HashMap cleanedLookup = new HashMap(((Map)entry.getValue()).size());
                for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                    cleanedLookup.put(((String)entry2.getKey()).toLowerCase(), entry2.getValue());
                }
                cleanedLookups.put((String)entry.getKey(), cleanedLookup);
            }
            this.lookups = cleanedLookups;
        }
        if (this.wantedFieldNames != null) {
            int wantedSize = this.wantedFieldNames.size();
            if (this.wantedFieldNames.contains("__Set_ALL_Fields__")) {
                --wantedSize;
            }
            LOG.info("Building all needed matchers for the requested {} fields.", (Object)wantedSize);
        } else {
            LOG.info("Building all matchers for all possible fields.");
        }
        int totalNumberOfMatchers = 0;
        int skippedMatchers = 0;
        if (this.matcherConfigs != null) {
            long fullStart = System.nanoTime();
            for (Map.Entry resourceEntry : resources.entrySet()) {
                Resource resource = (Resource)resourceEntry.getValue();
                String configFilename = resource.getFilename();
                List<MappingNode> matcherConfig = this.matcherConfigs.get(configFilename);
                if (matcherConfig == null) continue;
                long start = System.nanoTime();
                int startSkipped = skippedMatchers;
                for (MappingNode map : matcherConfig) {
                    try {
                        this.allMatchers.add(new Matcher(this, this.lookups, this.lookupSets, this.wantedFieldNames, map, configFilename));
                        ++totalNumberOfMatchers;
                    }
                    catch (UselessMatcherException ume) {
                        ++skippedMatchers;
                    }
                }
                long stop = System.nanoTime();
                int stopSkipped = skippedMatchers;
                if (!this.showMatcherStats) continue;
                Formatter msg = new Formatter(Locale.ENGLISH);
                Throwable throwable = null;
                try {
                    msg.format("Loading %4d (dropped %4d) matchers from %-" + maxFilenameLength + "s took %5d msec", matcherConfig.size() - (stopSkipped - startSkipped), stopSkipped - startSkipped, configFilename, (stop - start) / 1000000L);
                    LOG.info(msg.toString());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (msg == null) continue;
                    if (throwable != null) {
                        try {
                            msg.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    msg.close();
                }
            }
            long fullStop = System.nanoTime();
            try (Formatter msg = new Formatter(Locale.ENGLISH);){
                msg.format("Loading %4d (dropped %4d) matchers, %d lookups, %d lookupsets, %d testcases from %4d files took %5d msec", totalNumberOfMatchers, skippedMatchers, this.lookups == null ? 0 : this.lookups.size(), this.lookupSets.size(), this.testCases.size(), this.matcherConfigs.size(), (fullStop - fullStart) / 1000000L);
                LOG.info(msg.toString());
            }
        }
    }

    public void initializeMatchers() {
        if (this.matchersHaveBeenInitialized) {
            return;
        }
        LOG.info("Initializing Analyzer data structures");
        long start = System.nanoTime();
        this.allMatchers.forEach(Matcher::initialize);
        long stop = System.nanoTime();
        this.matchersHaveBeenInitialized = true;
        LOG.info("Built in {} msec : Hashmap {}, Ranges map:{}", new Object[]{(stop - start) / 1000000L, this.informMatcherActions.size(), this.informMatcherActionRanges.size()});
    }

    public Set<String> getAllPossibleFieldNames() {
        TreeSet<String> results = new TreeSet<String>(HARD_CODED_GENERATED_FIELDS);
        for (Matcher matcher : this.allMatchers) {
            results.addAll(matcher.getAllPossibleFieldNames());
        }
        return results;
    }

    public List<String> getAllPossibleFieldNamesSorted() {
        ArrayList<String> fieldNames = new ArrayList<String>(this.getAllPossibleFieldNames());
        Collections.sort(fieldNames);
        ArrayList<String> result = new ArrayList<String>();
        for (String fieldName : UserAgent.PRE_SORTED_FIELDS_LIST) {
            fieldNames.remove(fieldName);
            result.add(fieldName);
        }
        result.addAll(fieldNames);
        return result;
    }

    private void loadResource(Yaml yaml, InputStream yamlStream, String filename) {
        Node loadedYaml;
        try {
            loadedYaml = yaml.compose(new UnicodeReader(yamlStream));
        }
        catch (Exception e) {
            throw new InvalidParserConfigurationException("Parse error in the file " + filename + ": " + e.getMessage(), e);
        }
        if (loadedYaml == null) {
            throw new InvalidParserConfigurationException("The file " + filename + " is empty");
        }
        YamlUtils.requireNodeInstanceOf(MappingNode.class, loadedYaml, filename, "File must be a Map");
        MappingNode rootNode = (MappingNode)loadedYaml;
        NodeTuple configNodeTuple = null;
        for (NodeTuple tuple : rootNode.getValue()) {
            String name = YamlUtils.getKeyAsString(tuple, filename);
            if ("config".equals(name)) {
                configNodeTuple = tuple;
                break;
            }
            if (!"version".equals(name)) continue;
            YauaaVersion.assertSameVersion(tuple, filename);
            return;
        }
        YamlUtils.require(configNodeTuple != null, loadedYaml, filename, "The top level entry MUST be 'config'.");
        SequenceNode configNode = YamlUtils.getValueAsSequenceNode(configNodeTuple, filename);
        List<Node> configList = configNode.getValue();
        block15: for (Node configEntry : configList) {
            String entryType;
            YamlUtils.requireNodeInstanceOf(MappingNode.class, configEntry, filename, "The entry MUST be a mapping");
            NodeTuple entry = YamlUtils.getExactlyOneNodeTuple((MappingNode)configEntry, filename);
            MappingNode actualEntry = YamlUtils.getValueAsMappingNode(entry, filename);
            switch (entryType = YamlUtils.getKeyAsString(entry, filename)) {
                case "lookup": {
                    this.loadYamlLookup(actualEntry, filename);
                    continue block15;
                }
                case "set": {
                    this.loadYamlLookupSets(actualEntry, filename);
                    continue block15;
                }
                case "matcher": {
                    this.loadYamlMatcher(actualEntry, filename);
                    continue block15;
                }
                case "test": {
                    if (!this.loadTests) continue block15;
                    this.loadYamlTestcase(actualEntry, filename);
                    continue block15;
                }
            }
            throw new InvalidParserConfigurationException("Yaml config.(" + filename + ":" + actualEntry.getStartMark().getLine() + "): Found unexpected config entry: " + entryType + ", allowed are 'lookup', 'set', 'matcher' and 'test'");
        }
    }

    private void loadYamlLookup(MappingNode entry, String filename) {
        String name = null;
        HashMap<String, String> map = null;
        block8: for (NodeTuple tuple : entry.getValue()) {
            switch (YamlUtils.getKeyAsString(tuple, filename)) {
                case "name": {
                    name = YamlUtils.getValueAsString(tuple, filename);
                    break;
                }
                case "map": {
                    if (map == null) {
                        map = new HashMap<String, String>();
                    }
                    List<NodeTuple> mappings = YamlUtils.getValueAsMappingNode(tuple, filename).getValue();
                    for (NodeTuple mapping : mappings) {
                        String key = YamlUtils.getKeyAsString(mapping, filename);
                        String value = YamlUtils.getValueAsString(mapping, filename);
                        if (map.containsKey(key)) {
                            throw new InvalidParserConfigurationException("In the lookup \"" + name + "\" the key \"" + key + "\" appears multiple times.");
                        }
                        map.put(key, value);
                    }
                    continue block8;
                }
            }
        }
        YamlUtils.require(name != null && map != null, entry, filename, "Invalid lookup specified");
        this.lookups.put(name, map);
    }

    private void loadYamlLookupSets(MappingNode entry, String filename) {
        String name = null;
        HashSet<String> lookupSet = new HashSet<String>();
        block8: for (NodeTuple tuple : entry.getValue()) {
            switch (YamlUtils.getKeyAsString(tuple, filename)) {
                case "name": {
                    name = YamlUtils.getValueAsString(tuple, filename);
                    break;
                }
                case "values": {
                    SequenceNode node = YamlUtils.getValueAsSequenceNode(tuple, filename);
                    for (String value : YamlUtils.getStringValues(node, filename)) {
                        lookupSet.add(value.toLowerCase(Locale.ENGLISH));
                    }
                    continue block8;
                }
            }
        }
        this.lookupSets.put(name, lookupSet);
    }

    private void loadYamlMatcher(MappingNode entry, String filename) {
        List matcherConfigList = this.matcherConfigs.computeIfAbsent(filename, k -> new ArrayList(32));
        matcherConfigList.add(entry);
    }

    private void loadYamlTestcase(MappingNode entry, String filename) {
        if (!this.doingOnlyASingleTest) {
            HashMap<String, String> metaData = new HashMap<String, String>();
            metaData.put("filename", filename);
            metaData.put("fileline", String.valueOf(entry.getStartMark().getLine()));
            HashMap<String, String> input = null;
            List<String> options = null;
            HashMap<String, String> expected = new HashMap<String, String>();
            block16: for (NodeTuple tuple : entry.getValue()) {
                String name;
                switch (name = YamlUtils.getKeyAsString(tuple, filename)) {
                    case "options": {
                        options = YamlUtils.getStringValues(tuple.getValueNode(), filename);
                        if (!options.contains("only")) break;
                        this.doingOnlyASingleTest = true;
                        this.testCases.clear();
                        break;
                    }
                    case "input": {
                        for (NodeTuple inputTuple : YamlUtils.getValueAsMappingNode(tuple, filename).getValue()) {
                            String inputName;
                            switch (inputName = YamlUtils.getKeyAsString(inputTuple, filename)) {
                                case "user_agent_string": {
                                    String inputString = YamlUtils.getValueAsString(inputTuple, filename);
                                    input = new HashMap<String, String>();
                                    input.put(inputName, inputString);
                                    break;
                                }
                            }
                        }
                        continue block16;
                    }
                    case "expected": {
                        List<NodeTuple> mappings = YamlUtils.getValueAsMappingNode(tuple, filename).getValue();
                        for (NodeTuple mapping : mappings) {
                            String key = YamlUtils.getKeyAsString(mapping, filename);
                            String value = YamlUtils.getValueAsString(mapping, filename);
                            expected.put(key, value);
                        }
                        continue block16;
                    }
                }
            }
            YamlUtils.require(input != null, entry, filename, "Test is missing input");
            if (expected.isEmpty()) {
                this.doingOnlyASingleTest = true;
                this.testCases.clear();
            }
            HashMap testCase = new HashMap();
            testCase.put("input", input);
            if (!expected.isEmpty()) {
                testCase.put("expected", expected);
            }
            if (options != null) {
                HashMap<String, String> optionsMap = new HashMap<String, String>(options.size());
                for (String option : options) {
                    optionsMap.put(option, option);
                }
                testCase.put("options", optionsMap);
            }
            testCase.put("metaData", metaData);
            this.testCases.add(testCase);
        }
    }

    @Override
    public void lookingForRange(String treeName, WordRangeVisitor.Range range) {
        Set ranges = this.informMatcherActionRanges.computeIfAbsent(treeName, k -> new HashSet(4));
        ranges.add(range);
    }

    public static int firstCharactersForPrefixHashLength(String input, int maxChars) {
        return Math.min(maxChars, Math.min(3, input.length()));
    }

    public static String firstCharactersForPrefixHash(String input, int maxChars) {
        return input.substring(0, UserAgentAnalyzerDirect.firstCharactersForPrefixHashLength(input, maxChars));
    }

    @Override
    public void informMeAboutPrefix(MatcherAction matcherAction, String treeName, String prefix) {
        this.informMeAbout(matcherAction, treeName + "{\"" + UserAgentAnalyzerDirect.firstCharactersForPrefixHash(prefix, 3) + "\"");
        Set lengths = this.informMatcherActionPrefixesLengths.computeIfAbsent(treeName, k -> new HashSet(4));
        lengths.add(UserAgentAnalyzerDirect.firstCharactersForPrefixHashLength(prefix, 3));
    }

    @Override
    public Set<Integer> getRequiredPrefixLengths(String treeName) {
        return this.informMatcherActionPrefixesLengths.get(treeName);
    }

    @Override
    public void informMeAbout(MatcherAction matcherAction, String keyPattern) {
        String hashKey = keyPattern.toLowerCase();
        Set analyzerSet = this.informMatcherActions.computeIfAbsent(hashKey, k -> new HashSet());
        analyzerSet.add(matcherAction);
    }

    public void setVerbose(boolean newVerbose) {
        this.verbose = newVerbose;
        this.flattener.setVerbose(newVerbose);
    }

    public void setUserAgentMaxLength(int newUserAgentMaxLength) {
        this.userAgentMaxLength = newUserAgentMaxLength <= 0 ? 2048 : newUserAgentMaxLength;
    }

    public int getUserAgentMaxLength() {
        return this.userAgentMaxLength;
    }

    public UserAgent parse(String userAgentString) {
        UserAgent userAgent = new UserAgent(userAgentString);
        return this.parse(userAgent);
    }

    private UserAgent setAsHacker(UserAgent userAgent, int confidence) {
        userAgent.set("DeviceClass", "Hacker", confidence);
        userAgent.set("DeviceBrand", "Hacker", confidence);
        userAgent.set("DeviceName", "Hacker", confidence);
        userAgent.set("DeviceVersion", "Hacker", confidence);
        userAgent.set("OperatingSystemClass", "Hacker", confidence);
        userAgent.set("OperatingSystemName", "Hacker", confidence);
        userAgent.set("OperatingSystemVersion", "Hacker", confidence);
        userAgent.set("LayoutEngineClass", "Hacker", confidence);
        userAgent.set("LayoutEngineName", "Hacker", confidence);
        userAgent.set("LayoutEngineVersion", "Hacker", confidence);
        userAgent.set("LayoutEngineVersionMajor", "Hacker", confidence);
        userAgent.set("AgentClass", "Hacker", confidence);
        userAgent.set("AgentName", "Hacker", confidence);
        userAgent.set("AgentVersion", "Hacker", confidence);
        userAgent.set("AgentVersionMajor", "Hacker", confidence);
        userAgent.set("HackerToolkit", "Unknown", confidence);
        userAgent.set("HackerAttackVector", "Buffer overflow", confidence);
        return userAgent;
    }

    public synchronized UserAgent parse(UserAgent userAgent) {
        this.initializeMatchers();
        String useragentString = userAgent.getUserAgentString();
        if (useragentString != null && useragentString.length() > this.userAgentMaxLength) {
            this.setAsHacker(userAgent, 100);
            userAgent.setForced("HackerAttackVector", "Buffer overflow", 100L);
            return this.hardCodedPostProcessing(userAgent);
        }
        for (Matcher matcher : this.allMatchers) {
            matcher.reset();
        }
        if (userAgent.isDebug()) {
            for (Matcher matcher : this.allMatchers) {
                matcher.setVerboseTemporarily(true);
            }
        }
        try {
            userAgent = this.flattener.parse(userAgent);
            for (Matcher matcher : this.allMatchers) {
                matcher.analyze(userAgent);
            }
            userAgent.processSetAll();
            return this.hardCodedPostProcessing(userAgent);
        }
        catch (RuntimeException rte) {
            userAgent.reset();
            userAgent = this.setAsHacker(userAgent, 10000);
            userAgent.setForced("HackerAttackVector", "Yauaa Exploit", 10000L);
            return this.hardCodedPostProcessing(userAgent);
        }
    }

    public boolean isWantedField(String fieldName) {
        if (this.wantedFieldNames == null) {
            return true;
        }
        return this.wantedFieldNames.contains(fieldName);
    }

    private UserAgent hardCodedPostProcessing(UserAgent userAgent) {
        String newDeviceBrand;
        UserAgent.AgentField deviceName;
        UserAgent.AgentField email;
        if ("true".equals(userAgent.getValue("__SyntaxError__")) && userAgent.get("DeviceClass").getConfidence() == -1L) {
            userAgent.set("DeviceClass", "Hacker", 10L);
            userAgent.set("DeviceBrand", "Hacker", 10L);
            userAgent.set("DeviceName", "Hacker", 10L);
            userAgent.set("DeviceVersion", "Hacker", 10L);
            userAgent.set("OperatingSystemClass", "Hacker", 10L);
            userAgent.set("OperatingSystemName", "Hacker", 10L);
            userAgent.set("OperatingSystemVersion", "Hacker", 10L);
            userAgent.set("LayoutEngineClass", "Hacker", 10L);
            userAgent.set("LayoutEngineName", "Hacker", 10L);
            userAgent.set("LayoutEngineVersion", "Hacker", 10L);
            userAgent.set("LayoutEngineVersionMajor", "Hacker", 10L);
            userAgent.set("AgentClass", "Hacker", 10L);
            userAgent.set("AgentName", "Hacker", 10L);
            userAgent.set("AgentVersion", "Hacker", 10L);
            userAgent.set("AgentVersionMajor", "Hacker", 10L);
            userAgent.set("HackerToolkit", "Unknown", 10L);
            userAgent.set("HackerAttackVector", "Unknown", 10L);
        }
        this.addMajorVersionField(userAgent, "AgentVersion", "AgentVersionMajor");
        this.addMajorVersionField(userAgent, "LayoutEngineVersion", "LayoutEngineVersionMajor");
        this.addMajorVersionField(userAgent, "WebviewAppVersion", "WebviewAppVersionMajor");
        this.concatFieldValuesNONDuplicated(userAgent, "AgentNameVersion", "AgentName", "AgentVersion");
        this.concatFieldValuesNONDuplicated(userAgent, "AgentNameVersionMajor", "AgentName", "AgentVersionMajor");
        this.concatFieldValuesNONDuplicated(userAgent, "WebviewAppNameVersionMajor", "WebviewAppName", "WebviewAppVersionMajor");
        this.concatFieldValuesNONDuplicated(userAgent, "LayoutEngineNameVersion", "LayoutEngineName", "LayoutEngineVersion");
        this.concatFieldValuesNONDuplicated(userAgent, "LayoutEngineNameVersionMajor", "LayoutEngineName", "LayoutEngineVersionMajor");
        this.concatFieldValuesNONDuplicated(userAgent, "OperatingSystemNameVersion", "OperatingSystemName", "OperatingSystemVersion");
        UserAgent.AgentField deviceBrand = userAgent.get("DeviceBrand");
        if (deviceBrand.getConfidence() >= 0L) {
            userAgent.setForced("DeviceBrand", Normalize.brand(deviceBrand.getValue()), deviceBrand.getConfidence());
        }
        if ((email = userAgent.get("AgentInformationEmail")) != null && email.getConfidence() >= 0L) {
            userAgent.setForced("AgentInformationEmail", Normalize.email(email.getValue()), email.getConfidence());
        }
        if ((deviceName = userAgent.get("DeviceName")).getConfidence() >= 0L) {
            deviceBrand = userAgent.get("DeviceBrand");
            String deviceNameValue = deviceName.getValue();
            String deviceBrandValue = deviceBrand.getValue();
            deviceNameValue = deviceName.getConfidence() >= 0L && deviceBrand.getConfidence() >= 0L && !deviceBrandValue.equals("Unknown") ? Normalize.cleanupDeviceBrandName(deviceBrandValue, deviceNameValue) : Normalize.brand(deviceNameValue);
            userAgent.setForced("DeviceName", deviceNameValue, deviceName.getConfidence());
        }
        if (deviceBrand.getConfidence() < 0L && (newDeviceBrand = this.determineDeviceBrand(userAgent)) != null) {
            userAgent.setForced("DeviceBrand", newDeviceBrand, 1L);
        }
        return userAgent;
    }

    private String extractCompanyFromHostName(String hostname) {
        try {
            InternetDomainName domainName = InternetDomainName.from(hostname);
            return Normalize.brand((String)domainName.topPrivateDomain().parts().get(0));
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private String determineDeviceBrand(UserAgent userAgent) {
        UserAgent.AgentField informationEmail;
        UserAgent.AgentField informationUrl = userAgent.get("AgentInformationUrl");
        if (informationUrl != null && informationUrl.getConfidence() >= 0L) {
            String hostname = informationUrl.getValue();
            try {
                URL url = new URL(hostname);
                hostname = url.getHost();
            }
            catch (MalformedURLException url) {
                // empty catch block
            }
            hostname = this.extractCompanyFromHostName(hostname);
            if (hostname != null) {
                return hostname;
            }
        }
        if ((informationEmail = userAgent.get("AgentInformationEmail")) != null && informationEmail.getConfidence() >= 0L) {
            String hostname = informationEmail.getValue();
            int atOffset = hostname.indexOf(64);
            if (atOffset >= 0) {
                hostname = hostname.substring(atOffset + 1);
            }
            if ((hostname = this.extractCompanyFromHostName(hostname)) != null) {
                return hostname;
            }
        }
        return null;
    }

    void concatFieldValuesNONDuplicated(UserAgent userAgent, String targetName, String firstName, String secondName) {
        if (!this.isWantedField(targetName)) {
            return;
        }
        UserAgent.AgentField firstField = userAgent.get(firstName);
        UserAgent.AgentField secondField = userAgent.get(secondName);
        String first = null;
        long firstConfidence = -1L;
        String second = null;
        long secondConfidence = -1L;
        if (firstField != null) {
            first = firstField.getValue();
            firstConfidence = firstField.getConfidence();
        }
        if (secondField != null) {
            second = secondField.getValue();
            secondConfidence = secondField.getConfidence();
        }
        if (first == null && second == null) {
            return;
        }
        if (second == null) {
            if (firstConfidence >= 0L) {
                userAgent.set(targetName, first, firstConfidence);
            }
            return;
        }
        if (first == null) {
            if (secondConfidence >= 0L) {
                userAgent.set(targetName, second, secondConfidence);
            }
            return;
        }
        if (first.equals(second)) {
            userAgent.set(targetName, first, firstConfidence);
        } else if (second.startsWith(first)) {
            userAgent.set(targetName, second, secondConfidence);
        } else {
            userAgent.set(targetName, first + " " + second, Math.max(firstField.getConfidence(), secondField.getConfidence()));
        }
    }

    private void addMajorVersionField(UserAgent userAgent, String versionName, String majorVersionName) {
        UserAgent.AgentField agentVersion;
        if (!this.isWantedField(majorVersionName)) {
            return;
        }
        UserAgent.AgentField agentVersionMajor = userAgent.get(majorVersionName);
        if ((agentVersionMajor == null || agentVersionMajor.getConfidence() == -1L) && (agentVersion = userAgent.get(versionName)) != null) {
            String version = agentVersion.getValue();
            if (version != null) {
                version = VersionSplitter.getInstance().getSingleSplit(agentVersion.getValue(), 1);
            }
            userAgent.set(majorVersionName, version, agentVersion.getConfidence());
        }
    }

    @Override
    public Set<WordRangeVisitor.Range> getRequiredInformRanges(String treeName) {
        return this.informMatcherActionRanges.computeIfAbsent(treeName, k -> Collections.emptySet());
    }

    @Override
    public void inform(String key, String value, ParseTree ctx) {
        this.inform(key, key, value, ctx);
        this.inform(key + "=\"" + value + '\"', key, value, ctx);
        Set<Integer> lengths = this.getRequiredPrefixLengths(key);
        if (lengths != null) {
            int valueLength = value.length();
            for (Integer prefixLength : lengths) {
                if (valueLength < prefixLength) continue;
                this.inform(key + "{\"" + UserAgentAnalyzerDirect.firstCharactersForPrefixHash(value, prefixLength) + '\"', key, value, ctx);
            }
        }
    }

    private void inform(String match, String key, String value, ParseTree ctx) {
        Set<MatcherAction> relevantActions = this.informMatcherActions.get(match.toLowerCase(Locale.ENGLISH));
        if (this.verbose) {
            if (relevantActions == null) {
                LOG.info("--- Have (0): {}", (Object)match);
            } else {
                LOG.info("+++ Have ({}): {}", (Object)relevantActions.size(), (Object)match);
                int count = 1;
                for (MatcherAction action : relevantActions) {
                    LOG.info("+++ -------> ({}): {}", (Object)count, (Object)action);
                    ++count;
                }
            }
        }
        if (relevantActions != null) {
            for (MatcherAction matcherAction : relevantActions) {
                matcherAction.inform(key, value, ctx);
            }
        }
    }

    public long preHeat() {
        return this.preHeat(this.testCases.size(), true);
    }

    public long preHeat(long preheatIterations) {
        return this.preHeat(preheatIterations, true);
    }

    public long preHeat(long preheatIterations, boolean log) {
        if (this.testCases.isEmpty()) {
            LOG.warn("NO PREHEAT WAS DONE. Simply because there are no test cases available.");
            return 0L;
        }
        if (preheatIterations <= 0L) {
            LOG.warn("NO PREHEAT WAS DONE. Simply because you asked for {} to run.", (Object)preheatIterations);
            return 0L;
        }
        if (preheatIterations > 1000000L) {
            LOG.warn("NO PREHEAT WAS DONE. Simply because you asked for too many ({} > {}) to run.", (Object)preheatIterations, (Object)1000000L);
            return 0L;
        }
        if (log) {
            LOG.info("Preheating JVM by running {} testcases.", (Object)preheatIterations);
        }
        long remainingIterations = preheatIterations;
        long goodResults = 0L;
        block0: while (remainingIterations > 0L) {
            for (Map<String, Map<String, String>> test : this.testCases) {
                Map<String, String> input = test.get("input");
                String userAgentString = input.get("user_agent_string");
                --remainingIterations;
                if (!this.parse(userAgentString).hasSyntaxError()) {
                    ++goodResults;
                }
                if (remainingIterations > 0L) continue;
                continue block0;
            }
        }
        if (log) {
            LOG.info("Preheating JVM completed. ({} of {} were proper results)", (Object)goodResults, (Object)preheatIterations);
        }
        return preheatIterations;
    }

    public static List<String> getAllPaths(String agent) {
        return new GetAllPathsAnalyzer(agent).getValues();
    }

    public static GetAllPathsAnalyzer getAllPathsAnalyzer(String agent) {
        return new GetAllPathsAnalyzer(agent);
    }

    public static UserAgentAnalyzerDirectBuilder<? extends UserAgentAnalyzer, ? extends UserAgentAnalyzerDirectBuilder<?, ?>> newBuilder() {
        return new UserAgentAnalyzerDirectBuilder(new UserAgentAnalyzer());
    }

    static {
        HARD_CODED_GENERATED_FIELDS.add("__SyntaxError__");
        HARD_CODED_GENERATED_FIELDS.add("AgentVersionMajor");
        HARD_CODED_GENERATED_FIELDS.add("LayoutEngineVersionMajor");
        HARD_CODED_GENERATED_FIELDS.add("AgentNameVersion");
        HARD_CODED_GENERATED_FIELDS.add("AgentNameVersionMajor");
        HARD_CODED_GENERATED_FIELDS.add("LayoutEngineNameVersion");
        HARD_CODED_GENERATED_FIELDS.add("LayoutEngineNameVersionMajor");
        HARD_CODED_GENERATED_FIELDS.add("OperatingSystemNameVersion");
        HARD_CODED_GENERATED_FIELDS.add("WebviewAppVersionMajor");
        HARD_CODED_GENERATED_FIELDS.add("WebviewAppNameVersionMajor");
    }

    public static class UserAgentAnalyzerDirectBuilder<UAA extends UserAgentAnalyzerDirect, B extends UserAgentAnalyzerDirectBuilder<UAA, B>> {
        private final UAA uaa;
        private boolean didBuildStep = false;
        private int preheatIterations = 0;
        private List<String> resources = new ArrayList<String>();

        protected void failIfAlreadyBuilt() {
            if (this.didBuildStep) {
                throw new IllegalStateException("A builder can provide only a single instance. It is not allowed to set values after doing build()");
            }
        }

        protected UserAgentAnalyzerDirectBuilder(UAA newUaa) {
            this.uaa = newUaa;
            ((UserAgentAnalyzerDirect)this.uaa).setShowMatcherStats(false);
            this.resources.add(UserAgentAnalyzerDirect.DEFAULT_RESOURCES);
        }

        public B dropDefaultResources() {
            this.failIfAlreadyBuilt();
            this.resources.remove(UserAgentAnalyzerDirect.DEFAULT_RESOURCES);
            return (B)this;
        }

        public B addResources(String resourceString) {
            this.failIfAlreadyBuilt();
            this.resources.add(resourceString);
            return (B)this;
        }

        public B preheat(int iterations) {
            this.failIfAlreadyBuilt();
            this.preheatIterations = iterations;
            return (B)this;
        }

        public B preheat() {
            this.failIfAlreadyBuilt();
            this.preheatIterations = -1;
            return (B)this;
        }

        public B withField(String fieldName) {
            this.failIfAlreadyBuilt();
            if (((UserAgentAnalyzerDirect)this.uaa).wantedFieldNames == null) {
                ((UserAgentAnalyzerDirect)this.uaa).wantedFieldNames = new ArrayList<String>(32);
            }
            if (!((UserAgentAnalyzerDirect)this.uaa).wantedFieldNames.contains(fieldName)) {
                ((UserAgentAnalyzerDirect)this.uaa).wantedFieldNames.add(fieldName);
            }
            return (B)this;
        }

        public B withFields(Collection<String> fieldNames) {
            for (String fieldName : fieldNames) {
                this.withField(fieldName);
            }
            return (B)this;
        }

        public B withFields(String ... fieldNames) {
            for (String fieldName : fieldNames) {
                this.withField(fieldName);
            }
            return (B)this;
        }

        public B withAllFields() {
            this.failIfAlreadyBuilt();
            ((UserAgentAnalyzerDirect)this.uaa).wantedFieldNames = null;
            return (B)this;
        }

        public B showMatcherLoadStats() {
            this.failIfAlreadyBuilt();
            ((UserAgentAnalyzerDirect)this.uaa).setShowMatcherStats(true);
            return (B)this;
        }

        public B hideMatcherLoadStats() {
            this.failIfAlreadyBuilt();
            ((UserAgentAnalyzerDirect)this.uaa).setShowMatcherStats(false);
            return (B)this;
        }

        public B withUserAgentMaxLength(int newUserAgentMaxLength) {
            this.failIfAlreadyBuilt();
            ((UserAgentAnalyzerDirect)this.uaa).setUserAgentMaxLength(newUserAgentMaxLength);
            return (B)this;
        }

        public B keepTests() {
            this.failIfAlreadyBuilt();
            ((UserAgentAnalyzerDirect)this.uaa).keepTests();
            return (B)this;
        }

        public B dropTests() {
            this.failIfAlreadyBuilt();
            ((UserAgentAnalyzerDirect)this.uaa).dropTests();
            return (B)this;
        }

        public B delayInitialization() {
            this.failIfAlreadyBuilt();
            ((UserAgentAnalyzerDirect)this.uaa).delayInitialization();
            return (B)this;
        }

        public B immediateInitialization() {
            this.failIfAlreadyBuilt();
            ((UserAgentAnalyzerDirect)this.uaa).immediateInitialization();
            return (B)this;
        }

        private void addGeneratedFields(String result, String ... dependencies) {
            if (((UserAgentAnalyzerDirect)this.uaa).wantedFieldNames.contains(result)) {
                Collections.addAll(((UserAgentAnalyzerDirect)this.uaa).wantedFieldNames, dependencies);
            }
        }

        public UAA build() {
            boolean mustDropTestsLater;
            this.failIfAlreadyBuilt();
            if (((UserAgentAnalyzerDirect)this.uaa).wantedFieldNames != null) {
                this.addGeneratedFields("AgentNameVersion", "AgentName", "AgentVersion");
                this.addGeneratedFields("AgentNameVersionMajor", "AgentName", "AgentVersionMajor");
                this.addGeneratedFields("WebviewAppNameVersionMajor", "WebviewAppName", "WebviewAppVersionMajor");
                this.addGeneratedFields("LayoutEngineNameVersion", "LayoutEngineName", "LayoutEngineVersion");
                this.addGeneratedFields("LayoutEngineNameVersionMajor", "LayoutEngineName", "LayoutEngineVersionMajor");
                this.addGeneratedFields("OperatingSystemNameVersion", "OperatingSystemName", "OperatingSystemVersion");
                this.addGeneratedFields("DeviceName", "DeviceBrand");
                this.addGeneratedFields("AgentVersionMajor", "AgentVersion");
                this.addGeneratedFields("LayoutEngineVersionMajor", "LayoutEngineVersion");
                this.addGeneratedFields("WebviewAppVersionMajor", "WebviewAppVersion");
                this.addGeneratedFields("DeviceBrand", "AgentInformationUrl", "AgentInformationEmail");
                ((UserAgentAnalyzerDirect)this.uaa).wantedFieldNames.add("__Set_ALL_Fields__");
                ((UserAgentAnalyzerDirect)this.uaa).wantedFieldNames.add("DeviceClass");
            }
            boolean bl = mustDropTestsLater = !((UserAgentAnalyzerDirect)this.uaa).willKeepTests();
            if (this.preheatIterations != 0) {
                ((UserAgentAnalyzerDirect)this.uaa).keepTests();
            }
            ((UserAgentAnalyzerDirect)this.uaa).initialize(this.resources);
            if (this.preheatIterations < 0) {
                ((UserAgentAnalyzerDirect)this.uaa).preHeat();
            } else if (this.preheatIterations > 0) {
                ((UserAgentAnalyzerDirect)this.uaa).preHeat(this.preheatIterations);
            }
            if (mustDropTestsLater) {
                ((UserAgentAnalyzerDirect)this.uaa).dropTests();
            }
            this.didBuildStep = true;
            return this.uaa;
        }
    }

    public static class GetAllPathsAnalyzer
    implements Analyzer {
        private final List<String> values = new ArrayList<String>(128);
        private final UserAgentTreeFlattener flattener = new UserAgentTreeFlattener(this);
        private final UserAgent result;

        GetAllPathsAnalyzer(String useragent) {
            this.result = this.flattener.parse(useragent);
        }

        public List<String> getValues() {
            return this.values;
        }

        public UserAgent getResult() {
            return this.result;
        }

        @Override
        public void inform(String path, String value, ParseTree ctx) {
            this.values.add(path);
            this.values.add(path + "=\"" + value + "\"");
            this.values.add(path + "{\"" + UserAgentAnalyzerDirect.firstCharactersForPrefixHash(value, 3) + "\"");
        }

        @Override
        public void informMeAbout(MatcherAction matcherAction, String keyPattern) {
        }

        @Override
        public void lookingForRange(String treeName, WordRangeVisitor.Range range) {
        }

        @Override
        public Set<WordRangeVisitor.Range> getRequiredInformRanges(String treeName) {
            return Collections.emptySet();
        }

        @Override
        public void informMeAboutPrefix(MatcherAction matcherAction, String treeName, String prefix) {
        }

        @Override
        public Set<Integer> getRequiredPrefixLengths(String treeName) {
            return Collections.emptySet();
        }
    }

    public static class KryoSerializer
    extends FieldSerializer<UserAgentAnalyzerDirect> {
        public KryoSerializer(Kryo kryo, Class type) {
            super(kryo, type);
        }

        public UserAgentAnalyzerDirect read(Kryo kryo, Input input, Class<UserAgentAnalyzerDirect> type) {
            UserAgentAnalyzerDirect uaa = (UserAgentAnalyzerDirect)super.read(kryo, input, type);
            uaa.initTransientFields();
            uaa.showDeserializationStats();
            return uaa;
        }
    }
}

