/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.pull.tools;

import org.apache.commons.configuration2.Configuration;
import org.apache.fulcrum.parser.ParameterParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.turbine.Turbine;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.services.pull.ApplicationTool;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.uri.TemplateURI;

public class TemplateLink
implements ApplicationTool {
    public static final String TEMPLATE_LINK_PREFIX = "tool.link";
    public static final String TEMPLATE_LINK_RELATIVE_KEY = "want.relative";
    public static final boolean TEMPLATE_LINK_RELATIVE_DEFAULT = false;
    protected boolean wantRelative = false;
    protected String template = null;
    protected TemplateURI templateURI = null;
    private static final Logger log = LogManager.getLogger(TemplateLink.class);

    @Override
    public void init(Object data) {
        if (data instanceof PipelineData) {
            PipelineData pipelineData = (PipelineData)data;
            RunData runData = (RunData)pipelineData;
            this.templateURI = new TemplateURI(runData);
        } else {
            this.templateURI = new TemplateURI((RunData)data);
        }
        Configuration conf = Turbine.getConfiguration().subset(TEMPLATE_LINK_PREFIX);
        if (conf != null) {
            this.wantRelative = conf.getBoolean(TEMPLATE_LINK_RELATIVE_KEY, false);
        }
    }

    @Override
    public void refresh() {
    }

    public TemplateLink setEncodeURLOff() {
        this.templateURI.clearResponse();
        return this;
    }

    public TemplateLink setPage(String template) {
        log.debug("setPage({})", (Object)template);
        this.template = template;
        this.templateURI.setTemplate(template);
        return this;
    }

    public String getPage() {
        return this.template;
    }

    public TemplateLink setAction(String action) {
        log.debug("setAction({})", (Object)action);
        this.templateURI.setAction(action);
        return this;
    }

    public TemplateLink setActionEvent(String action, String event) {
        log.debug("setActionEvent({}, {})", (Object)action, (Object)event);
        this.templateURI.setActionEvent(action, event);
        return this;
    }

    public TemplateLink setScreen(String screen) {
        log.debug("setScreen({})", (Object)screen);
        this.templateURI.setScreen(screen);
        return this;
    }

    public TemplateLink setReference(String reference) {
        this.templateURI.setReference(reference);
        return this;
    }

    public String getReference() {
        return this.templateURI.getReference();
    }

    public TemplateLink addPathInfo(ParameterParser pp) {
        this.templateURI.addPathInfo(pp);
        return this;
    }

    public TemplateLink addPathInfo(String name, Object value) {
        this.templateURI.addPathInfo(name, value);
        return this;
    }

    public TemplateLink addPathInfo(String name, String value) {
        this.templateURI.addPathInfo(name, value);
        return this;
    }

    public TemplateLink addPathInfo(String name, double value) {
        this.templateURI.addPathInfo(name, value);
        return this;
    }

    public TemplateLink addPathInfo(String name, int value) {
        this.templateURI.addPathInfo(name, value);
        return this;
    }

    public TemplateLink addPathInfo(String name, long value) {
        this.templateURI.addPathInfo(name, value);
        return this;
    }

    public TemplateLink addQueryData(String name, Object value) {
        this.templateURI.addQueryData(name, value);
        return this;
    }

    public TemplateLink addQueryData(String name, String value) {
        this.templateURI.addQueryData(name, value);
        return this;
    }

    public TemplateLink addQueryData(String name, double value) {
        this.templateURI.addQueryData(name, value);
        return this;
    }

    public TemplateLink addQueryData(String name, int value) {
        this.templateURI.addQueryData(name, value);
        return this;
    }

    public TemplateLink addQueryData(String name, long value) {
        this.templateURI.addQueryData(name, value);
        return this;
    }

    public TemplateLink addQueryData(ParameterParser pp) {
        this.templateURI.addQueryData(pp);
        return this;
    }

    public TemplateLink removePathInfo() {
        this.templateURI.removePathInfo();
        return this;
    }

    public TemplateLink removePathInfo(String name) {
        this.templateURI.removePathInfo(name);
        return this;
    }

    public TemplateLink removeQueryData() {
        this.templateURI.removeQueryData();
        return this;
    }

    public TemplateLink removeQueryData(String name) {
        this.templateURI.removeQueryData(name);
        return this;
    }

    public String getAbsoluteLink() {
        String output = this.templateURI.getAbsoluteLink();
        this.templateURI.removePathInfo();
        this.templateURI.removeQueryData();
        return output;
    }

    public String getRelativeLink() {
        String output = this.templateURI.getRelativeLink();
        this.templateURI.removePathInfo();
        this.templateURI.removeQueryData();
        return output;
    }

    public String getLink() {
        return this.wantRelative ? this.getRelativeLink() : this.getAbsoluteLink();
    }

    public String getURI() {
        return this.wantRelative ? this.templateURI.getRelativeLink() : this.templateURI.getAbsoluteLink();
    }

    public String getAbsoluteURI() {
        return this.templateURI.getAbsoluteLink();
    }

    public String getRelativeURI() {
        return this.templateURI.getRelativeLink();
    }

    public String toString() {
        return this.getLink();
    }
}

